/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calpersonlist;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.cal.helper.CalResultCoverHelper;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalResultCoverImportingPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static Log log = LogFactory.getLog(CalResultCoverImportingPlugin.class);
    private static final String KEY_BTN_ERRORDETAIL = "errordetail";
    private static final String KEY_BTN_VIEWLOG = "viewlog";
    private static final String LABEL_SUCCESSCOUNT = "success";
    private static final String LABEL_TOTALCOUNT = "total";
    private static final String LABEL_FAILCOUNT = "fail";
    private static final String LABEL_PROCESS = "process";
    private static final String LABEL_TITLE = "title";
    private static final String KEY_BTN_BG = "btn_bg";

    public void initialize() {
        this.addClickListeners(new String[]{KEY_BTN_ERRORDETAIL, KEY_BTN_VIEWLOG, KEY_BTN_BG});
        ProgressBar calCheckWaitProcess = (ProgressBar)this.getControl("progressbarap");
        calCheckWaitProcess.addProgressListener((ProgresssListener)this);
    }

    public void onProgress(ProgressEvent progressEvent) {
        ProgressBar bar = (ProgressBar)progressEvent.getSource();
        int progress = progressEvent.getProgress();
        log.info("onProgress:{}", (Object)progress);
        if (100 == progress) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"logid", "flexpanelap", "flexpanelap2", KEY_BTN_ERRORDETAIL, KEY_BTN_BG});
            bar.stop();
        } else {
            progress = this.updateProgressAndRetLabel(this.getView());
            progressEvent.setProgress(progress);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        ProgressBar importProgress = (ProgressBar)this.getControl("progressbarap");
        importProgress.start();
        this.getView().getParentView().getPageCache().put("invokeOperation", "true");
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap", "flexpanelap2", KEY_BTN_ERRORDETAIL, "btn_know"});
        IFormView view = this.getView();
        Label total = (Label)view.getControl(LABEL_TOTALCOUNT);
        Label title = (Label)view.getControl(LABEL_TITLE);
        title.setText(ResManager.loadKDString((String)"\u5bfc\u5165\u8fdb\u5ea6", (String)"CalResultCoverImportingPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        FormShowParameter params = this.getView().getFormShowParameter();
        int totalCnt = (Integer)params.getCustomParam(LABEL_TOTALCOUNT);
        total.setText(totalCnt + "");
    }

    public void click(EventObject evt) {
        if (!SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"4730fc9f000003ae")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6838\u7b97\u540d\u5355\u201d\u7684\u201c\u5bfc\u5165\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HSASCalTableImportLogPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        String controlKey = ((Control)evt.getSource()).getKey();
        Long taskId = this.getTaskId();
        if (KEY_BTN_ERRORDETAIL.equals(controlKey)) {
            ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
            String errFilePath = (String)appCache.get("importErrorFilePath", String.class);
            if (StringUtils.isNotBlank((CharSequence)errFilePath)) {
                this.getView().download(errFilePath);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u5931\u8d25\u8be6\u60c5\u6587\u4ef6\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002\u82e5\u957f\u65f6\u95f4\u65e0\u54cd\u5e94\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalResultCoverImportingPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
        } else if (KEY_BTN_BG.equals(controlKey)) {
            ISWCAppCache bgAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "resultcoverimport_bggroud_taskid_%s", taskId));
            String bgTaskId = (String)bgAppCache.get("bgTaskId", String.class);
            if (SWCStringUtils.isNotEmpty((String)bgTaskId)) {
                HRBackgroundTaskHelper.getInstance().showBaskgroundTask(bgTaskId);
            }
            this.updateProgressAndRetLabel(this.getView());
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        ISWCAppCache bgAppCache;
        String bgTaskId;
        String finished = this.getView().getPageCache().get("finished");
        Long taskId = this.getTaskId();
        if (!SWCStringUtils.equals((String)"1", (String)finished) && SWCStringUtils.isNotEmpty((String)(bgTaskId = (String)(bgAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "resultcoverimport_bggroud_taskid_%s", taskId))).get("bgTaskId", String.class)))) {
            HRBackgroundTaskHelper.getInstance().showBaskgroundTask(bgTaskId);
        }
        PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(taskId), (String)CalPersonOperationEnum.OP_IMPORT.getOperationKey());
    }

    private int updateProgressAndRetLabel(IFormView view) {
        int percentage;
        Label success = (Label)view.getControl(LABEL_SUCCESSCOUNT);
        Label total = (Label)view.getControl(LABEL_TOTALCOUNT);
        Label fail = (Label)view.getControl(LABEL_FAILCOUNT);
        Label process = (Label)view.getControl(LABEL_PROCESS);
        Label title = (Label)view.getControl(LABEL_TITLE);
        Long taskId = this.getTaskId();
        String cacheKey = SWCStringUtils.equals((String)"2", (String)this.getCoverType()) ? "resultcoverimport_%s" : "prorationcoverimport_%s";
        Map progressMap = CalResultCoverHelper.getImportProgressMap((Long)taskId, (String)cacheKey);
        log.info("progressMap:{}", (Object)progressMap.toString());
        Integer totalCnt = (Integer)progressMap.get("totalcount");
        Integer successCnt = (Integer)progressMap.get("successcount");
        Integer failCnt = (Integer)progressMap.get("failcount");
        success.setText(successCnt + "");
        total.setText(totalCnt + "");
        fail.setText(failCnt + "");
        if (totalCnt == successCnt + failCnt) {
            if (failCnt > 0) {
                if (totalCnt.equals(failCnt)) {
                    view.setVisible(Boolean.FALSE, new String[]{"flexpanelap", "flexpanelap3", KEY_BTN_BG});
                    view.setVisible(Boolean.TRUE, new String[]{"flexpanelap2", KEY_BTN_ERRORDETAIL});
                } else {
                    view.setVisible(Boolean.FALSE, new String[]{"flexpanelap2", "flexpanelap3", KEY_BTN_BG});
                    view.setVisible(Boolean.TRUE, new String[]{"flexpanelap", KEY_BTN_ERRORDETAIL});
                }
            } else {
                view.setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
                view.setVisible(Boolean.FALSE, new String[]{"flexpanelap2", "flexpanelap3", KEY_BTN_BG, KEY_BTN_ERRORDETAIL});
            }
            percentage = 100;
            view.setVisible(Boolean.TRUE, new String[]{"btn_know"});
            title.setText(ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c", (String)"CalResultCoverImportingPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            view.getPageCache().put("finished", "1");
        } else {
            title.setText(ResManager.loadKDString((String)"\u5bfc\u5165\u8fdb\u5ea6", (String)"CalResultCoverImportingPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            view.setVisible(Boolean.FALSE, new String[]{"btn_know"});
            percentage = new BigDecimal(String.valueOf(successCnt + failCnt)).divide(new BigDecimal(String.valueOf(totalCnt)), 2, 1).multiply(new BigDecimal("100")).intValue();
        }
        process.setText(percentage + "");
        CalResultCoverHelper.updateImportFloatingProcess((int)percentage, (Long)taskId);
        return percentage;
    }

    private Long getTaskId() {
        FormShowParameter params = this.getView().getFormShowParameter();
        Long taskId = (Long)params.getCustomParam("taskId");
        return taskId;
    }

    private String getCoverType() {
        FormShowParameter params = this.getView().getFormShowParameter();
        String coverType = (String)params.getCustomParam("coverType");
        return coverType;
    }
}

