/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calpersonlist;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.cal.helper.CalResultCoverHelper;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.cal.vo.CalPayRollTaskContext;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalResultCoverSalaryItemPlugin
extends AbstractBillPlugIn
implements TreeNodeClickListener,
SearchEnterListener,
TreeNodeQueryListener,
TreeNodeCheckListener,
RowClickEventListener {
    private static final Log logger = LogFactory.getLog(CalResultCoverSalaryItemPlugin.class);
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String TREE_NODE = "treeNode";
    private static final String SELECTED_TREE_NODE = "selectedTreeNode";
    private static final String SEARCH_TEXT = "searchText";
    private static final String SEARCH_COUNT = "searchCount";
    private static final String KEY_LEFT_COUNT = "leftcount";
    private static final String KEY_LEFT_CHECK = "leftcheck";
    private static final String KEY_RIGHT_COUNT = "rightcount";
    private static final String KEY_RIGHT_CHECK = "rightcheck";
    private static final String CACHE_KEY_SALARYITEMMAP = "salaryitemmap";
    private static final String BTN_ADD = "btn_add";
    private static final String BTN_REMOVE = "btn_remove";
    private static final String BTN_OK = "btnok";
    private static final String BTN_SELECTALL_LEFT = "btn_selectallleft";
    private static final String BTN_SELECTALL_RIGHT = "btn_selectallright";
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String KEY_ITEM_NAME = "itemname";
    private static final String KEY_ITEM_ID = "itemid";
    private static final String BTN_RESET = "btn_reset";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        this.addClickListeners(new String[]{BTN_RESET, BTN_SELECTALL_LEFT, BTN_SELECTALL_RIGHT, BTN_ADD, BTN_REMOVE, BTN_OK});
        this.addItemClickListeners(new String[]{ADVCONTOOLBARAP});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        Search treeSearch = (Search)this.getView().getControl("treesearchap");
        Search entrySearch = (Search)this.getView().getControl("entrysearchap");
        if (treeSearch != null) {
            treeSearch.addEnterListener((SearchEnterListener)this);
        }
        if (entrySearch != null) {
            entrySearch.addEnterListener((SearchEnterListener)this);
        }
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        CalPayRollTaskContext calPayRollTaskContext = this.getCalPayRollTaskContext();
        Map operationParam = ((CalPayRollTask)calPayRollTaskContext.getValidDatas().get(0)).getOperationParam();
        Long calRuleVid = Long.valueOf((String)operationParam.get("calRuleHisId"));
        Map salaryItemMap = CalResultCoverHelper.assembleCoverSalaryItemMap((Long)calRuleVid);
        if (salaryItemMap.size() == 0) {
            return;
        }
        try {
            List excludeItemIdList = CalResultCoverHelper.invokeResultCoverSalaryItemExtPoint((Long)this.getTaskIdParam());
            logger.info("excludeItemIdList:{}", (Object)excludeItemIdList);
            if (!SWCListUtils.isEmpty((List)excludeItemIdList)) {
                Iterator iterator = excludeItemIdList.iterator();
                while (iterator.hasNext()) {
                    long itemid = (Long)iterator.next();
                    salaryItemMap.remove(itemid + "");
                }
            }
        }
        catch (Exception exception) {
            logger.error("invokeResultCoverSalaryItemExtPoint error", (Throwable)exception);
        }
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.setMulti(true);
        String text = "";
        this.buildTree(salaryItemMap, text, true);
        this.initCountCheckLabel();
        try {
            String salaryItemMapStr = SWCJSONUtils.toString((Object)salaryItemMap);
            this.getPageCache().put(CACHE_KEY_SALARYITEMMAP, salaryItemMapStr);
            this.getPageCache().put(SEARCH_TEXT, text);
        }
        catch (IOException exception) {
            logger.error(exception.getMessage());
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalResultCoverSalaryItemPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs args) {
        Map<String, Object> lastestSalaryItemMap = this.getLastestSalaryItemMap();
        String searchText = this.getPageCache().get(SEARCH_TEXT);
        this.buildTree(lastestSalaryItemMap, searchText, true);
        this.getView().updateView(KEY_ENTRYENTITY);
        this.updateRightCheckedCount();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        switch (key = ctlSource.getKey()) {
            case "btn_add": {
                this.addSalaryItemToRight();
                break;
            }
            case "btn_remove": {
                this.getLastestSalaryItemMap();
                break;
            }
            case "btn_selectallleft": {
                this.leftTreeSelectAll();
                break;
            }
            case "btn_reset": {
                this.resetLeft();
                break;
            }
            case "btnok": {
                boolean flag = this.checkHasSelectedData();
                if (flag) {
                    CalPayRollTaskContext calPayRollTaskContext = this.getCalPayRollTaskContext();
                    Map operationParam = ((CalPayRollTask)calPayRollTaskContext.getValidDatas().get(0)).getOperationParam();
                    this.cacheSelectedSalaryItem();
                    HashMap returnData = Maps.newHashMapWithExpectedSize((int)3);
                    returnData.put("isOk", Boolean.TRUE);
                    returnData.put("openType", operationParam.get("openType"));
                    this.getView().returnDataToParent((Object)returnData);
                    this.getView().close();
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8986\u76d6\u7684\u85aa\u916c\u9879\u76ee\u3002", (String)"CalResultCoverSalaryItemPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private boolean checkHasSelectedData() {
        DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity(KEY_ENTRYENTITY);
        return entryEntity != null && entryEntity.size() != 0;
    }

    private void cacheSelectedSalaryItem() {
        DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity(KEY_ENTRYENTITY);
        LinkedHashMap<Long, Map> salaryItemMap = new LinkedHashMap<Long, Map>(entryEntity.size());
        for (DynamicObject obj : entryEntity) {
            Map itemMap = salaryItemMap.getOrDefault(obj.getString(KEY_ITEM_ID), new HashMap(2));
            itemMap.put(KEY_ITEM_NAME, obj.getString(KEY_ITEM_NAME));
            itemMap.put(KEY_ITEM_ID, obj.getString(KEY_ITEM_ID));
            salaryItemMap.put(obj.getLong(KEY_ITEM_ID), itemMap);
        }
        CalPayRollTask calPayRollTask = (CalPayRollTask)this.getCalPayRollTaskContext().getValidDatas().get(0);
        String pageId = (String)calPayRollTask.getOperationParam().get("pageId");
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", calPayRollTask.getCalPayRollTaskId()));
        String personSimpleDataCacheKey = String.format("personSimpleData_%d_%s", calPayRollTask.getCalPayRollTaskId(), pageId);
        Map personSimpleDataMap = (Map)appCache.get(personSimpleDataCacheKey, Map.class);
        CalResultCoverHelper.assembleSalaryItemData(salaryItemMap);
        CalResultCoverHelper.assembleSelectedSalaryItemData((Long)calPayRollTask.getCalPayRollTaskId(), salaryItemMap, (Map)personSimpleDataMap);
        String cacheKey = String.format("salaryItemTransfer_%d_%s", calPayRollTask.getCalPayRollTaskId(), pageId);
        appCache.put(cacheKey, salaryItemMap);
        appCache.put(personSimpleDataCacheKey, (Object)personSimpleDataMap);
    }

    private void leftTreeSelectAll() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        String treeNodeStr = this.getPageCache().get(TREE_NODE);
        List treeNodeList = JSON.parseArray((String)treeNodeStr, TreeNode.class);
        treeView.checkNodes(treeNodeList);
        this.updateLeftCheckCount(true, treeNodeList.size());
    }

    private void resetLeft() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        String treeNodeStr = this.getPageCache().get(TREE_NODE);
        List treeNodeList = JSON.parseArray((String)treeNodeStr, TreeNode.class);
        List nodeIds = treeNodeList.stream().map(TreeNode::getId).collect(Collectors.toList());
        treeView.uncheckNodes(nodeIds);
        this.updateLeftCheckCount(true, 0);
    }

    private void addSalaryItemToRight() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        List selectedNodesList = treeView.getTreeState().getSelectedNodes();
        List<Map<String, Object>> validNodesList = this.checkNodesExist(selectedNodesList);
        if (SWCListUtils.isEmpty(validNodesList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u6570\u636e\u3002", (String)"CalResultCoverSalaryItemPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        this.addEntryRow(validNodesList);
        this.rebuildLeftTree();
        this.updateLeftCheckCount(false, 0);
        this.getPageCache().batchRemove(Arrays.asList(SEARCH_COUNT, SELECTED_TREE_NODE));
    }

    private List<Map<String, Object>> checkNodesExist(List<Map<String, Object>> selectedNodesList) {
        ArrayList<Map<String, Object>> validNodesList = new ArrayList<Map<String, Object>>(10);
        DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity(KEY_ENTRYENTITY);
        if (entryEntity != null && entryEntity.size() > 0) {
            List selectedItemIdList = entryEntity.stream().map(entry -> entry.getString(KEY_ITEM_ID)).collect(Collectors.toList());
            for (Map<String, Object> map : selectedNodesList) {
                String itemId = map.get("id").toString();
                if (selectedItemIdList.contains(itemId)) continue;
                validNodesList.add(map);
            }
        } else {
            validNodesList.addAll(selectedNodesList);
        }
        return validNodesList;
    }

    private void addEntryRow(List<Map<String, Object>> selectedNodesList) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int count = model.getEntryRowCount(KEY_ENTRYENTITY);
        model.batchCreateNewEntryRow(KEY_ENTRYENTITY, selectedNodesList.size());
        for (int i = 0; i < selectedNodesList.size(); ++i) {
            String fieldName = (String)selectedNodesList.get(i).get("text");
            String fieldKey = selectedNodesList.get(i).get("id").toString();
            this.getModel().setValue(KEY_ITEM_ID, (Object)fieldKey, count + i);
            this.getModel().setValue(KEY_ITEM_NAME, (Object)fieldName, count + i);
        }
        this.getView().sendFormAction(this.getView());
        this.updateRightTotalCount(count + selectedNodesList.size());
    }

    private void updateRightTotalCount(int count) {
        Label rightCount = (Label)this.getView().getControl(KEY_RIGHT_COUNT);
        rightCount.setText(count + "");
    }

    private void updateRightCheckedCount() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        Label rightCheck = (Label)this.getView().getControl(KEY_RIGHT_CHECK);
        rightCheck.setText(selectRows.length + "");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    private void rebuildLeftTree() {
        try {
            Map<String, Object> salaryItemMap = this.getLastestSalaryItemMap();
            logger.info("lastestSalaryItemMap:{}", (Object)salaryItemMap.toString());
            String searchText = this.getPageCache().get(SEARCH_TEXT);
            this.buildTree(salaryItemMap, searchText, false);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalResultCoverSalaryItemPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
    }

    private void initCountCheckLabel() {
        Label rightCount = (Label)this.getView().getControl(KEY_RIGHT_COUNT);
        Label leftCheck = (Label)this.getView().getControl(KEY_LEFT_CHECK);
        Label rightCheck = (Label)this.getView().getControl(KEY_RIGHT_CHECK);
        leftCheck.setText("0");
        rightCount.setText("0");
        rightCheck.setText("0");
    }

    private List<TreeNode> buildTree(Map<String, Object> salaryItemMap, String text, boolean isManul) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.deleteAllNodes();
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(salaryItemMap.size());
        treeView.setMulti(true);
        treeView.setRootVisible(true);
        treeView.setDraggable(true);
        treeView.setDroppable(true);
        if (text.isEmpty()) {
            for (Map.Entry<String, Object> entry : salaryItemMap.entrySet()) {
                TreeNode node = new TreeNode("", entry.getKey(), entry.getValue().toString(), false);
                treeView.addNode(node);
                nodes.add(node);
            }
        } else {
            for (Map.Entry<String, Object> entry : salaryItemMap.entrySet()) {
                if (!String.valueOf(entry.getValue()).contains(text)) continue;
                TreeNode node = new TreeNode("", entry.getKey(), entry.getValue().toString(), false);
                treeView.addNode(node);
                nodes.add(node);
            }
            if (isManul && nodes.size() == 0 && SWCStringUtils.isNotEmpty((String)text)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"CalSortColumnPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
        }
        Label leftCount = (Label)this.getView().getControl(KEY_LEFT_COUNT);
        leftCount.setText(nodes.size() + "");
        try {
            String treeNodeStr = SWCJSONUtils.toString(nodes);
            this.getPageCache().put(TREE_NODE, treeNodeStr);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalSortColumnPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        return nodes;
    }

    public void treeNodeCheck(TreeNodeCheckEvent event) {
        this.updateLeftCheckCount(false, 0);
    }

    private void updateLeftCheckCount(boolean selectAll, int size) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        Label leftCheck = (Label)this.getView().getControl(KEY_LEFT_CHECK);
        int checked = selectAll ? size : treeView.getTreeState().getCheckedNodeIds().size();
        leftCheck.setText(checked + "");
    }

    private Map<String, Object> getLastestSalaryItemMap() {
        String salaryItemMapStr = this.getPageCache().get(CACHE_KEY_SALARYITEMMAP);
        Map salaryItemMap = SWCJSONUtils.jsonToMap((Object)salaryItemMapStr);
        DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity(KEY_ENTRYENTITY);
        if (entryEntity != null && entryEntity.size() > 0) {
            List selectedItemIdList = entryEntity.stream().map(entry -> entry.getString(KEY_ITEM_ID)).collect(Collectors.toList());
            selectedItemIdList.stream().forEach(salaryItemMap::remove);
            this.updateRightTotalCount(entryEntity.size());
        } else {
            this.updateRightTotalCount(0);
        }
        List nodesIdList = salaryItemMap.keySet().stream().collect(Collectors.toList());
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.uncheckNodes(nodesIdList);
        return salaryItemMap;
    }

    public void search(SearchEnterEvent evt) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.deleteAllNodes();
        String text = evt.getText();
        Map<String, Object> lastestSalaryItemMap = this.getLastestSalaryItemMap();
        List<TreeNode> treeNodeList = this.buildTree(lastestSalaryItemMap, text, true);
        this.getPageCache().put(SEARCH_TEXT, text);
        if (SWCStringUtils.isNotEmpty((String)text) && treeNodeList.size() > 0) {
            this.setNodeFocus(treeView, treeNodeList.size());
        }
        this.updateLeftCheckCount(false, 0);
    }

    private void setNodeFocus(TreeView treeView, int nodeSize) {
        String indexStr = this.getPageCache().get(SEARCH_COUNT);
        String selectedTreeNodeStr = this.getPageCache().get(SELECTED_TREE_NODE);
        ArrayList<TreeNode> selectTreeNodeList = SWCStringUtils.isEmpty((String)selectedTreeNodeStr) ? new ArrayList<TreeNode>(10) : JSON.parseArray((String)selectedTreeNodeStr, TreeNode.class);
        int index = SWCStringUtils.isEmpty((String)indexStr) ? 0 : Integer.parseInt(indexStr) + 1;
        if (index >= nodeSize) {
            treeView.checkNodes(selectTreeNodeList);
            this.updateLeftCheckCount(false, 0);
            return;
        }
        String treeNodeStr = this.getPageCache().get(TREE_NODE);
        List treeNodeList = JSON.parseArray((String)treeNodeStr, TreeNode.class);
        TreeNode treeNode = (TreeNode)treeNodeList.get(index);
        selectTreeNodeList.add(treeNode);
        treeView.checkNodes(selectTreeNodeList);
        this.getPageCache().put(SEARCH_COUNT, index + "");
        this.updateLeftCheckCount(false, 0);
        try {
            this.getPageCache().put(SELECTED_TREE_NODE, SWCJSONUtils.toString(selectTreeNodeList));
        }
        catch (IOException exception) {
            logger.error(exception.getMessage());
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalResultCoverSalaryItemPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
    }

    public CalPayRollTaskContext getCalPayRollTaskContext() {
        return (CalPayRollTaskContext)SerializationUtils.fromJsonString((String)this.getView().getParentView().getPageCache().get("calPayRollTaskContext"), CalPayRollTaskContext.class);
    }

    public void entryRowClick(RowClickEvent evt) {
        this.updateRightCheckedCount();
    }

    private Long getTaskIdParam() {
        CalPayRollTask task = (CalPayRollTask)this.getCalPayRollTaskContext().getValidDatas().get(0);
        if (task == null) {
            return null;
        }
        return task.getCalPayRollTaskId();
    }
}

