/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calpersonlist;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.cal.helper.CalPersonListHelper;
import kd.swc.hsas.business.progress.CalPersonOPProgressInfo;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class DelPersonProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(DelPersonProgressPlugin.class);
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String KEY_LBLPROGRESS = "lblprogress";

    public void initialize() {
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressBar.start();
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        ISWCAppCache appCache = SWCAppCache.get((String)"hsas");
        CalPersonOPProgressInfo progressInfo = (CalPersonOPProgressInfo)appCache.get(String.format(Locale.ROOT, "CAL_PERSON_DEL_CACHE_KEY_%s", taskId), CalPersonOPProgressInfo.class);
        if (progressInfo != null) {
            this.setInfoText(progressInfo.getTotal(), 0);
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        ISWCAppCache appCache = SWCAppCache.get((String)"hsas");
        CalPersonOPProgressInfo progressInfo = (CalPersonOPProgressInfo)appCache.get(String.format(Locale.ROOT, "CAL_PERSON_DEL_CACHE_KEY_%s", taskId), CalPersonOPProgressInfo.class);
        if (progressInfo == null) {
            this.getView().close();
        } else {
            int percentage = 0;
            int total = progressInfo.getTotal();
            int finishCount = progressInfo.getFinish();
            if (total > 0) {
                percentage = new BigDecimal(String.valueOf(finishCount)).divide(new BigDecimal(String.valueOf(total)), 2, 1).multiply(new BigDecimal("100")).intValue();
            }
            progressEvent.setProgress(percentage);
            this.setInfoText(total, finishCount);
            if (percentage == 100) {
                this.getPageCache().put("couldClose", "1");
                IFormView parentView = this.getView().getParentView();
                CalPersonListHelper.showDelResult((int)total, (List)progressInfo.getFailList(), (IFormView)parentView);
                if (parentView != null) {
                    this.getView().sendFormAction(parentView);
                    IFormView grandfatherView = parentView.getParentView();
                    if (grandfatherView instanceof IListView) {
                        ((IListView)grandfatherView).refresh();
                        this.getView().sendFormAction(grandfatherView);
                    }
                }
                this.getView().close();
            }
        }
    }

    private void setInfoText(int total, int finishCount) {
        Label lblprogress = (Label)this.getControl(KEY_LBLPROGRESS);
        lblprogress.setText(ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u5206\u6279\u5904\u7406\uff0c\u6bcf\u62795000\u4eba\uff0c\u5df2\u5b8c\u6210{0}\uff0c\u603b\u6570{1}\u4eba\u3002", (String)"DelPersonProgressPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[]{finishCount, total}));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String couldClose = this.getView().getPageCache().get("couldClose");
        if (!SWCStringUtils.equals((String)"1", (String)couldClose)) {
            e.setCancel(true);
        }
    }
}

