/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calpersonlist;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.EntryGridSetRowDataEvent;
import kd.bos.form.control.events.EntryGridSetRowDataListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.swc.hsas.business.cal.helper.CalHelper;
import kd.swc.hsas.business.cal.helper.CalResultCoverHelper;
import kd.swc.hsas.business.cal.helper.CalTableCalHelper;
import kd.swc.hsas.business.cal.service.ResultCoverService;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.cal.vo.CalPayRollTaskContext;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsas.formplugin.web.calpersonlist.ResultCoverEntryGridControl;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.SWCErrorInfoEnum;
import kd.swc.hsbp.common.enums.SWCShowType;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;

public class ResultCoverListPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
EntryGridBindDataListener,
EntryGridSetRowDataListener {
    private static final Log logger = LogFactory.getLog(ResultCoverListPlugin.class);
    private static final String KEY_SEARCH = "searchap";
    private static final String KEY_TIPS_OFF = "tipsoff";
    private static final String BTN_CLEAR = "donothing_clear";
    private static final String BTN_DELETE = "donothing_delete";
    private static final String BTN_SAVE = "donothing_save";
    private static final String BTN_ADD = "donothing_add";
    private static final String SAVE_CONFIRM_CALLBACK = "save_confirm_callback";
    private static final String NEW_CALVERSION_CALLBACK = "new_calversion_callback";
    private static final String RECAL_VERSION_DATA_KEY = "recal_version_data_key";
    private static final String ADD_PERSON_CALLBACK = "add_person_callback";
    private static final String CONTINUE_CLOSE_CALLBACK = "continue_close";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"entryentity"});
        this.createAndReplaceEntryControl();
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        Search search = (Search)this.getView().getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        entryGrid.addSetRowDataListener((EntryGridSetRowDataListener)this);
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.initTaskInfo();
        this.initTitle();
        this.getView().getPageCache().put("isView", "0");
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCH, (CharSequence)search.getKey())) {
            String searchText = evt.getText();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            String currentPageIndex = this.getCurrentPageIndex();
            CalResultCoverHelper.updateModelToChangeData((int)this.getPageRow(), (String)currentPageIndex, (String)this.getCoverType(), (DynamicObjectCollection)entryEntity, (Long)this.getTaskId(), (String)this.getPersonPageId());
            CalResultCoverHelper.cacheSearchText((String)searchText, (Long)this.getTaskId(), (String)this.getPersonPageId());
            CalResultCoverHelper.loadGridData((IDataModel)this.getModel(), (int)Integer.parseInt(currentPageIndex), (int)this.getPageRow(), (IPageCache)this.getView().getPageCache(), (String)"entryentity", (IClientViewProxy)this.getClientService(), (boolean)false);
            this.getView().updateView("entryentity");
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs metasArgs) {
        FormShowParameter formShowParam = (FormShowParameter)metasArgs.getSource();
        Long taskId = (Long)formShowParam.getCustomParam("taskId");
        String personPageId = (String)formShowParam.getCustomParam("personPageId");
        String coverType = (String)formShowParam.getCustomParam("coverType");
        int precision = (Integer)formShowParam.getCustomParam("precision");
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)formShowParam.getFormId(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        Map salaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap((Long)taskId, (String)personPageId);
        EntryAp entryAp = CalResultCoverHelper.createEntryAp((int)precision, (EntityMetadata)entityMetadata, (Map)salaryItemMap, (String)coverType, (boolean)false);
        Object columns = entryAp.createControl().get("columns");
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)columns);
        metasArgs.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs eventArgs) {
        MainEntityType newMainType;
        MainEntityType oldMainType = eventArgs.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new KDBizException((Throwable)e1, new ErrorCode("", e1.getMessage()), new Object[0]);
        }
        Map salaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap((Long)this.getTaskId(), (String)this.getPersonPageId());
        CalResultCoverHelper.registerProp((EntryType)((EntryType)newMainType.getAllEntities().get("entryentity")), (Map)salaryItemMap, (String)this.getCoverType(), (Long)this.getTaskId(), (boolean)false);
        try {
            newMainType = (MainEntityType)newMainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new KDBizException((Throwable)e1, new ErrorCode("", e1.getMessage()), new Object[0]);
        }
        eventArgs.setNewEntityType(newMainType);
    }

    public void afterCreateNewData(EventObject eventObject) {
        CalResultCoverHelper.loadGridData((IDataModel)this.getModel(), (int)1, (int)this.getPageRow(), (IPageCache)this.getView().getPageCache(), (String)"entryentity", (IClientViewProxy)this.getClientService(), (boolean)false);
    }

    public void entryGridSetRowData(EntryGridSetRowDataEvent event) {
        Map values = event.getValues();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        Integer pageRows = entryGrid.getEntryState().getPageRows();
        Integer pageIndex = entryGrid.getEntryState().getCurrentPageIndex();
        Integer maxRowIndex = pageRows * pageIndex;
        for (Map.Entry entry : values.entrySet()) {
            List value = (List)entry.getValue();
            Iterator iterator = value.iterator();
            while (iterator.hasNext()) {
                Tuple next = (Tuple)iterator.next();
                Integer rowIndex = (Integer)next.item1;
                if (rowIndex < maxRowIndex) continue;
                iterator.remove();
            }
        }
    }

    public void beforeBindData(EventObject eventObject) {
        FormShowParameter formShowParam = this.getView().getFormShowParameter();
        Long taskId = (Long)formShowParam.getCustomParam("taskId");
        String personPageId = (String)formShowParam.getCustomParam("personPageId");
        String coverType = (String)formShowParam.getCustomParam("coverType");
        int precision = (Integer)formShowParam.getCustomParam("precision");
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hsas_calresultcoverlist", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        Map salaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap((Long)taskId, (String)personPageId);
        EntryAp entryAp = CalResultCoverHelper.createEntryAp((int)precision, (EntityMetadata)entityMetadata, (Map)salaryItemMap, (String)coverType, (boolean)false);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        List controlList = ((Container)entryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : controlList) {
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void onGetControl(OnGetControlArgs args) {
        String key = args.getKey();
        if (SWCStringUtils.equals((String)key, (String)"entryentity")) {
            EntryGrid entryGrid = this.createEntryControl();
            entryGrid.addSetRowDataListener((EntryGridSetRowDataListener)this);
            args.setControl((Control)entryGrid);
        } else {
            this.initItemField(args, key);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        operationResult.setShowMessage(false);
        if (operationResult != null && operationResult.isSuccess()) {
            switch (opKey) {
                case "donothing_save": {
                    this.saveCoverResult();
                    break;
                }
                case "donothing_clear": {
                    this.clearCalResultCover();
                    break;
                }
                case "donothing_delete": {
                    this.deleteCalResultCover();
                    break;
                }
                case "donothing_add": {
                    this.addCalPerson();
                    break;
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        Long taskId = this.getTaskId();
        String personPageId = this.getPersonPageId();
        String opName = ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u8986\u76d6", (String)"ResultCoverListPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        switch (callBackId) {
            case "new_calversion_callback": {
                this.execSaveAndReCal(this.getCacheVersionNo(result), opName, this.getIsCurPage(), taskId);
                break;
            }
            case "save_confirm_callback": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.getView().getParentView().getPageCache().put("invokeOperation", "true");
                    boolean flag = this.checkNewCalVersion(false);
                    if (!flag) break;
                    this.execSaveAndReCal(this.getCacheVersionNo(result), opName, this.getIsCurPage(), taskId);
                    break;
                }
                if (!MessageBoxResult.No.equals((Object)result)) break;
                this.getView().getParentView().getPageCache().put("invokeOperation", "true");
                this.onlySaveCoverData(taskId, personPageId, opName);
                break;
            }
            case "continue_close": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                this.deleteCacheData();
                this.getView().getPageCache().put("forceClose", "1");
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)event.getReturnData();
        if (SWCListUtils.isEmpty((List)returnData)) {
            CalResultCoverHelper.loadGridData((IDataModel)this.getModel(), (int)1, (int)this.getPageRow(), (IPageCache)this.getView().getPageCache(), (String)"entryentity", (IClientViewProxy)this.getClientService(), (boolean)false);
            this.getView().updateView("entryentity");
            return;
        }
        String coverType = this.getCoverType();
        ResultCoverService service = CalResultCoverHelper.getResultCoverService((String)coverType);
        switch (actionId) {
            case "add_person_callback": {
                int total;
                List personIdList = returnData.stream().map(single -> (Long)single.getPrimaryKeyValue()).collect(Collectors.toList());
                Long taskId = this.getTaskId();
                String pageId = this.getPersonPageId();
                if (SWCStringUtils.equals((String)"1", (String)coverType)) {
                    List existDataList = CalResultCoverHelper.getCacheProrationCoverDataList((Long)taskId, (String)pageId, (boolean)false);
                    DynamicObject task = CalPayrollTaskHelper.queryTaskInfoById((Long)taskId);
                    DynamicObject calRuleHisObj = task.getDynamicObject("calrulev");
                    List prorationItemDataList = CalResultCoverHelper.getProrationItemDataList((Long)calRuleHisObj.getLong("id"), personIdList, (boolean)false, (Long)taskId);
                    total = prorationItemDataList.size() + existDataList.size();
                } else {
                    Map existSumDataMap = CalResultCoverHelper.getCachePersonSimpleDataMap((Long)taskId, (String)pageId, (boolean)false);
                    total = personIdList.size() + existSumDataMap.size();
                }
                String msg = "";
                logger.info("total_addpersonata_size:{}", (Object)total);
                if (total > 20000) {
                    msg = ResManager.loadKDString((String)"\u6dfb\u52a0\u7684\u6570\u636e\u4f1a\u5bfc\u81f4\u5f39\u7a97\u603b\u6570\u636e\u8d85\u8fc7\u6700\u5927\u9650\u52362\u4e07\u884c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ResultCoverListPlugin_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                }
                if (SWCStringUtils.isNotEmpty((String)msg)) {
                    this.getView().showTipNotification(msg);
                    break;
                }
                service.addNewPersonData(personIdList, taskId, pageId);
                CalResultCoverHelper.loadGridData((IDataModel)this.getModel(), (int)1, (int)this.getPageRow(), (IPageCache)this.getView().getPageCache(), (String)"entryentity", (IClientViewProxy)this.getClientService(), (boolean)false);
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String currentPageIndex = this.getCurrentPageIndex();
        CalResultCoverHelper.updateModelToChangeData((int)this.getPageRow(), (String)currentPageIndex, (String)this.getCoverType(), (DynamicObjectCollection)entryEntity, (Long)this.getTaskId(), (String)this.getPersonPageId());
        boolean isChange = this.getDataChanged();
        String forceClose = this.getView().getPageCache().get("forceClose");
        if (SWCStringUtils.equals((String)"1", (String)forceClose)) {
            return;
        }
        if (isChange && event.isCheckDataChange()) {
            event.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONTINUE_CLOSE_CALLBACK, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"HSASCalTableList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"HSASCalTableList_88", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ResultCoverListPlugin_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            String changeMsg = ResManager.loadKDString((String)"\u53d8\u52a8\u6570\u636e\uff1a\u201c{0}\u201d\u3002", (String)"ResultCoverListPlugin_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            String changeDesc = MessageFormat.format(changeMsg, this.getChangeItemMsg());
            this.getView().showConfirm(msg, changeDesc, options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
    }

    public void pageRelease(EventObject event) {
        super.pageRelease(event);
        Long calPayRollTaskId = this.getTaskId();
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", calPayRollTaskId));
        String curSearchTextcacheKey = String.format(Locale.ROOT, "curSearchText_%d_%s", calPayRollTaskId, this.getPersonPageId());
        String curPersoncacheKey = String.format(Locale.ROOT, "curPersonIdList_%s_%s", calPayRollTaskId, this.getPersonPageId());
        String itemIndexcacheKey = String.format(Locale.ROOT, "itemIndex_%d_%s", calPayRollTaskId, this.getPersonPageId());
        String changeDatacacheKey = String.format(Locale.ROOT, "changeData_%d_%s", calPayRollTaskId, this.getPersonPageId());
        String prorationChangeDatacacheKey = String.format(Locale.ROOT, "prorationChangeData_%d_%s", calPayRollTaskId, this.getPersonPageId());
        String rowsIdMapcacheKey = String.format(Locale.ROOT, "rowsIdMap_%d_%s", calPayRollTaskId, this.getPersonPageId());
        String waitDeletecacheKey = String.format(Locale.ROOT, "waitDeleteData_%d_%s", calPayRollTaskId, this.getPersonPageId());
        appCache.remove(curSearchTextcacheKey);
        appCache.remove(curPersoncacheKey);
        appCache.remove(itemIndexcacheKey);
        appCache.remove(changeDatacacheKey);
        appCache.remove(rowsIdMapcacheKey);
        appCache.remove(waitDeletecacheKey);
        appCache.remove(prorationChangeDatacacheKey);
        String memoCacheKey = String.format(Locale.ROOT, "memoChangeData_%d_%s", calPayRollTaskId, this.getPersonPageId());
        appCache.remove(memoCacheKey);
        PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(this.getTaskId()), (String)CalPersonOperationEnum.OP_CAL_RESULT_COVER.getOperationKey());
    }

    private void initTitle() {
        FormShowParameter formShowParameter = this.getFormShowParameter();
        String coverType = (String)formShowParameter.getCustomParam("coverType");
        String captionName = this.getCaption(coverType);
        Label caption = (Label)this.getView().getControl("labelap");
        caption.setText(captionName);
    }

    private String getCaption(String type) {
        String caption = SWCStringUtils.equals((String)"2", (String)type) ? ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u8986\u76d6", (String)"CalPersonResultCoverOperateList_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5206\u6bb5\u7ed3\u679c\u8986\u76d6", (String)"CalPersonResultCoverOperateList_17", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        return caption;
    }

    private void initItemField(OnGetControlArgs args, String key) {
        Map salaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap((Long)this.getTaskId(), (String)this.getPersonPageId());
        if (salaryItemMap == null) {
            return;
        }
        String itemId = key.substring(4);
        Map itemMap = (Map)salaryItemMap.get(itemId);
        if (itemMap == null || itemMap.size() == 0) {
            return;
        }
        Object field = SWCShowType.DATE.getCode().equals(itemMap.get("datatype")) ? new DateEdit() : (SWCShowType.AMOUNT.getCode().equals(itemMap.get("datatype")) ? new AmountEdit() : (SWCShowType.NUM.getCode().equals(itemMap.get("datatype")) ? new DecimalEdit() : new TextEdit()));
        field.setFieldKey(key);
        field.setEntryKey("entryentity");
        field.setEntryControlKey("entryentity");
        field.setView(this.getView());
        field.setKey(key);
        field.setModel(this.getView().getModel());
        args.setControl((Control)field);
    }

    private String getChangeItemMsg() {
        Map map;
        StringBuilder sb = new StringBuilder();
        Long taskId = this.getTaskId();
        String personPageId = this.getPersonPageId();
        Map sumChangeData = CalResultCoverHelper.getSumChangeData((String)personPageId, (long)taskId);
        Map prorationChangeData = CalResultCoverHelper.getProrationChangeData((String)personPageId, (long)taskId);
        List waitDeleteData = CalResultCoverHelper.getWaitDeleteData((String)personPageId, (long)taskId);
        Map personMap = CalResultCoverHelper.getCachePersonSimpleDataMap((Long)taskId, (String)personPageId, (boolean)false);
        List prorationDataList = CalResultCoverHelper.getCacheProrationCoverDataList((Long)taskId, (String)personPageId, (boolean)false);
        Map prorationDataMap = prorationDataList.stream().collect(Collectors.toMap(dataKey -> (String)dataKey.get("idstr"), Function.identity(), (v1, v2) -> v1));
        String coverType = this.getCoverType();
        if (SWCStringUtils.equals((String)"2", (String)coverType) && sumChangeData.size() > 0) {
            for (Map.Entry entry : sumChangeData.entrySet()) {
                map = (Map)personMap.get(entry.getKey());
                if (map == null || map.size() == 0) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append((String)map.get("filenumber"));
            }
        }
        if (SWCStringUtils.equals((String)"1", (String)coverType) && prorationChangeData.size() > 0) {
            for (Map.Entry entry : prorationChangeData.entrySet()) {
                String idstr = (String)entry.getKey();
                Map map2 = (Map)prorationDataMap.get(idstr);
                if (map2 == null || map2.size() == 0) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append((String)map2.get("filenumber"));
            }
        }
        if (waitDeleteData.size() > 0) {
            for (String personId : waitDeleteData) {
                map = SWCStringUtils.equals((String)"1", (String)coverType) ? (Map)prorationDataMap.get(personId) : (Map)personMap.get(String.valueOf(personId));
                if (map == null || map.size() == 0) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append((String)map.get("filenumber"));
            }
        }
        return sb.toString();
    }

    protected boolean getDataChanged() {
        String personPageId = this.getPersonPageId();
        Long taskId = this.getTaskId();
        String coverType = this.getCoverType();
        Map sumChangeData = CalResultCoverHelper.getSumChangeData((String)personPageId, (long)taskId);
        Map prorationChangeData = CalResultCoverHelper.getProrationChangeData((String)personPageId, (long)taskId);
        if (SWCStringUtils.equals((String)"1", (String)coverType) && prorationChangeData.size() == 0) {
            return false;
        }
        return !SWCStringUtils.equals((String)"2", (String)coverType) || sumChangeData.size() != 0;
    }

    private void onlySaveCoverData(Long taskId, String personPageId, String opName) {
        ResultCoverService service = CalResultCoverHelper.getResultCoverService((String)this.getCoverType());
        service.doOnlySave(true, "1", taskId, personPageId);
        IPageCache pageCache = this.getView().getPageCache();
        String currentPageIndex = pageCache.get("currentPageIndex");
        if (SWCStringUtils.isEmpty((String)currentPageIndex)) {
            currentPageIndex = "1";
        }
        this.deleteCacheData();
        this.getView().getPageCache().put("forceClose", "1");
        CalResultCoverHelper.loadGridData((IDataModel)this.getModel(), (int)Integer.parseInt(currentPageIndex), (int)this.getPageRow(), (IPageCache)pageCache, (String)"entryentity", (IClientViewProxy)this.getClientService(), (boolean)false);
        this.getView().updateView("entryentity");
        String successMsg = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"ResultCoverListPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u8ba1\u7b97\u7ed3\u679c\u8986\u76d6", "ResultCoverListPlugin_2", "swc-hsas-formplugin");
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u64cd\u4f5c\u6210\u529f\u3002", "ResultCoverListPlugin_6", "swc-hsas-formplugin");
        SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)BTN_SAVE, (MultiLangEnumBridge)opNameBridge, null, (MultiLangEnumBridge)opDescBridge, null);
        this.getView().showSuccessNotification(successMsg);
    }

    private void addCalPerson() {
        Long taskId = this.getTaskId();
        String personPageId = this.getPersonPageId();
        String coverType = this.getCoverType();
        Boolean taxCalEnable = TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)taskId);
        ListShowParameter showParameter = this.setListShowParam(taskId);
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        List<String> taxOnValidCalStatus = Arrays.asList(CalStateEnum.UNCAL.getCode(), CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.ALL_CALED.getCode(), CalStateEnum.PRECAL_ERROR.getCode(), CalStateEnum.PUSHTAX_ERROR.getCode(), CalStateEnum.TAXCAL_ERROR.getCode(), CalStateEnum.PULLTAX_ERROR.getCode(), CalStateEnum.AFTERCAL_ERROR.getCode(), CalStateEnum.CANCELCAL_ERROR.getCode());
        List<String> taxOffValidCalStatus = Arrays.asList(CalStateEnum.UNCAL.getCode(), CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.ALL_CALED.getCode(), CalStateEnum.PRECAL_ERROR.getCode(), CalStateEnum.AFTERCAL_ERROR.getCode(), CalStateEnum.CANCELCAL_ERROR.getCode());
        qFilters.add(new QFilter("caltask", "=", (Object)taskId));
        if (taxCalEnable.booleanValue()) {
            qFilters.add(new QFilter("calstatus", "in", taxOnValidCalStatus));
        } else {
            qFilters.add(new QFilter("calstatus", "in", taxOffValidCalStatus));
        }
        if (SWCStringUtils.equals((String)"2", (String)coverType)) {
            Map personSimpleDataMap = CalResultCoverHelper.getCachePersonSimpleDataMap((Long)taskId, (String)personPageId, (boolean)false);
            List existPersonIdList = personSimpleDataMap.keySet().stream().map(personIdStr -> Long.valueOf(personIdStr)).collect(Collectors.toList());
            qFilters.add(new QFilter("id", "not in", existPersonIdList));
        } else {
            Set validPersonIdSet = CalResultCoverHelper.assembleValidProrationPersonIdSet((Long)taskId, (String)personPageId);
            qFilters.add(new QFilter("id", "in", (Object)validPersonIdSet));
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String currentPageIndex = this.getCurrentPageIndex();
        CalResultCoverHelper.updateModelToChangeData((int)this.getPageRow(), (String)currentPageIndex, (String)this.getCoverType(), (DynamicObjectCollection)entryEntity, (Long)taskId, (String)personPageId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_PERSON_CALLBACK);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected ListShowParameter setListShowParam(Long calTaskId) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setBillFormId("hsas_retcoverpersonf7");
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u8bb0\u5f55", (String)"HSASCalTableApprovalPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        listShowParameter.setLookUp(true);
        listShowParameter.setMultiSelect(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setHasRight(true);
        listShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        listShowParameter.setCustomParam("calTaskId", (Object)calTaskId);
        listShowParameter.setCustomParam("payrolltaskdataid", (Object)calTaskId);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("id", "=", (Object)calTaskId);
        DynamicObject taskDy = helper.queryOne("id,callistviewv.id,tasktype", new QFilter[]{filter});
        listShowParameter.setCustomParam("calTaskType", (Object)taskDy.getString("tasktype"));
        listShowParameter.setCustomParam("calListViewVid", (Object)taskDy.getString("callistviewv.id"));
        listShowParameter.setCustomParam("pageType", (Object)"approvecalperson");
        return listShowParameter;
    }

    private void execSaveAndReCal(String versionNo, String opName, Boolean isCurPage, Long taskId) {
        ResultCoverService service = CalResultCoverHelper.getResultCoverService((String)this.getCoverType());
        Map<String, Object> checkCertResult = this.checkCertForReCal(taskId, service);
        if (!Boolean.TRUE.equals(checkCertResult.get("success"))) {
            CalHelper.handlePrompts(checkCertResult, (IFormView)this.getView());
            return;
        }
        try {
            service.doSaveAndReCal(versionNo, false, this.getTaskId(), this.getPersonPageId(), "1");
        }
        catch (Exception exception) {
            logger.error("saveAndRecal error", (Throwable)exception);
            this.getView().showErrorNotification(exception.getMessage());
            return;
        }
        this.deleteCacheData();
        IFormView parentView = this.getView().getParentView();
        IFormView showView = isCurPage != false ? this.getView() : parentView;
        this.getView().getPageCache().put("forceClose", "1");
        String successMsg = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"CalResultCoverListPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String checkCertMsg = (String)checkCertResult.get("msg");
        if (SWCStringUtils.isEmpty((String)checkCertMsg)) {
            showView.showSuccessNotification(successMsg);
        } else {
            showView.showForm(CalHelper.getOperationResultParameter((String)(successMsg + "<br/>" + checkCertMsg)));
        }
        this.getView().sendFormAction(parentView);
        this.getView().invokeOperation("close");
        parentView.invokeOperation("refresh");
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u8ba1\u7b97\u7ed3\u679c\u8986\u76d6", "ResultCoverListPlugin_2", "swc-hsas-formplugin");
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u64cd\u4f5c\u6210\u529f\u3002", "ResultCoverListPlugin_6", "swc-hsas-formplugin");
        SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)BTN_SAVE, (MultiLangEnumBridge)opNameBridge, null, (MultiLangEnumBridge)opDescBridge, null);
    }

    private Map<String, Object> checkCertForReCal(Long taskId, ResultCoverService service) {
        ArrayList<CalPayRollTask> calPayRollTaskList = new ArrayList<CalPayRollTask>(1);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        DynamicObject taskDy = helper.queryOriginalOne("calrulev.opentaxcal", new QFilter[]{filter});
        CalPayRollTask calPayRollTask = new CalPayRollTask();
        String openTaxCal = taskDy.getString("calrulev.opentaxcal");
        if (SWCStringUtils.isEmpty((String)openTaxCal) || SWCStringUtils.equals((String)"0", (String)openTaxCal)) {
            calPayRollTask.setOpenTaxCal("0");
        } else {
            calPayRollTask.setOpenTaxCal("1");
        }
        calPayRollTaskList.add(calPayRollTask);
        List calPersonIdList = service.getNeedRecalPersonIdList(this.getTaskId(), this.getPersonPageId());
        calPayRollTask.setCalPersons(calPersonIdList);
        return CalHelper.checkCert((List)calPersonIdList, calPayRollTaskList);
    }

    private boolean getIsCurPage() {
        String versionStr = this.getView().getPageCache().get(RECAL_VERSION_DATA_KEY);
        if (SWCStringUtils.isEmpty((String)versionStr)) {
            return false;
        }
        try {
            Map versionMap = (Map)JSONUtils.cast((String)versionStr, Map.class);
            return (Boolean)versionMap.get("isCurPage");
        }
        catch (Exception exception) {
            logger.error("cast versionMap error :", (Throwable)exception);
            return false;
        }
    }

    private String getCacheVersionNo(MessageBoxResult result) {
        String versionStr = this.getView().getPageCache().get(RECAL_VERSION_DATA_KEY);
        if (SWCStringUtils.isEmpty((String)versionStr)) {
            return "";
        }
        String versionNo = "";
        try {
            Map versionMap = (Map)JSONUtils.cast((String)versionStr, Map.class);
            if (MessageBoxResult.Yes.equals((Object)result)) {
                Map versionData = (Map)versionMap.get("formula_grade_cachekey");
                if (versionData != null) {
                    versionNo = CalTableCalHelper.createCalVersion((Map)versionData);
                } else {
                    Map oldVersionData = (Map)versionMap.get("formula_grade_verion");
                    versionNo = (String)oldVersionData.get("calVersionNo");
                }
            } else {
                Map versionData = (Map)versionMap.get("formula_grade_verionold");
                versionNo = (String)versionData.get("calVersionNo");
            }
        }
        catch (Exception exception) {
            logger.error("cast versionMap error :", (Throwable)exception);
        }
        return versionNo;
    }

    public boolean checkNewCalVersion(boolean isCurPage) {
        CalPayRollTask calPayRollTask = this.getCalPayRollTask();
        DynamicObject taskDyObj = CalPayrollTaskHelper.queryTaskInfoById((Long)calPayRollTask.getCalPayRollTaskId());
        Map operationParam = calPayRollTask.getOperationParam();
        operationParam.put("enddate", SWCDateTimeUtils.format((Date)taskDyObj.getDate("ENDDATE"), (String)"yyyy-MM-dd"));
        operationParam.put("startdate", SWCDateTimeUtils.format((Date)taskDyObj.getDate("startdate"), (String)"yyyy-MM-dd"));
        operationParam.put("calType", "preTaxCal");
        long taxItemSchemeVid = taskDyObj.getLong("taxitemschemev.id");
        operationParam.put("TAXITEMSCHEMEVID", String.valueOf(taxItemSchemeVid));
        DynamicObject calRuleHisObj = taskDyObj.getDynamicObject("calrulev");
        operationParam.put("calRuleHisId", String.valueOf(calRuleHisObj.getLong("id")));
        HashMap<String, Boolean> versionData = new HashMap<String, Boolean>(16);
        String confirmMessage = CalHelper.initCalFormulaGradeInfo((CalPayRollTask)calPayRollTask, versionData);
        if (SWCStringUtils.isNotEmpty((String)confirmMessage)) {
            versionData.put("isCurPage", isCurPage);
            try {
                this.getView().getPageCache().put(RECAL_VERSION_DATA_KEY, JSONUtils.toString(versionData));
            }
            catch (IOException exception) {
                logger.error("json tostring error", (Throwable)exception);
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6709\u8ba1\u7b97\u5143\u7d20\u4ea7\u751f\u65b0\u7248\u672c\uff0c\u662f\u5426\u5168\u90e8\u5e94\u7528\u65b0\u7248\u672c\u53c2\u4e0e\u8ba1\u7b97\u3002", (String)"ResultCoverListPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(NEW_CALVERSION_CALLBACK, (IFormPlugin)this));
            return false;
        }
        versionData.put("isCurPage", isCurPage);
        try {
            this.getView().getPageCache().put(RECAL_VERSION_DATA_KEY, JSONUtils.toString(versionData));
        }
        catch (IOException exception) {
            logger.error("json tostring error", (Throwable)exception);
        }
        return true;
    }

    public CalPayRollTaskContext getCalPayRollTaskContext() {
        return (CalPayRollTaskContext)SerializationUtils.fromJsonString((String)this.getView().getParentView().getPageCache().get("calPayRollTaskContext"), CalPayRollTaskContext.class);
    }

    public CalPayRollTask getCalPayRollTask() {
        return (CalPayRollTask)this.getCalPayRollTaskContext().getValidDatas().get(0);
    }

    private void saveCoverResult() {
        List validPersonIdList;
        if (!SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"2DXPSF5JTISP")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6838\u7b97\u540d\u5355\u201d\u7684\u201c\u8ba1\u7b97\u7ed3\u679c\u8986\u76d6\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ResultCoverListPlugin_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        String source = (String)this.getView().getFormShowParameter().getCustomParam("source");
        IFormView view = SWCStringUtils.equals((String)"1", (String)source) ? this.getView() : this.getView().getParentView();
        FormShowParameter parentViewParameter = SessionManager.getCurrent().getFormShowParameter(view.getFormShowParameter().getParentPageId());
        if (parentViewParameter != null && parentViewParameter.isCancelDataRight()) {
            view.getFormShowParameter().setCancelDataRight(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ResultCoverListPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener("1000200"));
            return;
        }
        String personPageId = this.getPersonPageId();
        Long taskId = this.getTaskId();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String currentPageIndex = this.getCurrentPageIndex();
        CalResultCoverHelper.updateModelToChangeData((int)this.getPageRow(), (String)currentPageIndex, (String)this.getCoverType(), (DynamicObjectCollection)entryEntity, (Long)taskId, (String)personPageId);
        Map sumChangeData = CalResultCoverHelper.getSumChangeData((String)personPageId, (long)taskId);
        Map prorationChangeData = CalResultCoverHelper.getProrationChangeData((String)personPageId, (long)taskId);
        if (prorationChangeData.size() == 0 && sumChangeData.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u672a\u4f5c\u4fee\u6539\uff0c\u65e0\u9700\u4fdd\u5b58\u3002", (String)"ResultCoverListPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        Set<Object> personIdSet = new HashSet(16);
        if (SWCStringUtils.equals((String)"1", (String)this.getCoverType())) {
            for (String idStr : prorationChangeData.keySet()) {
                String[] split = idStr.split("#");
                personIdSet.add(Long.parseLong(split[0]));
            }
        } else {
            personIdSet = sumChangeData.keySet().stream().map(single -> Long.parseLong(single)).collect(Collectors.toSet());
        }
        if (SWCListUtils.isEmpty((List)(validPersonIdList = CalResultCoverHelper.getValidPersonIdList((long)taskId, new ArrayList(personIdSet))))) {
            this.getView().showConfirm(SWCErrorInfoEnum.COMMON_DATA_RIGHT_CHANGED.getErrInfo(), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener(SWCErrorInfoEnum.COMMON_DATA_RIGHT_CHANGED.getErrCode()));
            return;
        }
        this.saveCoverData();
    }

    private String getCurrentPageIndex() {
        return ((EntryGrid)this.getView().getControl("entryentity")).getEntryState().getCurrentPageIndex() + "";
    }

    private void saveCoverData() {
        String coverType;
        Long taskId = this.getTaskId();
        String personPageId = this.getPersonPageId();
        boolean hasCaled = CalResultCoverHelper.checkHasCaledPerson((String)personPageId, (Long)taskId, (String)(coverType = this.getCoverType()));
        if (hasCaled) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff0c\u8986\u76d6\u6570\u636e\u5728\u4e0b\u4e00\u6b21\u8ba1\u7b97\u624d\u4f1a\u88ab\u4f7f\u7528\uff0c\u662f\u5426\u9700\u8981\u5bf9\u8ba1\u7b97\u8fc7\u7684\u6570\u636e\u91cd\u65b0\u8ba1\u7b97\uff1f", (String)"ResultCoverListPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.openReCalConfirm(msg);
        } else {
            String opName = ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u8986\u76d6", (String)"ResultCoverListPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.onlySaveCoverData(taskId, personPageId, opName);
        }
    }

    private void openReCalConfirm(String msg) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(SAVE_CONFIRM_CALLBACK, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(3);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"ResultCoverListPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u4ec5\u4fdd\u5b58", (String)"ResultCoverListPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u4fdd\u5b58\u5e76\u91cd\u7b97", (String)"ResultCoverListPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.YesNoCancel;
        String changeDescStr = this.getModel().getChangeDesc();
        this.getView().showConfirm(msg, changeDescStr, options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    private void deleteCacheData() {
        this.clearChangeData();
        this.cleanWaitDeleteData();
    }

    private void cleanWaitDeleteData() {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", this.getTaskId()));
        String cacheKey = String.format(Locale.ROOT, "waitDeleteData_%d_%s", this.getTaskId(), this.getPersonPageId());
        appCache.remove(cacheKey);
    }

    private void clearChangeData() {
        Long calTaskId = this.getTaskId();
        String coverType = this.getCoverType();
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", calTaskId));
        String cacheKey = SWCStringUtils.equals((String)"2", (String)coverType) ? String.format(Locale.ROOT, "changeData_%d_%s", calTaskId, this.getPersonPageId()) : String.format(Locale.ROOT, "prorationChangeData_%d_%s", calTaskId, this.getPersonPageId());
        appCache.remove(cacheKey);
        this.getModel().setDataChanged(false);
    }

    private void deleteCalResultCover() {
        List<String> idList = this.getSelectedIdList();
        if (idList == null) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String curPageIndex = this.getCurrentPageIndex();
        CalResultCoverHelper.updateModelToChangeData((int)this.getPageRow(), (String)curPageIndex, (String)this.getCoverType(), (DynamicObjectCollection)entryEntity, (Long)this.getTaskId(), (String)this.getPersonPageId());
        this.removePersonFromCache(idList);
        IPageCache pageCache = this.getView().getPageCache();
        String currentPageIndex = pageCache.get("currentPageIndex");
        if (SWCStringUtils.isEmpty((String)currentPageIndex)) {
            currentPageIndex = "1";
        }
        CalResultCoverHelper.loadGridData((IDataModel)this.getModel(), (int)Integer.parseInt(currentPageIndex), (int)this.getPageRow(), (IPageCache)pageCache, (String)"entryentity", (IClientViewProxy)this.getClientService(), (boolean)false);
        this.getView().updateView("entryentity");
    }

    private void removePersonFromCache(List<String> idList) {
        Long taskId = this.getTaskId();
        String personPageId = this.getPersonPageId();
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String waitClearCacheKey = String.format(Locale.ROOT, "waitDeleteData_%d_%s", taskId, personPageId);
        List waitClearCachePersonIdList = (List)appCache.get(waitClearCacheKey, List.class);
        ResultCoverService service = CalResultCoverHelper.getResultCoverService((String)this.getCoverType());
        String curPageIndex = this.getCurrentPageIndex();
        service.removeCacheDataByIdList(curPageIndex, taskId, personPageId, idList);
        if (waitClearCachePersonIdList != null && waitClearCachePersonIdList.size() > 0) {
            waitClearCachePersonIdList.removeAll(idList);
            appCache.put(waitClearCacheKey, (Object)waitClearCachePersonIdList);
        }
    }

    private int getPageRow() {
        Map settingMap;
        Object pageRows;
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        String setting = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)"entrygridrowconfig_hsas_calresultcoverlist_entryentity");
        if (SWCStringUtils.isNotEmpty((String)setting) && (pageRows = (settingMap = (Map)JSONObject.parseObject((String)setting, Map.class)).get("PageRows")) != null) {
            return Integer.parseInt(pageRows + "");
        }
        return grid.getPageRow();
    }

    private void clearCalResultCover() {
        List<String> idList = this.getSelectedIdList();
        if (idList == null) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String curPageIndex = this.getCurrentPageIndex();
        CalResultCoverHelper.updateModelToChangeData((int)this.getPageRow(), (String)curPageIndex, (String)this.getCoverType(), (DynamicObjectCollection)entryEntity, (Long)this.getTaskId(), (String)this.getPersonPageId());
        this.cacheWaitDeleteData(idList);
        this.clearPersonChangeData(idList, this.getCoverType());
        IPageCache pageCache = this.getView().getPageCache();
        String currentPageIndex = pageCache.get("currentPageIndex");
        if (SWCStringUtils.isEmpty((String)currentPageIndex)) {
            currentPageIndex = "1";
        }
        CalResultCoverHelper.loadGridData((IDataModel)this.getModel(), (int)Integer.parseInt(currentPageIndex), (int)this.getPageRow(), (IPageCache)pageCache, (String)"entryentity", (IClientViewProxy)this.getClientService(), (boolean)false);
        this.getView().updateView("entryentity");
    }

    private List<String> getSelectedIdList() {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u85aa\u8d44\u6863\u6848\u3002", (String)"ResultCoverListPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return null;
        }
        ArrayList<String> idList = new ArrayList<String>(10);
        IPageCache pageCache = this.getView().getPageCache();
        String currentPageIndex = pageCache.get("currentPageIndex");
        if (SWCStringUtils.isEmpty((String)currentPageIndex)) {
            currentPageIndex = "1";
        }
        int pageIndex = Integer.parseInt(currentPageIndex);
        int pageRow = this.getPageRow();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int selectIndex : selectRows) {
            int index = selectIndex - (pageIndex - 1) * pageRow;
            if (index >= entryEntity.size()) continue;
            DynamicObject entryObj = (DynamicObject)entryEntity.get(index);
            idList.add(entryObj.get("idstr") + "");
        }
        return idList;
    }

    private void clearPersonChangeData(List<String> personIdList, String coverType) {
        Long calTaskId = this.getTaskId();
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", calTaskId));
        String personPageId = this.getPersonPageId();
        if (SWCStringUtils.equals((String)"2", (String)coverType)) {
            Map sumChangeDataAllPage = CalResultCoverHelper.getSumChangeDataAllPage((String)personPageId, (long)calTaskId);
            for (Map changeData : sumChangeDataAllPage.values()) {
                if (SWCListUtils.isEmpty(personIdList)) continue;
                for (String personId : personIdList) {
                    changeData.remove(personId);
                }
            }
            CalResultCoverHelper.updateCacheChangeData((Map)sumChangeDataAllPage, (Long)calTaskId, (String)personPageId);
        } else if (SWCStringUtils.equals((String)"1", (String)coverType)) {
            String cacheKeyProration = String.format(Locale.ROOT, "prorationChangeData_%d_%s", calTaskId, personPageId);
            Map changeData = (Map)appCache.get(cacheKeyProration, Map.class);
            if (changeData == null) {
                return;
            }
            if (!SWCListUtils.isEmpty(personIdList)) {
                for (String personId : personIdList) {
                    changeData.remove(personId);
                }
            }
            appCache.put(cacheKeyProration, (Object)changeData);
        }
    }

    private void cacheWaitDeleteData(List<String> personIdList) {
        Long taskId = this.getTaskId();
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String cacheKey = String.format(Locale.ROOT, "waitDeleteData_%d_%s", taskId, this.getPersonPageId());
        ArrayList<String> list = (ArrayList<String>)appCache.get(cacheKey, List.class);
        if (list == null) {
            list = new ArrayList<String>(10);
        }
        list.addAll(personIdList);
        appCache.put(cacheKey, list);
    }

    private List<String> getWaitDeleteIdList() {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", this.getTaskId()));
        String cacheKey = String.format(Locale.ROOT, "waitDeleteData_%d_%s", this.getTaskId(), this.getPersonPageId());
        List idList = (List)appCache.get(cacheKey, List.class);
        return idList == null ? new ArrayList(0) : idList;
    }

    protected IClientViewProxy getClientService() {
        return (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
    }

    private void createAndReplaceEntryControl() {
        EntryGrid grid = this.createEntryControl();
        Container entryParentAp = (Container)CalResultCoverHelper.findControl((List)((Container)this.getView().getRootControl()).getItems(), (String)"advconchildpanelap");
        List subItems = entryParentAp.getItems();
        int index = CalResultCoverHelper.findControlIndex((List)subItems, (String)"entryentity");
        if (index >= 0) {
            subItems.set(index, grid);
        }
        this.getView().createControlIndex(grid.getItems());
    }

    private EntryGrid createEntryControl() {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hsas_calresultcoverlist", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        Map salaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap((Long)this.getTaskId(), (String)this.getPersonPageId());
        Map taskMap = CalResultCoverHelper.getTaskCurrencyPrecision((Long)this.getTaskId());
        EntryAp entryAp = CalResultCoverHelper.createEntryAp((int)Integer.parseInt(taskMap.get("precision") + ""), (EntityMetadata)entityMetadata, (Map)salaryItemMap, (String)this.getCoverType(), (boolean)false);
        ResultCoverEntryGridControl grid = new ResultCoverEntryGridControl();
        grid.setEntryKey("entryentity");
        grid.setKey("entryentity");
        grid.setSplitPage(true);
        grid.getItems().clear();
        grid.getItems().addAll(((Container)entryAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex((List)Lists.newArrayList((Object[])new Control[]{grid}));
        grid.endInit();
        return grid;
    }

    private void initTaskInfo() {
        FormShowParameter formShowParameter = this.getFormShowParameter();
        String taskName = (String)formShowParameter.getCustomParam("taskName");
        String periodName = (String)formShowParameter.getCustomParam("periodName");
        Label taskLabel = (Label)this.getView().getControl("caltasknamevalue");
        taskLabel.setText(taskName);
        Label periodLabel = (Label)this.getView().getControl("calperiodvalue");
        periodLabel.setText(periodName);
    }

    private Long getTaskId() {
        FormShowParameter formShowParameter = this.getFormShowParameter();
        Long taskId = (Long)formShowParameter.getCustomParam("taskId");
        this.getPageCache().put("taskId", taskId + "");
        int precision = (Integer)formShowParameter.getCustomParam("precision");
        this.getPageCache().put("precision", precision + "");
        return taskId;
    }

    private FormShowParameter getFormShowParameter() {
        return this.getView().getFormShowParameter();
    }

    private String getCoverType() {
        FormShowParameter formShowParameter = this.getFormShowParameter();
        String coverType = (String)formShowParameter.getCustomParam("coverType");
        this.getPageCache().put("coverType", coverType);
        return coverType;
    }

    private String getPersonPageId() {
        FormShowParameter formShowParameter = this.getFormShowParameter();
        String personPageId = (String)formShowParameter.getCustomParam("personPageId");
        this.getPageCache().put("personPageId", personPageId);
        return personPageId;
    }
}

