/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calplatform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.swc.hsas.business.calplatform.CalPlatformHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class CalPlatformSchemeEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(CalPlatformSchemeEdit.class);
    private static final String KEY_BTNOK = "btn_ok";
    private static final String KEY_REMOVE = "remove";
    private static final String KEY_PAYROLLGROUP = "payrollgroup";
    private static final String KEY_PAYROLLSCENE = "payrollscene";
    private static final String KEY_CALPERIODTYPE = "calperiodtype";
    public static final String KEY_SALARYCALENDAR_TYPE = "1";
    public static final int KEY_PAGENUM = 3;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTNOK, KEY_REMOVE});
        for (int i = 1; i <= 3; ++i) {
            BasedataEdit payrollgroup = (BasedataEdit)this.getControl("payrollgroup_" + i);
            BasedataEdit payrollscene = (BasedataEdit)this.getControl("payrollscene_" + i);
            payrollgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            payrollscene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject[] schemes;
        FieldEdit calperiod = (FieldEdit)this.getControl("calperiodscheme");
        QFilter userFilter = new QFilter("creator.id", "=", (Object)RequestContext.get().getCurrUserId());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calplatformscheme");
        for (DynamicObject scheme : schemes = helper.query("tabType,isshow,payrollgroup.id,calperiodscheme,creator.id,calperiodtype.id,payrollscene.id", new QFilter[]{userFilter})) {
            if (scheme == null) continue;
            String tabType = scheme.getString("tabtype");
            this.getModel().setValue("payrollgroup_" + tabType, (Object)scheme.getLong("payrollgroup.id"));
            this.getModel().setValue("payrollscene_" + tabType, (Object)scheme.getLong("payrollscene.id"));
            this.getModel().setValue("calperiodscheme_" + tabType, (Object)scheme.getString("calperiodscheme"));
            this.getModel().setValue("calperiodtype_" + tabType, (Object)scheme.getString("calperiodtype.id"));
            this.getModel().setValue("isshow_" + tabType, (Object)scheme.getBoolean("isshow"));
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_ok": {
                this.saveScheme();
                break;
            }
            case "remove": {
                DynamicObject parentDy = this.getView().getParentView().getModel().getDataEntity();
                if (parentDy != null) {
                    SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calplatformscheme");
                    helper.deleteByFilter(new QFilter[]{new QFilter("creator.id", "=", (Object)RequestContext.get().getCurrUserId())});
                }
                MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u6e05\u9664\u6210\u529f\u3002", "CalPlatformSchemeEdit_5", "swc-hsas-formplugin");
                MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u6e05\u9664", "CalPlatformSchemeEdit_4", "swc-hsas-formplugin");
                SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)KEY_REMOVE, (MultiLangEnumBridge)opNameBridge, null, (MultiLangEnumBridge)opDescBridge, null);
                this.getModel().setDataChanged(false);
                this.getView().close();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        String pageNum = key.split("_")[1];
        ArrayList qFilters = new ArrayList(10);
        switch (key) {
            case "payrollgroup_1": {
                CalPlatformHelper.addGroupOrSceneAuthFilter(qFilters, (String)KEY_SALARYCALENDAR_TYPE, (boolean)true);
                for (QFilter qFilter : qFilters) {
                    beforeF7SelectEvent.addCustomQFilter(qFilter);
                }
                this.addBaseFilter(beforeF7SelectEvent);
                logger.info("payrollgrp_f7filter:{}", (Object)beforeF7SelectEvent.getCustomQFilters().toString());
                break;
            }
            case "payrollgroup_2": 
            case "payrollgroup_3": {
                CalPlatformHelper.addGroupOrSceneAuthFilter(qFilters, (String)"2", (boolean)true);
                for (QFilter qFilter : qFilters) {
                    beforeF7SelectEvent.addCustomQFilter(qFilter);
                }
                this.addBaseFilter(beforeF7SelectEvent);
                logger.info("payrollgrp_f7filter:{}", (Object)beforeF7SelectEvent.getCustomQFilters().toString());
                break;
            }
            case "payrollscene_1": {
                this.checkGroupAndSet(beforeF7SelectEvent, pageNum);
                CalPlatformHelper.addGroupOrSceneAuthFilter(qFilters, (String)KEY_SALARYCALENDAR_TYPE, (boolean)false);
                for (QFilter qFilter : qFilters) {
                    beforeF7SelectEvent.addCustomQFilter(qFilter);
                }
                logger.info("payrollscene_f7filter:{}", (Object)beforeF7SelectEvent.getCustomQFilters().toString());
                break;
            }
            case "payrollscene_2": 
            case "payrollscene_3": {
                this.checkGroupAndSet(beforeF7SelectEvent, pageNum);
                CalPlatformHelper.addGroupOrSceneAuthFilter(qFilters, (String)"2", (boolean)false);
                for (QFilter qFilter : qFilters) {
                    beforeF7SelectEvent.addCustomQFilter(qFilter);
                }
                logger.info("payrollscene_f7filter:{}", (Object)beforeF7SelectEvent.getCustomQFilters().toString());
                break;
            }
        }
    }

    private void checkGroupAndSet(BeforeF7SelectEvent beforeF7SelectEvent, String pageNum) {
        DynamicObject payrollgroup = this.getModel().getDataEntity().getDynamicObject("payrollgroup_" + pageNum);
        if (payrollgroup == null) {
            beforeF7SelectEvent.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u7684\u503c\u3002", (String)"CalPlatformHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]));
            return;
        }
        IFormView view = this.getView();
        String method = beforeF7SelectEvent.getSourceMethod();
        if ("setItemByNumber".equals(method) || "setItemByIdFromClient".equals(method)) {
            return;
        }
        ListShowParameter param = CalPlatformHelper.beforeCalRuleSelect((BeforeF7SelectEvent)beforeF7SelectEvent, (DynamicObject)payrollgroup, (IFormView)view);
        if (param != null) {
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "payrollscene_" + pageNum));
        }
    }

    private void addBaseFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)KEY_SALARYCALENDAR_TYPE);
        beforeF7SelectEvent.addCustomQFilter(statusFilter);
        beforeF7SelectEvent.addCustomQFilter(enableFilter);
    }

    private void saveScheme() {
        long currUserId = RequestContext.get().getCurrUserId();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calplatformscheme");
        QFilter userFilter = new QFilter("creator.id", "=", (Object)currUserId);
        DynamicObject[] schemes = helper.query("payrollgroup,calperiodtype,payrollscene,calperiodscheme,creator,createtime,modifier,modifytime,tabtype,isShow", new QFilter[]{userFilter});
        DynamicObject dataEntityScheme = this.getModel().getDataEntity();
        if (!this.validateScheme(dataEntityScheme)) {
            return;
        }
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(10);
        for (int i = 1; i <= 3; ++i) {
            DynamicObject schemeDy;
            Long payrollGroupId = dataEntityScheme.getLong("payrollgroup_" + i + ".id");
            Long payrollsceneId = dataEntityScheme.getLong("payrollscene_" + i + ".id");
            String calperiodscheme = dataEntityScheme.getString("calperiodscheme_" + i);
            Long calperiodtypeId = dataEntityScheme.getLong("calperiodtype_" + i + ".id");
            if (!(payrollGroupId == 0L && payrollsceneId == 0L && StringUtils.isEmpty((String)calperiodscheme) || payrollGroupId != 0L && payrollsceneId != 0L && !StringUtils.isEmpty((String)calperiodscheme))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u4e00\u7ec4\u9875\u7b7e\uff0c\u85aa\u8d44\u6838\u7b97\u7ec4\uff0c\u85aa\u8d44\u6838\u7b97\u573a\u666f\uff0c\u85aa\u8d44\u671f\u95f4\u6709\u4e00\u8005\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u4e09\u8005\u5fc5\u987b\u90fd\u4e0d\u4e3a\u7a7a\u3002", (String)"CalPlatformSchemeEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isShow = dataEntityScheme.getBoolean("isshow_" + i);
            String temp = String.valueOf(i);
            List schemeObjs = Arrays.stream(schemes).filter(scheme -> temp.equals(scheme.getString("tabtype"))).collect(Collectors.toList());
            if (!SWCListUtils.isEmpty(schemeObjs)) {
                schemeDy = (DynamicObject)schemeObjs.get(0);
            } else {
                schemeDy = helper.generateEmptyDynamicObject();
                schemeDy.set("creator", (Object)currUserId);
                schemeDy.set("createtime", (Object)new Date());
            }
            schemeDy.set(KEY_PAYROLLGROUP, (Object)payrollGroupId);
            schemeDy.set(KEY_PAYROLLSCENE, (Object)payrollsceneId);
            schemeDy.set("calperiodscheme", (Object)calperiodscheme);
            schemeDy.set(KEY_CALPERIODTYPE, (Object)calperiodtypeId);
            schemeDy.set("modifier", (Object)currUserId);
            schemeDy.set("modifytime", (Object)new Date());
            schemeDy.set("tabtype", (Object)i);
            schemeDy.set("isShow", (Object)isShow);
            dynamicObjectList.add(schemeDy);
        }
        helper.save(dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]));
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f\u3002", "CalPlatformSchemeEdit_3", "swc-hsas-formplugin");
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "CalPlatformSchemeEdit_2", "swc-hsas-formplugin");
        SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)KEY_BTNOK, (MultiLangEnumBridge)opNameBridge, null, (MultiLangEnumBridge)opDescBridge, null);
        this.getModel().setDataChanged(false);
        this.getView().close();
    }

    private boolean validateScheme(DynamicObject dataEntityScheme) {
        boolean isShow1 = dataEntityScheme.getBoolean("isshow_1");
        boolean isShow2 = dataEntityScheme.getBoolean("isshow_2");
        boolean isShow3 = dataEntityScheme.getBoolean("isshow_3");
        if (!(isShow1 || isShow2 || isShow3)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e09\u7ec4\u9875\u7b7e\u81f3\u5c11\u663e\u793a\u4e00\u7ec4\u3002", (String)"CalPlatformSchemeEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        String pageNum = actionId.split("_")[1];
        switch (actionId) {
            case "payrollscene_1": 
            case "payrollscene_2": 
            case "payrollscene_3": {
                Object returnData1 = closedCallBackEvent.getReturnData();
                if (!(returnData1 instanceof ListSelectedRowCollection)) break;
                ListSelectedRow listSelectedRow = ((ListSelectedRowCollection)returnData1).get(0);
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollscene");
                DynamicObject calRuleHelperDy = helper.queryOne("id,periodtype.id", listSelectedRow.getPrimaryKeyValue());
                this.getModel().setValue("payrollscene_" + pageNum, calRuleHelperDy.get("id"));
                this.getModel().setValue("calperiodtype_" + pageNum, calRuleHelperDy.get("periodtype.id"));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        String pageNum = key.split("_")[1];
        switch (key) {
            case "payrollgroup_1": 
            case "payrollgroup_2": 
            case "payrollgroup_3": {
                this.getModel().setValue("payrollscene_" + pageNum, null);
                this.getModel().setValue("calperiodtype_" + pageNum, null);
                break;
            }
            case "payrollscene_1": 
            case "payrollscene_2": 
            case "payrollscene_3": {
                DynamicObject scene = this.getModel().getDataEntity().getDynamicObject(key);
                if (scene != null) {
                    SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollscene");
                    DynamicObject calRuleHelperDy = helper.queryOne("id,calrule.id,periodtype.id", scene.get("id"));
                    if (!SWCObjectUtils.isEmpty((Object)calRuleHelperDy)) {
                        this.getModel().setValue("payrollscene_" + pageNum, calRuleHelperDy.get("id"));
                        this.getModel().setValue("calperiodtype_" + pageNum, calRuleHelperDy.get("periodtype.id"));
                    }
                } else {
                    this.getModel().setValue("calperiodtype_" + pageNum, null);
                }
                this.getModel().setValue("calperiodscheme_" + pageNum, null);
                break;
            }
        }
    }
}

