/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calplatform;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.calplatform.CalPlatformHelper;
import kd.swc.hsas.formplugin.web.calplatform.TaskPage;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalTaskCardListPlugin
extends AbstractFormPlugin {
    private static final String KEY_PAYROLLGROUP = "payrollgroup";
    private static final String KEY_CALRULE = "calrule";
    private static final String KEY_PAYROLLSCENE = "payrollscene";
    private static final String KEY_CALPERIOD = "calperiod";
    private static final String KEY_PREPAGE = "prepage";
    private static final String KEY_NEXTPAGE = "nextpage";
    private static final String KEY_ISCONTAINTEMP = "iscontaintemp";
    private static final String KEY_REFRESH = "caltaskrefresh";
    private static final String KEY_VIEWMORE = "caltaskviewmore";
    private static final String KEY_QUICKCREATETASK = "quickcreatetask";
    private static final String KEY_TRACKINGSTATUS = "trackingstatussettings";
    private static final String KEY_PAGENUM = "pagenum";
    private static final String KEY_TOTOLPAGE = "totolpage";
    private static final String KEY_DOT = "dot";
    private static final int KEY_MAXDOT_NUM = 5;
    private static final String KEY_CALPATFLAG = "calplatformflag";
    private static final String QXX_QUICKCREATE_PERM = "2B+P=Q5GPS2Z";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_PREPAGE, KEY_NEXTPAGE, KEY_VIEWMORE, KEY_REFRESH, KEY_QUICKCREATETASK, KEY_TRACKINGSTATUS});
    }

    public void beforeBindData(EventObject e) {
        String isContainTempTask = this.getView().getPageCache().get("isContainTempTask");
        this.getModel().setValue(KEY_ISCONTAINTEMP, (Object)(!SWCStringUtils.equals((String)Boolean.FALSE.toString(), (String)isContainTempTask) ? 1 : 0));
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "prepage": 
            case "nextpage": {
                TaskPage page = (TaskPage)JSON.parseObject((String)this.getPageCache().get("taskpage"), TaskPage.class);
                this.skipPage(page, key.equals(KEY_PREPAGE) ? page.getCurrentPage() - 1 : page.getCurrentPage() + 1);
                break;
            }
            case "caltaskrefresh": {
                this.refreshPage();
                break;
            }
            case "caltaskviewmore": {
                this.openCalTaskList();
                break;
            }
            case "quickcreatetask": {
                this.openCreateTaskFormPage("hsas_createcalpayrolltask");
                break;
            }
            case "trackingstatussettings": {
                this.openFormPage("hsas_followstatuscfg");
                break;
            }
        }
    }

    private void openCalTaskList() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId("hsas_calpayrolltask");
        showParameter.setCaption(ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u4efb\u52a1", (String)"CalTaskCardListPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        DynamicObject params = this.getView().getModel().getDataEntity();
        List filters = showParameter.getListFilterParameter().getQFilters();
        if (params != null) {
            DynamicObject object = params.getDynamicObject(KEY_CALPERIOD);
            if (object == null) {
                return;
            }
            Long calperiod = object.getLong("id");
            Long payrollgroupId = params.getLong("payrollgroup.id");
            Long payrollsceneId = params.getLong("payrollscene.id");
            QFilter payrollgroupFilter = new QFilter("payrollgroup.id", "=", (Object)payrollgroupId);
            QFilter payrollsceneFilter = new QFilter("payrollscene.id", "=", (Object)payrollsceneId);
            QFilter calperiodFilter = new QFilter("period.id", "=", (Object)calperiod);
            filters.addAll(Arrays.asList(payrollgroupFilter, payrollsceneFilter, calperiodFilter));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openFormPage(String pageId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(pageId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm(showParameter);
    }

    private void openCreateTaskFormPage(String pageId) {
        if (this.isHasPerm()) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(pageId);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCustomParam(KEY_CALPATFLAG, (Object)KEY_CALPATFLAG);
            this.getView().showForm(showParameter);
        }
    }

    private boolean isHasPerm() {
        if (!SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_calpayrolltask", (String)QXX_QUICKCREATE_PERM)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\u7684\u5feb\u901f\u521b\u5efa\u6743\u9650\u3002", (String)"CalTaskCardListPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u65b0\u589e\u5931\u8d25\u3002", "CalTaskCardListPlugin_4", "swc-hsas-formplugin");
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u65b0\u589e", "CalTaskCardListPlugin_5", "swc-hsas-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)KEY_QUICKCREATETASK, (MultiLangEnumBridge)opNameBridge, null, (MultiLangEnumBridge)opDescBridge, null);
            return false;
        }
        return true;
    }

    public void afterBindData(EventObject e) {
        this.refreshPage();
    }

    private void refreshPage() {
        this.showQueckCreatTaskPage();
        DynamicObject params = this.getView().getModel().getDataEntity();
        if (params != null) {
            DynamicObject object = params.getDynamicObject(KEY_CALPERIOD);
            if (object == null) {
                this.showEmptyPage();
                return;
            }
            Long calperiod = object.getLong("id");
            Long payrollgroupId = params.getLong("payrollgroup.id");
            Long payrollSceneId = params.getLong("payrollscene.id");
            SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
            ArrayList<Long> taskIds = new ArrayList<Long>(10);
            SWCDataServiceHelper calPlatformHelper = new SWCDataServiceHelper("hsas_calplatformcfg");
            QFilter sceneFilter = new QFilter("payrollscene.id", "=", (Object)payrollSceneId);
            DynamicObject cfg = calPlatformHelper.queryOne("taxopenfollstatus,taxclosefollstatus", new QFilter[]{new QFilter("payrollgroup.id", "=", (Object)payrollgroupId), sceneFilter, new QFilter("enable", "=", (Object)"1")});
            List<QFilter> permFilter = this.getPermFilter();
            if (permFilter == null || permFilter.size() == 0) {
                this.showNoDatePage();
                return;
            }
            QFilter grpFilter = new QFilter("payrollgroup.id", "=", (Object)payrollgroupId);
            List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calpayrolltask", (String)"47150e89000000ac");
            if (authorizedDataRuleQFilter == null) {
                grpFilter.and(new QFilter("1", "!=", (Object)1));
            } else {
                authorizedDataRuleQFilter.forEach(arg_0 -> ((QFilter)grpFilter).and(arg_0));
            }
            HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_calpayrolltask", (String)"47150e89000000ac");
            if (!permOrgs.hasAllOrgPerm()) {
                grpFilter.and(new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs()));
            }
            DynamicObject[] tasks = taskHelper.query("id", new QFilter[]{grpFilter, sceneFilter, new QFilter("period.id", "=", (Object)calperiod)}, "tasktype,createtime desc");
            taskIds.addAll(Arrays.stream(tasks).map(o -> o.getLong("id")).collect(Collectors.toList()));
            if (SWCListUtils.isEmpty(taskIds)) {
                this.showNoDatePage();
                return;
            }
            int pageSize = 2;
            int total = taskIds.size();
            int pageNum = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
            TaskPage page = new TaskPage();
            page.setCurrentPage(1);
            page.setPageSize(pageSize);
            page.setTotalPage(pageNum);
            page.setData(taskIds);
            String followsStatus = "";
            if (cfg != null) {
                followsStatus = cfg.getString("taxopenfollstatus");
            }
            page.setFollowStatus(followsStatus);
            this.skipPage(page, 1);
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap18"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"emptyflex2"});
        }
    }

    private void showQueckCreatTaskPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("flexpanelcreatetask");
        showParameter.setFormId("hsas_calquickcreatetask");
        this.getView().showForm(showParameter);
    }

    private List<QFilter> getPermFilter() {
        List permissionFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"47150e89000000ac");
        return permissionFilter;
    }

    private void showEmptyPage() {
        FormShowParameter emptyPage = CalPlatformHelper.getEmptyPage((String)ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u8bf7\u786e\u4fdd\u6240\u6709\u7b5b\u9009\u6761\u4ef6\u6709\u503c\u3002", (String)"CalTaskCardListPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (String)"emptyflex2");
        this.getView().showForm(emptyPage);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap18"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"emptyflex2"});
    }

    private void showNoDatePage() {
        FormShowParameter emptyPage = CalPlatformHelper.getEmptyPage((String)ResManager.loadKDString((String)"\u6682\u65e0\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\uff0c\u8bf7\u521b\u5efa\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\u518d\u8fdb\u884c\u67e5\u770b\u3002", (String)"CalTaskCardListPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (String)"emptyflex2");
        this.getView().showForm(emptyPage);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap18"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"emptyflex2"});
    }

    private void skipPage(TaskPage page, int pageNumber) {
        List<Long> showTasks = page.flip(pageNumber);
        for (int i = 0; i < page.getPageSize(); ++i) {
            String key = "task_" + i;
            if (i < showTasks.size()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{key});
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.InContainer);
                showParameter.getOpenStyle().setTargetKey(key);
                showParameter.setFormId("hsas_singlecaltaskcard");
                showParameter.setCustomParam("taskId", (Object)showTasks.get(i));
                showParameter.setCustomParam("followstatus", (Object)page.getFollowStatus());
                this.getView().showForm(showParameter);
                continue;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{key});
        }
        this.getView().setEnable(Boolean.valueOf(pageNumber < page.getTotalPage()), new String[]{KEY_NEXTPAGE});
        this.getView().setEnable(Boolean.valueOf(pageNumber > 1), new String[]{KEY_PREPAGE});
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty(KEY_PAGENUM, "text", (Object)page.getCurrentPage());
        proxy.setFieldProperty(KEY_TOTOLPAGE, "text", (Object)page.getTotalPage());
        this.setDotStyle(page.getTotalPage(), page.getCurrentPage());
        this.getPageCache().put("taskpage", JSON.toJSONString((Object)page));
    }

    private void setDotStyle(int totalPage, int currentPage) {
        for (int i = 1; i <= 5; ++i) {
            if (i <= totalPage) {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_DOT + i});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_DOT + i});
            }
            if (i == currentPage || i == 5 && currentPage > 5) {
                this.setDotColor(KEY_DOT + i, "#0E5FD8");
                continue;
            }
            this.setDotColor(KEY_DOT + i, "#e5e5e5");
        }
    }

    private void setDotColor(String label, String color) {
        HashMap<String, String> ctrl = new HashMap<String, String>();
        ctrl.put("bc", color);
        this.getView().updateControlMetadata(label, ctrl);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "iscontaintemp": {
                this.refreshPage();
                Boolean newValue = (Boolean)e.getChangeSet()[0].getNewValue();
                IPageCache parentPageCache = this.getView().getParentView().getPageCache();
                if (newValue != null) {
                    parentPageCache.put("isContainTempTask", newValue.toString());
                } else {
                    parentPageCache.remove("isContainTempTask");
                }
                parentPageCache.saveChanges();
                break;
            }
        }
    }
}

