/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calplatform;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.calplatform.CalPlatformHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;

public class SalaryChartConfigPlugin
extends AbstractFormPlugin {
    private static final String KEY_CHARTCONFIGENT = "chartconfigent";
    private static final String KEY_PAYROLLGROUP = "payrollgroup";
    private static final String KEY_PAYROLLSCENE = "payrollscene";
    private static final String KEY_BTNOK = "btnok";
    private static final int KEY_SETMAX = 4;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTNOK});
    }

    public void beforeBindData(EventObject e) {
        Long payrollSceneId;
        SWCDataServiceHelper calPlatformHelper = new SWCDataServiceHelper("hsas_calplatformcfg");
        DynamicObject params = this.getView().getParentView().getModel().getDataEntity();
        Long payrollgroupId = params.getLong("payrollgroup.id");
        DynamicObject cfg = calPlatformHelper.queryOne("chartconfigent.itemname,chartconfigent.itemshowname,chartconfigent.isshow,chartconfigent.charttype", new QFilter[]{new QFilter("payrollgroup.id", "=", (Object)payrollgroupId), new QFilter("payrollscene.id", "=", (Object)(payrollSceneId = Long.valueOf(params.getLong("payrollscene.id")))), new QFilter("enable", "=", (Object)"1")});
        if (cfg == null) {
            CalPlatformHelper.setInitChartConfig((IDataModel)this.getModel(), (String)KEY_CHARTCONFIGENT);
        } else {
            DynamicObjectCollection chartConfigent = cfg.getDynamicObjectCollection(KEY_CHARTCONFIGENT);
            if (chartConfigent == null || chartConfigent.size() == 0) {
                CalPlatformHelper.setInitChartConfig((IDataModel)this.getModel(), (String)KEY_CHARTCONFIGENT);
            } else {
                for (DynamicObject chartConfig : chartConfigent) {
                    int rowIndex = this.getModel().createNewEntryRow(KEY_CHARTCONFIGENT);
                    this.getModel().setValue("itemname", (Object)chartConfig.getString("itemname"), rowIndex);
                    this.getModel().setValue("itemshowname", (Object)chartConfig.getString("itemshowname"), rowIndex);
                    this.getModel().setValue("isshow", (Object)chartConfig.getBoolean("isshow"), rowIndex);
                    this.getModel().setValue("charttype", (Object)chartConfig.getString("charttype"), rowIndex);
                }
            }
        }
        this.getView().getModel().setDataChanged(false);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                DynamicObjectCollection currentChartConfigs = this.getModel().getEntryEntity(KEY_CHARTCONFIGENT);
                if (!this.validatorChart(currentChartConfigs)) break;
                this.saveChartConfig(currentChartConfigs);
                this.getView().getParentView().updateView();
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
            }
        }
    }

    private void saveChartConfig(DynamicObjectCollection currentChartConfigs) {
        DynamicObjectCollection chartConfigs;
        DynamicObject params = this.getView().getParentView().getModel().getDataEntity();
        DynamicObject payrollGroupDy = params.getDynamicObject(KEY_PAYROLLGROUP);
        DynamicObject payrollSceneDy = params.getDynamicObject(KEY_PAYROLLSCENE);
        if (SWCObjectUtils.isEmpty((Object)payrollGroupDy) || SWCObjectUtils.isEmpty((Object)payrollSceneDy)) {
            return;
        }
        SWCDataServiceHelper calPlatformHelper = new SWCDataServiceHelper("hsas_calplatformcfg");
        DynamicObject cfg = calPlatformHelper.queryOne("payrollgroup,payrollscene,chartconfigent.itemname,chartconfigent.itemshowname,chartconfigent.isshow,chartconfigent.charttype,creator,createtime,modifier,modifytime", new QFilter[]{new QFilter("payrollgroup.id", "=", (Object)payrollGroupDy.getLong("id")), new QFilter("payrollscene.id", "=", (Object)payrollSceneDy.getLong("id"))});
        if (cfg == null) {
            cfg = calPlatformHelper.generateEmptyDynamicObject();
            cfg.set(KEY_PAYROLLGROUP, (Object)payrollGroupDy);
            cfg.set(KEY_PAYROLLSCENE, (Object)payrollSceneDy);
            cfg.set("enable", (Object)"1");
            cfg.set("number", (Object)(payrollGroupDy.getString("number") + payrollSceneDy.getString("number")));
            cfg.set("name", (Object)(payrollGroupDy.getString("name") + payrollSceneDy.get("name")));
            cfg.set("status", (Object)"A");
            CalPlatformHelper.setSystemFieldValue((DynamicObject)cfg, (boolean)false);
            chartConfigs = cfg.getDynamicObjectCollection(KEY_CHARTCONFIGENT);
            if (chartConfigs != null && currentChartConfigs != null) {
                this.setNewEntryData(chartConfigs, currentChartConfigs);
            }
        } else {
            chartConfigs = cfg.getDynamicObjectCollection(KEY_CHARTCONFIGENT);
            if (chartConfigs == null || chartConfigs.size() == 0) {
                if (currentChartConfigs != null) {
                    this.setNewEntryData(chartConfigs, currentChartConfigs);
                }
            } else {
                block0: for (DynamicObject currentChartConfig : currentChartConfigs) {
                    for (DynamicObject chartConfig : chartConfigs) {
                        if (!chartConfig.getString("itemname").equals(currentChartConfig.getString("itemname"))) continue;
                        chartConfig.set("itemname", (Object)currentChartConfig.getString("itemname"));
                        chartConfig.set("itemshowname", (Object)currentChartConfig.getString("itemshowname"));
                        chartConfig.set("isshow", (Object)currentChartConfig.getBoolean("isshow"));
                        chartConfig.set("charttype", (Object)currentChartConfig.getString("charttype"));
                        continue block0;
                    }
                }
            }
            CalPlatformHelper.setSystemFieldValue((DynamicObject)cfg, (boolean)true);
        }
        calPlatformHelper.saveOne(cfg);
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f\u3002", "SalaryChartConfigPlugin_4", "swc-hsas-formplugin");
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "SalaryChartConfigPlugin_3", "swc-hsas-formplugin");
        SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)KEY_BTNOK, (MultiLangEnumBridge)opNameBridge, null, (MultiLangEnumBridge)opDescBridge, null);
    }

    private void setNewEntryData(DynamicObjectCollection chartConfigs, DynamicObjectCollection currentChartConfigs) {
        for (DynamicObject currentChartConfig : currentChartConfigs) {
            if (chartConfigs == null) continue;
            DynamicObject newEntry = chartConfigs.addNew();
            newEntry.set("itemname", (Object)currentChartConfig.getString("itemname"));
            newEntry.set("itemshowname", (Object)currentChartConfig.getString("itemshowname"));
            newEntry.set("isshow", (Object)currentChartConfig.getBoolean("isshow"));
            newEntry.set("charttype", (Object)currentChartConfig.getString("charttype"));
        }
    }

    private boolean validatorChart(DynamicObjectCollection currentChartConfigs) {
        boolean flag = false;
        boolean nameFlag = true;
        HashSet<String> nameSet = new HashSet<String>();
        for (DynamicObject chartconfig : currentChartConfigs) {
            String showName = chartconfig.getString("itemshowname");
            if (StringUtils.isEmpty((CharSequence)showName)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u663e\u793a\u522b\u540d\u3002", (String)"SalaryChartConfigPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return false;
            }
            nameSet.add(showName);
            if (!chartconfig.getBoolean("isshow")) continue;
            flag = true;
        }
        if (nameSet.size() < 4) {
            nameFlag = false;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u663e\u793a\u522b\u540d\u5b58\u5728\u76f8\u540c\u7684\u503c\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"SalaryChartConfigPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        if (!flag) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u85aa\u8d44\u53d8\u5316\u8d8b\u52bf\u7684\u663e\u793a\u8bbe\u7f6e\u81f3\u5c11\u8bbe\u7f6e\u4e00\u4e2a\u3002", (String)"SalaryChartConfigPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        return flag && nameFlag;
    }
}

