/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calplatform;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.calplatform.CalPlatformHelper;
import kd.swc.hsas.common.enums.SalaryChartEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang.StringUtils;

public class SalaryChartPlugin
extends AbstractFormPlugin {
    private static final String KEY_RANGE = "range";
    private static final String KEY_ADMINORG = "adminorg";
    private static final String KEY_REFRESH = "salarychartrefresh";
    private static final String KEY_SALARYCHARTSETTINGS = "salarychartsettings";
    private static final String KEY_CURRENCY = "currencychart";
    private static final String KEY_PAYROLLSCENE = "payrollscene";
    private static final Log log = LogFactory.getLog(SalaryChartPlugin.class);

    public void initialize() {
        this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", (Object)"hsas_salaryresult");
        this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_REFRESH, KEY_SALARYCHARTSETTINGS});
    }

    public void beforeBindData(EventObject e) {
        this.loadChart();
    }

    private void loadChart() {
        DynamicObject params = this.getView().getModel().getDataEntity();
        if (params == null) {
            log.info("SalaryChartPlugin_loadChart_params is null");
            return;
        }
        DynamicObject periodObj = params.getDynamicObject("calperiod");
        if (periodObj == null) {
            log.info("periodObj is null");
            this.showEmptyPage();
            return;
        }
        Date salaryStartDate = periodObj.getDate("startdate");
        Long payrollgroupId = params.getLong("payrollgroup.id");
        Long payrollsceneId = params.getLong("payrollscene.id");
        Long calperiodTypeId = periodObj.getLong("periodtypeid");
        SWCDataServiceHelper calPlatformHelper = new SWCDataServiceHelper("hsas_calplatformcfg");
        DynamicObject cfg = calPlatformHelper.queryOne("id,chartconfigent,chartconfigent.itemname,chartconfigent.itemshowname,chartconfigent.charttype,chartconfigent.isshow", new QFilter[]{new QFilter("payrollgroup.id", "=", (Object)payrollgroupId), new QFilter("payrollscene.id", "=", (Object)payrollsceneId), new QFilter("enable", "=", (Object)"1"), new QFilter("chartconfigent.isshow", "=", (Object)Boolean.TRUE)});
        SWCDataServiceHelper payrollgrpHelper = new SWCDataServiceHelper("hsas_payrollgrp");
        SWCDataServiceHelper periodHelper = new SWCDataServiceHelper("hsbs_calperiod");
        DynamicObjectCollection calperiods = periodHelper.queryColl("id,startdate,enddate,name", new QFilter[]{new QFilter("startdate", "<=", (Object)salaryStartDate), new QFilter("periodtypeid", "=", (Object)calperiodTypeId)}, "startdate asc");
        SWCDataServiceHelper calPeriodTypeHelper = new SWCDataServiceHelper("hsbs_calperiodtype");
        DynamicObject calperiodType = calPeriodTypeHelper.queryOne("calfrequency.type", (Object)calperiodTypeId);
        String value = (String)this.getModel().getValue(KEY_RANGE);
        int range = 12;
        if (SWCStringUtils.isNotEmpty((String)value)) {
            range = Integer.parseInt(value);
        }
        List usedCalperiods = calperiods.subList(range > calperiods.size() ? 0 : calperiods.size() - range, calperiods.size());
        DynamicObjectCollection chartconfigcoll = null;
        ArrayList<DynamicObject> chartconfigent = new ArrayList<DynamicObject>(10);
        if (cfg == null) {
            cfg = calPlatformHelper.generateEmptyDynamicObject();
            chartconfigcoll = cfg.getDynamicObjectCollection("chartconfigent");
            this.initChartConfig(chartconfigcoll);
        } else {
            chartconfigcoll = cfg.getDynamicObjectCollection("chartconfigent");
            if (chartconfigcoll != null && chartconfigcoll.size() == 0) {
                this.initChartConfig(chartconfigcoll);
            }
        }
        HashSet<String> fields = new HashSet<String>(16);
        boolean isHasAvg = false;
        boolean isHasSum = false;
        if (chartconfigcoll != null) {
            for (DynamicObject config : chartconfigcoll) {
                String code = config.getString("itemname");
                SalaryChartEnum chartEnum = SalaryChartEnum.getEnumByCode((String)code);
                if (code == null || !config.getBoolean("isshow")) continue;
                chartconfigent.add(config);
                fields.add(chartEnum.getFiled());
                if (chartEnum.getType().equals("avg")) {
                    isHasAvg = true;
                    continue;
                }
                if (!chartEnum.getType().equals("sum")) continue;
                isHasSum = true;
            }
            HashMap<String, Map<Long, BigDecimal>> dataMap = new HashMap<String, Map<Long, BigDecimal>>(16);
            long st = System.currentTimeMillis();
            log.info("queryAndInitSalaryMap_begin");
            this.queryAndInitSalaryMap(payrollgroupId, payrollsceneId, usedCalperiods, dataMap, fields, isHasAvg);
            log.info("queryAndInitSalaryMap_finish,cost:{} ms", (Object)(System.currentTimeMillis() - st));
            st = System.currentTimeMillis();
            log.info("drawChart_beign");
            DynamicObject payrollgroup = payrollgrpHelper.queryOne("currency.name,currency.amtprecision", (Object)payrollgroupId);
            if (payrollgroup != null) {
                int amtprecision = payrollgroup.getInt("currency.amtprecision");
                this.drawChart(payrollgroup.getString("currency.name"), amtprecision, calperiodType, usedCalperiods, dataMap, chartconfigent, isHasAvg, isHasSum);
                log.info("drawChart_finish,cost:{} ms", (Object)(System.currentTimeMillis() - st));
            }
        }
    }

    private void initChartConfig(DynamicObjectCollection chartconfigcoll) {
        for (SalaryChartEnum salaryChartEnum : SalaryChartEnum.values()) {
            if (chartconfigcoll == null) continue;
            DynamicObject newChartDy = chartconfigcoll.addNew();
            newChartDy.set("itemname", (Object)salaryChartEnum.getCode());
            newChartDy.set("itemshowname", (Object)salaryChartEnum.getName());
            newChartDy.set("isshow", (Object)Boolean.TRUE);
            newChartDy.set("charttype", (Object)(SWCStringUtils.equals((String)salaryChartEnum.getType(), (String)"sum") ? "bar" : "line"));
        }
    }

    private void drawChart(String currencyName, int amtprecision, DynamicObject calperiodType, List<DynamicObject> usedCalperiods, Map<String, Map<Long, BigDecimal>> dataMap, List<DynamicObject> chartconfigent, boolean isHasAvg, boolean isHasSum) {
        ArrayList<String> XValues = new ArrayList<String>(10);
        ArrayList<String> nameArr = new ArrayList<String>(10);
        HashMap<String, List> serieDataMap = new HashMap<String, List>(16);
        BigDecimal maxSalary = BigDecimal.ZERO;
        BigDecimal minSalary = BigDecimal.ZERO;
        BigDecimal maxAvgSalary = BigDecimal.ZERO;
        BigDecimal minAvgSalary = BigDecimal.ZERO;
        for (DynamicObject usedCalperiod : usedCalperiods) {
            long id = usedCalperiod.getLong("id");
            for (DynamicObject chartconfig : chartconfigent) {
                String itemname = chartconfig.getString("itemname");
                String[] splitArr = itemname.split("-");
                String type = splitArr[0];
                String field = splitArr[1];
                List serirDatas = serieDataMap.computeIfAbsent(itemname, k -> new ArrayList(10));
                Map<Long, BigDecimal> longBigDecimalMap = dataMap.get(field);
                if (longBigDecimalMap == null) {
                    serirDatas.add(BigDecimal.ZERO);
                    continue;
                }
                BigDecimal value = longBigDecimalMap.get(id);
                if (value == null) {
                    serirDatas.add(BigDecimal.ZERO);
                    continue;
                }
                if (SWCStringUtils.equals((String)type, (String)"sum")) {
                    BigDecimal showValue = value.setScale(amtprecision, 4);
                    serirDatas.add(showValue);
                    maxSalary = this.getMaxValue(showValue, maxSalary);
                    minSalary = this.getMinValue(showValue, minSalary);
                    continue;
                }
                BigDecimal personcount = dataMap.get("personcount").get(id);
                BigDecimal showValue = personcount.compareTo(BigDecimal.ZERO) > 0 ? value.divide(personcount, amtprecision, 4) : BigDecimal.ZERO;
                serirDatas.add(showValue);
                maxAvgSalary = this.getMaxValue(showValue, maxAvgSalary);
                minAvgSalary = this.getMinValue(showValue, minAvgSalary);
            }
            XValues.add(usedCalperiod.getString("name"));
            nameArr.add("'" + this.getDateRangeStr(usedCalperiod.getDate("startdate"), usedCalperiod.getDate("enddate")) + "'");
        }
        ArrayList<String> toolTipFuncPath = new ArrayList<String>();
        toolTipFuncPath.add("tooltip");
        toolTipFuncPath.add("formatter");
        Chart chart = (Chart)this.getControl("customchartap");
        chart.setMerge(false);
        chart.addTooltip("trigger", (Object)"axis");
        HashMap<String, String> toolTipAxisPointer = new HashMap<String, String>(16);
        toolTipAxisPointer.put("type", "cross");
        chart.addTooltip("axisPointer", toolTipAxisPointer);
        chart.setShowTooltip(true);
        String periodStr = ResManager.loadKDString((String)"\u85aa\u8d44\u671f\u95f4\uff1a", (String)"SalaryChartPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String jsNameArrStr = "var nameArr = [" + StringUtils.join(nameArr, (char)',') + "];\n";
        String formatter = "function(param){" + jsNameArrStr + "var str = '" + periodStr + "'+nameArr[param[0].dataIndex];\nfor (let index = 0; index < param.length; index++) {\n  const element = param[index];\n    str += '<br />';\n  str += element.seriesName + '" + ResManager.loadKDString((String)"\uff1a", (String)"SalaryChartPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]) + "' ;\n  var dataValue= element.data;\n   str+=dataValue;\n};return str}";
        chart.addTooltip("formatter", (Object)formatter);
        chart.addFuncPath(toolTipFuncPath);
        chart.setShowLegend(true);
        chart.setLegendAlign(XAlign.center, YAlign.bottom);
        chart.setMargin(Position.bottom, "15%");
        this.initXAxis(XValues, chart, currencyName);
        this.initYAxis(maxSalary, minSalary, maxAvgSalary, minAvgSalary, chart, isHasAvg, isHasSum);
        for (DynamicObject chartconfig : chartconfigent) {
            LineSeries series = chart.createLineSeries(chartconfig.getString("itemshowname"));
            String charttype = chartconfig.getString("charttype");
            if (SWCStringUtils.equals((String)charttype, (String)"bar")) {
                series.setPropValue("barMaxWidth", (Object)32);
            }
            series.setType(ChartType.valueOf((String)charttype));
            this.setItemColor(series, chartconfig.getString("itemname"));
            List seriesList = (List)serieDataMap.get(chartconfig.getString("itemname"));
            if (!SWCListUtils.isEmpty((List)seriesList)) {
                series.setData((Number[])seriesList.toArray(new BigDecimal[0]));
            }
            SalaryChartEnum salaryChartEnum = SalaryChartEnum.getEnumByCode((String)chartconfig.getString("itemname"));
            if (!isHasSum || !salaryChartEnum.getType().equals("avg")) continue;
            series.setYAxisIndex(1);
        }
        chart.refresh();
        this.getView().setVisible(Boolean.FALSE, new String[]{"emptyflex1"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap17"});
    }

    private void setItemColor(LineSeries series, String itemName) {
        switch (itemName) {
            case "sum-totalsalary": {
                series.setItemColor("#289EFF");
                break;
            }
            case "sum-netsalary": {
                series.setItemColor("#FFE040");
                break;
            }
            case "avg-totalsalary": {
                series.setItemColor("#FB5979");
                break;
            }
            case "avg-netsalary": {
                series.setItemColor("#73D13C");
            }
        }
    }

    private void initYAxis(BigDecimal maxSalary, BigDecimal minSalary, BigDecimal maxAvgSalary, BigDecimal minAvgSalary, Chart chart, boolean isHasAvg, boolean isHasSum) {
        HashMap<String, Object> nameTextStyle;
        HashMap<String, Serializable> splitLine = new HashMap<String, Serializable>();
        splitLine.put("show", Boolean.TRUE);
        HashMap<String, Boolean> yAxisLine = new HashMap<String, Boolean>();
        yAxisLine.put("show", Boolean.FALSE);
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        splitLine.put("lineStyle", lineStyle);
        lineStyle.put("type", "dashed");
        HashMap<String, Boolean> yAxisTick = new HashMap<String, Boolean>();
        yAxisTick.put("show", Boolean.FALSE);
        if (isHasSum) {
            Axis yAxis = chart.createYAxis(ResManager.loadKDString((String)"\u85aa\u8d44\u989d", (String)"SalaryChartPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]), AxisType.value);
            yAxis.setPropValue("scale", (Object)Boolean.TRUE);
            yAxis.setPropValue("splitLine", splitLine);
            yAxis.setPropValue("axisTick", yAxisTick);
            yAxis.setPropValue("axisLine", yAxisLine);
            yAxis.setPropValue("boundaryGap", (Object)new String[]{"5%", "5%"});
            nameTextStyle = new HashMap();
            nameTextStyle.put("align", "right");
            nameTextStyle.put("padding", new int[]{0, 8, 0, 0});
            yAxis.setPropValue("nameTextStyle", nameTextStyle);
            Map<String, Object> splitInfo = SalaryChartPlugin.getSplitInfo(maxSalary.doubleValue(), minSalary.doubleValue());
            for (Map.Entry<String, Object> entity : splitInfo.entrySet()) {
                yAxis.setPropValue(entity.getKey(), entity.getValue());
            }
        }
        if (isHasAvg) {
            Axis yAxis1 = chart.createYAxis(ResManager.loadKDString((String)"\u5e73\u5747\u503c", (String)"SalaryChartPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]), AxisType.value);
            yAxis1.setPropValue("scale", (Object)Boolean.TRUE);
            yAxis1.setPropValue("splitLine", splitLine);
            yAxis1.setPropValue("axisTick", yAxisTick);
            yAxis1.setPropValue("axisLine", yAxisLine);
            nameTextStyle = new HashMap<String, Object>();
            nameTextStyle.put("align", "left");
            nameTextStyle.put("padding", new int[]{0, 0, 0, 8});
            yAxis1.setPropValue("nameTextStyle", nameTextStyle);
            Map<String, Object> splitInfo1 = SalaryChartPlugin.getSplitInfo(maxAvgSalary.doubleValue(), minAvgSalary.doubleValue());
            for (Map.Entry<String, Object> entity : splitInfo1.entrySet()) {
                yAxis1.setPropValue(entity.getKey(), entity.getValue());
            }
        }
    }

    private void initXAxis(List<String> XValues, Chart chart, String currencyName) {
        StringBuilder currencySb = new StringBuilder(ResManager.loadKDString((String)"\u5e01\u79cd\uff1a", (String)"SalaryChartPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        String currencyNameStr = currencySb.append(currencyName).toString();
        Axis xAxis = chart.createXAxis(currencyNameStr, AxisType.category);
        xAxis.setCategorys(XValues.toArray(new String[0]));
        HashMap<String, String> axisPointer = new HashMap<String, String>(16);
        axisPointer.put("type", "shadow");
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>(16);
        axisTick.put("inside", Boolean.TRUE);
        xAxis.setPropValue("axisPointer", axisPointer);
        xAxis.setPropValue("axisTick", axisTick);
        xAxis.setPropValue("nameLocation", (Object)"center");
        HashMap<String, Object> nameTextStyle = new HashMap<String, Object>(16);
        nameTextStyle.put("padding", new int[]{33, 1000, 0, 0});
        nameTextStyle.put("color", "#666666");
        nameTextStyle.put("fontSize", 12);
        xAxis.setPropValue("nameTextStyle", nameTextStyle);
    }

    private void queryAndInitSalaryMap(Long payrollgroupId, Long payrollsceneId, List<DynamicObject> usedCalperiods, Map<String, Map<Long, BigDecimal>> dataMap, Set<String> fields, boolean isNeedPersonCount) {
        DynamicObject adminorg;
        StringBuilder sb = new StringBuilder();
        sb.append("select FCALPERIODID id,  ");
        if (isNeedPersonCount) {
            sb.append("COUNT( DISTINCT fpersonid ) personcount,");
        }
        int i = 1;
        for (String field : fields) {
            sb.append("sum(");
            sb.append('f');
            sb.append(field);
            sb.append(") ");
            sb.append(field);
            if (i < fields.size()) {
                sb.append(',');
            } else {
                sb.append(' ');
            }
            ++i;
        }
        sb.append(" from T_HSAS_SALARYRESULT ");
        sb.append("where fpayrollgroupid= ").append(payrollgroupId);
        sb.append(" and fpayrollsceneid = ").append(payrollsceneId);
        if (!SWCListUtils.isEmpty(usedCalperiods)) {
            sb.append(" and fcalperiodid in (");
            for (DynamicObject usedCalperiod : usedCalperiods) {
                sb.append(usedCalperiod.getLong("id")).append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(')');
        }
        if ((adminorg = this.getModel().getDataEntity().getDynamicObject(KEY_ADMINORG)) != null) {
            sb.append(" and  fadminorgid =").append(adminorg.getLong("id"));
        }
        sb.append(" group by  FCALPERIODID");
        SWCDbUtil.query((DBRoute)new DBRoute("swc"), (String)sb.toString(), null, rs -> {
            while (rs.next()) {
                long id = rs.getLong("id");
                if (isNeedPersonCount) {
                    Map personcountMap = dataMap.computeIfAbsent("personcount", k -> new HashMap(16));
                    personcountMap.put(id, rs.getBigDecimal("personcount"));
                }
                for (String field : fields) {
                    Map fiedMap = dataMap.computeIfAbsent(field, k -> new HashMap(16));
                    fiedMap.put(id, rs.getBigDecimal(field));
                }
            }
            return null;
        });
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "salarychartrefresh": {
                this.loadChart();
                break;
            }
            case "salarychartsettings": {
                this.openFormPage("hsas_salarychartconfig");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "range": 
            case "adminorg": {
                this.loadChart();
                break;
            }
        }
    }

    private void openFormPage(String pageId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(pageId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm(showParameter);
    }

    private void showEmptyPage() {
        FormShowParameter emptyPage = CalPlatformHelper.getEmptyPage((String)ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u8bf7\u786e\u4fdd\u6240\u6709\u7b5b\u9009\u6761\u4ef6\u6709\u503c\u3002", (String)"CalTaskCardListPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (String)"emptyflex1");
        this.getView().showForm(emptyPage);
        this.getView().setVisible(Boolean.TRUE, new String[]{"emptyflex1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap17"});
    }

    public static Map<String, Object> getSplitInfo(double max, double min) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        double grossStep = (max - min) / 5.0;
        if (BigDecimal.ZERO.compareTo(BigDecimal.valueOf(grossStep)) == 0) {
            return result;
        }
        double step = Math.pow(10.0, Math.floor(Math.log10(grossStep)));
        step = Math.ceil(grossStep / step) * step;
        double imin = Math.floor(min / step) * step;
        double imax = step * 5.0 + imin;
        result.put("interval", step);
        result.put("max", imax);
        result.put("min", imin);
        return result;
    }

    private BigDecimal getMaxValue(BigDecimal v1, BigDecimal v2) {
        if (v1.compareTo(v2) > 0) {
            return v1;
        }
        return v2;
    }

    private BigDecimal getMinValue(BigDecimal v1, BigDecimal v2) {
        if (v1.compareTo(v2) > 0) {
            return v2;
        }
        return v1;
    }

    public String getDateRangeStr(Date startDate, Date endDate) {
        return SWCInteDateTimeUtil.formateDate((Date)startDate) + "-" + SWCInteDateTimeUtil.formateDate((Date)endDate);
    }
}

