/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calplatform;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.swc.hsas.formplugin.web.calplatform.TaskPage;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;
import org.apache.commons.collections4.CollectionUtils;

public class SalaryResultCheckPlugin
extends AbstractFormPlugin {
    public static final String KEY_PAYROLLSCENE = "payrollscene";
    private static final String KEY_PREPAGE = "checkprepage";
    private static final String KEY_NEXTPAGE = "checknextpage";
    private static final String KEY_SWICTH = "switch";
    public static final String CLOSE_CALL_BACK_ID = "closecaldetailpage";
    public static final String KEY_BASICCHECK = "1";
    public static final String KEY_HIGHCHECK = "2";
    public static final String KEY_ITEMCOUNT_1 = "itemcount_1";
    public static final String KEY_ITEMCOUNT_2 = "itemcount_2";
    public static final String KEY_ITEMCOUNT_3 = "itemcount_3";
    public static final String KEY_ITEMCOUNT_4 = "itemcount_4";
    public static final String KEY_ITEMCOUNT_5 = "itemcount_5";
    public static final int KEY_DEALTCHECKLENGTH = 5;
    private static final Log LOGGER = LogFactory.getLog(SalaryResultCheckPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_PREPAGE, KEY_NEXTPAGE, KEY_ITEMCOUNT_1, KEY_ITEMCOUNT_2, KEY_ITEMCOUNT_3, KEY_ITEMCOUNT_4, KEY_ITEMCOUNT_5, KEY_SWICTH});
    }

    public void afterBindData(EventObject e) {
        this.getModel().setValue("currentpage", (Object)KEY_BASICCHECK);
        this.refreshPage();
    }

    private void refreshPage() {
        DynamicObject params = this.getView().getModel().getDataEntity();
        if (params != null) {
            DynamicObject periodObj = params.getDynamicObject("calperiod");
            if (periodObj == null) {
                return;
            }
            Long calperiod = periodObj.getLong("id");
            Long payrollGroupId = params.getLong("payrollgroup.id");
            Long payrollSceneId = params.getLong("payrollscene.id");
            if (calperiod == null || payrollGroupId == null || payrollSceneId == null) {
                this.hideCheckPart();
                return;
            }
            List<Long> taskIds = this.assembleTaskId(payrollGroupId, payrollSceneId, calperiod);
            if (SWCListUtils.isEmpty(taskIds)) {
                this.hideCheckPart();
                return;
            }
            String currentPage = String.valueOf(this.getModel().getValue("currentpage"));
            DynamicObjectCollection chechScheme = this.queryCheckScheme(payrollGroupId, payrollSceneId);
            if (chechScheme == null || chechScheme.size() == 0) {
                this.hideCheckPart();
                return;
            }
            Long schemeId = ((DynamicObject)chechScheme.get(0)).getLong("id");
            LinkedHashMap<Long, String> itemMap = new LinkedHashMap<Long, String>();
            for (DynamicObject dyObj : chechScheme) {
                if (!dyObj.getBoolean("valueentry.workbenchshow")) continue;
                String itemNameStr = dyObj.getString("valueentry.itemname");
                itemMap.put(dyObj.getLong("valueentry.itemid"), itemNameStr.length() > 9 ? itemNameStr.substring(0, 9) + "..." : itemNameStr);
            }
            if (itemMap == null || itemMap.size() == 0) {
                this.hideCheckPart();
                return;
            }
            ArrayList<Long> itemIdList = new ArrayList<Long>(itemMap.keySet());
            HashMap<Long, List<Map<String, Object>>> dataResult = new HashMap<Long, List<Map<String, Object>>>();
            DynamicObjectCollection resultCheckStatObjs = this.queryResultCheckStatObjs(schemeId, taskIds);
            if (SWCListUtils.isEmpty((List)resultCheckStatObjs)) {
                LOGGER.info("resultCheckStatObjs is empty");
            }
            long start = System.currentTimeMillis();
            this.assembleItemCheckStatInfo(dataResult, resultCheckStatObjs, itemMap);
            LOGGER.info("assembleItemCheckStatInfo_finish,cost:{} ms", (Object)(System.currentTimeMillis() - start));
            this.getPageCache().put("data", JSON.toJSONString(dataResult));
            int pageSize = 5;
            int total = itemIdList.size();
            int pageNum = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
            TaskPage page = new TaskPage();
            page.setCurrentPage(1);
            page.setPageSize(pageSize);
            page.setTotalPage(pageNum);
            page.setData(itemIdList);
            page.setParam(itemMap);
            this.skipPage(page, 1);
        }
    }

    private void assembleItemCheckStatInfo(Map<Long, List<Map<String, Object>>> dataResult, DynamicObjectCollection resultCheckStatObjs, Map<Long, String> itemMap) {
        HashMap<Long, Map<Long, Map<String, Object>>> dataMap = new HashMap<Long, Map<Long, Map<String, Object>>>(16);
        if (!SWCListUtils.isEmpty((List)resultCheckStatObjs)) {
            Map<Long, Long> checkStatTaskIdMap = resultCheckStatObjs.stream().collect(Collectors.toMap(key -> key.getLong("id"), value -> value.getLong("caltask.id")));
            this.assembleIndexStatDataMap(checkStatTaskIdMap, itemMap, dataMap);
            Map<String, Set<Long>> indexPersonMap = this.assembleIndexPersonMap(checkStatTaskIdMap.keySet(), itemMap.keySet());
            this.assembleIndexStatPersonData(indexPersonMap, dataMap);
        }
        this.assembleStatData(dataResult, dataMap, itemMap);
    }

    private void assembleStatData(Map<Long, List<Map<String, Object>>> dataResult, Map<Long, Map<Long, Map<String, Object>>> dataMap, Map<Long, String> itemMap) {
        ArrayList list = new ArrayList(0);
        if (dataMap.size() == 0) {
            for (Map.Entry<Long, String> item : itemMap.entrySet()) {
                dataResult.put(item.getKey(), list);
            }
        } else {
            HashMap itemTaskMap = new HashMap(16);
            for (Map.Entry<Long, String> entry : itemMap.entrySet()) {
                Long itemId = entry.getKey();
                Map<Long, Map<String, Object>> itemDataMap = dataMap.get(itemId);
                if (itemDataMap == null || itemDataMap.size() == 0) {
                    dataResult.put(itemId, list);
                    continue;
                }
                itemDataMap.forEach((key, value) -> {
                    Map singleMap = itemTaskMap.computeIfAbsent(itemId, map -> new HashMap(4));
                    if (singleMap.size() == 0) {
                        singleMap.put((Long)value.get("taskid"), value);
                    } else {
                        Map taskMap = singleMap.computeIfAbsent((Long)value.get("taskid"), tempMap -> new HashMap(4));
                        if (taskMap.size() == 0) {
                            taskMap.putAll(value);
                        } else {
                            HashSet personSet = new HashSet(16);
                            personSet.addAll((List)value.get("personList"));
                            personSet.addAll((List)taskMap.get("personList"));
                            taskMap.put("count", personSet.size());
                            taskMap.put("personList", new ArrayList(personSet));
                        }
                    }
                });
                List collect = ((Map)itemTaskMap.get(itemId)).values().stream().collect(Collectors.toList());
                dataResult.put(itemId, collect);
            }
        }
    }

    private void assembleIndexStatPersonData(Map<String, Set<Long>> indexPersonMap, Map<Long, Map<Long, Map<String, Object>>> dataMap) {
        ArrayList personIdList = new ArrayList(0);
        for (Map.Entry<Long, Map<Long, Map<String, Object>>> entry : dataMap.entrySet()) {
            Map<Long, Map<String, Object>> value = entry.getValue();
            for (Map.Entry<Long, Map<String, Object>> entry2 : value.entrySet()) {
                Map<String, Object> map = entry2.getValue();
                map.put("count", 0);
                map.put("personList", personIdList);
            }
        }
        for (Map.Entry<Object, Object> entry : indexPersonMap.entrySet()) {
            Map<String, Object> map;
            String[] split = ((String)entry.getKey()).split("-");
            Map<Long, Map<String, Object>> statMap = dataMap.get(Long.parseLong(split[0]));
            if (statMap == null || statMap.size() == 0 || (map = statMap.get(Long.parseLong(split[1]))) == null || map.size() == 0) continue;
            Set personSet = (Set)entry.getValue();
            map.put("count", personSet.size());
            map.put("personList", new ArrayList(personSet));
        }
    }

    private Map<String, Set<Long>> assembleIndexPersonMap(Set<Long> checkStatIdSet, Set<Long> itemIdSet) {
        HashMap<String, Set<Long>> indexPersonMap = new HashMap<String, Set<Long>>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_checkindexperson");
        QFilter filter = new QFilter("checkstatid", "in", checkStatIdSet);
        filter.and("itemid", "in", itemIdSet);
        long st = System.currentTimeMillis();
        DynamicObjectCollection indexPersonObjs = helper.queryOriginalCollection("checkstatid,itemid,personid", new QFilter[]{filter});
        LOGGER.info("queryIndexPersonData_cost:{} ms", (Object)(System.currentTimeMillis() - st));
        if (SWCListUtils.isEmpty((List)indexPersonObjs)) {
            return indexPersonMap;
        }
        for (DynamicObject personObj : indexPersonObjs) {
            long checkStatId = personObj.getLong("checkstatid");
            long itemId = personObj.getLong("itemid");
            String key = itemId + "-" + checkStatId;
            Set personIdSet = indexPersonMap.computeIfAbsent(key, value -> new HashSet(16));
            personIdSet.add(personObj.getLong("personid"));
        }
        return indexPersonMap;
    }

    private void assembleIndexStatDataMap(Map<Long, Long> checkStatTaskIdMap, Map<Long, String> itemMap, Map<Long, Map<Long, Map<String, Object>>> dataMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_checkindexstats");
        QFilter filter = new QFilter("checkstatid", "in", checkStatTaskIdMap.keySet());
        filter.and("itemid", "in", itemMap.keySet());
        LOGGER.info("queryIndexStatData_begin");
        long st = System.currentTimeMillis();
        DynamicObjectCollection indexStatObjs = helper.queryOriginalCollection("checkstatid,itemid,indexcount", new QFilter[]{filter});
        LOGGER.info("queryIndexStatData_finish cost:{} ms", (Object)(System.currentTimeMillis() - st));
        if (SWCListUtils.isEmpty((List)indexStatObjs)) {
            return;
        }
        LOGGER.info("indexStatObjs.size:{}", (Object)indexStatObjs.size());
        for (DynamicObject statObj : indexStatObjs) {
            long checkStatId = statObj.getLong("checkstatid");
            long itemId = statObj.getLong("itemid");
            Map map = dataMap.computeIfAbsent(itemId, value -> new HashMap(16));
            if (map.containsKey(checkStatId)) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            data.put("taskid", checkStatTaskIdMap.get(checkStatId));
            data.put("itemName", itemMap.get(itemId));
            map.put(checkStatId, data);
        }
    }

    private DynamicObjectCollection queryResultCheckStatObjs(Long schemeId, List<Long> taskIds) {
        SWCDataServiceHelper resultCheckHelper = new SWCDataServiceHelper("hsas_checkretstats");
        AuthorizedOrgResult orgFilter = this.getPermFilter();
        QFilter filter = new QFilter("checkscheme.id", "=", (Object)schemeId);
        filter.and(new QFilter("caltask.id", "in", taskIds));
        if (!orgFilter.isHasAllOrgPerm() && CollectionUtils.isNotEmpty((Collection)orgFilter.getHasPermOrgs())) {
            filter.and(new QFilter("adminorg.id", "in", (Object)orgFilter.getHasPermOrgs()));
        }
        LOGGER.info("queryResultCheckStatObjs_filters :{}", (Object)filter.toString());
        return resultCheckHelper.queryOriginalCollection("id,adminorg.id,caltask.id", new QFilter[]{filter});
    }

    private DynamicObjectCollection queryCheckScheme(Long payrollGroupId, Long payrollSceneId) {
        SWCDataServiceHelper checkHelper = new SWCDataServiceHelper("hsas_resultcheckscheme");
        QFilter filter = new QFilter("payrollgroup.id", "=", (Object)payrollGroupId);
        filter.and("payrollscene.id", "=", (Object)payrollSceneId);
        return checkHelper.queryOriginalCollection("id,valueentry.itemid,valueentry.itemname,valueentry.workbenchshow", new QFilter[]{filter}, "id asc");
    }

    private List<Long> assembleTaskId(Long payrollGroupId, Long payrollSceneId, Long calperiod) {
        DynamicObjectCollection tasks;
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("payrollgroup.id", "=", (Object)payrollGroupId);
        filter.and("payrollscene.id", "=", (Object)payrollSceneId);
        filter.and("period.id", "=", (Object)calperiod);
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calpayrolltask", (String)"47150e89000000ac");
        if (authorizedDataRuleQFilter == null) {
            return new ArrayList<Long>(0);
        }
        authorizedDataRuleQFilter.forEach(arg_0 -> ((QFilter)filter).and(arg_0));
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_calpayrolltask", (String)"47150e89000000ac");
        if (!permOrgs.hasAllOrgPerm()) {
            filter.and(new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs()));
        }
        if (!SWCListUtils.isEmpty((List)(tasks = taskHelper.queryOriginalCollection("id", new QFilter[]{filter})))) {
            return tasks.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>(0);
    }

    private AuthorizedOrgResult getPermFilter() {
        AuthorizedOrgResult permOrgs = SWCPermissionServiceHelper.getAuthorizedAdminOrgs((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"47150e89000000ac", (String)"adminorg");
        return permOrgs;
    }

    private void hideCheckPart() {
        for (int i = 0; i < 5; ++i) {
            String key = "item_" + (i + 1);
            this.getView().setVisible(Boolean.FALSE, new String[]{key});
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_NEXTPAGE});
        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_PREPAGE});
    }

    private void skipPage(TaskPage page, int pageNumber) {
        List<Long> showItems = page.flip(pageNumber);
        Map itemMap = (Map)page.getParam();
        for (int i = 0; i < page.getPageSize(); ++i) {
            String key = "item_" + (i + 1);
            if (i < showItems.size()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{key});
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.InContainer);
                showParameter.getOpenStyle().setTargetKey(key);
                showParameter.setFormId("hsas_singlecheckcard");
                showParameter.setCustomParam("itemid", (Object)showItems.get(i));
                showParameter.setCustomParam("index", (Object)(i + 1));
                showParameter.setCustomParam("itemmap", (Object)itemMap);
                this.getView().showForm(showParameter);
                continue;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{key});
        }
        this.getView().setEnable(Boolean.valueOf(pageNumber < page.getTotalPage()), new String[]{KEY_NEXTPAGE});
        this.getView().setEnable(Boolean.valueOf(pageNumber > 1), new String[]{KEY_PREPAGE});
        this.getPageCache().put("page", JSON.toJSONString((Object)page));
    }

    private void setLabelText(String labelName, String value) {
        Label label = (Label)this.getView().getControl(labelName);
        label.setText(value);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "checkprepage": 
            case "checknextpage": {
                TaskPage page = (TaskPage)JSON.parseObject((String)this.getPageCache().get("page"), TaskPage.class);
                this.skipPage(page, key.equals(KEY_PREPAGE) ? page.getCurrentPage() - 1 : page.getCurrentPage() + 1);
                break;
            }
            case "switch": {
                String currentPage = String.valueOf(this.getModel().getValue("currentpage"));
                if (KEY_BASICCHECK.equals(currentPage)) {
                    this.getModel().setValue("currentpage", (Object)KEY_HIGHCHECK);
                    this.setLabelText("checktype", ResManager.loadKDString((String)"\u9ad8\u9636\u68c0\u6838", (String)"SalaryResultCheckPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                } else {
                    this.getModel().setValue("currentpage", (Object)KEY_BASICCHECK);
                    this.setLabelText("checktype", ResManager.loadKDString((String)"\u57fa\u7840\u68c0\u6838", (String)"SalaryResultCheckPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                }
                this.refreshPage();
            }
        }
    }
}

