/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calresulttpl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.Pair;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hr.impt.core.validate.AbstractValidateHandler;
import kd.swc.hsas.business.calresulttpl.helper.CalResultTplAddItemServiceHelper;
import kd.swc.hsas.business.calresulttpl.helper.CalResultTplServiceHelper;
import kd.swc.hsas.common.enums.ItemTypeEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalResultTemplateImportValidator
extends AbstractValidateHandler {
    private static final Log logger = LogFactory.getLog(CalResultTemplateImportValidator.class);

    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.AFTER;
    }

    public void validate(List<ImportBillData> dataList, ImportLog importLog) {
        HashSet<String> orgNumberSet = new HashSet<String>(16);
        HashSet<String> groupNumberSet = new HashSet<String>(16);
        Map<String, Map<String, Map<String, Object>>> fieldTypeMap = this.getFieldTypeMap();
        HashSet<String> importNumberSet = new HashSet<String>(16);
        HashMap<String, Set<String>> itemNumberMap = new HashMap<String, Set<String>>(16);
        Stack<Pair<String, Set<String>>> defaultNumberGroupStack = new Stack<Pair<String, Set<String>>>();
        for (ImportBillData billData : dataList) {
            JSONObject data = billData.getData().getJSONObject("hsas_calresulttpl");
            String number = data.getString("number");
            String orgNumber = data.getJSONObject("org").getString("number");
            String isDefault = data.getString("isdefault");
            HashSet<String> tempGroupNumberSet = new HashSet<String>(16);
            JSONArray payrollgroups = data.getJSONArray("payrollgroups");
            if (SWCStringUtils.isEmpty((String)number) || SWCStringUtils.isEmpty((String)orgNumber) || payrollgroups == null || payrollgroups.size() == 0) continue;
            for (Object payrollgroup : payrollgroups) {
                JSONObject obj = (JSONObject)payrollgroup;
                if (obj.size() <= 1) continue;
                tempGroupNumberSet.add(obj.getString("number"));
            }
            groupNumberSet.addAll(tempGroupNumberSet);
            if (SWCStringUtils.equals((String)ResManager.loadKDString((String)"\u662f", (String)"CalResultTemplateImportValidator_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (String)isDefault)) {
                defaultNumberGroupStack.push((Pair<String, Set<String>>)new Pair((Object)number, tempGroupNumberSet));
            }
            orgNumberSet.add(orgNumber);
            importNumberSet.add(number);
            JSONArray resultEntry = data.getJSONArray("resultlist");
            if (resultEntry == null || resultEntry.size() <= 0) continue;
            for (int i = 0; i < resultEntry.size(); ++i) {
                JSONObject itemRet = resultEntry.getJSONObject(i);
                String itemNumber = itemRet.getString("itemnumber");
                String itemType = itemRet.getString("itemcategory");
                Set itemNumberSet = itemNumberMap.computeIfAbsent(itemType, single -> new HashSet(16));
                itemNumberSet.add(itemNumber);
            }
        }
        Set<String> defaultNumberSet = this.removeRepeatDefaultNumber(defaultNumberGroupStack);
        HashMap<String, String> orgNumberNameMap = new HashMap<String, String>(orgNumberSet.size());
        HashMap<Long, String> orgIdNumberMap = new HashMap<Long, String>(orgNumberSet.size());
        HashMap<String, Long> orgNumberIdMap = new HashMap<String, Long>(orgNumberSet.size());
        this.assembleOrgInfoByNumber(orgNumberSet, orgNumberNameMap, orgIdNumberMap, orgNumberIdMap);
        Map<String, Map<String, String>> groupInfoMap = this.queryGroupInfoByNumber(groupNumberSet);
        Map<String, List<String>> validItemNumberMap = this.queryValidItemNumbers(itemNumberMap);
        Map<Long, Map<String, Map<String, Map<String, Object>>>> orgItemMap = this.queryOrgItem(orgIdNumberMap.keySet());
        List hasPermOrgIds = SWCPermissionServiceHelper.getUserHasPermOrgs((Long)RequestContext.get().getCurrUserId());
        List orgIds = hasPermOrgIds != null ? hasPermOrgIds : null;
        Set payrollGroupIdSet = SWCPermissionServiceHelper.getPayrollGrpSetByPermItem((String)"/UHMBBGZQ65X", (String)"hsas_calresulttpl", (String)"47150e89000000ac");
        CalResultTplServiceHelper serviceHelper = new CalResultTplServiceHelper();
        List resultTplList = serviceHelper.getCalResultTplByNumber(importNumberSet);
        HashMap<String, Map> resultTplEntryMap = new HashMap<String, Map>(16);
        for (DynamicObject tplObj : resultTplList) {
            String number = tplObj.getString("number");
            Map entryMap = resultTplEntryMap.computeIfAbsent(number, single -> new HashMap(16));
            Set itemList = entryMap.computeIfAbsent("itemEntry", single -> new HashSet(16));
            Set resultList = entryMap.computeIfAbsent("resultEntry", single -> new HashSet(16));
            long itemEntryId = tplObj.getLong("payrolllist.id");
            long resultEntryId = tplObj.getLong("resultlist.id");
            if (itemEntryId > 0L) {
                String itemKey = tplObj.getString("payrolllist.id") + "#" + tplObj.getString("payrolllist.fieldsource") + "_" + tplObj.getString("payrolllist.field");
                itemList.add(itemKey);
            }
            if (resultEntryId <= 0L) continue;
            String resultKey = resultEntryId + "#" + tplObj.getString("resultlist.itemcategory") + "_" + tplObj.getString("resultlist.itemnumber");
            resultList.add(resultKey);
        }
        for (ImportBillData billData : dataList) {
            JSONArray resultEntry;
            String errorMsg;
            JSONObject data = billData.getData().getJSONObject("hsas_calresulttpl");
            String number = data.getString("number");
            String isDefault = data.getString("isdefault");
            if (SWCStringUtils.equals((String)ResManager.loadKDString((String)"\u662f", (String)"CalResultTemplateImportValidator_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (String)isDefault) && !defaultNumberSet.contains(number)) {
                data.put("isdefault", null);
            }
            String orgNumber = data.getJSONObject("org").getString("number");
            JSONArray payrollgroups = data.getJSONArray("payrollgroups");
            if (SWCStringUtils.isEmpty((String)number) || SWCStringUtils.isEmpty((String)orgNumber) || payrollgroups == null || payrollgroups.size() == 0) continue;
            String orgName = data.getJSONObject("org").getString("name");
            String dbOrgName = (String)orgNumberNameMap.get(orgNumber);
            Long orgId = (Long)orgNumberIdMap.get(orgNumber);
            if (orgIds != null && !orgIds.contains(orgId)) {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u201c\u7b97\u53d1\u85aa\u7ec4\u7ec7\u201d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u6ca1\u6709\u6743\u9650\uff1a\u7f16\u7801\u201c{1}\u201d\u3002", (String)"CalResultTemplateImportValidator_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), billData.getStartIndex(), MessageFormat.format(errorMsg, billData.getStartIndex(), orgNumber));
                continue;
            }
            if (SWCStringUtils.isNotEmpty((String)orgName) && !SWCStringUtils.equals((String)orgName, (String)dbOrgName)) {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u201c\u7b97\u53d1\u85aa\u7ec4\u7ec7\u201d\u7f16\u7801\u4e0e\u540d\u79f0\u4e0d\u5339\u914d\uff1a\u7f16\u7801\u201c{1}\u201d\u3002", (String)"CalResultTemplateImportValidator_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), billData.getStartIndex(), MessageFormat.format(errorMsg, billData.getStartIndex(), orgNumber));
                continue;
            }
            JSONObject groupNameObj = (JSONObject)payrollgroups.get(payrollgroups.size() - 1);
            String[] groupNames = null;
            if (payrollgroups.size() > 1 && groupNameObj.size() == 1) {
                String groupNameStr = groupNameObj.getString("name");
                groupNames = groupNameStr.split(",");
                payrollgroups.remove(payrollgroups.size() - 1);
            }
            this.checkGroup(importLog, groupInfoMap, payrollGroupIdSet, billData, orgId, payrollgroups, groupNames);
            JSONArray fieldEntry = data.getJSONArray("payrolllist");
            Map entryMap = (Map)resultTplEntryMap.get(number);
            if (fieldEntry != null) {
                HashMap<String, Set<String>> existFieldMap = new HashMap<String, Set<String>>(16);
                this.checkFieldEntry(importLog, fieldTypeMap, billData, fieldEntry, existFieldMap, entryMap);
            }
            if ((resultEntry = data.getJSONArray("resultlist")) == null) continue;
            Map<String, Map<String, Map<String, Object>>> orgItemTypeMap = orgItemMap.get(orgId);
            HashMap<String, Set<String>> existItemMap = new HashMap<String, Set<String>>(16);
            this.checkResultEntry(importLog, billData, resultEntry, orgItemTypeMap, existItemMap, entryMap, validItemNumberMap);
        }
    }

    private Set<String> removeRepeatDefaultNumber(Stack<Pair<String, Set<String>>> defaultNumberGroupStack) {
        HashSet<String> defaultNumberSet = new HashSet<String>(16);
        HashSet defaultGroupSet = new HashSet(16);
        while (!defaultNumberGroupStack.isEmpty()) {
            Pair<String, Set<String>> pair = defaultNumberGroupStack.pop();
            Set groups = (Set)pair.getValue();
            HashSet tempGroup = new HashSet(groups);
            tempGroup.retainAll(defaultGroupSet);
            if (tempGroup.size() != 0) continue;
            defaultGroupSet.addAll(groups);
            defaultNumberSet.add((String)pair.getKey());
        }
        return defaultNumberSet;
    }

    private Map<String, List<String>> queryValidItemNumbers(Map<String, Set<String>> itemNumberMap) {
        Set<String> accItemSet;
        Set<String> spItemSet;
        Set<String> bizItemSet;
        Set<String> fetchItemSet;
        HashMap<String, List<String>> itemMap = new HashMap<String, List<String>>(16);
        Set<String> salaryItemSet = itemNumberMap.get(ItemTypeEnum.SALARYITEMKEY.getDesc());
        if (salaryItemSet != null && salaryItemSet.size() > 0) {
            this.queryValidItemNumbers("hsbs_salaryitem", itemMap, salaryItemSet, ItemTypeEnum.SALARYITEMKEY.getDesc());
        }
        if ((fetchItemSet = itemNumberMap.get(ItemTypeEnum.FTITEMKEY.getDesc())) != null && fetchItemSet.size() > 0) {
            this.queryValidItemNumbers("hsbs_fetchitem", itemMap, fetchItemSet, ItemTypeEnum.FTITEMKEY.getDesc());
        }
        if ((bizItemSet = itemNumberMap.get(ItemTypeEnum.BSITEMKEY.getDesc())) != null && bizItemSet.size() > 0) {
            this.queryValidItemNumbers("hsbs_bizitem", itemMap, bizItemSet, ItemTypeEnum.BSITEMKEY.getDesc());
        }
        if ((spItemSet = itemNumberMap.get(ItemTypeEnum.SPITEMKEY.getDesc())) != null && spItemSet.size() > 0) {
            this.queryValidItemNumbers("hsbs_supportitem", itemMap, spItemSet, ItemTypeEnum.SPITEMKEY.getDesc());
        }
        if ((accItemSet = itemNumberMap.get(ItemTypeEnum.ACKEY.getDesc())) != null && accItemSet.size() > 0) {
            this.queryValidItemNumbers("hsas_accumulator", itemMap, accItemSet, ItemTypeEnum.ACKEY.getDesc());
        }
        return itemMap;
    }

    private void queryValidItemNumbers(String entity, Map<String, List<String>> itemMap, Set<String> itemSet, String itemType) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entity);
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        filter.and("number", "in", itemSet);
        DynamicObjectCollection itemObjs = helper.queryOriginalCollection("number", new QFilter[]{filter});
        if (!SWCListUtils.isEmpty((List)itemObjs)) {
            itemMap.put(itemType, itemObjs.stream().map(single -> single.getString("number")).collect(Collectors.toList()));
        }
    }

    private void checkGroup(ImportLog importLog, Map<String, Map<String, String>> groupInfoMap, Set<Long> payrollGroupIdSet, ImportBillData billData, Long orgId, JSONArray payrollgroups, String[] groupNames) {
        if (groupNames != null && groupNames.length > 0 && groupNames.length != payrollgroups.size()) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u7f16\u7801\u4e0e\u540d\u79f0\u4e0d\u5339\u914d\u3002", (String)"CalResultTemplateImportValidator_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), billData.getStartIndex(), MessageFormat.format(errorMsg, billData.getStartIndex()));
            return;
        }
        for (int j = 0; j < payrollgroups.size(); ++j) {
            String errorMsg;
            JSONObject group = (JSONObject)payrollgroups.get(j);
            if (group.size() == 1) continue;
            String groupNumber = group.getString("number");
            Map<String, String> groupMap = groupInfoMap.get(groupNumber);
            if (groupMap == null || groupMap.size() == 0) {
                String errorMsg2 = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u6ca1\u6709\u6743\u9650\uff1a\u7f16\u7801\u201c{1}\u201d\u3002", (String)"CalResultTemplateImportValidator_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), billData.getStartIndex(), MessageFormat.format(errorMsg2, billData.getStartIndex(), groupNumber));
                continue;
            }
            Long groupId = Long.valueOf(groupMap.get("groupId"));
            String groupName = groupMap.get("groupName");
            Long orgIdT = Long.valueOf(groupMap.get("orgId"));
            if (orgId.compareTo(orgIdT) != 0) {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u6240\u5c5e\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u4e0e\u6a21\u677f\u7684\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u4e00\u81f4\u3002", (String)"CalResultTemplateImportValidator_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), billData.getStartIndex(), MessageFormat.format(errorMsg, billData.getStartIndex()));
                continue;
            }
            if (payrollGroupIdSet != null && !payrollGroupIdSet.contains(groupId)) {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u6ca1\u6709\u6743\u9650\uff1a\u7f16\u7801\u201c{1}\u201d\u3002", (String)"CalResultTemplateImportValidator_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), billData.getStartIndex(), MessageFormat.format(errorMsg, billData.getStartIndex(), groupNumber));
                continue;
            }
            if (groupNames == null || groupNames.length <= 0 || SWCStringUtils.equals((String)groupName, (String)groupNames[j])) continue;
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u7f16\u7801\u4e0e\u540d\u79f0\u4e0d\u5339\u914d\uff1a\u7f16\u7801\u201c{1}\u201d\u3002", (String)"CalResultTemplateImportValidator_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), billData.getStartIndex(), MessageFormat.format(errorMsg, billData.getStartIndex(), groupNumber));
        }
    }

    private void checkFieldEntry(ImportLog importLog, Map<String, Map<String, Map<String, Object>>> fieldTypeMap, ImportBillData billData, JSONArray fieldEntry, Map<String, Set<String>> existFieldMap, Map<String, Set<String>> entryMap) {
        Set<String> itemEntry;
        ArrayList<String> existItemKeyList = new ArrayList<String>(10);
        if (entryMap != null && entryMap.size() > 0 && (itemEntry = entryMap.get("itemEntry")) != null && itemEntry.size() > 0) {
            existItemKeyList.addAll(itemEntry);
        }
        HashMap<String, String> itemKeyMap = new HashMap<String, String>(16);
        for (String itemKey : existItemKeyList) {
            String[] split = itemKey.split("#");
            itemKeyMap.put(split[1], split[0]);
        }
        for (int i = 0; i < fieldEntry.size(); ++i) {
            Integer errIndex;
            String errorMsg;
            Integer errIndex2;
            String errorMsg2;
            JSONObject fieldData = fieldEntry.getJSONObject(i);
            if (fieldData.size() == 0) continue;
            String fieldSource = fieldData.getString("fieldsource");
            String field = fieldData.getString("field");
            String fieldName = fieldData.getString("fieldname");
            if (SWCStringUtils.isEmpty((String)fieldSource) || SWCStringUtils.isEmpty((String)field) || SWCStringUtils.isEmpty((String)fieldName)) continue;
            String itemKey = fieldSource + "_" + field;
            String entryId = fieldData.getString("payrolllist_id");
            String existEntryId = (String)itemKeyMap.get(itemKey);
            if (SWCStringUtils.isNotEmpty((String)existEntryId) && (SWCStringUtils.isEmpty((String)entryId) || !SWCStringUtils.equals((String)entryId, (String)existEntryId))) {
                String errorMsg3 = ResManager.loadKDString((String)"\u6838\u7b97\u540d\u5355\u5b57\u6bb5\u5206\u5f55\u5df2\u5b58\u5728\u201c{0}\u201d\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"CalResultTemplateImportValidator_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                Integer errIndex3 = fieldData.getInteger("$excelIndex");
                importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), errIndex3.intValue(), MessageFormat.format(errorMsg3, field));
                continue;
            }
            Map<String, Map<String, Object>> fieldSourceMap = fieldTypeMap.get(fieldSource);
            if (fieldSourceMap == null) {
                errorMsg2 = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c{0}\u884c\u201c\u5b57\u6bb5\u6765\u6e90\u201d\uff1a\u201c{1}\u201d\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"CalResultTemplateImportValidator_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                errIndex2 = fieldData.getInteger("$excelIndex");
                importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), errIndex2.intValue(), MessageFormat.format(errorMsg2, errIndex2, fieldSource));
                continue;
            }
            Map<String, Object> fieldMap = fieldSourceMap.get(field);
            if (fieldMap == null) {
                errorMsg2 = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u201c%2$s\u201d\u4e2d\u8be5\u201c%3$s\u201d\u65e0\u5bf9\u5e94\u5b57\u6bb5\u3002", (String)"CalResultTemplateImportValidator_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                errIndex2 = fieldData.getInteger("$excelIndex");
                importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), errIndex2.intValue(), String.format(errorMsg2, errIndex2, fieldSource, fieldName));
                continue;
            }
            String dbFieldName = (String)fieldMap.get("name");
            if (!SWCStringUtils.equals((String)dbFieldName, (String)fieldName)) {
                errorMsg = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u201c\u201c%2$s\u201d\u201d\u4e2d\u8be5\u201c\u201c%3$s\u201d\u201d\u4e0e\u7cfb\u7edf\u5b57\u6bb5\u540d\u79f0\u4e0d\u5339\u914d\u3002", (String)"CalResultTemplateImportValidator_17", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                errIndex = fieldData.getInteger("$excelIndex");
                importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), errIndex.intValue(), String.format(errorMsg, errIndex, fieldSource, fieldName));
                continue;
            }
            Set fieldSet = existFieldMap.computeIfAbsent(fieldSource, single -> new HashSet(16));
            if (fieldSet.contains(field)) {
                errorMsg = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u201c%2$s\u201d\u4e2d\u8be5\u201c%3$s\u201d\u91cd\u590d\u5bfc\u5165\u3002", (String)"CalResultTemplateImportValidator_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                errIndex = fieldData.getInteger("$excelIndex");
                importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), errIndex.intValue(), String.format(errorMsg, errIndex, fieldSource, fieldName));
                continue;
            }
            fieldSet.add(field);
            fieldData.put("fieldnumber", fieldMap.get("number"));
            fieldData.put("fieldtype", fieldMap.get("type"));
        }
    }

    private void checkResultEntry(ImportLog importLog, ImportBillData billData, JSONArray resultEntry, Map<String, Map<String, Map<String, Object>>> orgItemTypeMap, Map<String, Set<String>> existItemMap, Map<String, Set<String>> entryMap, Map<String, List<String>> validItemNumberMap) {
        Set<String> existResultEntry;
        ArrayList<String> existResultKeyList = new ArrayList<String>(10);
        if (entryMap != null && entryMap.size() > 0 && (existResultEntry = entryMap.get("resultEntry")) != null && existResultEntry.size() > 0) {
            existResultKeyList.addAll(existResultEntry);
        }
        HashMap<String, String> resultKeyMap = new HashMap<String, String>(16);
        for (String itemKey : existResultKeyList) {
            String[] split = itemKey.split("#");
            resultKeyMap.put(split[1], split[0]);
        }
        for (int j = 0; j < resultEntry.size(); ++j) {
            Integer errIndex;
            String errorMsg;
            String errorMsg2;
            Map<String, Map<String, Object>> itemTypeMap;
            JSONObject resultData = resultEntry.getJSONObject(j);
            if (resultData.size() == 0) continue;
            String itemType = resultData.getString("itemcategory");
            String itemNumber = resultData.getString("itemnumber");
            if (SWCStringUtils.isEmpty((String)itemType) || SWCStringUtils.isEmpty((String)itemNumber) || (itemTypeMap = orgItemTypeMap.get(itemType)) == null) continue;
            Map itemNumberMap = itemTypeMap.values().stream().collect(Collectors.toMap(obj -> obj.get("number"), Function.identity(), (v1, v2) -> v1));
            String itemName = resultData.getString("itemname");
            String resultKey = ItemTypeEnum.getPrefixByName((String)itemType) + "_" + itemNumber;
            String entryId = resultData.getString("resultlist_id");
            String existEntryId = (String)resultKeyMap.get(resultKey);
            List<String> validItemNumberList = validItemNumberMap.get(itemType);
            if (SWCListUtils.isEmpty(validItemNumberList) || !validItemNumberList.contains(itemNumber)) {
                Integer errIndex2 = resultData.getInteger("$excelIndex");
                logger.info("errIndex:{},itemType:{}", (Object)errIndex2, (Object)itemType);
                errorMsg2 = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u201c\u201c%2$s\u201d\u201d\u4e2d\u8be5\u201c\u201c%3$s\u201d\u201d\u65e0\u5bf9\u5e94\u9879\u76ee\u6216\u9879\u76ee\u975e\u5df2\u5ba1\u6838\u53ef\u7528\u3002", (String)"CalResultTemplateImportValidator_18", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), errIndex2.intValue(), String.format(errorMsg2, errIndex2, itemType, itemNumber));
                continue;
            }
            Map itemMap = (Map)itemNumberMap.get(itemNumber);
            if (itemMap == null) {
                Integer errIndex3 = resultData.getInteger("$excelIndex");
                errorMsg = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u201c\u201c%2$s\u201d\u201d\u4e2d\u8be5\u201c\u201c%3$s\u201d\u201d\u4f7f\u7528\u7ec4\u7ec7\u4e0d\u5305\u542b\u6a21\u677f\u7684\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"CalResultTemplateImportValidator_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), errIndex3.intValue(), String.format(errorMsg, errIndex3, itemType, itemNumber));
                continue;
            }
            if (SWCStringUtils.isNotEmpty((String)existEntryId) && (SWCStringUtils.isEmpty((String)entryId) || !SWCStringUtils.equals((String)entryId, (String)existEntryId))) {
                errorMsg2 = ResManager.loadKDString((String)"\u7ed3\u679c\u8868\u5185\u5bb9\u5206\u5f55\u5df2\u5b58\u5728{0}\u201c{1}\u201d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"CalResultTemplateImportValidator_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                Integer errIndex4 = resultData.getInteger("$excelIndex");
                importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), errIndex4.intValue(), MessageFormat.format(errorMsg2, itemType, itemNumber));
                continue;
            }
            Set existItemSet = existItemMap.computeIfAbsent(itemType, single -> new HashSet(16));
            if (existItemSet.contains(itemNumber)) {
                errorMsg = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u201c%2$s\u201d\u4e2d\u8be5\u201c%3$s\u201d\u91cd\u590d\u5bfc\u5165\u3002", (String)"CalResultTemplateImportValidator_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                errIndex = resultData.getInteger("$excelIndex");
                importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), errIndex.intValue(), String.format(errorMsg, errIndex, itemType, itemNumber));
                continue;
            }
            existItemSet.add(itemNumber);
            if (SWCStringUtils.isEmpty((String)itemName)) {
                resultData.put("itemname", itemMap.get("name"));
            } else if (!SWCStringUtils.equals((String)itemName, (String)(itemMap.get("name") + ""))) {
                errorMsg = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u201c%2$s\u201d\u4e0e\u201c%3$s\u201d\u4e0d\u5339\u914d\u3002", (String)"CalResultTemplateImportValidator_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                errIndex = resultData.getInteger("$excelIndex");
                importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), errIndex.intValue(), String.format(errorMsg, errIndex, itemName, itemNumber));
                continue;
            }
            resultData.put("itemunicodeid", (Object)(ItemTypeEnum.getPrefixByName((String)itemType) + "_" + itemNumber));
        }
    }

    private Map<Long, Map<String, Map<String, Map<String, Object>>>> queryOrgItem(Set<Long> orgIdSet) {
        HashMap<Long, Map<String, Map<String, Map<String, Object>>>> orgItemMap = new HashMap<Long, Map<String, Map<String, Map<String, Object>>>>(orgIdSet.size());
        CalResultTplAddItemServiceHelper helper = new CalResultTplAddItemServiceHelper();
        for (Long orgId : orgIdSet) {
            Map dataMap = helper.getAllItemData(orgId.longValue(), true);
            HashMap dataMapNew = new HashMap(dataMap.size());
            for (Map.Entry entry : dataMap.entrySet()) {
                dataMapNew.put(ItemTypeEnum.getDesc((String)((String)entry.getKey())), entry.getValue());
            }
            orgItemMap.put(orgId, dataMapNew);
        }
        return orgItemMap;
    }

    private void assembleOrgInfoByNumber(Set<String> orgNumberSet, Map<String, String> orgNumberNameMap, Map<Long, String> orgIdNumberMap, Map<String, Long> orgNumberIdMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("bos_org");
        DynamicObjectCollection orgs = helper.queryOriginalCollection("id,number,name", new QFilter("number", "in", orgNumberSet).toArray());
        if (SWCListUtils.isEmpty((List)orgs)) {
            return;
        }
        for (DynamicObject org : orgs) {
            orgNumberNameMap.put(org.getString("number"), org.getString("name"));
            orgIdNumberMap.put(org.getLong("id"), org.getString("name"));
            orgNumberIdMap.put(org.getString("number"), org.getLong("id"));
        }
    }

    private Map<String, Map<String, String>> queryGroupInfoByNumber(Set<String> groupNumberSet) {
        HashMap<String, Map<String, String>> groupInfoMap = new HashMap<String, Map<String, String>>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        filter.and("iscurrentversion", "=", (Object)"1");
        filter.and("number", "in", groupNumberSet);
        DynamicObjectCollection groups = helper.queryOriginalCollection("id,number,name,org.id", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)groups)) {
            return groupInfoMap;
        }
        for (DynamicObject group : groups) {
            String number = group.getString("number");
            Map map = groupInfoMap.computeIfAbsent(number, single -> new HashMap(16));
            map.put("groupId", group.getString("id"));
            map.put("groupName", group.getString("name"));
            map.put("orgId", group.getString("org.id"));
        }
        return groupInfoMap;
    }

    private Map<String, Map<String, Map<String, Object>>> getFieldTypeMap() {
        Long perruleobjId;
        String name;
        HashMap<String, Map<String, Map<String, Object>>> fieldTypeMap = new HashMap<String, Map<String, Map<String, Object>>>(16);
        HashMap<String, Map> fieldInfoMap = new HashMap<String, Map>(16);
        SWCDataServiceHelper fieldObjHelper = new SWCDataServiceHelper("hsbs_perruleobj");
        QFilter filter = new QFilter("id", "!=", (Object)0L);
        DynamicObject[] objs = fieldObjHelper.query("id,parentid,name,number,table", new QFilter[]{filter}, "index asc");
        List secondNodeObjs = Arrays.stream(objs).filter(o -> o.getLong("parentid") == 0L).collect(Collectors.toList());
        Map<Long, String> typeMap = secondNodeObjs.stream().collect(Collectors.toMap(v1 -> v1.getLong("id"), v2 -> v2.getString("name")));
        Map<Long, List<DynamicObject>> thirdNodeMap = Arrays.stream(objs).filter(o -> o.getLong("parentid") != 0L).collect(Collectors.groupingBy(dy -> dy.getLong("parentid")));
        ArrayList<Long> thirdTreeIdList = new ArrayList<Long>(10);
        ArrayList<Long> thirdPersonHrIdList = new ArrayList<Long>(10);
        for (DynamicObject secondNodeObj : secondNodeObjs) {
            List<DynamicObject> thirdNodeObjs = thirdNodeMap.get(secondNodeObj.getLong("id"));
            if (thirdNodeObjs == null) continue;
            for (DynamicObject thirdNodeObj : thirdNodeObjs) {
                String objNumber = thirdNodeObj.getString("number");
                if (SWCStringUtils.equals((String)"hsas_employee", (String)objNumber) || SWCStringUtils.equals((String)"hsas_pernontsprop", (String)objNumber)) continue;
                Long thirdTreeId = thirdNodeObj.getLong("id");
                if (SWCStringUtils.equals((String)objNumber, (String)"hsas_personhr")) {
                    thirdPersonHrIdList.add(thirdTreeId);
                    continue;
                }
                thirdTreeIdList.add(thirdTreeId);
            }
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_callistfieldcfg");
        DynamicObject[] filedCfgs = null;
        DynamicObject[] personHrCfgs = null;
        List<String> removeStrList = Arrays.asList("viewdetailresult", "calpersonmark", "addfiletype", "onholdstatus", "calstatus", "taxstatus", "paystatus", "allotstatus", "salarystatus");
        QFilter removeFilter = new QFilter("field", "not in", removeStrList);
        if (thirdTreeIdList != null && thirdTreeIdList.size() > 0) {
            filedCfgs = helper.query("name,number,perruleobj.number,perruleobj.id,field,type", new QFilter[]{new QFilter("perruleobj", "in", thirdTreeIdList).and(removeFilter)});
        }
        if (thirdPersonHrIdList != null && thirdPersonHrIdList.size() > 0) {
            personHrCfgs = helper.query("name,type,number,perruleobj.number,perruleobj.id,field,type", new QFilter[]{new QFilter("perruleobj.number", "in", Arrays.asList("hsas_personhr", "hsas_employee", "hsas_pernontsprop")).and(removeFilter)});
        }
        Map<String, List<DynamicObject>> filedCfgMap = Arrays.stream(filedCfgs).collect(Collectors.groupingBy(o -> o.getString("perruleobj.number")));
        HashMap<Long, List> leafNameMap = new HashMap<Long, List>(16);
        for (Map.Entry<String, List<DynamicObject>> entry : filedCfgMap.entrySet()) {
            DynamicObject[] fields = entry.getValue();
            for (DynamicObject field : fields) {
                Long thirdTreeId = field.getLong("perruleobj.id");
                String string = field.getString("number");
                name = field.getLocaleString("name").toString();
                String filed = field.getString("field");
                List leafFieldList = leafNameMap.computeIfAbsent(thirdTreeId, single -> new ArrayList(10));
                leafFieldList.add(filed);
                Map dataMap = fieldInfoMap.computeIfAbsent(filed, single -> new HashMap(16));
                dataMap.put("name", name);
                String type = field.getString("type");
                dataMap.put("type", type);
                perruleobjId = field.getLong("perruleobj.id");
                dataMap.put("perruleobjId", perruleobjId);
                dataMap.put("alias", filed);
                dataMap.put("number", thirdTreeId + "_" + string);
            }
        }
        if (personHrCfgs != null && personHrCfgs.length > 0) {
            for (Long l : thirdPersonHrIdList) {
                for (DynamicObject field : personHrCfgs) {
                    String string = field.getString("number");
                    name = field.getLocaleString("name").toString();
                    String type = field.getString("type");
                    String filed = field.getString("field");
                    List leafFieldList = leafNameMap.computeIfAbsent(l, single -> new ArrayList(10));
                    leafFieldList.add(filed);
                    Map dataMap = fieldInfoMap.computeIfAbsent(filed, single -> new HashMap(16));
                    dataMap.put("name", name);
                    dataMap.put("type", type);
                    perruleobjId = field.getLong("perruleobj.id");
                    dataMap.put("perruleobjId", perruleobjId);
                    dataMap.put("alias", filed);
                    dataMap.put("number", l + "_" + string);
                }
            }
            for (Map.Entry<Object, List<Object>> entry : thirdNodeMap.entrySet()) {
                String typeName = typeMap.get(entry.getKey());
                if (SWCStringUtils.isEmpty((String)typeName)) continue;
                Map fieldNameList = fieldTypeMap.computeIfAbsent(typeName, single -> new HashMap(16));
                List<Object> value = entry.getValue();
                for (DynamicObject dynamicObject : value) {
                    long typeId = dynamicObject.getLong("id");
                    List list = (List)leafNameMap.get(typeId);
                    if (SWCListUtils.isEmpty((List)list)) continue;
                    for (String field : list) {
                        Map fieldMap = (Map)fieldInfoMap.get(field);
                        if (fieldMap == null) continue;
                        String alias = (String)fieldMap.get("alias");
                        fieldNameList.put(alias, fieldMap);
                    }
                }
            }
        }
        return fieldTypeMap;
    }
}

