/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calresulttpl;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.calresulttpl.helper.CalResultTplServiceHelper;
import kd.swc.hsas.formplugin.web.basedata.HisBaseDataSummaryEdit;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalResultTempleteBaseEdit
extends HisBaseDataSummaryEdit
implements BeforeF7SelectListener {
    protected static final Log logger = LogFactory.getLog(CalResultTempleteBaseEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit payrollaGrp = (MulBasedataEdit)this.getView().getControl("payrollgroups");
        payrollaGrp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setIsDefaultByPayrolltask();
        this.setHighLightColor();
        this.getModel().setDataChanged(false);
    }

    private void setIsDefaultByPayrolltask() {
        DynamicObjectCollection payRollGroups = (DynamicObjectCollection)this.getModel().getValue("payrollgroups");
        if (payRollGroups != null && payRollGroups.size() > 0) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"isdefault"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"isdefault"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String optKey = formOperate.getOperateKey();
        if (SWCStringUtils.equals((String)optKey, (String)"resultcontent_additem")) {
            this.checkPayRollGroupSelect(args);
        } else if (SWCStringUtils.equals((String)optKey, (String)"submit")) {
            if (!this.submitCheck(args)) {
                return;
            }
            this.isDefaultTplCheck(args, false);
        } else if (SWCStringUtils.equals((String)optKey, (String)"save")) {
            if (!this.submitCheck(args)) {
                return;
            }
            this.isDefaultTplCheck(args, true);
        }
    }

    private boolean submitCheck(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection resultListColl = this.getModel().getEntryEntity("resultlist");
        if (resultListColl == null || resultListColl.size() == 0) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7ed3\u679c\u8868\u5185\u5bb9\u8bbe\u7f6e\u201d\u3002", (String)"CalResultTempleteBaseEdit_18", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private void isDefaultTplCheck(BeforeDoOperationEventArgs args, boolean isSave) {
        long calResultTplId;
        String isDefaultTpl = (String)this.getModel().getValue("isdefault");
        if (SWCStringUtils.isEmpty((String)isDefaultTpl) || !SWCStringUtils.equals((String)isDefaultTpl, (String)"1")) {
            return;
        }
        DynamicObjectCollection payRollGroups = (DynamicObjectCollection)this.getModel().getValue("payrollgroups");
        if (payRollGroups == null || payRollGroups.size() == 0) {
            return;
        }
        CalResultTplServiceHelper helper = new CalResultTplServiceHelper();
        List payRollGroupIds = payRollGroups.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
        DynamicObject[] defaultInfo = helper.getCalResultTplIsDefaultInfo(payRollGroupIds, calResultTplId = ((Long)this.getModel().getValue("id")).longValue());
        if (defaultInfo == null || defaultInfo.length == 0) {
            return;
        }
        FormOperate source = (FormOperate)args.getSource();
        String confirmStr = "";
        confirmStr = isSave ? "cal_result_after_confirm_save" : "cal_result_after_confirm_submit";
        if (!source.getOption().tryGetVariableValue(confirmStr, new RefObject())) {
            ConfirmCallBackListener confirmCallBacks = null;
            confirmCallBacks = isSave ? new ConfirmCallBackListener("calresultdefaultsave", (IFormPlugin)this) : new ConfirmCallBackListener("calresultdefaultsubmit", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"CalResultTempleteBaseEdit_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"CalResultTempleteBaseEdit_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u85aa\u8d44\u6838\u7b97\u7ec4\u90e8\u5206\u6216\u5168\u90e8\u5df2\u5b58\u5728\u9ed8\u8ba4\u6a21\u677f\uff0c\u786e\u8ba4\u5168\u90e8\u66ff\u6362\u6210\u5f53\u524d\u6a21\u677f\uff1f", (String)"CalResultTempleteBaseEdit_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            String changeDescStr = this.getModel().getChangeDesc();
            this.getView().showConfirm(msg, changeDescStr, options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String optKey = args.getOperateKey();
        if (SWCStringUtils.equals((String)optKey, (String)"resultcontent_additem")) {
            this.openResultContentAddItem();
        } else if (SWCStringUtils.equals((String)optKey, (String)"calperson_additem")) {
            this.openCalPersonAddItem();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String optKey = e.getProperty().getName();
        if (SWCStringUtils.equals((String)optKey, (String)"org")) {
            this.changeOrg(e);
        } else if (SWCStringUtils.equals((String)optKey, (String)"ishighlight")) {
            this.setHighLightColor();
        } else if (SWCStringUtils.equals((String)optKey, (String)"payrollgroups")) {
            this.changePayRollGroup();
        }
    }

    private void changeOrg(PropertyChangedArgs e) {
        ChangeData[] changeDatas = e.getChangeSet();
        ChangeData changeData = changeDatas[0];
        DynamicObject oldObj = (DynamicObject)changeData.getOldValue();
        DynamicObject newObj = (DynamicObject)changeData.getNewValue();
        if (!SWCObjectUtils.isEmpty((Object)oldObj) && !SWCObjectUtils.isEmpty((Object)newObj)) {
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            Long oldId = oldObj.getLong("id");
            Long newId = newObj.getLong("id");
            pageCache.put("orgOldId", (Object)oldId);
            pageCache.put("orgNewId", (Object)newId);
            Boolean isShowFrame = (Boolean)pageCache.get("isNeedShowFrame", Boolean.class);
            if (isShowFrame == null) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6a21\u677f\u57fa\u7840\u8d44\u6599\u5c06\u6539\u53d8\uff0c\u9700\u8981\u91cd\u65b0\u8fdb\u884c\u5185\u5bb9\u8bbe\u7f6e\u3002", (String)"CalResultTempleteBaseEdit_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("orgchangeclosed"));
            } else if (!isShowFrame.booleanValue()) {
                pageCache.remove("isNeedShowFrame");
                return;
            }
        } else if (!SWCObjectUtils.isEmpty((Object)oldObj) && SWCObjectUtils.isEmpty((Object)newObj)) {
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            Long oldId = oldObj.getLong("id");
            pageCache.put("orgOldId", (Object)oldId);
            pageCache.put("orgNewId", null);
            Boolean isShowFrame = (Boolean)pageCache.get("isNeedShowFrame", Boolean.class);
            if (isShowFrame == null) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6a21\u677f\u57fa\u7840\u8d44\u6599\u5c06\u6539\u53d8\uff0c\u9700\u8981\u91cd\u65b0\u8fdb\u884c\u5185\u5bb9\u8bbe\u7f6e\u3002", (String)"CalResultTempleteBaseEdit_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("orgchangeclosed"));
            } else if (!isShowFrame.booleanValue()) {
                pageCache.remove("isNeedShowFrame");
                return;
            }
        }
    }

    private void changePayRollGroup() {
        this.setIsDefaultByPayrolltask();
        this.getModel().setValue("isdefault", null);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if (SWCStringUtils.equals((String)callBackId, (String)"orgchangeclosed")) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getModel().setValue("payrollgroups", null);
                this.getModel().deleteEntryData("resultlist");
            } else if (MessageBoxResult.Cancel.equals((Object)result)) {
                this.orgCancelCallBack();
            }
        } else if (SWCStringUtils.equals((String)callBackId, (String)"calresultdefaultsave")) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("cal_result_after_confirm_save", Boolean.TRUE.toString());
                this.getView().invokeOperation("save", option);
            }
        } else if (SWCStringUtils.equals((String)callBackId, (String)"calresultdefaultsubmit") && MessageBoxResult.Yes.equals((Object)result)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("cal_result_after_confirm_submit", Boolean.TRUE.toString());
            this.getView().invokeOperation("submit", option);
        }
    }

    private void orgCancelCallBack() {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Long oldId = (Long)pageCache.get("orgOldId", Long.class);
        Long newId = (Long)pageCache.get("orgNewId", Long.class);
        if (newId == null) {
            pageCache.remove("isNeedShowFrame");
            this.getModel().setValue("org", (Object)oldId);
        } else {
            pageCache.put("isNeedShowFrame", (Object)Boolean.FALSE);
            this.getModel().setValue("org", (Object)oldId);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        switch (actionId = evt.getActionId()) {
            case "additemclose": {
                this.addItemCloseEvent(evt);
                break;
            }
            case "addcalpersonclose": {
                this.addCalPersonCloseEvent(evt);
                break;
            }
        }
    }

    private void addCalPersonCloseEvent(ClosedCallBackEvent evt) {
        DynamicObjectCollection itemDatas = (DynamicObjectCollection)evt.getReturnData();
        if (itemDatas == null || itemDatas.size() == 0) {
            return;
        }
        DynamicObjectCollection calPersonDatas = this.getModel().getEntryEntity("payrolllist");
        if (calPersonDatas == null || calPersonDatas.size() == 0) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("fieldsource", new Object[0]);
            vs.addField("fieldname", new Object[0]);
            vs.addField("fieldtype", new Object[0]);
            vs.addField("field", new Object[0]);
            vs.addField("fieldnumber", new Object[0]);
            vs.addField("perruleobj", new Object[0]);
            for (DynamicObject dataObj : itemDatas) {
                vs.addRow(new Object[]{dataObj.get("fieldsource"), dataObj.get("itemname"), dataObj.get("itemcategory"), dataObj.get("field"), dataObj.get("number"), dataObj.get("perruleobj")});
            }
            model.batchCreateNewEntryRow("payrolllist", vs);
            model.endInit();
            this.getView().updateView("payrolllist");
            return;
        }
        HashMap<String, String> aliasMap = new HashMap<String, String>(16);
        for (DynamicObject calPersonObj : calPersonDatas) {
            aliasMap.put(calPersonObj.getString("fieldnumber"), calPersonObj.getString("alias"));
        }
        this.getModel().deleteEntryData("payrolllist");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("fieldsource", new Object[0]);
        vs.addField("fieldname", new Object[0]);
        vs.addField("fieldtype", new Object[0]);
        vs.addField("field", new Object[0]);
        vs.addField("fieldnumber", new Object[0]);
        vs.addField("perruleobj", new Object[0]);
        vs.addField("alias", new Object[0]);
        for (DynamicObject dataObj : itemDatas) {
            String number = (String)dataObj.get("number");
            String alias = (String)aliasMap.get(number);
            if (SWCStringUtils.isNotEmpty((String)alias)) {
                vs.addRow(new Object[]{dataObj.get("fieldsource"), dataObj.get("itemname"), dataObj.get("itemcategory"), dataObj.get("field"), dataObj.get("number"), dataObj.get("perruleobj"), alias});
                continue;
            }
            vs.addRow(new Object[]{dataObj.get("fieldsource"), dataObj.get("itemname"), dataObj.get("itemcategory"), dataObj.get("field"), dataObj.get("number"), dataObj.get("perruleobj"), null});
        }
        model.batchCreateNewEntryRow("payrolllist", vs);
        model.endInit();
        this.getView().updateView("payrolllist");
    }

    public void addItemCloseEvent(ClosedCallBackEvent evt) {
        DynamicObjectCollection itemDatas = (DynamicObjectCollection)evt.getReturnData();
        if (itemDatas == null || itemDatas.size() == 0) {
            return;
        }
        DynamicObjectCollection resultContentDatas = this.getModel().getEntryEntity("resultlist");
        if (resultContentDatas == null || resultContentDatas.size() == 0) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("itemnumber", new Object[0]);
            vs.addField("itemunicodeid", new Object[0]);
            vs.addField("itemcategory", new Object[0]);
            vs.addField("itemname", new Object[0]);
            for (DynamicObject dataObj : itemDatas) {
                vs.addRow(new Object[]{dataObj.get("itemnumber"), dataObj.get("itemunicodeid"), dataObj.get("itemcategory"), dataObj.get("itemname")});
            }
            model.batchCreateNewEntryRow("resultlist", vs);
            model.endInit();
            this.getView().updateView("resultlist");
            return;
        }
        HashMap<String, String> aliasMap = new HashMap<String, String>(16);
        for (DynamicObject dataObj : resultContentDatas) {
            String resultUnicode = dataObj.getString("itemunicodeid");
            aliasMap.put(resultUnicode, dataObj.getString("resultalias"));
        }
        this.getModel().deleteEntryData("resultlist");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("itemnumber", new Object[0]);
        vs.addField("itemunicodeid", new Object[0]);
        vs.addField("itemcategory", new Object[0]);
        vs.addField("itemname", new Object[0]);
        vs.addField("resultalias", new Object[0]);
        for (DynamicObject dataObj : itemDatas) {
            String uniqueCode = (String)dataObj.get("itemunicodeid");
            String alias = (String)aliasMap.get(uniqueCode);
            if (SWCStringUtils.isNotEmpty((String)alias)) {
                vs.addRow(new Object[]{dataObj.get("itemnumber"), uniqueCode, dataObj.get("itemcategory"), dataObj.get("itemname"), alias});
                continue;
            }
            vs.addRow(new Object[]{dataObj.get("itemnumber"), uniqueCode, dataObj.get("itemcategory"), dataObj.get("itemname"), null});
        }
        model.batchCreateNewEntryRow("resultlist", vs);
        model.endInit();
        this.getView().updateView("resultlist");
    }

    private void openResultContentAddItem() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_calitemselect");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setCaption(ResManager.loadKDString((String)"\u6dfb\u52a0\u9879\u76ee", (String)"CalResultTempleteBaseEdit_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "additemclose"));
        this.getView().showForm(showParameter);
    }

    private void openCalPersonAddItem() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_calpersonselect");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setCaption(ResManager.loadKDString((String)"\u6dfb\u52a0\u4eba\u5458\u53ca\u6863\u6848\u4fe1\u606f", (String)"CalResultTempleteBaseEdit_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addcalpersonclose"));
        this.getView().showForm(showParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        if (SWCStringUtils.equals((String)fieldKey, (String)"payrollgroups")) {
            event.addCustomQFilter(new QFilter("org", "=", (Object)this.getModel().getDataEntity().getLong("org.id")));
        }
    }

    private void checkPayRollGroupSelect(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection payrollgroupObj = (DynamicObjectCollection)this.getModel().getValue("payrollgroups");
        if (payrollgroupObj == null || payrollgroupObj.size() == 0) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u85aa\u8d44\u6838\u7b97\u7ec4\u3002", (String)"CalResultTempleteBaseEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            args.setCancel(true);
        }
    }

    private void setHighLightColor() {
        Boolean isHighLightColor = (Boolean)this.getModel().getValue("ishighlight");
        this.getView().setVisible(isHighLightColor, new String[]{"highlightcolor"});
        ((FieldEdit)this.getControl("highlightcolor")).setMustInput(isHighLightColor.booleanValue());
        if (!isHighLightColor.booleanValue()) {
            this.getModel().setValue("highlightcolor", null);
        }
        this.getView().updateView("highlightcolor");
    }
}

