/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calresulttpl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.swc.hsas.business.calresulttpl.helper.CalResultTplAddItemServiceHelper;
import kd.swc.hsas.business.formula.helper.FormulaDataServiceHelper;
import kd.swc.hsas.business.formula.helper.FormulaItemOrFuncTreeHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import org.apache.commons.collections4.CollectionUtils;

public class CalResultTplAddItemPlugin
extends SWCDataBaseEdit {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel", "btnsave"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        long orgId = ((DynamicObject)this.getView().getParentView().getModel().getValue("org")).getLong("id");
        IFormView parentView = this.getView().getParentView();
        boolean needAccItem = parentView != null ? !SWCStringUtils.equals((String)parentView.getEntityId(), (String)"hsas_migrationtpl") : true;
        this.loadMainPageData();
        CalResultTplAddItemServiceHelper helper = new CalResultTplAddItemServiceHelper();
        Map dataMap = helper.getAllItemData(orgId, needAccItem);
        this.initItemTree(dataMap);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String optKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (optKey = formOperate.getOperateKey()) {
            case "do_moveto": {
                this.openMoveToPage(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        switch (args.getOperateKey()) {
            case "do_addcolumn": {
                this.addColumn();
                break;
            }
            case "do_removecolumn": {
                this.removeColumn();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String clickedKey;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (clickedKey = source.getKey()) {
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btnsave": {
                this.btnOkClickEvent();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        switch (actionId = evt.getActionId()) {
            case "movetoclosed": {
                this.moveToClosedEvent(evt);
                break;
            }
        }
    }

    private void checkSelectedTreeNode(TreeView treeView, List<TreeNode> nodeList) {
        DynamicObjectCollection selectDatas = this.getView().getModel().getEntryEntity("itemselectentry");
        Set uniqueCodeSet = selectDatas.stream().map(selectData -> selectData.getString("itemunicodeid")).collect(Collectors.toSet());
        List checkNodeList = FormulaItemOrFuncTreeHelper.getCheckTreeNodeList(nodeList, uniqueCodeSet);
        if (CollectionUtils.isNotEmpty((Collection)checkNodeList)) {
            treeView.checkNodes(checkNodeList);
        }
    }

    public void loadMainPageData() {
        if (SWCStringUtils.equals((String)this.getView().getParentView().getEntityId(), (String)"hsas_migrationtpl")) {
            this.loadMainPageDataFromMigrationTempate();
            return;
        }
        IFormView parentView = this.getView().getParentView();
        DynamicObjectCollection resultContentDatas = parentView.getModel().getEntryEntity("resultlist");
        if (resultContentDatas == null || resultContentDatas.size() == 0) {
            return;
        }
        IDataModel model = this.getModel();
        for (DynamicObject dataObj : resultContentDatas) {
            int detailIndex = model.createNewEntryRow("itemselectentry");
            String itemCategory = (String)dataObj.get("itemcategory");
            if (SWCStringUtils.equals((String)itemCategory, (String)"SI")) {
                itemCategory = "SL";
            } else if (SWCStringUtils.equals((String)itemCategory, (String)"BI")) {
                itemCategory = "BC";
            }
            String itemNum = dataObj.getString("itemnumber");
            model.setValue("itemnumber", (Object)itemNum, detailIndex);
            model.setValue("itemcategory", (Object)itemCategory, detailIndex);
            String itemName = (String)dataObj.get("itemname");
            model.setValue("itemname", (Object)itemName, detailIndex);
            String uniqueCode = (String)dataObj.get("itemunicodeid");
            model.setValue("itemunicodeid", (Object)uniqueCode, detailIndex);
            model.setValue("treenodeid", (Object)uniqueCode, detailIndex);
        }
        this.getView().updateView("itemselectentry");
    }

    private void loadMainPageDataFromMigrationTempate() {
        DynamicObjectCollection matchRelationDatas = this.getView().getParentView().getModel().getEntryEntity("hsas_migrationtplent");
        if (CollectionUtils.isEmpty((Collection)matchRelationDatas)) {
            return;
        }
        IDataModel model = this.getModel();
        for (DynamicObject matchRelationData : matchRelationDatas) {
            String itemCategory;
            String itemType = matchRelationData.getString("itemtype");
            if (SWCStringUtils.equals((String)"1", (String)itemType)) {
                itemCategory = "SL";
            } else if (SWCStringUtils.equals((String)"2", (String)itemType)) {
                itemCategory = "SP";
            } else if (SWCStringUtils.equals((String)"3", (String)itemType)) {
                itemCategory = "BS";
            } else {
                if (!SWCStringUtils.equals((String)"4", (String)itemType)) continue;
                itemCategory = "FT";
            }
            int detailIndex = model.createNewEntryRow("itemselectentry");
            model.setValue("itemnumber", (Object)matchRelationData.getString("itemnumber"), detailIndex);
            model.setValue("itemcategory", (Object)itemCategory, detailIndex);
            model.setValue("itemname", (Object)matchRelationData.getString("itemname"), detailIndex);
            model.setValue("itemunicodeid", (Object)matchRelationData.getString("uniquecode"), detailIndex);
            model.setValue("treenodeid", (Object)matchRelationData.getString("uniquecode"), detailIndex);
        }
        this.getView().updateView("itemselectentry");
    }

    public void btnOkClickEvent() {
        DynamicObjectCollection entryDatas = this.getModel().getEntryEntity("itemselectentry");
        if (entryDatas == null || entryDatas.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u9879\u76ee\u3002", (String)"CalResultTplAddItemPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent((Object)entryDatas);
        this.getView().close();
    }

    public void moveToClosedEvent(ClosedCallBackEvent evt) {
        Map returnData = (Map)evt.getReturnData();
        if (SWCObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        String clickStatus = (String)returnData.get("clickStatus");
        if (!SWCStringUtils.equals((String)"ok", (String)clickStatus)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("itemselectentry");
        int[] rows = entryGrid.getSelectRows();
        int oldRow = rows[0];
        int newRow = (Integer)returnData.get("rownumber");
        IDataModel model = this.getModel();
        DynamicObjectCollection datas = model.getEntryEntity("itemselectentry");
        int size = datas.size();
        if (--newRow > size - 1) {
            newRow = size - 1;
        }
        if (oldRow == newRow) {
            return;
        }
        DynamicObject oldObj = (DynamicObject)datas.get(oldRow);
        model.deleteEntryRow("itemselectentry", oldRow);
        model.createNewEntryRow("itemselectentry", newRow, oldObj);
        EntryGrid grid = (EntryGrid)this.getView().getControl("itemselectentry");
        grid.selectRows(newRow, true);
    }

    private void initItemTree(Map<String, Map<String, Map<String, Object>>> dataMap) {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        List list = FormulaItemOrFuncTreeHelper.loadFTTreeNodeList(null, (boolean)false, dataMap);
        list.addAll(FormulaItemOrFuncTreeHelper.loadSLItemChildNode(null, (boolean)false, dataMap));
        list.addAll(FormulaItemOrFuncTreeHelper.loadBSTreeNodeList(null, (boolean)false, dataMap));
        list.addAll(FormulaItemOrFuncTreeHelper.loadSPTreeNodeList(null, (boolean)false, dataMap));
        list.addAll(this.loadACTreeNodeList(null, false, dataMap));
        treeView.deleteAllNodes();
        treeView.addNodes(list);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Map treeNodeMap = list.stream().collect(Collectors.toMap(TreeNode::getId, Function.identity(), (entity1, entity2) -> entity2));
        pageCache.put("tree", (Object)SerializationUtils.serializeToBase64(treeNodeMap));
        pageCache.put("allItemData", dataMap);
        Map<String, Map<String, String>> simpleDataMap = this.rebuildData(dataMap);
        pageCache.put("simpleAllItemData", simpleDataMap);
        this.checkSelectedTreeNode(treeView, list);
    }

    private Map<String, Map<String, String>> rebuildData(Map<String, Map<String, Map<String, Object>>> dataMap) {
        if (dataMap == null || dataMap.size() == 0) {
            return null;
        }
        HashMap<String, Map<String, String>> retMap = new HashMap<String, Map<String, String>>(16);
        for (Map.Entry<String, Map<String, Map<String, Object>>> entry : dataMap.entrySet()) {
            String key = entry.getKey();
            Map<String, Map<String, Object>> value = entry.getValue();
            HashMap<String, String> innerMap = new HashMap<String, String>(16);
            for (Map.Entry<String, Map<String, Object>> innerEntry : value.entrySet()) {
                String innerKey = innerEntry.getKey();
                Map<String, Object> innerValue = innerEntry.getValue();
                String uniqueCode = (String)innerValue.get("uniquecode");
                innerMap.put(innerKey, uniqueCode);
            }
            retMap.put(key, innerMap);
        }
        return retMap;
    }

    public List<TreeNode> loadACTreeNodeList(String name, boolean isExpend, Map<String, Map<String, Map<String, Object>>> dataMap) {
        List result = null;
        result = name == null ? FormulaDataServiceHelper.mapToList(dataMap.get("ackey")) : FormulaDataServiceHelper.findItemByName((String)name, (String)"ackey", dataMap);
        if (result == null || result.size() == 0) {
            return new ArrayList<TreeNode>(10);
        }
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(result.size());
        for (Map acc : result) {
            treeNodeList.add(new TreeNode("_@_AC", String.valueOf(acc.get("uniquecode")), (String)acc.get("name")));
        }
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(10);
        if (treeNodeList.size() > 0) {
            TreeNode node = new TreeNode("", "_@_AC", ResManager.loadKDString((String)"\u7d2f\u52a0\u5668-AC", (String)"CalResultTplAddItemPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            node.setChildren(treeNodeList);
            node.setExpend(isExpend);
            node.setIsOpened(isExpend);
            nodeList.add(node);
        }
        return nodeList;
    }

    public void addColumn() {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        List selectNodeIds = treeView.getTreeState().getCheckedNodeIds();
        if (CollectionUtils.isEmpty((Collection)selectNodeIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u6570\u636e\u3002", (String)"CalResultTplAddItemPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String cacheTreeNodeStr = (String)pageCache.get("tree", String.class);
        Map nodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)cacheTreeNodeStr);
        Map dataMap = (Map)pageCache.get("allItemData", Map.class);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("itemcategory", new Object[0]);
        vs.addField("itemnumber", new Object[0]);
        vs.addField("itemname", new Object[0]);
        vs.addField("itemunicodeid", new Object[0]);
        vs.addField("treenodeid", new Object[0]);
        ArrayList<TreeNode> checkNodeList = new ArrayList<TreeNode>(selectNodeIds.size());
        for (String selectNodeId : selectNodeIds) {
            String treeNodeId;
            List childTrees;
            String parentId;
            TreeNode treeNode = this.getTreeNodeByTreeId(nodeMap, selectNodeId);
            if (treeNode == null || SWCStringUtils.isEmpty((String)treeNode.getId()) || SWCStringUtils.isEmpty((String)(parentId = treeNode.getParentid())) || (childTrees = treeNode.getChildren()) != null && childTrees.size() > 0 || this.isExistTreeNode(selectNodeId) || (treeNodeId = treeNode.getId()).equals("0_@_BS") || treeNodeId.equals("1_@_BS")) continue;
            String itemCategory = treeNodeId.substring(0, treeNodeId.indexOf(95));
            if (SWCStringUtils.equals((String)itemCategory, (String)"SI")) {
                itemCategory = "SL";
            } else if (SWCStringUtils.equals((String)itemCategory, (String)"BI")) {
                itemCategory = "BC";
            }
            String treeNodeName = treeNode.getText();
            String itemNum = this.getItemNumber(dataMap, itemCategory, treeNodeName, treeNode);
            String itemUnicodeId = this.getItemUnicodeId(treeNodeId, treeNodeName);
            if (SWCStringUtils.equals((String)itemCategory, (String)"BS") && (parentId.equals("0_@_BS") || parentId.equals("1_@_BS"))) {
                itemCategory = "ATTBS";
            }
            vs.addRow(new Object[]{itemCategory, itemNum, treeNodeName, itemUnicodeId, treeNodeId});
            checkNodeList.add(treeNode);
        }
        model.batchCreateNewEntryRow("itemselectentry", vs);
        model.endInit();
        this.getView().updateView("itemselectentry");
        if (CollectionUtils.isNotEmpty(checkNodeList)) {
            treeView.checkNodes(checkNodeList);
        }
    }

    private void removeCheckNode(int[] rows) {
        DynamicObjectCollection selectDatas = this.getView().getModel().getEntryEntity("itemselectentry");
        ArrayList<String> removeCheckNodeList = new ArrayList<String>(selectDatas.size());
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String cacheTreeNodeStr = (String)pageCache.get("tree", String.class);
        Map nodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)cacheTreeNodeStr);
        for (int index : rows) {
            DynamicObject selectData = (DynamicObject)selectDatas.get(index);
            TreeNode treeNode = this.getTreeNodeByTreeId(nodeMap, selectData.getString("itemunicodeid"));
            if (treeNode == null) continue;
            removeCheckNodeList.add(treeNode.getId());
        }
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.uncheckNodes(removeCheckNodeList);
    }

    private String getItemNumber(Map<String, Map<String, Map<String, Object>>> dataMap, String itemCategory, String treeNodeName, TreeNode treeNode) {
        Map<String, Map<String, Object>> itemMap = null;
        if (SWCStringUtils.equals((String)"SL", (String)itemCategory)) {
            itemMap = dataMap.get("salaryitemkey");
        } else if (SWCStringUtils.equals((String)"BS", (String)itemCategory)) {
            String parentId = treeNode.getParentid();
            itemMap = parentId.equals("0_@_BS") || parentId.equals("1_@_BS") ? dataMap.get("bsattitemkey") : dataMap.get("bsitemkey");
        } else if (SWCStringUtils.equals((String)"SP", (String)itemCategory)) {
            itemMap = dataMap.get("spitemkey");
        } else if (SWCStringUtils.equals((String)"AC", (String)itemCategory)) {
            itemMap = dataMap.get("ackey");
        } else if (SWCStringUtils.equals((String)"FT", (String)itemCategory)) {
            itemMap = dataMap.get("ftitemkey");
        }
        if (itemMap == null) {
            return "";
        }
        Map<String, Object> nameMap = itemMap.get(treeNodeName);
        if (nameMap == null || nameMap.size() == 0) {
            return "";
        }
        String number = (String)nameMap.get("number");
        return SWCStringUtils.isEmpty((String)number) ? "" : number;
    }

    public boolean isExistTreeNode(String selectTreeNodeId) {
        DynamicObjectCollection itemDatas = this.getModel().getEntryEntity("itemselectentry");
        for (DynamicObject itemData : itemDatas) {
            String treeNodeId = itemData.getString("treenodeid");
            if (!SWCStringUtils.equals((String)treeNodeId, (String)selectTreeNodeId)) continue;
            return true;
        }
        return false;
    }

    public String getItemUnicodeId(String treeNodeId, String treeNodeName) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Map dataMap = (Map)pageCache.get("simpleAllItemData", Map.class);
        if (SWCObjectUtils.isEmpty((Object)dataMap)) {
            return "";
        }
        for (Map.Entry entry : dataMap.entrySet()) {
            Map itemData = (Map)entry.getValue();
            String uniqueCode = (String)itemData.get(treeNodeName);
            if (!SWCStringUtils.equals((String)uniqueCode, (String)treeNodeId)) continue;
            return uniqueCode;
        }
        return "";
    }

    public TreeNode getTreeNodeByTreeId(Map<String, TreeNode> nodeMap, String treeId) {
        TreeNode treeNode = new TreeNode();
        for (Map.Entry<String, TreeNode> entry : nodeMap.entrySet()) {
            TreeNode value = entry.getValue();
            this.getSubTreeNode(treeNode, treeId, value);
            if (!SWCStringUtils.isNotEmpty((String)treeNode.getId())) continue;
            return treeNode;
        }
        return treeNode;
    }

    public void getSubTreeNode(TreeNode treeNode, String treeId, TreeNode subTreeNode) {
        String subTreeId = subTreeNode.getId();
        if (SWCStringUtils.equals((String)treeId, (String)subTreeId)) {
            this.copyTreeNode(treeNode, subTreeNode);
        } else {
            List childTrees = subTreeNode.getChildren();
            if (childTrees != null && childTrees.size() > 0) {
                for (TreeNode childTree : childTrees) {
                    this.getSubTreeNode(treeNode, treeId, childTree);
                }
            }
        }
    }

    public void copyTreeNode(TreeNode newTreeNode, TreeNode oldTreeNode) {
        newTreeNode.setId(oldTreeNode.getId());
        newTreeNode.setText(oldTreeNode.getText());
        newTreeNode.setParentid(oldTreeNode.getParentid());
        newTreeNode.setData(oldTreeNode.getData());
        newTreeNode.setChildren(oldTreeNode.getChildren());
        newTreeNode.setExpend(oldTreeNode.isExpend());
        newTreeNode.setIsOpened(oldTreeNode.getIsOpened());
        newTreeNode.setType(oldTreeNode.getType());
        newTreeNode.setColor(oldTreeNode.getColor());
        newTreeNode.setLongNumber(oldTreeNode.getLongNumber());
        newTreeNode.setLeaf(oldTreeNode.isLeaf());
        newTreeNode.setCheckable(oldTreeNode.isCheckable());
        newTreeNode.setIcon(oldTreeNode.getIcon());
    }

    public void removeColumn() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("itemselectentry");
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CalResultTplAddItemPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        this.removeCheckNode(rows);
        this.getModel().deleteEntryRows("itemselectentry", rows);
    }

    public void openMoveToPage(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("itemselectentry");
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CalResultTplAddItemPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (rows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"CalResultTplAddItemPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_calitemmoveto");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setCaption(ResManager.loadKDString((String)"\u79fb\u52a8\u5230", (String)"CalResultTplAddItemPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "movetoclosed"));
        this.getView().showForm(showParameter);
    }
}

