/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calview;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalSchemeViewColorPlugIn
extends AbstractFormPlugin {
    private static final String PANEL_KEY = "flexpanelap";
    private static final String RADIOGOUP_KEY = "radiogroupfield";
    private static final String BTN_OK = "btnok";
    private static final Log logger = LogFactory.getLog(CalSchemeViewColorPlugIn.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        if (formShowParameter == null || formShowParameter.getParentPageId() == null) {
            e.setCancel(true);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        DynamicObject[] results = this.getOrgTypeDys();
        FlexPanelAp panel = this.createPanel(results);
        HashMap<String, Object> mapHead = new HashMap<String, Object>();
        mapHead.put("id", PANEL_KEY);
        List items = (List)panel.createControl().get("items");
        for (Map item : items) {
            Map subItem = (Map)item.get("item");
            String type = (String)subItem.get("type");
            if (!SWCStringUtils.equals((String)type, (String)"radio")) continue;
            subItem.put("group", RADIOGOUP_KEY);
        }
        mapHead.put("items", items);
        e.getItems().add(mapHead);
    }

    private FlexPanelAp createPanel(DynamicObject[] orgTypeDys) {
        FlexPanelAp panel = new FlexPanelAp();
        panel.setId(PANEL_KEY);
        panel.setKey(PANEL_KEY);
        for (DynamicObject dy : orgTypeDys) {
            FieldAp radioField = this.getRadioField(dy.getString("id"), dy.getLocaleString("name").getLocaleValue(), dy.getString("number"));
            panel.getItems().add(this.modifyStyle(radioField, orgTypeDys.length, dy.getString("number")));
        }
        return panel;
    }

    private FieldAp modifyStyle(FieldAp radioField, int length, String number) {
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("100px");
        margin.setTop(100 / length - 15 + "px");
        margin.setBottom(100 / length - 15 + "px");
        radioField.setWidth(new LocaleString("220px"));
        style.setMargin(margin);
        radioField.setFieldForeColor(number);
        radioField.setStyle(style);
        return radioField;
    }

    private FieldAp getRadioField(String id, String name, String number) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(id);
        fieldAp.setKey(id);
        StringBuilder stringBuffer = new StringBuilder("\u25a0").append("           ").append(name).append("           ").append(number);
        String appendName = stringBuffer.toString();
        fieldAp.setName(new LocaleString(appendName));
        fieldAp.setFieldFontSize(12);
        RadioField rf = new RadioField();
        rf.setId(id);
        rf.setKey(id);
        rf.setName(new LocaleString(name));
        rf.setItems(id);
        fieldAp.setField((Field)rf);
        return fieldAp;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        DynamicObject[] orgTypes;
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            logger.error(exp.getMessage());
        }
        for (DynamicObject dy : orgTypes = this.getOrgTypeDys()) {
            String txtHidden = dy.getString("name");
            TextProp textProp = new TextProp();
            textProp.setName(txtHidden);
            if (newMainType == null) continue;
            newMainType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        }
        e.setNewEntityType(newMainType);
    }

    private DynamicObject[] getOrgTypeDys() {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        QFilter filter2 = new QFilter("status", "=", (Object)"C");
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_calcolor");
        return serviceHelper.query(new QFilter[]{filter, filter2});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String clkKey = control.getKey();
        HashMap<String, String> returnData = new HashMap<String, String>();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String colorId = dataEntity.getString(0);
        if (BTN_OK.equals(clkKey)) {
            returnData.put("clickStatus", "ok");
            returnData.put("colorId", colorId);
            this.getView().setReturnData(returnData);
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        Object returnData = this.getView().getReturnData();
        if (returnData != null) {
            this.getView().returnDataToParent(returnData);
        }
    }
}

