/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.datagrade;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.swc.hsas.business.datagrade.helper.DataGradeHelper;
import kd.swc.hsas.common.enums.DataGradeMatchMethodEnum;
import kd.swc.hsas.formplugin.web.basedata.HisBaseDataSummaryEdit;
import kd.swc.hsbp.business.area.AreaHelper;
import kd.swc.hsbp.business.datagrade.enums.DataGradeValueTypeEnum;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.util.StringCheckUtils;

public class DataGradeBaseEdit
extends HisBaseDataSummaryEdit
implements BeforeF7SelectListener {
    private static final String[] CHANGE_PAGE_HIDE_BTNS = new String[]{"conditionaddentry", "conditiondeleteentry", "conditionmoveup", "conditionmovedown", "resultaddentry", "resultdeleteentry", "resultmoveup", "resultmovedown"};
    private static final String[] CHANGE_PAGE_ENABLE_FIELDS = new String[]{"number", "areatype", "country"};
    private static final String[] CHANGE_PAGE_LOCK_BTNS = new String[]{"name", "matchmethod", "beyondpolicy", "dataround", "failpolice"};
    private static final String CONDITION_ACCURACY_CALLBACK = "conditionaccuracycallback";
    private static final String CONDITION_LENGTH_CALLBACK = "conditionlengthcallback";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"adddata"});
        BasedataEdit conditionValType = (BasedataEdit)this.getView().getControl("conditionvaltype");
        conditionValType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"country"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"nullpage"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"contentpage"});
    }

    private void setChangePage(DynamicObjectCollection conditionColl, DynamicObjectCollection resultColl) {
        int i;
        boolean isHisPage = BaseDataHisHelper.isHisPage((IFormView)this.getView());
        if (!isHisPage) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, CHANGE_PAGE_HIDE_BTNS);
        int size = conditionColl.size();
        if (size > 0) {
            for (i = 0; i < size; ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"conditionitemname", "conditionvaltype", "conditionaccuracy", "conditionlength", "conditioncurrency"});
            }
        }
        if ((size = resultColl.size()) > 0) {
            for (i = 0; i < size; ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"resultitemname", "resultvaltype", "resultaccuracy", "resultlength", "resultcurrency", "resultdefaultval"});
            }
        }
        this.getView().setEnable(Boolean.FALSE, CHANGE_PAGE_LOCK_BTNS);
    }

    public void dynamicMatchByMatchType() {
        String matchType = (String)this.getModel().getValue("matchmethod");
        if (SWCStringUtils.equals((String)matchType, (String)"1") || SWCStringUtils.equals((String)matchType, (String)"5")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"beyondpolicy"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"dataround"});
        } else if (SWCStringUtils.equals((String)matchType, (String)"2")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"beyondpolicy"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"dataround"});
        } else if (SWCStringUtils.equals((String)matchType, (String)"3") || SWCStringUtils.equals((String)matchType, (String)"4")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"beyondpolicy"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"dataround"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection conditionDatas = this.getModel().getEntryEntity("conditionentryidentify");
        DynamicObjectCollection resultDatas = this.getModel().getEntryEntity("resultentryidentify");
        DynamicObjectCollection gradeDatas = this.getModel().getEntryEntity("dataentry");
        this.dynamicMatchByMatchType();
        this.loadGradeTable(conditionDatas, resultDatas, gradeDatas);
        this.changeMatchMethodSelect(conditionDatas, resultDatas);
        this.setCountryShow();
        this.setConditionAndResultFieldInfo(conditionDatas, resultDatas);
        this.setGradeDataToCache(gradeDatas);
        this.setChangePage(conditionDatas, resultDatas);
        this.setDataRoundMustInput();
        this.changePageSetFieldEnable();
        this.getModel().setDataChanged(false);
    }

    private void setDataRoundMustInput() {
        String matchMethod = (String)this.getModel().getValue("matchmethod");
        if (SWCStringUtils.equals((String)matchMethod, (String)"2")) {
            this.setDataRoundMustInput(true);
        } else {
            this.setDataRoundMustInput(false);
        }
    }

    private void setGradeDataToCache(DynamicObjectCollection gradeDatas) {
        if (gradeDatas == null || gradeDatas.size() == 0) {
            return;
        }
        ArrayList dataList = new ArrayList(10);
        for (DynamicObject dataObj : gradeDatas) {
            int rownum = dataObj.getInt("rownum");
            String fieldid = dataObj.getString("fieldid");
            String fieldName = dataObj.getString("fieldname");
            Object value = dataObj.get("value");
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            dataMap.put("rownum", rownum);
            dataMap.put("fieldid", fieldid);
            dataMap.put("fieldName", fieldName);
            dataMap.put("value", value);
            dataList.add(dataMap);
        }
        ISWCAppCache appCache = SWCAppCache.get((String)"hsas_datagrade_appcache");
        String pageId = this.getView().getPageId();
        appCache.put(pageId + "_subPageGradeCache", dataList);
    }

    private void setCountryShow() {
        String areaType = (String)this.getModel().getValue("areatype");
        if (SWCStringUtils.isEmpty((String)areaType)) {
            return;
        }
        if (SWCStringUtils.equals((String)areaType, (String)"2")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"country"});
            AreaHelper.setAreaTypeAndcountryStatus((IDataModel)this.getModel(), (IFormView)this.getView());
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"country"});
        }
    }

    private void loadGradeTable(DynamicObjectCollection conditionDatas, DynamicObjectCollection resultDatas, DynamicObjectCollection gradeDatas) {
        if (CollectionUtil.isNotEmpty((Collection)conditionDatas)) {
            this.setConditionCache(conditionDatas);
        }
        if (CollectionUtil.isNotEmpty((Collection)resultDatas)) {
            this.setResultCache(resultDatas);
        }
        if (CollectionUtil.isNotEmpty((Collection)conditionDatas) && CollectionUtil.isNotEmpty((Collection)resultDatas)) {
            int i;
            for (i = 0; i < conditionDatas.size(); ++i) {
                DynamicObject conditionObj = (DynamicObject)conditionDatas.get(i);
                DynamicObject valTypeObj = conditionObj.getDynamicObject("conditionvaltype");
                String number = valTypeObj.getString("number");
                if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"conditionlength"});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"conditioncurrency"});
                    continue;
                }
                if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.TEXT.getCode())) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"conditionaccuracy"});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"conditioncurrency"});
                    continue;
                }
                if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"conditionlength"});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"conditionaccuracy"});
                    continue;
                }
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"conditionlength"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"conditionaccuracy"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"conditioncurrency"});
            }
            for (i = 0; i < resultDatas.size(); ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"resultvaltype"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"resultaccuracy"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"resultlength"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"resultcurrency"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"resultdefaultval"});
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)gradeDatas)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"nullpage"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"contentpage"});
            this.openDataGradeSubTable();
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            String pageId = this.getView().getPageId();
            pageCache.put(pageId + "_isinit", (Object)Boolean.TRUE);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String optKey;
        DynamicObjectCollection conditionDatas = this.getModel().getEntryEntity("conditionentryidentify");
        DynamicObjectCollection resultDatas = this.getModel().getEntryEntity("resultentryidentify");
        switch (optKey = e.getProperty().getName()) {
            case "areatype": {
                this.countryChangeEvent(e);
                break;
            }
            case "matchmethod": {
                this.matchMethodChangeEvent(e, conditionDatas);
                break;
            }
            case "conditionvaltype": {
                this.conditionValTypeChangeEvent(e, conditionDatas, resultDatas);
                this.setConditionCache(conditionDatas);
                this.setOneTimeThrow();
                break;
            }
            case "conditionitemname": {
                this.checkSpecialChar(e, "condition");
                this.checkConditionNameAndSetId(e, conditionDatas);
                this.setConditionCache(conditionDatas);
                break;
            }
            case "conditioncurrency": {
                this.setConditionCache(conditionDatas);
                break;
            }
            case "conditionlength": {
                this.conditionLengthChangeEvent(e);
                this.setConditionCache(conditionDatas);
                break;
            }
            case "conditionaccuracy": {
                this.conditionAccurancyChangeEvent(e);
                this.setConditionCache(conditionDatas);
                break;
            }
            case "resultitemname": {
                this.checkSpecialChar(e, "result");
                this.checkResultNameAndSetId(e, resultDatas);
                this.setResultCache(resultDatas);
                break;
            }
        }
    }

    private void setOneTimeThrow() {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put("setOneTimeThrow", (Object)Boolean.TRUE);
    }

    private void checkSpecialChar(PropertyChangedArgs e, String type) {
        ChangeData[] changeArray = e.getChangeSet();
        ChangeData changeData0 = changeArray[0];
        int rowIndex = changeData0.getRowIndex();
        LocaleDynamicObjectCollection localeDyCollection = (LocaleDynamicObjectCollection)changeData0.getNewValue();
        if (localeDyCollection == null) {
            return;
        }
        IDataEntityProperty localeProperty = localeDyCollection.getLocaleIdProperty();
        if (localeProperty == null) {
            return;
        }
        String currentLocaleValue = (String)localeDyCollection.getCurrentLocaleValue(localeProperty);
        if (SWCStringUtils.isEmpty((String)currentLocaleValue)) {
            return;
        }
        DynamicObject displayNameDy = localeDyCollection.getOrCreateItemByLocaleId(currentLocaleValue);
        if (displayNameDy == null) {
            return;
        }
        String newValue = SWCStringUtils.equals((String)type, (String)"condition") ? displayNameDy.getString("conditionitemname") : displayNameDy.getString("resultitemname");
        if (StringCheckUtils.checkIsContainSpecialChar((String)newValue)) {
            if (SWCStringUtils.equals((String)type, (String)"condition")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8f93\u5165\u201c\u6761\u4ef6\u540d\u79f0\u201d\uff0c\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u3002", (String)"DataGradeBaseEdit_34", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("conditionitemname", null, rowIndex);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u679c\u540d\u79f0\u5b58\u5728\u7279\u6b8a\u5b57\u7b26\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"DataGradeBaseEdit_35", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("resultitemname", null, rowIndex);
            }
            return;
        }
    }

    private void conditionLengthChangeEvent(PropertyChangedArgs e) {
        String dataTypeNum;
        DynamicObject dataTypeObj;
        ChangeData[] changeDatas0 = e.getChangeSet();
        ChangeData data = changeDatas0[0];
        int rowIndex = data.getRowIndex();
        SWCPageCache cache = new SWCPageCache(this.getView());
        String pageId = this.getView().getPageId();
        DynamicObject conditionObj = this.getModel().getEntryRowEntity("conditionentryidentify", rowIndex);
        Integer oldVal = (Integer)data.getOldValue();
        Integer newVal = (Integer)data.getNewValue();
        if ((newVal == null || newVal == 0) && !SWCObjectUtils.isEmpty((Object)(dataTypeObj = conditionObj.getDynamicObject("conditionvaltype"))) && SWCStringUtils.equals((String)(dataTypeNum = dataTypeObj.getString("number")), (String)DataGradeValueTypeEnum.TEXT.getCode())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataGradeBaseEdit_38", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("conditionlength", (Object)oldVal, rowIndex);
            return;
        }
        if (oldVal != null && oldVal != 0 && newVal != null && newVal != 0) {
            Boolean isCancel = (Boolean)cache.get(this.getView().getPageId() + "_iscancel", Boolean.class);
            if (isCancel != null && isCancel.booleanValue()) {
                cache.remove(this.getView().getPageId() + "_iscancel");
                return;
            }
            HashMap<String, String> cacheMap = new HashMap<String, String>(16);
            cacheMap.put("oldVal", String.valueOf(oldVal));
            cacheMap.put("newVal", String.valueOf(newVal));
            cacheMap.put("rowIndex", String.valueOf(rowIndex));
            if (conditionObj != null) {
                DynamicObject dataTypeObj2 = conditionObj.getDynamicObject("conditionvaltype");
                cacheMap.put("changeConditionId", this.getChangeConditionId(dataTypeObj2, rowIndex));
            }
            cache.put(pageId + "_conditionlength", cacheMap);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u73b0\u6709\u6761\u4ef6\u7684\u6570\u636e\u7c7b\u578b\u3001\u6570\u636e\u7cbe\u5ea6\u6216\u6570\u636e\u957f\u5ea6\u65f6\uff0c\u5c06\u6e05\u7a7a\u6570\u636e\u5206\u7ea7\u8868\u4e2d\u8be5\u5217\u7684\u6570\u636e\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"DataGradeBaseEdit_19", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONDITION_LENGTH_CALLBACK));
        }
    }

    private void conditionAccurancyChangeEvent(PropertyChangedArgs e) {
        ChangeData[] changeDatas0 = e.getChangeSet();
        ChangeData data = changeDatas0[0];
        int rowIndex = data.getRowIndex();
        String oldVal = (String)data.getOldValue();
        String newVal = (String)data.getNewValue();
        if (SWCStringUtils.isNotEmpty((String)oldVal) && SWCStringUtils.isNotEmpty((String)newVal)) {
            SWCPageCache cache = new SWCPageCache(this.getView());
            Boolean isCancel = (Boolean)cache.get(this.getView().getPageId() + "_iscancel", Boolean.class);
            if (isCancel != null && isCancel.booleanValue()) {
                cache.remove(this.getView().getPageId() + "_iscancel");
                return;
            }
            String pageId = this.getView().getPageId();
            HashMap<String, String> cacheMap = new HashMap<String, String>(16);
            cacheMap.put("oldVal", oldVal);
            cacheMap.put("newVal", newVal);
            cacheMap.put("rowIndex", String.valueOf(rowIndex));
            DynamicObject conditionObj = this.getModel().getEntryRowEntity("conditionentryidentify", rowIndex);
            if (conditionObj != null) {
                DynamicObject dataTypeObj = conditionObj.getDynamicObject("conditionvaltype");
                cacheMap.put("changeConditionId", this.getChangeConditionId(dataTypeObj, rowIndex));
            }
            cache.put(pageId + "_conditionaccuracy", cacheMap);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u73b0\u6709\u6761\u4ef6\u7684\u6570\u636e\u7c7b\u578b\u3001\u6570\u636e\u7cbe\u5ea6\u6216\u6570\u636e\u957f\u5ea6\u65f6\uff0c\u5c06\u6e05\u7a7a\u6570\u636e\u5206\u7ea7\u8868\u4e2d\u8be5\u5217\u7684\u6570\u636e\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"DataGradeBaseEdit_19", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONDITION_ACCURACY_CALLBACK));
        }
    }

    private void conditionValTypeChangeEvent(PropertyChangedArgs e, DynamicObjectCollection conditionDatas, DynamicObjectCollection resultDatas) {
        ChangeData[] changeDatas0 = e.getChangeSet();
        ChangeData data = changeDatas0[0];
        int rowIndex = data.getRowIndex();
        DynamicObject oldObj = (DynamicObject)data.getOldValue();
        DynamicObject newObj = (DynamicObject)data.getNewValue();
        this.changeMatchMethodSelect(conditionDatas, resultDatas);
        if (SWCObjectUtils.isEmpty((Object)oldObj) && !SWCObjectUtils.isEmpty((Object)newObj)) {
            String number = newObj.getString("number");
            if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"conditionaccuracy"});
                String accurancy = (String)this.getModel().getValue("conditionaccuracy", rowIndex);
                if (SWCStringUtils.isEmpty((String)accurancy)) {
                    this.getModel().setValue("conditionaccuracy", (Object)"2", rowIndex);
                }
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditionlength"});
                this.getModel().setValue("conditionlength", null, rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditioncurrency"});
                this.getModel().setValue("conditioncurrency", null, rowIndex);
            } else if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.TEXT.getCode())) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"conditionlength"});
                Integer length = (Integer)this.getModel().getValue("conditionlength", rowIndex);
                if (length == null || length == 0) {
                    this.getModel().setValue("conditionlength", (Object)200, rowIndex);
                }
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditionaccuracy"});
                this.getModel().setValue("conditionaccuracy", null, rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditioncurrency"});
                this.getModel().setValue("conditioncurrency", null, rowIndex);
            } else if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"conditioncurrency"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditionlength"});
                this.getModel().setValue("conditionlength", null, rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditionaccuracy"});
                this.getModel().setValue("conditionaccuracy", null, rowIndex);
            } else {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditionaccuracy"});
                this.getModel().setValue("conditionaccuracy", null, rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditionlength"});
                this.getModel().setValue("conditionlength", null, rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditioncurrency"});
                this.getModel().setValue("conditioncurrency", null, rowIndex);
            }
            this.setConditionCache(conditionDatas);
            this.conditionValTypeFirstChangeEvent();
        } else if (!SWCObjectUtils.isEmpty((Object)oldObj) && SWCObjectUtils.isEmpty((Object)newObj)) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditionaccuracy"});
            this.getModel().setValue("conditionaccuracy", null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditionlength"});
            this.getModel().setValue("conditionlength", null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditioncurrency"});
            this.getModel().setValue("conditioncurrency", null, rowIndex);
        } else if (oldObj != null && newObj != null) {
            SWCPageCache cache = new SWCPageCache(this.getView());
            Boolean isCancel = (Boolean)cache.get(this.getView().getPageId() + "_iscancel", Boolean.class);
            if (isCancel != null && isCancel.booleanValue()) {
                cache.remove(this.getView().getPageId() + "_iscancel");
                return;
            }
            String oldNum = oldObj.getString("number");
            String newNum = newObj.getString("number");
            if (SWCStringUtils.isNotEmpty((String)oldNum) && SWCStringUtils.isNotEmpty((String)newNum) && !SWCStringUtils.equals((String)oldNum, (String)newNum)) {
                String pageId = this.getView().getPageId();
                HashMap<String, String> cacheMap = new HashMap<String, String>(16);
                cacheMap.put("oldNum", oldNum);
                cacheMap.put("oldId", oldObj.getString("id"));
                cacheMap.put("newNum", newNum);
                cacheMap.put("rowIndex", String.valueOf(rowIndex));
                cacheMap.put("changeConditionId", this.getChangeConditionId(oldObj, rowIndex));
                cache.put(pageId + "_conditiontype", cacheMap);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u73b0\u6709\u6761\u4ef6\u7684\u6570\u636e\u7c7b\u578b\u3001\u6570\u636e\u7cbe\u5ea6\u6216\u6570\u636e\u957f\u5ea6\u65f6\uff0c\u5c06\u6e05\u7a7a\u6570\u636e\u5206\u7ea7\u8868\u4e2d\u8be5\u5217\u7684\u6570\u636e\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"DataGradeBaseEdit_19", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("conditiontypecallback"));
            }
        }
    }

    private void conditionValTypeFirstChangeEvent() {
        String pageId = this.getView().getPageId();
        SWCPageCache cache = new SWCPageCache(this.getView());
        String subPageId = (String)cache.get(pageId, String.class);
        if (SWCStringUtils.isEmpty((String)subPageId)) {
            return;
        }
        this.getView().invokeOperation("donothing_update");
    }

    private String getChangeConditionId(DynamicObject oldObj, int index) {
        DynamicObject oldConditionObj = this.getModel().getEntryRowEntity("conditionentryidentify", index);
        if (oldConditionObj == null) {
            return "";
        }
        String conditionId = oldConditionObj.getString("conditionid");
        if (SWCStringUtils.isEmpty((String)conditionId)) {
            return "";
        }
        DataGradeHelper helper = new DataGradeHelper();
        String number = oldObj.getString("number");
        String valueType = helper.getValueTypeDesc(number);
        return "condition-" + valueType + "-" + conditionId;
    }

    private void matchMethodChangeEvent(PropertyChangedArgs e, DynamicObjectCollection datas) {
        ChangeData[] changeDatas = e.getChangeSet();
        ChangeData changeData = changeDatas[0];
        String oldVal = (String)changeData.getOldValue();
        String newVal = (String)changeData.getNewValue();
        if ((SWCStringUtils.equals((String)oldVal, (String)"1") || SWCStringUtils.equals((String)oldVal, (String)"3") || SWCStringUtils.equals((String)oldVal, (String)"4")) && (SWCStringUtils.equals((String)newVal, (String)"2") || SWCStringUtils.equals((String)newVal, (String)"5")) && datas.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u6570\u91cf\u5927\u4e8e1\u4e2a\uff0c\u65e0\u6cd5\u66f4\u6539\u5339\u914d\u65b9\u6cd5\u3002", (String)"DataGradeBaseEdit_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("matchmethod", (Object)oldVal);
            return;
        }
        String newMethod = (String)e.getChangeSet()[0].getNewValue();
        if (SWCStringUtils.equals((String)newMethod, (String)"2")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"beyondpolicy"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"dataround"});
            this.setDataRoundMustInput(true);
        } else if (SWCStringUtils.equals((String)newMethod, (String)"3")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"beyondpolicy"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"dataround"});
            this.setDataRoundMustInput(false);
        } else if (SWCStringUtils.equals((String)newMethod, (String)"4")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"beyondpolicy"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"dataround"});
            this.setDataRoundMustInput(false);
        } else if (SWCStringUtils.equals((String)newMethod, (String)"5")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"dataround"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"beyondpolicy"});
            this.setDataRoundMustInput(false);
        } else if (SWCStringUtils.equals((String)newMethod, (String)"1")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"beyondpolicy"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"dataround"});
            this.setDataRoundMustInput(false);
        }
    }

    private void setDataRoundMustInput(boolean mustInput) {
        BasedataEdit dataRound = (BasedataEdit)this.getView().getControl("dataround");
        dataRound.setMustInput(mustInput);
        this.getView().updateView("dataround");
    }

    private void countryChangeEvent(PropertyChangedArgs e) {
        String newType = (String)e.getChangeSet()[0].getNewValue();
        if (SWCStringUtils.equals((String)newType, (String)"2")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"country"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"country"});
        }
        AreaHelper.setAreaTypeAndcountryStatus((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void getListComboItem(String[] values, List<ComboItem> data) {
        for (String value : values) {
            if (SWCStringUtils.equals((String)value, (String)DataGradeMatchMethodEnum.PRECISE.getCode())) {
                data.add(new ComboItem(new LocaleString(DataGradeMatchMethodEnum.PRECISE.getDesc()), DataGradeMatchMethodEnum.PRECISE.getCode()));
                continue;
            }
            if (SWCStringUtils.equals((String)value, (String)DataGradeMatchMethodEnum.LINE.getCode())) {
                data.add(new ComboItem(new LocaleString(DataGradeMatchMethodEnum.LINE.getDesc()), DataGradeMatchMethodEnum.LINE.getCode()));
                continue;
            }
            if (SWCStringUtils.equals((String)value, (String)DataGradeMatchMethodEnum.CLOSEHIGH.getCode())) {
                data.add(new ComboItem(new LocaleString(DataGradeMatchMethodEnum.CLOSEHIGH.getDesc()), DataGradeMatchMethodEnum.CLOSEHIGH.getCode()));
                continue;
            }
            if (SWCStringUtils.equals((String)value, (String)DataGradeMatchMethodEnum.CLOSELOW.getCode())) {
                data.add(new ComboItem(new LocaleString(DataGradeMatchMethodEnum.CLOSELOW.getDesc()), DataGradeMatchMethodEnum.CLOSELOW.getCode()));
                continue;
            }
            if (!SWCStringUtils.equals((String)value, (String)DataGradeMatchMethodEnum.CLOSE.getCode())) continue;
            data.add(new ComboItem(new LocaleString(DataGradeMatchMethodEnum.CLOSE.getDesc()), DataGradeMatchMethodEnum.CLOSE.getCode()));
        }
    }

    private void changeMatchMethodSelect(DynamicObjectCollection conditionDatas, DynamicObjectCollection resultDatas) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("matchmethod");
        String matchMethod = (String)this.getModel().getValue("matchmethod");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(10);
        if (conditionDatas != null && conditionDatas.size() > 1) {
            this.getListComboItem(new String[]{"1", "3", "4"}, data);
            this.getModel().setValue("matchmethod", (Object)matchMethod);
            comboEdit.setComboItems(data);
            return;
        }
        Set<Object> valTypeSet = new HashSet(16);
        valTypeSet = this.getValueType(conditionDatas, resultDatas);
        if (valTypeSet.contains(DataGradeValueTypeEnum.DATE.getDesc()) && valTypeSet.contains(DataGradeValueTypeEnum.TEXT.getDesc())) {
            this.getListComboItem(new String[]{"1", "3", "4"}, data);
        } else if (valTypeSet.contains(DataGradeValueTypeEnum.DATE.getDesc()) && !valTypeSet.contains(DataGradeValueTypeEnum.TEXT.getDesc())) {
            this.getListComboItem(new String[]{"1", "3", "4", "5"}, data);
        } else if (!valTypeSet.contains(DataGradeValueTypeEnum.DATE.getDesc()) && valTypeSet.contains(DataGradeValueTypeEnum.TEXT.getDesc())) {
            this.getListComboItem(new String[]{"1", "3", "4"}, data);
        } else if (!valTypeSet.contains(DataGradeValueTypeEnum.DATE.getDesc()) && !valTypeSet.contains(DataGradeValueTypeEnum.TEXT.getDesc())) {
            this.getListComboItem(new String[]{"1", "2", "3", "4", "5"}, data);
        }
        this.getModel().setValue("matchmethod", (Object)matchMethod);
        comboEdit.setComboItems(data);
    }

    public Set<String> getValueType(DynamicObjectCollection conditionDatas, DynamicObjectCollection resultDatas) {
        String valueType;
        String number;
        DynamicObject valTypeObj;
        HashSet<String> retSet = new HashSet<String>(16);
        DataGradeHelper helper = new DataGradeHelper();
        if (CollectionUtil.isNotEmpty((Collection)conditionDatas)) {
            for (DynamicObject obj : conditionDatas) {
                valTypeObj = obj.getDynamicObject("conditionvaltype");
                if (SWCObjectUtils.isEmpty((Object)valTypeObj)) continue;
                number = valTypeObj.getString("number");
                valueType = helper.getValueTypeDesc(number);
                retSet.add(valueType);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)resultDatas)) {
            for (DynamicObject obj : resultDatas) {
                valTypeObj = obj.getDynamicObject("resultvaltype");
                if (SWCObjectUtils.isEmpty((Object)valTypeObj)) continue;
                number = valTypeObj.getString("number");
                valueType = helper.getValueTypeDesc(number);
                retSet.add(valueType);
            }
        }
        return retSet;
    }

    protected List<String> getFixSummarykeyList() {
        ArrayList<String> fixSummaryKeyList = new ArrayList<String>(10);
        fixSummaryKeyList.add("name");
        fixSummaryKeyList.add("number");
        fixSummaryKeyList.add("status");
        fixSummaryKeyList.add("enable");
        fixSummaryKeyList.add("bsed");
        fixSummaryKeyList.add("country");
        fixSummaryKeyList.add("started");
        fixSummaryKeyList.add("ismodify");
        return fixSummaryKeyList;
    }

    private void checkConditionNameAndSetId(PropertyChangedArgs e, DynamicObjectCollection datas) {
        ChangeData[] changeArray = e.getChangeSet();
        ChangeData changeData0 = changeArray[0];
        int rowIndex = changeData0.getRowIndex();
        LocaleDynamicObjectCollection localeDyCollection = (LocaleDynamicObjectCollection)changeData0.getNewValue();
        if (localeDyCollection == null) {
            return;
        }
        IDataEntityProperty localeProperty = localeDyCollection.getLocaleIdProperty();
        if (localeProperty == null) {
            return;
        }
        String currentLocaleValue = (String)localeDyCollection.getCurrentLocaleValue(localeProperty);
        if (SWCStringUtils.isEmpty((String)currentLocaleValue)) {
            return;
        }
        DynamicObject displayNameDy = localeDyCollection.getOrCreateItemByLocaleId(currentLocaleValue);
        if (displayNameDy == null) {
            return;
        }
        String newValue = displayNameDy.getString("conditionitemname");
        if (SWCStringUtils.isEmpty((String)newValue)) {
            return;
        }
        for (int i = 0; i < datas.size(); ++i) {
            DynamicObject obj;
            String conditionName;
            if (i == rowIndex || !SWCStringUtils.equals((String)newValue, (String)(conditionName = (obj = (DynamicObject)datas.get(i)).getString("conditionitemname")))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u4e0e\u5df2\u6709\u6761\u4ef6\u540d\u79f0\u540c\u540d\u3002", (String)"DataGradeBaseEdit_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("conditionitemname", null, rowIndex);
            return;
        }
        String conditionId = (String)this.getModel().getValue("conditionid", rowIndex);
        if (SWCStringUtils.isEmpty((String)conditionId)) {
            Long currentTimes = System.currentTimeMillis();
            this.getModel().setValue("conditionid", (Object)String.valueOf(currentTimes), rowIndex);
        }
    }

    private void checkResultNameAndSetId(PropertyChangedArgs e, DynamicObjectCollection datas) {
        ChangeData[] changeArray = e.getChangeSet();
        ChangeData changeData0 = changeArray[0];
        int rowIndex = changeData0.getRowIndex();
        LocaleDynamicObjectCollection localeDyCollection = (LocaleDynamicObjectCollection)changeData0.getNewValue();
        if (localeDyCollection == null) {
            return;
        }
        IDataEntityProperty localeProperty = localeDyCollection.getLocaleIdProperty();
        if (localeProperty == null) {
            return;
        }
        String currentLocaleValue = (String)localeDyCollection.getCurrentLocaleValue(localeProperty);
        if (SWCStringUtils.isEmpty((String)currentLocaleValue)) {
            return;
        }
        DynamicObject displayNameDy = localeDyCollection.getOrCreateItemByLocaleId(currentLocaleValue);
        if (displayNameDy == null) {
            return;
        }
        String newValue = displayNameDy.getString("resultitemname");
        if (SWCStringUtils.isEmpty((String)newValue)) {
            return;
        }
        for (int i = 0; i < datas.size(); ++i) {
            DynamicObject obj;
            String conditionName;
            if (i == rowIndex || !SWCStringUtils.equals((String)newValue, (String)(conditionName = (obj = (DynamicObject)datas.get(i)).getString("resultitemname")))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u4e0e\u5df2\u6709\u7ed3\u679c\u540d\u79f0\u540c\u540d\u3002", (String)"DataGradeBaseEdit_31", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("resultitemname", null, rowIndex);
            return;
        }
        String conditionId = (String)this.getModel().getValue("resultid", rowIndex);
        if (SWCStringUtils.isEmpty((String)conditionId)) {
            Long currentTimes = System.currentTimeMillis();
            this.getModel().setValue("resultid", (Object)String.valueOf(currentTimes), rowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String optKey = formOperate.getOperateKey();
        if (SWCStringUtils.equals((String)optKey, (String)"donothing_update")) {
            this.updateGradeTableBeforeEvent(args);
        } else if (SWCStringUtils.equals((String)optKey, (String)"donothing_add") || SWCStringUtils.equals((String)optKey, (String)"deletegradedata") || SWCStringUtils.equals((String)optKey, (String)"donothing_moveup") || SWCStringUtils.equals((String)optKey, (String)"donothing_movedown") || SWCStringUtils.equals((String)optKey, (String)"donothing_export") || SWCStringUtils.equals((String)optKey, (String)"donothing_import")) {
            boolean isNeedDo = this.saveCheck(args);
            if (isNeedDo) {
                this.mainPageOpereationInvokeSubPageBeforeEvent(optKey, args);
            }
        } else if (SWCStringUtils.equals((String)optKey, (String)"conditionaddentry")) {
            this.conditionAddEntryBeforeEvent(args);
        } else if (SWCStringUtils.equals((String)optKey, (String)"resultnewentry")) {
            this.resultAddEntryBeforeEvent(args);
        } else if (SWCStringUtils.equals((String)optKey, (String)"save")) {
            this.saveCheckAndSetData(args);
        } else if (SWCStringUtils.equals((String)optKey, (String)"confirmchange")) {
            boolean isNeedDo = this.submitCheckAndSetData(args);
            if (isNeedDo) {
                this.submitCheck(args);
            }
        } else if (SWCStringUtils.equals((String)optKey, (String)"conditiondeleteentry")) {
            this.delConditionEntry(args);
        } else if (SWCStringUtils.equals((String)optKey, (String)"resultdelentry")) {
            this.delResultEntry(args);
        } else if (SWCStringUtils.equals((String)optKey, (String)"submit")) {
            boolean isNeedDo = this.submitCheckAndSetData(args);
            if (isNeedDo) {
                this.submitCheck(args);
            }
        } else if (SWCStringUtils.equals((String)optKey, (String)"donothing_calculate")) {
            this.simulationCalCheck(args);
        }
    }

    private void changePageSetFieldEnable() {
        boolean isHisPage = BaseDataHisHelper.isHisPage((IFormView)this.getView());
        if (isHisPage) {
            this.getView().setEnable(Boolean.FALSE, CHANGE_PAGE_ENABLE_FIELDS);
        }
    }

    private void simulationCalCheck(BeforeDoOperationEventArgs args) {
        String matchMethod = (String)this.getModel().getValue("matchmethod");
        DynamicObject dataRound = (DynamicObject)this.getModel().getValue("dataround");
        if (!SWCStringUtils.equals((String)matchMethod, (String)"2")) {
            return;
        }
        if (SWCObjectUtils.isEmpty((Object)dataRound)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7cbe\u5ea6\u5c3e\u5dee\u5904\u7406\u201d\u3002", (String)"DataGradeBaseEdit_36", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void resultAddEntryBeforeEvent(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection datas = this.getModel().getEntryEntity("resultentryidentify");
        int length = datas.size();
        if (length >= 10) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u670910\u4e2a\u7ed3\u679c\uff0c\u4e0d\u5141\u8bb8\u518d\u6dfb\u52a0\u65b0\u7ed3\u679c\u3002", (String)"DataGradeBaseEdit_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    private void conditionAddEntryBeforeEvent(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection datas = this.getModel().getEntryEntity("conditionentryidentify");
        int length = datas.size();
        String matchMethod = (String)this.getModel().getValue("matchmethod");
        if (SWCStringUtils.equals((String)matchMethod, (String)"1")) {
            if (length >= 5) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u67095\u4e2a\u6761\u4ef6\uff0c\u4e0d\u5141\u8bb8\u518d\u6dfb\u52a0\u65b0\u6761\u4ef6\u3002", (String)"DataGradeBaseEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (SWCStringUtils.equals((String)matchMethod, (String)"2")) {
            if (length >= 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u5339\u914d\u65b9\u6cd5\u4e3a\u7ebf\u6027\u6216\u6700\u63a5\u8fd1\u7684\u503c\u65f6\u4ec5\u80fd\u8bbe\u7f6e\u4e00\u4e2a\u6761\u4ef6\u3002", (String)"DataGradeBaseEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (SWCStringUtils.equals((String)matchMethod, (String)"5")) {
            if (length >= 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4f7f\u7528\u6700\u63a5\u8fd1\u7684\u503c\u201d\u5339\u914d\u65b9\u6cd5\uff0c\u53ea\u80fd\u8bbe\u7f6e1\u4e2a\u6761\u4ef6\u3002", (String)"DataGradeBaseEdit_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if ((SWCStringUtils.equals((String)matchMethod, (String)"3") || SWCStringUtils.equals((String)matchMethod, (String)"4")) && length >= 5) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u67095\u4e2a\u6761\u4ef6\uff0c\u4e0d\u5141\u8bb8\u518d\u6dfb\u52a0\u65b0\u6761\u4ef6\u3002", (String)"DataGradeBaseEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    private void mainPageOpereationInvokeSubPageBeforeEvent(String optKey, BeforeDoOperationEventArgs args) {
        DynamicObjectCollection conditionDatas = this.getModel().getEntryEntity("conditionentryidentify");
        if (conditionDatas == null || conditionDatas.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6761\u4ef6\u8bbe\u7f6e\u548c\u7ed3\u679c\u8bbe\u7f6e\u3002", (String)"DataGradeBaseEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObjectCollection resultDatas = this.getModel().getEntryEntity("resultentryidentify");
        if (resultDatas == null || resultDatas.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6761\u4ef6\u8bbe\u7f6e\u548c\u7ed3\u679c\u8bbe\u7f6e\u3002", (String)"DataGradeBaseEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DataGradeHelper helper = new DataGradeHelper();
        Boolean isNull = helper.checkConditionRequired(conditionDatas, this.getView());
        if (isNull.booleanValue()) {
            args.setCancel(true);
            return;
        }
        Boolean isNeedFrash = this.isNeedUpdateGrade(conditionDatas);
        if (isNeedFrash.booleanValue()) {
            args.setCancel(true);
            return;
        }
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String subPageId = (String)pageCache.get(this.getView().getPageId(), String.class);
        IFormView childView = this.getView().getView(subPageId);
        if (SWCStringUtils.equals((String)optKey, (String)"donothing_add")) {
            childView.invokeOperation("addentrydata");
            String pageId = this.getView().getPageId();
            pageCache.put(pageId + "_isinit", (Object)Boolean.FALSE);
        } else if (SWCStringUtils.equals((String)optKey, (String)"deletegradedata")) {
            childView.invokeOperation("deleteentry");
        } else if (SWCStringUtils.equals((String)optKey, (String)"donothing_moveup")) {
            childView.invokeOperation("moveentryup");
        } else if (SWCStringUtils.equals((String)optKey, (String)"donothing_movedown")) {
            childView.invokeOperation("moveentrydown");
        } else if (SWCStringUtils.equals((String)optKey, (String)"donothing_export")) {
            Boolean isExistNull = this.checkGradeMandatoryField();
            if (isExistNull.booleanValue()) {
                args.setCancel(true);
                return;
            }
            childView.invokeOperation("donothing_export");
        } else if (SWCStringUtils.equals((String)optKey, (String)"donothing_import")) {
            boolean result = this.checkImportSet();
            if (!result) {
                args.setCancel(true);
                return;
            }
            childView.invokeOperation("donothing_import");
        }
        this.getView().sendFormAction(childView);
    }

    public boolean checkImportSet() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("conditionentryidentify");
        if (CollectionUtil.isEmpty((Collection)entryEntity)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6761\u4ef6\u8bbe\u7f6e\u548c\u7ed3\u679c\u8bbe\u7f6e\u3002", (String)"DataGradeBaseEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        DataGradeHelper helper = new DataGradeHelper();
        Boolean isNull = helper.checkConditionRequired(entryEntity, this.getView());
        if (isNull.booleanValue()) {
            return false;
        }
        DynamicObjectCollection resultDatas = this.getModel().getEntryEntity("resultentryidentify");
        if (CollectionUtil.isEmpty((Collection)resultDatas)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6761\u4ef6\u8bbe\u7f6e\u548c\u7ed3\u679c\u8bbe\u7f6e\u3002", (String)"DataGradeBaseEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        Boolean isNeedFrash = this.isNeedUpdateGrade(entryEntity);
        return isNeedFrash == false;
    }

    private void updateGradeTableBeforeEvent(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection conditionDatas = this.getEntryData("conditionentryidentify", ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6761\u4ef6\u8bbe\u7f6e\u548c\u7ed3\u679c\u8bbe\u7f6e\u3002", (String)"DataGradeBaseEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        if (CollectionUtils.isEmpty((Collection)conditionDatas)) {
            args.setCancel(true);
            return;
        }
        DataGradeHelper helper = new DataGradeHelper();
        Boolean isNull = helper.checkConditionRequired(conditionDatas, this.getView());
        if (isNull.booleanValue()) {
            args.setCancel(true);
            return;
        }
        DynamicObjectCollection resultDatas = this.getEntryData("resultentryidentify", ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6761\u4ef6\u8bbe\u7f6e\u548c\u7ed3\u679c\u8bbe\u7f6e\u3002", (String)"DataGradeBaseEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        if (CollectionUtils.isEmpty((Collection)resultDatas)) {
            args.setCancel(true);
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"nullpage"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"contentpage"});
        this.openDataGradeSubTable();
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String pageId = this.getView().getPageId();
        pageCache.put(pageId + "_isinit", (Object)Boolean.FALSE);
        this.setConditionAndResultFieldInfo(conditionDatas, resultDatas);
    }

    private void writeHideDataBySubPageData() {
        String pageId;
        ISWCAppCache appCache = SWCAppCache.get((String)"hsas_datagrade_appcache");
        List subPageGradeCache = (List)appCache.get((pageId = this.getView().getPageId()) + "_subPageGradeCache", List.class);
        if (subPageGradeCache == null || subPageGradeCache.size() == 0) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
            model.deleteEntryData("dataentry");
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("rownum", new Object[0]);
        setter.addField("fieldid", new Object[0]);
        setter.addField("value", new Object[0]);
        setter.addField("fieldname", new Object[0]);
        for (Map dataMap : subPageGradeCache) {
            int rowNum = (Integer)dataMap.get("rownum");
            String fieldId = (String)dataMap.get("fieldid");
            String fieldName = (String)dataMap.get("fieldName");
            Object value = dataMap.get("value");
            setter.addRow(new Object[]{rowNum, fieldId, value, fieldName});
        }
        model.deleteEntryData("dataentry");
        model.batchCreateNewEntryRow("dataentry", setter);
        model.endInit();
    }

    private void submitCheck(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection dataColl = this.getModel().getEntryEntity("dataentry");
        String number = (String)this.getModel().getValue("number");
        if (SWCObjectUtils.isEmpty((Object)dataColl) || dataColl.size() == 0) {
            String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u8bf7\u5148\u7ef4\u62a4\u6570\u636e\u5206\u7ea7\u8868\u3002", (String)"DataGradeBaseEdit_20", (String)"swc-hsas-formplugin", (Object[])new Object[0]), number);
            this.getView().showTipNotification(msg);
            args.setCancel(true);
        }
    }

    private void delResultEntry(BeforeDoOperationEventArgs args) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndexs = proxy.getEntryState("resultentryidentify").getSelectedRows();
        if (rowIndexs.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"DataGradeBaseEdit_18", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("resultdelcallback", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"DataGradeBaseEdit_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"DataGradeBaseEdit_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4f60\u5df2\u9009\u4e2d%s\u6761\u6570\u636e\uff0c\u5220\u9664\u540e\u4e0d\u53ef\u6062\u590d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DataGradeBaseEdit_17", (String)"swc-hsas-formplugin", (Object[])new Object[0]), rowIndexs.length);
        String changeDescStr = this.getModel().getChangeDesc();
        this.getView().showConfirm(msg, changeDescStr, options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        args.setCancel(true);
    }

    private void delConditionEntry(BeforeDoOperationEventArgs args) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndexs = proxy.getEntryState("conditionentryidentify").getSelectedRows();
        if (rowIndexs.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"DataGradeBaseEdit_18", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("conditiondelcallback", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"DataGradeBaseEdit_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"DataGradeBaseEdit_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4f60\u5df2\u9009\u4e2d%s\u6761\u6570\u636e\uff0c\u5220\u9664\u540e\u4e0d\u53ef\u6062\u590d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DataGradeBaseEdit_17", (String)"swc-hsas-formplugin", (Object[])new Object[0]), rowIndexs.length);
        String changeDescStr = this.getModel().getChangeDesc();
        this.getView().showConfirm(msg, changeDescStr, options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        args.setCancel(true);
    }

    private boolean saveCheckAndSetData(BeforeDoOperationEventArgs args) {
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        if (StringCheckUtils.checkNameIsContainSpecialChar((String)name.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c\u3010\u201d\u3001\u201c[\u201d\u3001\u201c]\u201d\u3001\u201c\u3011\u201d\u3002", (String)"DataGradeBaseEdit_33", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        DataGradeHelper helper = new DataGradeHelper();
        DynamicObjectCollection conditionDatas = this.getModel().getEntryEntity("conditionentryidentify");
        Boolean isNull = helper.checkConditionRequired(conditionDatas, this.getView());
        if (isNull.booleanValue()) {
            args.setCancel(true);
            return false;
        }
        Boolean isNeedFrash = this.isNeedUpdateGrade(conditionDatas);
        if (isNeedFrash.booleanValue()) {
            args.setCancel(true);
            return false;
        }
        Boolean isExistNull = this.checkGradeMandatoryField();
        if (isExistNull.booleanValue()) {
            args.setCancel(true);
            return false;
        }
        this.writeHideDataBySubPageData();
        FormOperate source = (FormOperate)args.getSource();
        DynamicObjectCollection gradeDatas = this.getModel().getEntryEntity("dataentry");
        if (!source.getOption().tryGetVariableValue("data_grade_after_confirm", new RefObject()) && (SWCObjectUtils.isEmpty((Object)gradeDatas) || gradeDatas.size() == 0)) {
            this.showDataGradeConfirmMsg();
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private boolean submitCheckAndSetData(BeforeDoOperationEventArgs args) {
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        if (StringCheckUtils.checkNameIsContainSpecialChar((String)name.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c\u3010\u201d\u3001\u201c[\u201d\u3001\u201c]\u201d\u3001\u201c\u3011\u201d\u3002", (String)"DataGradeBaseEdit_33", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        DataGradeHelper helper = new DataGradeHelper();
        DynamicObjectCollection conditionDatas = this.getModel().getEntryEntity("conditionentryidentify");
        Boolean isNull = helper.checkConditionRequired(conditionDatas, this.getView());
        if (isNull.booleanValue()) {
            args.setCancel(true);
            return false;
        }
        Boolean isNeedFrash = this.isNeedUpdateGrade(conditionDatas);
        if (isNeedFrash.booleanValue()) {
            args.setCancel(true);
            return false;
        }
        Boolean isExistNull = this.checkGradeMandatoryField();
        if (isExistNull.booleanValue()) {
            args.setCancel(true);
            return false;
        }
        this.writeHideDataBySubPageData();
        return true;
    }

    private boolean saveCheck(BeforeDoOperationEventArgs args) {
        DataGradeHelper helper = new DataGradeHelper();
        DynamicObjectCollection conditionDatas = this.getModel().getEntryEntity("conditionentryidentify");
        Boolean isNull = helper.checkConditionRequired(conditionDatas, this.getView());
        if (isNull.booleanValue()) {
            args.setCancel(true);
            return false;
        }
        Boolean isNeedFrash = this.isNeedUpdateGrade(conditionDatas);
        if (isNeedFrash.booleanValue()) {
            args.setCancel(true);
            return false;
        }
        this.writeHideDataBySubPageData();
        return true;
    }

    public Boolean isNeedUpdateGrade(DynamicObjectCollection conditionDatas) {
        String fieldName;
        String valueType;
        String number;
        DynamicObject valTypeObj;
        String id;
        DynamicObjectCollection resultDatas = this.getModel().getEntryEntity("resultentryidentify");
        DataGradeHelper helper = new DataGradeHelper();
        ArrayList<String> mainEntryList = new ArrayList<String>(10);
        for (DynamicObject dataObj : conditionDatas) {
            id = dataObj.getString("conditionid");
            valTypeObj = dataObj.getDynamicObject("conditionvaltype");
            number = valTypeObj.getString("number");
            valueType = helper.getValueTypeDesc(number);
            mainEntryList.add("condition-" + valueType + "-" + id);
            fieldName = dataObj.getString("conditionitemname");
            mainEntryList.add(fieldName);
        }
        for (DynamicObject dataObj : resultDatas) {
            id = dataObj.getString("resultid");
            valTypeObj = dataObj.getDynamicObject("resultvaltype");
            number = valTypeObj.getString("number");
            valueType = helper.getValueTypeDesc(number);
            mainEntryList.add("result-" + valueType + "-" + id);
            fieldName = dataObj.getString("resultitemname");
            mainEntryList.add(fieldName);
        }
        SWCPageCache cache = new SWCPageCache(this.getView());
        List subEntryList = (List)cache.get("conditionAndResultFieldInfo", List.class);
        int size = mainEntryList.size();
        if (size != subEntryList.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u6216\u7ed3\u679c\u8bbe\u7f6e\u5df2\u4fee\u6539\uff0c\u8bf7\u66f4\u65b0\u6570\u636e\u5206\u7ea7\u8868\u3002", (String)"DataGradeBaseEdit_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        for (int i = 0; i < size; ++i) {
            if (SWCStringUtils.equals((String)((String)mainEntryList.get(i)), (String)((String)subEntryList.get(i)))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u6216\u7ed3\u679c\u8bbe\u7f6e\u5df2\u4fee\u6539\uff0c\u8bf7\u66f4\u65b0\u6570\u636e\u5206\u7ea7\u8868\u3002", (String)"DataGradeBaseEdit_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Boolean checkGradeMandatoryField() {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String subPageId = (String)pageCache.get(this.getView().getPageId(), String.class);
        if (SWCStringUtils.isEmpty((String)subPageId)) {
            return Boolean.FALSE;
        }
        IFormView subView = this.getView().getView(subPageId);
        DynamicObjectCollection subEntryDatas = subView.getModel().getEntryEntity("entryentity");
        for (DynamicObject dataObj : subEntryDatas) {
            DataEntityPropertyCollection properties = dataObj.getDataEntityType().getProperties();
            for (IDataEntityProperty propertie : properties) {
                Object value;
                String fieldId = propertie.getName();
                if (!fieldId.startsWith("condition-") && !fieldId.startsWith("result-") || !SWCObjectUtils.isEmpty((Object)(value = dataObj.get(fieldId)))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6570\u636e\u5206\u7ea7\u8868\u5fc5\u586b\u5b57\u6bb5\u3002", (String)"DataGradeBaseEdit_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public List<DynamicObjectCollection> groupCollection(DynamicObjectCollection datas) {
        ArrayList<DynamicObjectCollection> list = new ArrayList<DynamicObjectCollection>(10);
        DynamicObject firstObj = (DynamicObject)datas.get(0);
        DynamicObject lastObj = (DynamicObject)datas.get(datas.size() - 1);
        int lastIndex = lastObj.getInt("rownum");
        for (int index = firstObj.getInt("rownum"); index <= lastIndex; ++index) {
            DynamicObjectCollection coll = new DynamicObjectCollection();
            for (DynamicObject obj : datas) {
                int rowNum = obj.getInt("rownum");
                if (rowNum != index) continue;
                coll.add((Object)obj);
            }
            list.add(coll);
        }
        return list;
    }

    private void showDataGradeConfirmMsg() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("null_grade_save", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u5426", (String)"DataGradeBaseEdit_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u662f", (String)"DataGradeBaseEdit_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u6570\u636e\u5206\u7ea7\u8868\u5206\u5f55\u4e3a\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58\u64cd\u4f5c\uff1f", (String)"DataGradeBaseEdit_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String changeDescStr = this.getModel().getChangeDesc();
        this.getView().showConfirm(msg, changeDescStr, options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if (SWCStringUtils.equals((String)callBackId, (String)"null_grade_save")) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("data_grade_after_confirm", Boolean.TRUE.toString());
                this.getView().invokeOperation("save", option);
            }
        } else if (SWCStringUtils.equals((String)callBackId, (String)"conditiondelcallback")) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                int[] rowIndexs = proxy.getEntryState("conditionentryidentify").getSelectedRows();
                this.getModel().deleteEntryRows("conditionentryidentify", rowIndexs);
            }
            DynamicObjectCollection conditionDatas = this.getModel().getEntryEntity("conditionentryidentify");
            DynamicObjectCollection resultDatas = this.getModel().getEntryEntity("resultentryidentify");
            this.changeMatchMethodSelect(conditionDatas, resultDatas);
            this.setConditionCache(conditionDatas);
        } else if (SWCStringUtils.equals((String)callBackId, (String)"resultdelcallback")) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                int[] rowIndexs = proxy.getEntryState("resultentryidentify").getSelectedRows();
                this.getModel().deleteEntryRows("resultentryidentify", rowIndexs);
            }
            DynamicObjectCollection conditionDatas = this.getModel().getEntryEntity("conditionentryidentify");
            DynamicObjectCollection resultDatas = this.getModel().getEntryEntity("resultentryidentify");
            this.changeMatchMethodSelect(conditionDatas, resultDatas);
            this.setResultCache(resultDatas);
        } else if (SWCStringUtils.equals((String)callBackId, (String)"conditiontypecallback")) {
            this.conditionValCallBackEvent(result);
        } else if (SWCStringUtils.equals((String)callBackId, (String)CONDITION_ACCURACY_CALLBACK)) {
            this.conditionAccuracyCallBackEvent(result);
        } else if (SWCStringUtils.equals((String)callBackId, (String)CONDITION_LENGTH_CALLBACK)) {
            this.conditionLengthCallBackEvent(result);
        }
    }

    private void conditionLengthCallBackEvent(MessageBoxResult result) {
        String pageId = this.getView().getPageId();
        SWCPageCache cache = new SWCPageCache(this.getView());
        Map cacheMap = (Map)cache.get(pageId + "_conditionlength", Map.class);
        int rowIndex = 0;
        String indexStr = (String)cacheMap.get("rowIndex");
        if (SWCStringUtils.isNotEmpty((String)indexStr)) {
            rowIndex = Integer.parseInt(indexStr);
        }
        if (MessageBoxResult.Yes.equals((Object)result)) {
            cache.put(this.getView().getPageId() + "_iscancel", (Object)Boolean.FALSE);
            String changeConditionId = (String)cacheMap.get("changeConditionId");
            this.removeChageColumnDataFromCache(changeConditionId);
            this.openDataGradeSubTable();
            this.writeHideDataBySubPageData();
        } else {
            String oldValStr = (String)cacheMap.get("oldVal");
            IDataModel model = this.getModel();
            cache.put(this.getView().getPageId() + "_iscancel", (Object)Boolean.TRUE);
            if (SWCStringUtils.isEmpty((String)oldValStr)) {
                model.setValue("conditionlength", null, rowIndex);
            } else {
                model.setValue("conditionlength", (Object)Integer.parseInt(oldValStr), rowIndex);
            }
        }
        DynamicObjectCollection conditionDatas = this.getModel().getEntryEntity("conditionentryidentify");
        this.setConditionCache(conditionDatas);
    }

    private void conditionAccuracyCallBackEvent(MessageBoxResult result) {
        String pageId = this.getView().getPageId();
        SWCPageCache cache = new SWCPageCache(this.getView());
        Map cacheMap = (Map)cache.get(pageId + "_conditionaccuracy", Map.class);
        int rowIndex = 0;
        String indexStr = (String)cacheMap.get("rowIndex");
        if (SWCStringUtils.isNotEmpty((String)indexStr)) {
            rowIndex = Integer.parseInt(indexStr);
        }
        if (MessageBoxResult.Yes.equals((Object)result)) {
            cache.put(this.getView().getPageId() + "_iscancel", (Object)Boolean.FALSE);
            String changeConditionId = (String)cacheMap.get("changeConditionId");
            this.removeChageColumnDataFromCache(changeConditionId);
            this.openDataGradeSubTable();
            this.writeHideDataBySubPageData();
        } else {
            String oldVal = (String)cacheMap.get("oldVal");
            IDataModel model = this.getModel();
            cache.put(this.getView().getPageId() + "_iscancel", (Object)Boolean.TRUE);
            model.setValue("conditionaccuracy", (Object)oldVal, rowIndex);
        }
        DynamicObjectCollection conditionDatas = this.getModel().getEntryEntity("conditionentryidentify");
        this.setConditionCache(conditionDatas);
    }

    private void conditionValCallBackEvent(MessageBoxResult result) {
        String pageId = this.getView().getPageId();
        SWCPageCache cache = new SWCPageCache(this.getView());
        Map cacheMap = (Map)cache.get(pageId + "_conditiontype", Map.class);
        int rowIndex = 0;
        String indexStr = (String)cacheMap.get("rowIndex");
        if (SWCStringUtils.isNotEmpty((String)indexStr)) {
            rowIndex = Integer.parseInt(indexStr);
        }
        String number = "";
        if (MessageBoxResult.Yes.equals((Object)result)) {
            number = (String)cacheMap.get("newNum");
            cache.put(this.getView().getPageId() + "_iscancel", (Object)Boolean.FALSE);
            String changeConditionId = (String)cacheMap.get("changeConditionId");
            this.removeChageColumnDataFromCache(changeConditionId);
            this.openDataGradeSubTable();
            this.writeHideDataBySubPageData();
        } else {
            number = (String)cacheMap.get("oldNum");
            String oldId = (String)cacheMap.get("oldId");
            IDataModel model = this.getModel();
            cache.put(this.getView().getPageId() + "_iscancel", (Object)Boolean.TRUE);
            model.setValue("conditionvaltype", (Object)oldId, rowIndex);
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"conditionaccuracy"});
            String accurency = (String)this.getModel().getValue("conditionaccuracy", rowIndex);
            if (SWCStringUtils.isEmpty((String)accurency)) {
                this.getModel().setValue("conditionaccuracy", (Object)"2", rowIndex);
            }
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditionlength"});
            this.getModel().setValue("conditionlength", null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditioncurrency"});
            this.getModel().setValue("conditioncurrency", null, rowIndex);
        } else if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.TEXT.getCode())) {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"conditionlength"});
            Integer length = (Integer)this.getModel().getValue("conditionlength", rowIndex);
            if (length == null || length == 0) {
                this.getModel().setValue("conditionlength", (Object)200, rowIndex);
            }
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditionaccuracy"});
            this.getModel().setValue("conditionaccuracy", null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditioncurrency"});
            this.getModel().setValue("conditioncurrency", null, rowIndex);
        } else if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"conditioncurrency"});
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditionlength"});
            this.getModel().setValue("conditionlength", null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditionaccuracy"});
            this.getModel().setValue("conditionaccuracy", null, rowIndex);
        } else {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditionaccuracy"});
            this.getModel().setValue("conditionaccuracy", null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditionlength"});
            this.getModel().setValue("conditionlength", null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"conditioncurrency"});
            this.getModel().setValue("conditioncurrency", null, rowIndex);
        }
        DynamicObjectCollection conditionDatas = this.getModel().getEntryEntity("conditionentryidentify");
        this.setConditionCache(conditionDatas);
    }

    private void removeChageColumnDataFromCache(String changeConditionId) {
        String pageId;
        ISWCAppCache appCache = SWCAppCache.get((String)"hsas_datagrade_appcache");
        List subPageGradeCache = (List)appCache.get((pageId = this.getView().getPageId()) + "_subPageGradeCache", List.class);
        if (subPageGradeCache == null || subPageGradeCache.size() == 0) {
            return;
        }
        if (SWCStringUtils.isEmpty((String)changeConditionId)) {
            return;
        }
        ArrayList<Map> newDataList = new ArrayList<Map>(10);
        for (Map dataMap : subPageGradeCache) {
            String fieldId = (String)dataMap.get("fieldid");
            if (SWCStringUtils.equals((String)fieldId, (String)changeConditionId)) continue;
            newDataList.add(dataMap);
        }
        appCache.put(pageId + "_subPageGradeCache", newDataList);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String optKey = args.getOperateKey();
        if (SWCStringUtils.equals((String)optKey, (String)"donothing_calculate")) {
            this.simulationCalAfterDoEvent();
        } else if (SWCStringUtils.equals((String)optKey, (String)"conditionaddentry")) {
            DynamicObjectCollection conditionEntryDatas = this.getModel().getEntryEntity("conditionentryidentify");
            int index = conditionEntryDatas.size();
            this.getView().setEnable(Boolean.FALSE, index - 1, new String[]{"conditionaccuracy"});
            this.getView().setEnable(Boolean.FALSE, index - 1, new String[]{"conditionlength"});
            this.getView().setEnable(Boolean.FALSE, index - 1, new String[]{"conditioncurrency"});
        } else if (SWCStringUtils.equals((String)optKey, (String)"resultnewentry")) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hsas_datagraderestform");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addresultcallback"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        } else if (SWCStringUtils.equals((String)optKey, (String)"resultedit")) {
            this.resultEditAfterDoEvent();
        } else if (SWCStringUtils.equals((String)optKey, (String)"conditionmoveup") || SWCStringUtils.equals((String)optKey, (String)"conditionmovedown")) {
            DynamicObjectCollection conditionDatas = this.getModel().getEntryEntity("conditionentryidentify");
            this.setConditionCache(conditionDatas);
        } else if (SWCStringUtils.equals((String)optKey, (String)"resultmoveup") || SWCStringUtils.equals((String)optKey, (String)"resultmovedown")) {
            DynamicObjectCollection resultDatas = this.getModel().getEntryEntity("resultentryidentify");
            this.setResultCache(resultDatas);
        } else if (SWCStringUtils.equals((String)optKey, (String)"deletegradedata")) {
            this.openDataGradeSubTable();
        }
    }

    private void simulationCalAfterDoEvent() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_datagradesimulacal");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setParentPageId(this.getView().getPageId());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("conditionentryidentify");
        if (CollectionUtil.isEmpty((Collection)entryEntity)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6761\u4ef6\u8bbe\u7f6e\u548c\u7ed3\u679c\u8bbe\u7f6e\u3002", (String)"DataGradeBaseEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        showParameter.setCustomParam("conditionDatas", (Object)entryEntity);
        DynamicObjectCollection resultDatas = this.getModel().getEntryEntity("resultentryidentify");
        if (CollectionUtil.isEmpty((Collection)resultDatas)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6761\u4ef6\u8bbe\u7f6e\u548c\u7ed3\u679c\u8bbe\u7f6e\u3002", (String)"DataGradeBaseEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        showParameter.setCustomParam("resultDatas", (Object)resultDatas);
        DataGradeHelper helper = new DataGradeHelper();
        DynamicObjectCollection conditionDatas = this.getModel().getEntryEntity("conditionentryidentify");
        Boolean isNull = helper.checkConditionRequired(conditionDatas, this.getView());
        if (isNull.booleanValue()) {
            return;
        }
        Boolean isNeedFrash = this.isNeedUpdateGrade(entryEntity);
        if (isNeedFrash.booleanValue()) {
            return;
        }
        if (this.checkDataGradeIsNull()) {
            return;
        }
        Boolean isExistNull = this.checkGradeMandatoryField();
        if (isExistNull.booleanValue()) {
            return;
        }
        this.getView().showForm(showParameter);
    }

    private boolean checkDataGradeIsNull() {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String subPageId = (String)pageCache.get(this.getView().getPageId(), String.class);
        if (SWCStringUtils.isEmpty((String)subPageId)) {
            return false;
        }
        IFormView subView = this.getView().getView(subPageId);
        DynamicObjectCollection subEntryDatas = subView.getModel().getEntryEntity("entryentity");
        if (subEntryDatas == null || subEntryDatas.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6570\u636e\u5206\u7ea7\u8868\u3002", (String)"DataGradeBaseEdit_37", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void resultEditAfterDoEvent() {
        String resultId;
        String defVal;
        Object currency;
        Object length;
        int index = this.getModel().getEntryCurrentRowIndex("resultentryidentify");
        DynamicObject editObj = this.getModel().getEntryRowEntity("resultentryidentify", index);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_datagraderestform");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addresultcallback"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        JSONObject params = new JSONObject();
        OrmLocaleValue filedName = (OrmLocaleValue)editObj.get("resultitemname");
        params.put("resultitemname", (Object)filedName.getLocaleValue());
        DynamicObject valTypeObj = (DynamicObject)editObj.get("resultvaltype");
        String id = valTypeObj.getString("id");
        params.put("resultvaltype", (Object)id);
        DataGradeHelper helper = new DataGradeHelper();
        String number = valTypeObj.getString("number");
        String valueType = helper.getValueTypeDesc(number);
        params.put("valueType", (Object)valueType);
        Object accuracy = editObj.get("resultaccuracy");
        if (accuracy != null) {
            params.put("accuracy", (Object)((String)accuracy));
        }
        if ((length = editObj.get("resultlength")) != null) {
            params.put("length", (Object)((Integer)length));
        }
        if ((currency = editObj.get("resultcurrency")) != null) {
            DynamicObject resultCurrency = (DynamicObject)currency;
            params.put("currency", resultCurrency.get("id"));
        }
        if (SWCStringUtils.isNotEmpty((String)(defVal = editObj.getString("resultdefaultval")))) {
            params.put("defVal", (Object)defVal);
        }
        if (SWCStringUtils.isNotEmpty((String)(resultId = editObj.getString("resultid")))) {
            params.put("resultId", (Object)resultId);
        }
        params.put("index", (Object)index);
        showParameter.setCustomParam("params", (Object)params);
        this.getView().showForm(showParameter);
    }

    public void click(EventObject evt) {
        String clickedKey;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (clickedKey = source.getKey()) {
            case "adddata": {
                boolean isNeedDo = this.addDataClickEvent();
                if (!isNeedDo) break;
                DynamicObjectCollection conditionDatas = this.getModel().getEntryEntity("conditionentryidentify");
                DynamicObjectCollection resultDatas = this.getModel().getEntryEntity("resultentryidentify");
                this.setConditionAndResultFieldInfo(conditionDatas, resultDatas);
                break;
            }
        }
    }

    private boolean addDataClickEvent() {
        DynamicObjectCollection conditionDatas = this.getEntryData("conditionentryidentify", ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6761\u4ef6\u8bbe\u7f6e\u548c\u7ed3\u679c\u8bbe\u7f6e\u3002", (String)"DataGradeBaseEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        if (CollectionUtils.isEmpty((Collection)conditionDatas)) {
            return false;
        }
        DataGradeHelper helper = new DataGradeHelper();
        Boolean isNull = helper.checkConditionRequired(conditionDatas, this.getView());
        if (isNull.booleanValue()) {
            return false;
        }
        DynamicObjectCollection resultDatas = this.getEntryData("resultentryidentify", ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6761\u4ef6\u8bbe\u7f6e\u548c\u7ed3\u679c\u8bbe\u7f6e\u3002", (String)"DataGradeBaseEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        if (CollectionUtils.isEmpty((Collection)resultDatas)) {
            return false;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"nullpage"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"contentpage"});
        this.openDataGradeSubTable();
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String pageId = this.getView().getPageId();
        pageCache.put(pageId + "_isinit", (Object)Boolean.FALSE);
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actId = closedCallBackEvent.getActionId();
        if (SWCStringUtils.equals((String)actId, (String)"addresultcallback")) {
            this.addResultCloseCallBackEvent(closedCallBackEvent);
        }
    }

    private void addResultCloseCallBackEvent(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (SWCObjectUtils.isEmpty((Object)returnData) || returnData.size() == 0) {
            return;
        }
        String resultName = (String)returnData.get("resultName");
        String valueTypeId = (String)returnData.get("valueTypeId");
        String accuracy = (String)returnData.get("accuracy");
        Integer length = (Integer)returnData.get("length");
        String defaultVal = (String)returnData.get("defaultValue");
        String resultId = (String)returnData.get("resultId");
        String currencyId = (String)returnData.get("currencyId");
        Object indexObj = returnData.get("index");
        if (indexObj != null) {
            int index = (Integer)indexObj;
            this.getModel().setValue("resultitemname", (Object)resultName, index);
            this.getModel().setValue("resultvaltype", (Object)valueTypeId, index);
            this.getModel().setValue("resultaccuracy", (Object)accuracy, index);
            this.getModel().setValue("resultlength", (Object)length, index);
            this.getModel().setValue("resultcurrency", (Object)currencyId, index);
            this.getModel().setValue("resultdefaultval", (Object)defaultVal, index);
            this.getModel().setValue("resultid", (Object)resultId, index);
        } else {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter setter = new TableValueSetter(new String[0]);
            setter.addField("resultitemname", new Object[0]);
            setter.addField("resultvaltype", new Object[0]);
            setter.addField("resultaccuracy", new Object[0]);
            setter.addField("resultlength", new Object[0]);
            setter.addField("resultcurrency", new Object[0]);
            setter.addField("resultdefaultval", new Object[0]);
            setter.addField("resultid", new Object[0]);
            setter.addRow(new Object[]{resultName, valueTypeId, accuracy, length, currencyId, defaultVal, resultId});
            model.batchCreateNewEntryRow("resultentryidentify", setter);
            this.getView().updateView("resultentryidentify");
            model.endInit();
            DynamicObjectCollection resultData = this.getModel().getEntryEntity("resultentryidentify");
            int index = 0;
            if (resultData != null && resultData.size() > 0) {
                index = resultData.size() - 1;
            }
            for (int i = 0; i <= index; ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"resultvaltype"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"resultaccuracy"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"resultlength"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"resultcurrency"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"resultdefaultval"});
            }
        }
        DynamicObjectCollection conditionDatas = this.getModel().getEntryEntity("conditionentryidentify");
        DynamicObjectCollection resultDatas = this.getModel().getEntryEntity("resultentryidentify");
        this.changeMatchMethodSelect(conditionDatas, resultDatas);
        this.setResultCache(resultDatas);
    }

    private DynamicObjectCollection getEntryData(String entryName, String errorMsg) {
        DynamicObjectCollection conditionData = this.getModel().getEntryEntity(entryName);
        if (SWCObjectUtils.isEmpty((Object)conditionData) || conditionData.size() == 0) {
            this.getView().showTipNotification(errorMsg);
            return null;
        }
        return conditionData;
    }

    private void openDataGradeSubTable() {
        FormShowParameter formShow = new FormShowParameter();
        OpenStyle openStyle = formShow.getOpenStyle();
        openStyle.setTargetKey("contentpanel");
        openStyle.setShowType(ShowType.InContainer);
        formShow.setFormId("hsas_datagradeentry");
        formShow.setParentPageId(this.getView().getPageId());
        formShow.setCustomParam("main_page", (Object)this.getView().getPageId());
        this.getView().showForm(formShow);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put(this.getView().getPageId(), (Object)formShow.getPageId());
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey;
        switch (fieldKey = event.getProperty().getName()) {
            case "conditionvaltype": {
                this.conditionValTypeF7Click(event);
                break;
            }
        }
    }

    private void conditionValTypeF7Click(BeforeF7SelectEvent event) {
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        formShowParameter.setMultiSelect(false);
        String matchMethod = (String)this.getModel().getValue("matchmethod");
        if (SWCStringUtils.equals((String)matchMethod, (String)"2")) {
            QFilter filter = new QFilter("number", "=", (Object)DataGradeValueTypeEnum.DECIMAL.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.AMOUNT.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.INTEGER.getCode());
            formShowParameter.getListFilterParameter().getQFilters().add(filter);
        } else if (SWCStringUtils.equals((String)matchMethod, (String)"5")) {
            QFilter filter = new QFilter("number", "=", (Object)DataGradeValueTypeEnum.DECIMAL.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.AMOUNT.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.INTEGER.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.DATE.getCode());
            formShowParameter.getListFilterParameter().getQFilters().add(filter);
        } else if (SWCStringUtils.equals((String)matchMethod, (String)"1")) {
            QFilter filter = new QFilter("number", "=", (Object)DataGradeValueTypeEnum.DECIMAL.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.AMOUNT.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.TEXT.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.INTEGER.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.DATE.getCode());
            formShowParameter.getListFilterParameter().getQFilters().add(filter);
        } else if (SWCStringUtils.equals((String)matchMethod, (String)"4") || SWCStringUtils.equals((String)matchMethod, (String)"3")) {
            QFilter filter = new QFilter("number", "=", (Object)DataGradeValueTypeEnum.DECIMAL.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.AMOUNT.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.TEXT.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.INTEGER.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.DATE.getCode());
            formShowParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    private void setConditionCache(DynamicObjectCollection conditionDatas) {
        if (SWCObjectUtils.isEmpty((Object)conditionDatas) || conditionDatas.size() == 0) {
            return;
        }
        int size = conditionDatas.size();
        JSONArray dataArray = new JSONArray(size);
        DataGradeHelper helper = new DataGradeHelper();
        for (DynamicObject conditionObj : conditionDatas) {
            Object conditionIdObj;
            DynamicObject currencyObj;
            Object lengthObj;
            Object accuracyObj;
            DynamicObject valTypeObj;
            JSONObject jsonObj = new JSONObject();
            Object nameObj = conditionObj.get("conditionitemname");
            if (!SWCObjectUtils.isEmpty((Object)nameObj)) {
                OrmLocaleValue localObj = (OrmLocaleValue)nameObj;
                String conditionName = localObj.getLocaleValue();
                jsonObj.put("conditionitemname", (Object)conditionName);
            }
            if (!SWCObjectUtils.isEmpty((Object)(valTypeObj = conditionObj.getDynamicObject("conditionvaltype")))) {
                String number = valTypeObj.getString("number");
                String valueType = helper.getValueTypeDesc(number);
                jsonObj.put("number", (Object)number);
                jsonObj.put("valueType", (Object)valueType);
                String id = valTypeObj.getString("id");
                jsonObj.put("conditionvaltype", (Object)id);
            }
            if (!SWCObjectUtils.isEmpty((Object)(accuracyObj = conditionObj.get("conditionaccuracy")))) {
                String accuracy = (String)accuracyObj;
                jsonObj.put("conditionaccuracy", (Object)accuracy);
            }
            if (!SWCObjectUtils.isEmpty((Object)(lengthObj = conditionObj.get("conditionlength")))) {
                int length = (Integer)lengthObj;
                jsonObj.put("conditionlength", (Object)length);
            }
            if (!SWCObjectUtils.isEmpty((Object)(currencyObj = conditionObj.getDynamicObject("conditioncurrency")))) {
                Integer amtPrecision = currencyObj.getInt("amtprecision");
                String id = currencyObj.getString("id");
                jsonObj.put("conditioncurrency", (Object)id);
                jsonObj.put("amtPrecision", (Object)amtPrecision);
            }
            if (!SWCObjectUtils.isEmpty((Object)(conditionIdObj = conditionObj.get("conditionid")))) {
                String conditionId = (String)conditionIdObj;
                jsonObj.put("conditionid", (Object)conditionId);
            }
            dataArray.add((Object)jsonObj);
        }
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put("conditiondatas", (Object)dataArray.toJSONString());
        ISWCAppCache appCache = SWCAppCache.get((String)"hsas_datagrade_appcache");
        String pageId = this.getView().getPageId();
        appCache.put(pageId + "_conditionentry", (Object)dataArray.toJSONString());
    }

    private void setResultCache(DynamicObjectCollection resultDatas) {
        if (SWCObjectUtils.isEmpty((Object)resultDatas) || resultDatas.size() == 0) {
            return;
        }
        int size = resultDatas.size();
        JSONArray dataArray = new JSONArray(size);
        DataGradeHelper helper = new DataGradeHelper();
        for (DynamicObject resultObj : resultDatas) {
            Object defValObj;
            Object resultIdObj;
            DynamicObject currencyObj;
            Object lengthObj;
            Object accuracyObj;
            DynamicObject valTypeObj;
            JSONObject jsonObj = new JSONObject();
            Object nameObj = resultObj.get("resultitemname");
            if (!SWCObjectUtils.isEmpty((Object)nameObj)) {
                OrmLocaleValue localObj = (OrmLocaleValue)nameObj;
                String resultName = localObj.getLocaleValue();
                jsonObj.put("resultitemname", (Object)resultName);
            }
            if (!SWCObjectUtils.isEmpty((Object)(valTypeObj = resultObj.getDynamicObject("resultvaltype")))) {
                String number = valTypeObj.getString("number");
                String valueType = helper.getValueTypeDesc(number);
                jsonObj.put("number", (Object)number);
                jsonObj.put("valueType", (Object)valueType);
                String id = valTypeObj.getString("id");
                jsonObj.put("resultvaltype", (Object)id);
            }
            if (!SWCObjectUtils.isEmpty((Object)(accuracyObj = resultObj.get("resultaccuracy")))) {
                String accuracy = (String)accuracyObj;
                jsonObj.put("resultaccuracy", (Object)accuracy);
            }
            if (!SWCObjectUtils.isEmpty((Object)(lengthObj = resultObj.get("resultlength")))) {
                int length = (Integer)lengthObj;
                jsonObj.put("resultlength", (Object)length);
            }
            if (!SWCObjectUtils.isEmpty((Object)(currencyObj = resultObj.getDynamicObject("resultcurrency")))) {
                Integer amtPrecision = currencyObj.getInt("amtprecision");
                String id = currencyObj.getString("id");
                jsonObj.put("resultcurrency", (Object)id);
                jsonObj.put("amtPrecision", (Object)amtPrecision);
            }
            if (!SWCObjectUtils.isEmpty((Object)(resultIdObj = resultObj.get("resultid")))) {
                String resultId = (String)resultIdObj;
                jsonObj.put("resultid", (Object)resultId);
            }
            if (!SWCObjectUtils.isEmpty((Object)(defValObj = resultObj.get("resultdefaultval")))) {
                String defVal = (String)defValObj;
                jsonObj.put("resultdefaultval", (Object)defVal);
            }
            dataArray.add((Object)jsonObj);
        }
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put("resultdatas", (Object)dataArray.toJSONString());
        ISWCAppCache appCache = SWCAppCache.get((String)"hsas_datagrade_appcache");
        String pageId = this.getView().getPageId();
        appCache.put(pageId + "_resultentry", (Object)dataArray.toJSONString());
    }

    protected void setConditionAndResultFieldInfo(DynamicObjectCollection conditionDatas, DynamicObjectCollection resultDatas) {
        String fieldName;
        String valueType;
        String number;
        DynamicObject valTypeObj;
        String id;
        ArrayList<String> fieldInfo = new ArrayList<String>(10);
        DataGradeHelper helper = new DataGradeHelper();
        if (conditionDatas != null && conditionDatas.size() > 0) {
            for (DynamicObject dataObj : conditionDatas) {
                id = dataObj.getString("conditionid");
                valTypeObj = dataObj.getDynamicObject("conditionvaltype");
                number = valTypeObj.getString("number");
                valueType = helper.getValueTypeDesc(number);
                fieldInfo.add("condition-" + valueType + "-" + id);
                fieldName = dataObj.getString("conditionitemname");
                fieldInfo.add(fieldName);
            }
        }
        if (resultDatas != null && resultDatas.size() > 0) {
            for (DynamicObject dataObj : resultDatas) {
                id = dataObj.getString("resultid");
                valTypeObj = dataObj.getDynamicObject("resultvaltype");
                number = valTypeObj.getString("number");
                valueType = helper.getValueTypeDesc(number);
                fieldInfo.add("result-" + valueType + "-" + id);
                fieldName = dataObj.getString("resultitemname");
                fieldInfo.add(fieldName);
            }
        }
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put("conditionAndResultFieldInfo", fieldInfo);
    }
}

