/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.datagrade;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.datagrade.enums.DataGradeValueTypeEnum;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.util.StringCheckUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class DataGradeResultPlugin
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCLE = "btncancel";
    private static final String[] DECIMAL_FIELD_YES = new String[]{"decimalvalue", "resultaccuracy"};
    private static final String[] DECIMAL_FIELD_NO = new String[]{"resultlength", "textvalue", "integervalue", "datevalue", "amountvalue", "resultcurrency"};
    private static final String[] DECIMAL_NULL_FIELD = new String[]{"decimalvalue", "resultlength", "textvalue", "integervalue", "datevalue", "amountvalue", "resultcurrency"};
    private static final String[] TEXT_FIELD_YES = new String[]{"textvalue", "resultlength"};
    private static final String[] TEXT_FIELD_NO = new String[]{"resultaccuracy", "decimalvalue", "integervalue", "datevalue", "amountvalue", "resultcurrency"};
    private static final String[] TEXT_NULL_FIELD = new String[]{"decimalvalue", "resultaccuracy", "textvalue", "integervalue", "datevalue", "amountvalue", "resultcurrency"};
    private static final String[] AMOUNT_FIELD_YES = new String[]{"amountvalue", "resultcurrency"};
    private static final String[] AMOUNT_FIELD_NO = new String[]{"resultaccuracy", "resultlength", "integervalue", "datevalue", "decimalvalue", "textvalue"};
    private static final String[] AMOUNT_NULL_FIELD = new String[]{"decimalvalue", "resultaccuracy", "textvalue", "integervalue", "datevalue", "amountvalue"};
    private static final String[] INTEGER_FIELD_YES = new String[]{"integervalue"};
    private static final String[] INTEGER_FIELD_NO = new String[]{"resultaccuracy", "resultlength", "amountvalue", "datevalue", "decimalvalue", "textvalue", "resultcurrency"};
    private static final String[] INTEGER_NULL_FIELD = new String[]{"decimalvalue", "resultaccuracy", "textvalue", "integervalue", "datevalue", "amountvalue", "resultcurrency"};
    private static final String[] DATE_FIELD_YES = new String[]{"datevalue"};
    private static final String[] DATE_FIELD_NO = new String[]{"resultaccuracy", "resultlength", "amountvalue", "integervalue", "decimalvalue", "textvalue", "resultcurrency"};
    private static final String[] DATE_NULL_FIELD = new String[]{"decimalvalue", "resultaccuracy", "textvalue", "integervalue", "datevalue", "amountvalue", "resultcurrency"};
    private static final String[] UNENABLE_EDIT_FIELD = new String[]{"resultitemname", "resultvaltype", "resultaccuracy", "resultlength", "resultcurrency"};
    private static final String RESULT_VAL_TYPE = "resultvaltype";
    private static final String RESULT_ITEM_NAME = "resultitemname";
    private static final String TEXT_DFT_VAL = "textvalue";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCLE});
        BasedataEdit resultValType = (BasedataEdit)this.getView().getControl(RESULT_VAL_TYPE);
        resultValType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        JSONObject editObj;
        boolean isHisPage = BaseDataHisHelper.isHisPage((IFormView)this.getView().getParentView());
        if (isHisPage) {
            this.getView().setEnable(Boolean.FALSE, UNENABLE_EDIT_FIELD);
        }
        if (SWCObjectUtils.isEmpty((Object)(editObj = (JSONObject)this.getView().getFormShowParameter().getCustomParam("params"))) || editObj.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"integervalue"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"decimalvalue"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"amountvalue"});
            this.getView().setVisible(Boolean.FALSE, new String[]{TEXT_DFT_VAL});
            this.getView().setVisible(Boolean.FALSE, new String[]{"datevalue"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"resultaccuracy"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"resultlength"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"resultcurrency"});
        } else {
            String fieldName = editObj.getString(RESULT_ITEM_NAME);
            this.getModel().setValue(RESULT_ITEM_NAME, (Object)fieldName);
            String id = editObj.getString(RESULT_VAL_TYPE);
            this.getModel().setValue(RESULT_VAL_TYPE, (Object)id);
            String resultId = editObj.getString("resultId");
            this.getModel().setValue("resultid", (Object)resultId);
            String valType = editObj.getString("valueType");
            if (SWCStringUtils.equals((String)DataGradeValueTypeEnum.DECIMAL.getDesc(), (String)valType)) {
                String defVal;
                this.getView().setVisible(Boolean.FALSE, new String[]{"integervalue"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"decimalvalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"amountvalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{TEXT_DFT_VAL});
                this.getView().setVisible(Boolean.FALSE, new String[]{"datevalue"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"resultaccuracy"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"resultlength"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"resultcurrency"});
                String accuracy = editObj.getString("accuracy");
                if (SWCStringUtils.isNotEmpty((String)accuracy)) {
                    this.getModel().setValue("resultaccuracy", (Object)accuracy);
                }
                if (SWCStringUtils.isNotEmpty((String)(defVal = editObj.getString("defVal")))) {
                    this.getModel().setValue("decimalvalue", (Object)defVal);
                }
            } else if (SWCStringUtils.equals((String)DataGradeValueTypeEnum.INTEGER.getDesc(), (String)valType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"integervalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"decimalvalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"amountvalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{TEXT_DFT_VAL});
                this.getView().setVisible(Boolean.FALSE, new String[]{"datevalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"resultaccuracy"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"resultlength"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"resultcurrency"});
                String defVal = editObj.getString("defVal");
                if (SWCStringUtils.isNotEmpty((String)defVal)) {
                    this.getModel().setValue("integervalue", (Object)defVal);
                }
            } else if (SWCStringUtils.equals((String)DataGradeValueTypeEnum.AMOUNT.getDesc(), (String)valType)) {
                String defVal;
                this.getView().setVisible(Boolean.FALSE, new String[]{"integervalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"decimalvalue"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"amountvalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{TEXT_DFT_VAL});
                this.getView().setVisible(Boolean.FALSE, new String[]{"datevalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"resultaccuracy"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"resultlength"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"resultcurrency"});
                String currency = editObj.getString("currency");
                if (SWCStringUtils.isNotEmpty((String)currency)) {
                    this.getModel().setValue("resultcurrency", (Object)currency);
                }
                if (SWCStringUtils.isNotEmpty((String)(defVal = editObj.getString("defVal")))) {
                    this.getModel().setValue("amountvalue", (Object)defVal);
                }
            } else if (SWCStringUtils.equals((String)DataGradeValueTypeEnum.TEXT.getDesc(), (String)valType)) {
                String defVal;
                this.getView().setVisible(Boolean.FALSE, new String[]{"integervalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"decimalvalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"amountvalue"});
                this.getView().setVisible(Boolean.TRUE, new String[]{TEXT_DFT_VAL});
                this.getView().setVisible(Boolean.FALSE, new String[]{"datevalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"resultaccuracy"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"resultlength"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"resultcurrency"});
                Integer length = editObj.getInteger("length");
                if (length != null) {
                    this.getModel().setValue("resultlength", (Object)length);
                }
                if (SWCStringUtils.isNotEmpty((String)(defVal = editObj.getString("defVal")))) {
                    this.getModel().setValue(TEXT_DFT_VAL, (Object)defVal);
                }
            } else if (SWCStringUtils.equals((String)DataGradeValueTypeEnum.DATE.getDesc(), (String)valType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"integervalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"decimalvalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"amountvalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{TEXT_DFT_VAL});
                this.getView().setVisible(Boolean.TRUE, new String[]{"datevalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"resultaccuracy"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"resultlength"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"resultcurrency"});
                String defVal = editObj.getString("defVal");
                if (SWCStringUtils.isNotEmpty((String)defVal)) {
                    this.getModel().setValue("datevalue", (Object)defVal);
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey;
        switch (fieldKey = event.getProperty().getName()) {
            case "resultvaltype": {
                this.conditionValTypeF7Click(event);
                break;
            }
        }
    }

    private void conditionValTypeF7Click(BeforeF7SelectEvent event) {
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        formShowParameter.setMultiSelect(false);
        String matchMethod = (String)this.getView().getParentView().getModel().getValue("matchmethod");
        if (SWCStringUtils.equals((String)matchMethod, (String)"2")) {
            QFilter filter = new QFilter("number", "=", (Object)DataGradeValueTypeEnum.DECIMAL.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.AMOUNT.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.INTEGER.getCode());
            formShowParameter.getListFilterParameter().getQFilters().add(filter);
        } else if (SWCStringUtils.equals((String)matchMethod, (String)"5")) {
            QFilter filter = new QFilter("number", "=", (Object)DataGradeValueTypeEnum.DECIMAL.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.AMOUNT.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.INTEGER.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.DATE.getCode());
            formShowParameter.getListFilterParameter().getQFilters().add(filter);
        } else if (SWCStringUtils.equals((String)matchMethod, (String)"1")) {
            QFilter filter = new QFilter("number", "=", (Object)DataGradeValueTypeEnum.DECIMAL.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.AMOUNT.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.TEXT.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.INTEGER.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.DATE.getCode());
            formShowParameter.getListFilterParameter().getQFilters().add(filter);
        } else if (SWCStringUtils.equals((String)matchMethod, (String)"4") || SWCStringUtils.equals((String)matchMethod, (String)"3")) {
            QFilter filter = new QFilter("number", "=", (Object)DataGradeValueTypeEnum.DECIMAL.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.AMOUNT.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.TEXT.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.INTEGER.getCode());
            filter.or("number", "=", (Object)DataGradeValueTypeEnum.DATE.getCode());
            formShowParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String optKey;
        switch (optKey = e.getProperty().getName()) {
            case "resultvaltype": {
                this.changeFieldByValType();
                break;
            }
            case "resultitemname": {
                this.checkSpecialChar(e);
                this.checkResultNameAndSetId();
                break;
            }
        }
    }

    private void checkSpecialChar(PropertyChangedArgs e) {
        OrmLocaleValue nameObj = (OrmLocaleValue)this.getModel().getValue(RESULT_ITEM_NAME);
        String fieldName = nameObj.getLocaleValue();
        if (StringCheckUtils.checkIsContainSpecialChar((String)fieldName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u679c\u540d\u79f0\u5b58\u5728\u7279\u6b8a\u5b57\u7b26\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"DataGradeResultPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(RESULT_ITEM_NAME, null);
            this.getModel().setValue("resultid", null);
            return;
        }
    }

    private void checkResultNameAndSetId() {
        DynamicObjectCollection datas = this.getView().getParentView().getModel().getEntryEntity("resultentryidentify");
        OrmLocaleValue nameObj = (OrmLocaleValue)this.getModel().getValue(RESULT_ITEM_NAME);
        String fieldName = nameObj.getLocaleValue();
        if (SWCStringUtils.isEmpty((String)fieldName)) {
            return;
        }
        for (int i = 0; i < datas.size(); ++i) {
            DynamicObject obj = (DynamicObject)datas.get(i);
            String conditionName = obj.getString(RESULT_ITEM_NAME);
            if (!SWCStringUtils.equals((String)fieldName, (String)conditionName)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u4e0e\u5df2\u6709\u7ed3\u679c\u540d\u79f0\u540c\u540d\u3002", (String)"DataGradeResultPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(RESULT_ITEM_NAME, null);
            this.getModel().setValue("resultid", null);
            return;
        }
        String resultId = (String)this.getModel().getValue("resultid");
        if (SWCStringUtils.isEmpty((String)resultId)) {
            Long currentTimes = System.currentTimeMillis();
            this.getModel().setValue("resultid", (Object)String.valueOf(currentTimes));
        }
    }

    private void changeFieldByValType() {
        DynamicObject valTypeObj = (DynamicObject)this.getModel().getValue(RESULT_VAL_TYPE);
        if (SWCObjectUtils.isEmpty((Object)valTypeObj)) {
            return;
        }
        String number = valTypeObj.getString("number");
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
            this.getModel().setValue("resultaccuracy", (Object)"2");
            this.setFieldVisiableAndSetNull(DECIMAL_FIELD_YES, DECIMAL_FIELD_NO, DECIMAL_NULL_FIELD);
        } else if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.TEXT.getCode())) {
            this.getModel().setValue("resultlength", (Object)200);
            this.setFieldVisiableAndSetNull(TEXT_FIELD_YES, TEXT_FIELD_NO, TEXT_NULL_FIELD);
        } else if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) {
            this.setFieldVisiableAndSetNull(AMOUNT_FIELD_YES, AMOUNT_FIELD_NO, AMOUNT_NULL_FIELD);
        } else if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.INTEGER.getCode())) {
            this.setFieldVisiableAndSetNull(INTEGER_FIELD_YES, INTEGER_FIELD_NO, INTEGER_NULL_FIELD);
        } else if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DATE.getCode())) {
            this.setFieldVisiableAndSetNull(DATE_FIELD_YES, DATE_FIELD_NO, DATE_NULL_FIELD);
        }
    }

    private void setFieldVisiableAndSetNull(String[] fieldYes, String[] fieldNo, String[] nullField) {
        for (String key : fieldYes) {
            this.getView().setVisible(Boolean.TRUE, new String[]{key});
        }
        for (String key : fieldNo) {
            this.getView().setVisible(Boolean.FALSE, new String[]{key});
        }
        for (String key : nullField) {
            this.getModel().setValue(key, null);
        }
    }

    public void click(EventObject evt) {
        String clickedKey;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (clickedKey = source.getKey()) {
            case "btnok": {
                Date date;
                OrmLocaleValue nameObj = (OrmLocaleValue)this.getModel().getValue(RESULT_ITEM_NAME);
                if (SWCObjectUtils.isEmpty((Object)nameObj) || nameObj.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u679c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataGradeResultPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    break;
                }
                DynamicObject valTypeObj = (DynamicObject)this.getModel().getValue(RESULT_VAL_TYPE);
                if (SWCObjectUtils.isEmpty((Object)valTypeObj)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataGradeResultPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    break;
                }
                String valTypeNum = valTypeObj.getString("number");
                if (SWCStringUtils.equals((String)valTypeNum, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
                    String accuracy = (String)this.getModel().getValue("resultaccuracy");
                    if (SWCStringUtils.isEmpty((String)accuracy)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u7cbe\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataGradeResultPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                        break;
                    }
                } else if (SWCStringUtils.equals((String)valTypeNum, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) {
                    DynamicObject currencyObj = (DynamicObject)this.getModel().getValue("resultcurrency");
                    if (SWCObjectUtils.isEmpty((Object)currencyObj)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataGradeResultPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                        break;
                    }
                } else if (SWCStringUtils.equals((String)valTypeNum, (String)DataGradeValueTypeEnum.TEXT.getCode())) {
                    Integer length = (Integer)this.getModel().getValue("resultlength");
                    if (SWCObjectUtils.isEmpty((Object)length)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataGradeResultPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    String textDefVal = (String)this.getModel().getValue(TEXT_DFT_VAL);
                    if (SWCStringUtils.isNotEmpty((String)textDefVal) && textDefVal.length() > length) {
                        String msg = MessageFormat.format(ResManager.loadKDString((String)"\u5df2\u8d85\u8fc7\u5f53\u524d\u6570\u636e\u957f\u5ea6\u9650\u5236\uff1a{0}\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u540e\u91cd\u65b0\u8f93\u5165\u9ed8\u8ba4\u503c\u3002", (String)"DataGradeResultPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]), length);
                        this.getView().showTipNotification(msg);
                        break;
                    }
                }
                HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
                returnMap.put("resultName", nameObj.getLocaleValue());
                returnMap.put("valueTypeId", valTypeObj.getString("id"));
                if (SWCStringUtils.equals((String)valTypeNum, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
                    String accuracy = (String)this.getModel().getValue("resultaccuracy");
                    returnMap.put("accuracy", accuracy);
                    BigDecimal decimal = (BigDecimal)this.getModel().getValue("decimalvalue");
                    if (decimal != null) {
                        decimal = decimal.setScale(Integer.parseInt(accuracy), 4);
                        returnMap.put("defaultValue", decimal.toPlainString());
                    }
                } else if (SWCStringUtils.equals((String)valTypeNum, (String)DataGradeValueTypeEnum.TEXT.getCode())) {
                    Integer length = (Integer)this.getModel().getValue("resultlength");
                    returnMap.put("length", length);
                    String text = (String)this.getModel().getValue(TEXT_DFT_VAL);
                    returnMap.put("defaultValue", text);
                } else if (SWCStringUtils.equals((String)valTypeNum, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) {
                    DynamicObject currencyObj = (DynamicObject)this.getModel().getValue("resultcurrency");
                    String currencyId = currencyObj.getString("id");
                    Integer amtPrecision = currencyObj.getInt("amtprecision");
                    BigDecimal amount = (BigDecimal)this.getModel().getValue("amountvalue");
                    if (amount != null) {
                        returnMap.put("defaultValue", amount.setScale((int)amtPrecision, RoundingMode.HALF_UP).toString());
                    }
                    returnMap.put("currencyId", currencyId);
                } else if (SWCStringUtils.equals((String)valTypeNum, (String)DataGradeValueTypeEnum.INTEGER.getCode())) {
                    Integer defaultVal = (Integer)this.getModel().getValue("integervalue");
                    if (defaultVal != null) {
                        returnMap.put("defaultValue", String.valueOf(defaultVal));
                    }
                } else if (SWCStringUtils.equals((String)valTypeNum, (String)DataGradeValueTypeEnum.DATE.getCode()) && (date = (Date)this.getModel().getValue("datevalue")) != null) {
                    returnMap.put("defaultValue", SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd"));
                }
                JSONObject editObj = (JSONObject)this.getView().getFormShowParameter().getCustomParam("params");
                if (editObj != null && editObj.size() > 0) {
                    Integer index = editObj.getInteger("index");
                    returnMap.put("index", index);
                }
                String resultId = (String)this.getModel().getValue("resultid");
                returnMap.put("resultId", resultId);
                this.getView().returnDataToParent(returnMap);
                this.getView().close();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }
}

