/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.file.sidebar;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.file.FileSidebarService;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryFileMultiSidePlugin
extends AbstractFormPlugin {
    private static final String TAB_NEW = "donothing_new";
    private static final String OP_REFRESH = "donothing_refresh";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "donothing_refresh": {
                Boolean isShowLogicDelete = (Boolean)this.getModel().getValue("isshowlogicdelete");
                this.createAndEmbedList(isShowLogicDelete);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Boolean isShowLogicDelete = (Boolean)this.getModel().getValue("isshowlogicdelete");
        if (null != isShowLogicDelete) {
            this.createAndEmbedList(isShowLogicDelete);
        }
    }

    private void createAndEmbedList(boolean isShowLogicDelete) {
        IFormView view = this.getView();
        String pageName = (String)view.getFormShowParameter().getCustomParam("currentRelatePage");
        if (!SWCStringUtils.isEmpty((String)pageName)) {
            QFilter qFilter = this.getQFilter(view, isShowLogicDelete);
            String pageKey = pageName;
            FlexPanelAp flexPanelAp = FileSidebarService.createFlexpanelAp((QFilter[])new QFilter[]{qFilter}, (String)pageName, (String)pageKey, (String)"panelconstant");
            view.updateControlMetadata("panelconstant", flexPanelAp.createControl());
            FileSidebarService.showEntryHisPage((IFormView)view, (String)pageName, (String)"panelconstant");
        }
    }

    private QFilter getQFilter(IFormView view, boolean isShowLogicDelete) {
        QFilter qFilter = null;
        Object salaryFileObj = view.getParentView().getModel().getValue("salaryfile");
        if (null != salaryFileObj) {
            qFilter = new QFilter("salaryfile", "=", ((DynamicObject)salaryFileObj).get("id"));
            BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
            if (!isShowLogicDelete) {
                qFilter.and(new QFilter("datastatus", "!=", (Object)"-2"));
            }
        }
        return qFilter;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (SWCStringUtils.equals((String)"isshowlogicdelete", (String)e.getProperty().getName())) {
            this.createAndEmbedList((Boolean)e.getChangeSet()[0].getNewValue());
        }
    }
}

