/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.file.sidebar;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.person.PersonHelper;
import kd.swc.hsas.business.salaryfile.DefaultEmptyPage;
import kd.swc.hsas.business.salaryfile.SalaryTaxFileRelServiceHelper;
import kd.swc.hsas.common.enums.DefaultEmptyPageEnum;
import kd.swc.hsas.common.utils.BaseResult;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryTaxFileRelPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(SalaryTaxFileRelPlugin.class);
    private static final String FLEX_LIST = "contentlistflexpanelap";
    private static final String FLEX_EMPTY = "contentemptyflexpanelap";
    public static final String TOOL_BAR_AP = "toolbarap";
    public static final String BAR_REFRESH = "bar_refresh";
    public static final String BAR_NEW = "donothing_new";
    public static final String BAR_DELETE = "donothing_del";
    public static final String BAR_MODIFY = "donothing_modify";
    private static final String IS_SHOW_EXPIRE = "isShowExpire";
    public static final String ITC_TAX_FILE_F7_ADD = "itc_taxfilef7_add";
    public static final String ITC_TAX_FILE_F7_MODIFY = "itc_taxfilef7_modify";
    public static final String CONFIRM_BTN_CANCEL = "Cancel";
    public static final String HSAS_SALARY_TAX_FILE_REL_DELETE = "hsas_salarytaxfilerel_delete";
    public static final String SWC_HSAS_FORM_PLUGIN = "swc-hsas-formplugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BAR_AP});
    }

    public void beforeBindData(EventObject e) {
        this.showFormView();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("isshowexpire".equals(e.getProperty().getName())) {
            this.showFormView();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows;
        IListView listView;
        DynamicObject salaryFile;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String itemKey = operate.getOperateKey();
        IFormView view = this.getView();
        if (BAR_REFRESH.equals(itemKey)) {
            this.showFormView();
            return;
        }
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && "hsas_empfilerelateinfo".equals(parentView.getEntityId())) {
            DynamicObject dataEntity = parentView.getModel().getDataEntity();
            salaryFile = dataEntity.getDynamicObject("salaryfile");
        } else {
            parentView = this.getView();
            salaryFile = this.getSalaryFileFromParam();
        }
        if (salaryFile == null) {
            parentView.showTipNotification(ResManager.loadKDString((String)"\u8be5\u6863\u6848\u5df2\u88ab\u5220\u9664\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"SalaryFileTaxAddNewPlugin_35", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(parentView);
            return;
        }
        SWCDataServiceHelper dataServiceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObject person = (salaryFile = dataServiceHelper.generateDynamicObject((Object)salaryFile.getLong("id"), "id,name,masterid,payrollregion,status,bsed,bsled,person")).getDynamicObject("person");
        if (person == null) {
            parentView.showTipNotification(ResManager.loadKDString((String)"\u8be5\u6863\u6848\u5bf9\u5e94\u7684\u8ba1\u85aa\u4eba\u5458\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"SalaryFileTaxAddNewPlugin_36", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(parentView);
            return;
        }
        if ("E".equals(salaryFile.get("status"))) {
            parentView.showTipNotification(ResManager.loadKDString((String)"\u8be5\u6863\u6848\u5df2\u5e9f\u5f03\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"SalaryFileTaxAddNewPlugin_13", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(parentView);
            return;
        }
        if (BAR_NEW.equals(itemKey)) {
            this.openTaxFileF7(salaryFile, person, null);
            return;
        }
        SWCPageCache pageCache = new SWCPageCache(view);
        String flexListId = (String)this.getView().getFormShowParameter().getCustomParam(FLEX_LIST);
        if (SWCStringUtils.isEmpty((String)flexListId) || (listView = (IListView)view.getView(flexListId)) == null || CollectionUtils.isEmpty((Collection)(selectedRows = listView.getSelectedRows()))) {
            parentView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SalaryFileTaxAddNewPlugin_37", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(parentView);
            return;
        }
        if (BAR_DELETE.equals(itemKey)) {
            this.showDeleteConfirmMessage(salaryFile, selectedRows);
            return;
        }
        if (BAR_MODIFY.equals(itemKey)) {
            if (selectedRows.size() > 1) {
                parentView.showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u4fee\u6539\u64cd\u4f5c\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"SalaryFileTaxAddNewPlugin_15", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]));
                this.getView().sendFormAction(parentView);
                return;
            }
            this.openTaxFileF7(salaryFile, person, selectedRows.get(0).getPrimaryKeyValue());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "itc_taxfilef7_add": 
            case "itc_taxfilef7_modify": {
                String opName;
                ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                if (CollectionUtils.isEmpty((Collection)returnData)) {
                    return;
                }
                IFormView parentView = this.getView().getParentView();
                Long salaryFile = null;
                if (parentView != null && "hsas_empfilerelateinfo".equals(parentView.getEntityId())) {
                    DynamicObject dataEntity = parentView.getModel().getDataEntity();
                    salaryFile = dataEntity.getLong("salaryfile.id");
                } else {
                    Map customVariables = (Map)this.getView().getFormShowParameter().getCustomParam("customvariables");
                    salaryFile = Long.parseLong(String.valueOf(customVariables.get("salaryfileid")));
                }
                SWCDataServiceHelper dataServiceHelper = new SWCDataServiceHelper("hsas_salaryfile");
                Long oldRelId = null;
                String opKey = null;
                if (ITC_TAX_FILE_F7_MODIFY.equals(actionId)) {
                    oldRelId = Long.valueOf(this.getPageCache().get("oldRelId"));
                    opName = ResManager.loadKDString((String)"\u53d8\u66f4\u5173\u8054\u5173\u7cfb", (String)"SalaryTaxFileRelPlugin_1", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]);
                    opKey = BAR_MODIFY;
                } else {
                    opName = ResManager.loadKDString((String)"\u65b0\u589e\u5173\u8054\u5173\u7cfb", (String)"SalaryTaxFileRelPlugin_2", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]);
                    opKey = BAR_NEW;
                }
                Long taxFile = (Long)returnData.get(0).getPrimaryKeyValue();
                BaseResult result = SalaryTaxFileRelServiceHelper.relateSalaryWithTaxFile((Long)taxFile, (Long)salaryFile, (Long)oldRelId);
                if (!result.isSuccess()) {
                    log.error("SalaryTaxFileRelPlugin.closedCallBack,opName:{},Message:{}", (Object)opName, (Object)result.getMessage());
                    this.getView().showErrorNotification(result.getMessage());
                    break;
                }
                if (ITC_TAX_FILE_F7_MODIFY.equals(actionId)) {
                    this.clearRelSelection();
                }
                SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)opKey, null, (MultiLangEnumBridge)new MultiLangEnumBridge("{0}\u6210\u529f", "SalaryTaxFileRelPlugin_3", SWC_HSAS_FORM_PLUGIN), (String[])new String[]{opName});
                this.showFormView();
                break;
            }
        }
    }

    public void clearRelSelection() {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String flexListId = (String)pageCache.get(FLEX_LIST, String.class);
        IListView listView = (IListView)this.getView().getView(flexListId);
        if (listView != null) {
            listView.clearSelection();
            this.getView().sendFormAction((IFormView)listView);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String resultValue = messageBoxClosedEvent.getResultValue();
        if (CONFIRM_BTN_CANCEL.equals(resultValue)) {
            return;
        }
        if (HSAS_SALARY_TAX_FILE_REL_DELETE.equals(messageBoxClosedEvent.getCallBackId())) {
            String opName = ResManager.loadKDString((String)"\u5220\u9664", (String)"SalaryTaxFileRelPlugin_0", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]);
            List deleteRelIds = JSONArray.parseArray((String)this.getPageCache().get("deleteRelIds"), Long.class);
            if (CollectionUtils.isEmpty((Collection)deleteRelIds)) {
                return;
            }
            BaseResult result = SalaryTaxFileRelServiceHelper.deleteSalaryTaxFileRel((List)deleteRelIds);
            if (!result.isSuccess()) {
                log.error("SalaryTaxFileRelPlugin.confirmCallBack,opName:{},Message:{}", (Object)opName, (Object)result.getMessage());
                this.getView().showErrorNotification(result.getMessage());
            } else {
                this.clearRelSelection();
                this.showFormView();
                SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)BAR_DELETE, null, (MultiLangEnumBridge)new MultiLangEnumBridge("{0}\u6210\u529f", "SalaryTaxFileRelPlugin_3", SWC_HSAS_FORM_PLUGIN), (String[])new String[]{opName});
            }
        }
    }

    private DynamicObject getPersonFileFromParam() {
        Long personId = PersonHelper.getPersonId((IFormView)this.getView());
        if (personId != null) {
            SWCDataServiceHelper dataServiceHelper = new SWCDataServiceHelper("hsas_person");
            return dataServiceHelper.loadSingle((Object)personId);
        }
        return null;
    }

    private DynamicObject getSalaryFileFromParam() {
        Object pk;
        Map customVariables = (Map)this.getView().getFormShowParameter().getCustomParam("customvariables");
        if (customVariables != null && (pk = customVariables.get("salaryfileid")) != null) {
            SWCDataServiceHelper dataServiceHelper = new SWCDataServiceHelper("hsas_salaryfile");
            return dataServiceHelper.queryOne(pk);
        }
        return null;
    }

    private void showFormView() {
        DynamicObject salaryFileObj;
        boolean isShowExpire = this.getModel().getDataEntity().getBoolean(IS_SHOW_EXPIRE);
        String pageName = (String)this.getView().getFormShowParameter().getCustomParam("currentRelatePage");
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && "hsas_empfilerelateinfo".equals(parentView.getEntityId())) {
            salaryFileObj = parentView.getModel().getDataEntity().getDynamicObject("salaryfile");
        } else {
            salaryFileObj = this.getSalaryFileFromParam();
            parentView = this.getView();
        }
        if (salaryFileObj == null) {
            parentView.showTipNotification(ResManager.loadKDString((String)"\u8be5\u6863\u6848\u5df2\u5e9f\u5f03\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"SalaryFileTaxAddNewPlugin_13", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(parentView);
            return;
        }
        IFormView view = this.getView();
        if (this.isContainData(pageName, salaryFileObj, isShowExpire)) {
            this.showTargetList(pageName, salaryFileObj, isShowExpire);
            view.setVisible(Boolean.FALSE, new String[]{FLEX_EMPTY});
            view.setVisible(Boolean.TRUE, new String[]{FLEX_LIST});
        } else {
            this.showEmptyPage();
            view.setVisible(Boolean.FALSE, new String[]{FLEX_LIST});
            view.setVisible(Boolean.TRUE, new String[]{FLEX_EMPTY});
        }
    }

    private boolean isContainData(String pageName, DynamicObject salaryFileObj, boolean isStopTax) {
        List<QFilter> qFilters = this.getListFilters(pageName, salaryFileObj, isStopTax);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(pageName);
        return serviceHelper.isExists(qFilters.toArray(new QFilter[0]));
    }

    private List<QFilter> getListFilters(String pageName, DynamicObject salaryFileObj, boolean isShowLogicDelete) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter("salaryfile.id", "=", salaryFileObj.get("id")));
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        return qFilters;
    }

    private void showTargetList(String pageName, DynamicObject salaryFileObj, boolean isStopTax) {
        IFormView view = this.getView();
        if (!SWCStringUtils.isEmpty((String)pageName) && null != salaryFileObj) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(FLEX_LIST);
            showParameter.setFormId("hsbp_nosearch_list");
            showParameter.setBillFormId(pageName);
            showParameter.setLookUp(false);
            showParameter.setCustomParam("nofilter", (Object)Boolean.TRUE);
            showParameter.setCustomParam("regionId", (Object)salaryFileObj.getLong("payrollregion.id"));
            showParameter.setCustomParam("isShowStopTax", (Object)isStopTax);
            List<QFilter> qFilters = this.getListFilters(pageName, salaryFileObj, isStopTax);
            ListFilterParameter filterParams = showParameter.getListFilterParameter();
            filterParams.setQFilters(qFilters);
            filterParams.setOrderBy("createtime asc");
            view.showForm((FormShowParameter)showParameter);
            SWCPageCache pageCache = new SWCPageCache(view);
            pageCache.put(FLEX_LIST, (Object)showParameter.getPageId());
            view.getFormShowParameter().setCustomParam(FLEX_LIST, (Object)showParameter.getPageId());
            view.cacheFormShowParameter();
        }
    }

    private void showEmptyPage() {
        IFormView view = this.getView();
        DefaultEmptyPage defaultEmptyPage = new DefaultEmptyPage(DefaultEmptyPageEnum.VIEW_DATA_PAGE_TYPE, FLEX_EMPTY, ShowType.InContainer);
        view.showForm(defaultEmptyPage.getFormShowParameter());
    }

    public void openTaxFileF7(DynamicObject salaryFile, DynamicObject person, Object primaryKeyValue) {
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)"hsas_taxfilef7", (boolean)false);
        if (primaryKeyValue != null) {
            showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ITC_TAX_FILE_F7_MODIFY));
            this.getPageCache().put("oldRelId", String.valueOf(primaryKeyValue));
        } else {
            showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ITC_TAX_FILE_F7_ADD));
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_salarytaxfilerel");
        ArrayList<QFilter> filtersRel = new ArrayList<QFilter>(2);
        filtersRel.add(new QFilter("salaryfile.id", "=", salaryFile.get("id")));
        filtersRel.add(new QFilter("status", "=", (Object)"C"));
        Object[] query = serviceHelper.query("taxfile", filtersRel.toArray(new QFilter[0]));
        if (!SWCArrayUtils.isEmpty((Object[])query)) {
            Long[] excludeIds = new Long[query.length];
            for (int i = 0; i < query.length; ++i) {
                excludeIds[i] = query[i].getLong("taxfile");
            }
            showListForm.setCustomParam("excludeIds", (Object)excludeIds);
        }
        showListForm.setCustomParam("regionId", salaryFile.get("payrollregion.id"));
        showListForm.setCustomParam("personId", person.get("id"));
        this.getView().showForm((FormShowParameter)showListForm);
    }

    private void showDeleteConfirmMessage(DynamicObject salaryFile, ListSelectedRowCollection selectedRows) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_salarytaxfilerel");
        QFilter[] filtersRel = new QFilter[3];
        filtersRel[0] = new QFilter("salaryfile.id", "=", salaryFile.get("id"));
        filtersRel[2] = new QFilter("status", "=", (Object)"C");
        Set deleteIds = selectedRows.stream().map(e -> (Long)e.getPrimaryKeyValue()).collect(Collectors.toSet());
        this.getPageCache().put("deleteRelIds", JSONArray.toJSONString(deleteIds));
        Object[] ids = serviceHelper.query("id", filtersRel);
        if (SWCArrayUtils.isEmpty((Object[])ids)) {
            String confirmMsg = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\uff1f", (String)"SalaryFileTaxAddNewPlugin_16", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]);
            this.getView().showConfirm(confirmMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(HSAS_SALARY_TAX_FILE_REL_DELETE));
            return;
        }
        Set existIds = Arrays.stream(ids).map(e -> e.getLong("id")).collect(Collectors.toSet());
        existIds.removeAll(deleteIds);
        if (existIds.isEmpty()) {
            String confirmMsg = ResManager.loadKDString((String)"\u5220\u9664\u8be5\u8bb0\u5f55\u540e\uff0c\u5f53\u524d\u85aa\u8d44\u6863\u6848\u5c06\u4e0d\u518d\u5173\u8054\u4efb\u4f55\u4e2a\u7a0e\u6863\u6848\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SalaryFileTaxAddNewPlugin_17", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]);
            this.getView().showConfirm(confirmMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(HSAS_SALARY_TAX_FILE_REL_DELETE));
            return;
        }
        String confirmMsg = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\uff1f", (String)"SalaryFileTaxAddNewPlugin_16", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]);
        this.getView().showConfirm(confirmMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(HSAS_SALARY_TAX_FILE_REL_DELETE));
    }
}

