/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.file.subpage;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.person.PersonHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCImageUrlUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PersonFilePreviewPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(PersonFilePreviewPlugin.class);
    private static final String LBL_NON_INSERT = "noninsertlbl";
    private static final String SELECT_PERSON_PROPS = "person.headsculpture, empnumber, person.name, person.id";
    private static final String SELECT_SALARY_FILE_PROPS = "status, salaryfile.status, payrollgroup, paystatus, empgroup, empposinfo,org,payrollregion,payrollgroup,salarycalcstyle,managingscope.managingscope.name, managingscope.id";
    private static final String SELECT_EMP_PROPS = "adminorg, position, job, company, startdate,postype,posstatus";
    private static final String SELECT_PERNON_TSPROP_PROPS = "gender,nationality.id";
    private static final String SELECT_EMP_JOB_REL_PROPS = "joblevel.name,jobgrade.name,startdate";
    private static final String SELECT_EMPENTREL_PROPS = "laborreltype,laborrelstatus,enddate,startdate";
    private static final String SWC_HSAS_FORM_PLUGIN = "swc-hsas-formplugin";

    public void beforeBindData(EventObject eventObject) {
        this.setTipsForPerson();
        FormShowParameter params = this.getView().getFormShowParameter();
        Long employeeId = PersonHelper.getPersonId((IFormView)this.getView());
        Object salaryFileId = params.getCustomParam("salaryfileid");
        Object salaryFileVId = params.getCustomParam("salaryFileVid");
        if (salaryFileVId instanceof Long && (Long)salaryFileVId != 0L) {
            salaryFileId = salaryFileVId;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"laborreltype", "laborrelstatus", "postype", "posstatus", "salarycalcstyle"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap1", "company", "vectorap2", "adminorg", "vectorap3", "positionlabelap", "vectorap4", "workplacelabelap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"labeltxt1", "labeltxt2", "labeltxt3", "labeltxt4"});
        if (null != employeeId) {
            DynamicObject employeeDyobj = this.getEmployeeDyobj(employeeId);
            DynamicObject salaryFileDyobj = this.getSalaryFileobj(salaryFileId);
            this.setFieldValue(employeeDyobj, salaryFileDyobj);
            this.setStatusImg(salaryFileDyobj.getString("salaryfile.status"));
        }
    }

    private void setTipsForPerson() {
        String vectKey = "vectorap1";
        this.setTips(vectKey, this.getControlName(vectKey));
        vectKey = "vectorap2";
        this.setTips(vectKey, this.getControlName(vectKey));
        vectKey = "vectorap3";
        this.setTips(vectKey, this.getControlName(vectKey));
        vectKey = "vectorap4";
        this.setTips(vectKey, this.getControlName(vectKey));
    }

    private String getControlName(String vectKey) {
        HashMap<String, String> controlNameMap = new HashMap<String, String>(16);
        String company = ResManager.loadKDString((String)"\u516c\u53f8", (String)"PersonFilePreviewPlugin_10", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]);
        String adminorg = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"PersonFilePreviewPlugin_11", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]);
        String position = ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"PersonFilePreviewPlugin_12", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]);
        String workplace = ResManager.loadKDString((String)"\u5e38\u9a7b\u5de5\u4f5c\u5730", (String)"PersonFilePreviewPlugin_13", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]);
        controlNameMap.put("vectorap1", company);
        controlNameMap.put("vectorap2", adminorg);
        controlNameMap.put("vectorap3", position);
        controlNameMap.put("vectorap4", workplace);
        return (String)controlNameMap.get(vectKey);
    }

    private void setTips(String vectKey, String content) {
        VectorAp vectorAp = new VectorAp();
        vectorAp.setKey(vectKey);
        Tips ctlTips = new Tips();
        ctlTips.setType("text");
        ctlTips.setContent(new LocaleString(content));
        ctlTips.setShowIcon(false);
        vectorAp.setCtlTips(ctlTips);
        this.getView().updateControlMetadata(vectKey, vectorAp.createControl());
    }

    private void setStatusImg(String status) {
        if (null != status) {
            switch (status) {
                case "A": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"savelabelap"});
                    break;
                }
                case "B": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"submitlabelap"});
                    break;
                }
                case "C": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"auditlabelap"});
                    break;
                }
                case "E": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"obsoletelabelap"});
                    break;
                }
            }
        }
    }

    private DynamicObject getEmployeeDyobj(Object employeeId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_employee");
        return serviceHelper.queryOne(SELECT_PERSON_PROPS, employeeId);
    }

    private DynamicObject getSalaryFileobj(Object salaryFileId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        return serviceHelper.queryOne(SELECT_SALARY_FILE_PROPS, salaryFileId);
    }

    private void setFieldValue(DynamicObject employeeDyobj, DynamicObject salaryFileDyobj) {
        if (null != employeeDyobj) {
            SWCDataServiceHelper managingScopeHelper;
            DynamicObject managingScopeObj;
            IFormView formView = this.getView();
            SWCDataServiceHelper pernonTspropHelper = new SWCDataServiceHelper("hsas_pernontsprop");
            QFilter personFilter = new QFilter("person", "=", (Object)employeeDyobj.getLong("person.id"));
            BaseDataHisHelper.addHisCurrFilter((QFilter)personFilter);
            personFilter.and("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
            SWCDataServiceHelper empentrelHelper = new SWCDataServiceHelper("hsas_empentrel");
            DynamicObject empentrelObj = empentrelHelper.queryOne(SELECT_EMPENTREL_PROPS, new QFilter[]{personFilter}, "enddate desc, startdate desc");
            if (null != empentrelObj) {
                this.setLabelValue("laborreltype", empentrelObj.getString("laborreltype.name"), formView);
                this.setLabelValue("laborrelstatus", empentrelObj.getString("laborrelstatus.name"), formView);
            }
            SWCDataServiceHelper empHelper = new SWCDataServiceHelper("hsas_empposorgrelhr");
            QFilter empIdFilter = new QFilter("id", "=", (Object)salaryFileDyobj.getLong("empposinfo.id"));
            DynamicObject empObj = empHelper.queryOne(SELECT_EMP_PROPS, new QFilter[]{empIdFilter});
            if (null != empObj) {
                this.setLabelValue("postype", empObj.getString("postype.name"), formView);
                this.setLabelValue("posstatus", empObj.getString("posstatus.name"), formView);
                this.setLabelValueGroup("vectorap1", "company", empObj.getString("company.name"), formView);
                this.setLabelValueGroup("vectorap2", "adminorg", empObj.getString("adminorg.name"), formView);
                String positionInfo = empObj.getString("position.name");
                String jobInfo = empObj.getString("job.name");
                String jobLabel = SWCStringUtils.isEmpty((String)positionInfo) ? (SWCStringUtils.isEmpty((String)jobInfo) ? "" : jobInfo) : positionInfo;
                this.setLabelValueGroup("vectorap3", "positionlabelap", jobLabel, formView);
            }
            if (null != (managingScopeObj = (managingScopeHelper = new SWCDataServiceHelper("hsas_managingscope")).queryOne("workplace", (Object)salaryFileDyobj.getLong("managingscope.id")))) {
                this.setLabelValueGroup("vectorap4", "workplacelabelap", managingScopeObj.getString("workplace.name"), formView);
            }
            this.setPortrait(employeeDyobj.getString("person.headsculpture"));
            this.setLabelValue("name", employeeDyobj.getString("person.name"), formView);
            this.setLabelValue("empnumber", employeeDyobj.getString("empnumber"), formView);
            this.setLabelValue("salarycalcstyle", salaryFileDyobj.getString("salarycalcstyle.name"), formView);
            this.setLabelValueGroup("labeltxt1", "orgname", salaryFileDyobj.getString("org.name"), formView);
            this.setLabelValueGroup("labeltxt2", "payrollregionname", salaryFileDyobj.getString("payrollregion.name"), formView);
            this.setLabelValueGroup("labeltxt3", "payrollgroupname", salaryFileDyobj.getString("payrollgroup.name"), formView);
            this.setLabelValueGroup("labeltxt4", "managingscopename", salaryFileDyobj.getString("managingscope.managingscope.name"), formView);
        }
    }

    private void setCountry(Long countryId, IFormView formView) {
        SWCDataServiceHelper dataServiceHelper = new SWCDataServiceHelper("hbss_nationality");
        QFilter qFilter = new QFilter("id", "=", (Object)countryId);
        DynamicObject countryDyobj = dataServiceHelper.queryOne("logo", new QFilter[]{qFilter});
        if (null != countryDyobj) {
            Image portrait = (Image)this.getControl("country");
            portrait.setUrl(SWCImageUrlUtil.getImageFullUrl((String)countryDyobj.getString("logo")));
            formView.setVisible(Boolean.TRUE, new String[]{"country"});
        } else {
            formView.setVisible(Boolean.FALSE, new String[]{"country"});
        }
    }

    private void setGender(String gender, IFormView formView) {
        Image genderImg = (Image)this.getControl("gender");
        if (null != gender) {
            switch (gender) {
                case "1": {
                    genderImg.setUrl("/icons/pc/label/male.png");
                    break;
                }
                case "2": {
                    genderImg.setUrl("/icons/pc/label/female_16_16.png");
                    break;
                }
                default: {
                    formView.setVisible(Boolean.FALSE, new String[]{"gender"});
                    break;
                }
            }
        } else {
            formView.setVisible(Boolean.FALSE, new String[]{"gender"});
        }
    }

    private void setPortrait(String portraitUrl) {
        Image portrait = (Image)this.getControl("headsculpture");
        if (null != portraitUrl && !"".equals(portraitUrl.trim())) {
            portrait.setUrl(SWCImageUrlUtil.getImageFullUrl((String)portraitUrl));
        } else {
            portrait.setUrl("/images/pc/emotion/default_person_82_82.png");
        }
    }

    private void setLabelValue(String fieldKey, String value, IFormView formView) {
        Label label = (Label)this.getControl(fieldKey);
        if (!SWCStringUtils.isEmpty((String)value)) {
            label.setText(value);
            formView.setVisible(Boolean.TRUE, new String[]{fieldKey});
        }
    }

    private void setLabelValueGroup(String icon, String fieldKey, String value, IFormView formView) {
        Label label = (Label)this.getControl(fieldKey);
        if (!SWCStringUtils.isEmpty((String)value)) {
            label.setText(value);
            formView.setVisible(Boolean.TRUE, new String[]{icon, fieldKey});
        }
    }

    private void setJobLevelAndGraderValue(String fieldKey, DynamicObject empObj) {
        Label label = (Label)this.getControl(fieldKey);
        String jobLevel = empObj.getString("joblevel.name");
        String jobGrade = empObj.getString("jobgrade.name");
        StringBuilder result = new StringBuilder();
        if (SWCStringUtils.isEmpty((String)jobLevel) || SWCStringUtils.isEmpty((String)jobGrade)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{fieldKey});
            return;
        }
        result.append(jobLevel);
        result.append('-');
        result.append(jobGrade);
        label.setText(result.toString());
    }
}

