/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.file.subpage;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.swc.hsas.business.dataport.salaryfile.SalaryFileExportConfig;
import kd.swc.hsas.business.dataport.salaryfile.SalaryFileExportDataTask;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang.StringUtils;

public class SalaryFileExportingPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String KEY_BILLNAME = "listname";
    private static final String KEY_TOTAL = "total";
    private static final String KEY_COMPLETE = "complete";
    private static final String KEY_INITTIPS = "inittips";
    private static final String IS_FINISH = "isfinish";
    private static final String KEY_PROGRESSDATAS = "progressdatas";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Label title = (Label)this.getControl(KEY_BILLNAME);
        String text = ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa{0}\uff0c\u5b8c\u6210\u540e\u5c06\u81ea\u52a8\u4e0b\u8f7d", (String)"SalaryFileExportingPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[]{this.getEntityName()});
        title.setText(text);
        this.startBar();
        try {
            SalaryFileExportConfig config = this.getConfig();
            RequestContext requestConext = RequestContext.get();
            SWCThreadPoolFactory.getCommonExportThreadpool().execute((Runnable)new SalaryFileExportDataTask(requestConext, config, this.getView().getPageId()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private SalaryFileExportConfig getConfig() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("hastaxfileperm", showParameter.getCustomParam("hastaxfileperm"));
        params.put("targetpageid", showParameter.getCustomParam("targetpageid"));
        params.put("isexportall", showParameter.getCustomParam("isexportall"));
        params.put("isimport", showParameter.getCustomParam("isimport"));
        return new SalaryFileExportConfig(params);
    }

    public void onProgress(ProgressEvent e) {
        SWCPageCache cache = new SWCPageCache(this.getView());
        String url = (String)cache.get("url", String.class);
        Integer cacheProgress = (Integer)cache.get("progress", Integer.class);
        int progress = cacheProgress == null ? 0 : cacheProgress;
        boolean isFinish = this.getFinishFlag();
        if (isFinish) {
            this.stopBar();
            this.getView().close();
        } else if (progress >= 100) {
            progress = 99;
            cache.put(IS_FINISH, (Object)"1");
            if (StringUtils.isNotBlank((String)url)) {
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.addAction("download", (Object)url);
            }
        }
        e.setProgress(progress);
        this.showExportDetails();
    }

    private void showExportDetails() {
        String completeCount;
        SWCPageCache paCache = new SWCPageCache(this.getView());
        Map data = (Map)paCache.get("data", Map.class);
        if (data == null) {
            return;
        }
        String totalCount = String.valueOf(data.get(KEY_TOTAL));
        if (SWCStringUtils.isEmpty((String)totalCount)) {
            totalCount = ResManager.loadKDString((String)"\u672a\u77e5", (String)"SalaryFileExportingPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        }
        if (SWCStringUtils.isEmpty((String)(completeCount = String.valueOf(data.get(KEY_COMPLETE))))) {
            completeCount = ResManager.loadKDString((String)"\u672a\u77e5", (String)"SalaryFileExportingPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        }
        Label totalLabel = (Label)this.getControl(KEY_TOTAL);
        totalLabel.setText(totalCount);
        Label completeLabel = (Label)this.getControl(KEY_COMPLETE);
        completeLabel.setText(completeCount);
        if (data.containsKey(KEY_TOTAL)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_INITTIPS});
            HashMap<String, Integer> notHidden = new HashMap<String, Integer>();
            notHidden.put("gr", 1);
            this.getView().updateControlMetadata(KEY_PROGRESSDATAS, notHidden);
        }
    }

    private boolean getFinishFlag() {
        SWCPageCache cache = new SWCPageCache(this.getView());
        return SWCStringUtils.equals((String)((String)cache.get(IS_FINISH, String.class)), (String)"1");
    }

    private String getEntityName() {
        return (String)this.getView().getFormShowParameter().getCustomParam("entityName");
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.start();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.stop();
    }
}

