/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.file.subpage;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.hr.metadata.form.control.Hint;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.swc.hsas.business.paysalarysetting.PaySalarySettingHelper;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.ErrorResultObserver;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdateErrorResult;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdatePaySettingDTO;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdatePaySettingEnum;
import kd.swc.hsas.business.paysalarysetting.paysetting.updateobject.UpdateCoverStrategy;
import kd.swc.hsas.business.salaryfile.SWCSalaryFileServiceHelper;
import kd.swc.hsas.common.constants.PaySalaryAccountConstants;
import kd.swc.hsas.common.dto.PaySettingDTO;
import kd.swc.hsas.common.dto.PersonRangeDTO;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class SalaryPaySettingEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private Log log = LogFactory.getLog(SalaryPaySettingEdit.class);
    private static final String PERSON_NAME = "personName";
    private static final String SOCAIRELTYPE = "socialreltypeid";
    private static final String RECEIVER_NAME = "receivername";
    private static final String PAY_TYPE = "paytype";
    private static final String PAY_SUBJECT = "paysubject";
    private static final String BANK_ACCOUNT = "bankaccount";
    private static final String PERBANKCARD = "perbankcard";
    private static final String SALARY_ITEM_SHOW = "salaryitemshow";
    private static final String PAY_WAY = "paymentway";
    private static final String PAY_RATE = "payrate";
    private static final String PAY_AMOUNT = "payamount";
    private static final String CURRENCY = "currency";
    private static final String ISMANUALLYMODIFY = "ismanuallymodify";
    private static final String AUTOMATICALLY = "1";
    private static final String CUSTOMIZE = "0";
    private static final String UNLIMITED = "0";
    private static final String PAY_TYPE_BY_BANK = "1";
    private static final String IS_MAIN_ACCOUNT = "1";
    private static final String PAY_BY_PROPORTION = "0";
    private static final String PAY_BY_AMOUNY = "1";
    private static final String CHECK_CURRENCY = "0";
    private static final String ACCOUNT_CURRENCY = "2";
    private static final String DESIGNATED_CURRENCY = "1";
    private static final String MODIFY_AFTER_AUDIT = "modifyafteraudit";
    private static final String DELETE_ENTRY = "deleteentry";
    private static final String RED_RAW = "redraw";
    private static final String RED_RAW_ID = "0ZCPQTAXK3F7";
    private static final String SELECTBANKCARD = "selectbankcard";
    private static final String KEY_HRPI_PER_BANK_CARD = "hrpi_perbankcard";
    private static final String CALL_BACK_CHECK_DATA = "call_back_check_data";
    private static final String CALL_BACK_CREATE_RULE = "call_back_create_rule";
    private static final String KEY_EMPLOYEE_ID = "employee.id";
    private static final String KEY_NEWENTRY = "donothing_newentry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
        this.addItemClickListeners(new String[]{"advtoolbar"});
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(PAY_SUBJECT);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addPackageDataListener(pkEvent -> {
            Object source = pkEvent.getSource();
            if (source instanceof OperationColumn && "operationcolumnap".equalsIgnoreCase(((OperationColumn)source).getKey())) {
                List operationColItems = (List)pkEvent.getFormatValue();
                Long payKindId = pkEvent.getRowData().getLong("paytype.paycategory.id");
                for (OperationColItem operationColItem : operationColItems) {
                    if (PaySalaryAccountConstants.NEEDBANKCARDIDS.contains(payKindId)) continue;
                    operationColItem.setVisible(false);
                }
            }
            if (source instanceof DecimalEdit) {
                String payWay = pkEvent.getRowData().getString(PAY_WAY);
                int seq = pkEvent.getRowData().getInt("seq");
                if (PAY_AMOUNT.equals(((DecimalEdit)source).getKey())) {
                    if ("0".equals(payWay)) {
                        ((DecimalEdit)source).setEnable("", false, seq - 1);
                    } else {
                        ((DecimalEdit)source).setEnable("", true, seq - 1);
                    }
                }
                if (PAY_RATE.equals(((DecimalEdit)source).getKey())) {
                    if ("0".equals(payWay)) {
                        ((DecimalEdit)source).setEnable("", true, seq - 1);
                    } else {
                        ((DecimalEdit)source).setEnable("", false, seq - 1);
                    }
                }
            }
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        for (int index = 0; index < entryentity.size(); ++index) {
            DynamicObject rule = (DynamicObject)entryentity.get(index);
            String salaryItemMark = rule.getString("salaryItemMark");
            String salaryItemShow = rule.getLong("salaryitem.id") == 0L ? salaryItemMark : rule.getString("salaryitem.name");
            this.getModel().beginInit();
            this.getModel().setValue(SALARY_ITEM_SHOW, (Object)salaryItemShow, index);
            this.getModel().endInit();
        }
        this.getView().updateView("entryentity");
        this.initTips();
        this.getModel().setDataChanged(false);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "redraw": {
                long userId = RequestContext.get().getCurrUserId();
                boolean permFlag = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)this.getView().getEntityId(), (String)RED_RAW_ID);
                if (permFlag) {
                    this.selectPaySettingConfig();
                    break;
                }
                this.getView().showErrorNotification(SWCPermissionServiceHelper.getNoPermTips((String)ResManager.loadKDString((String)"\u6309\u89c4\u5219\u751f\u6210", (String)"SalaryPaySettingEdit_17", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (SWCStringUtils.equals((String)operateKey, (String)"save") || SWCStringUtils.equals((String)operateKey, (String)"saveafteraudit") || SWCStringUtils.equals((String)"formsave", (String)operateKey)) {
            if (SWCStringUtils.isEmpty((String)operate.getOption().getVariableValue("ignore", null))) {
                this.checkData(args, operateKey);
            }
            this.setChange(operate.getOption());
        }
        if (SWCStringUtils.equals((String)operateKey, (String)"newentry") || SWCStringUtils.equals((String)operateKey, (String)SELECTBANKCARD) || SWCStringUtils.equals((String)operateKey, (String)DELETE_ENTRY)) {
            this.setDataChange(Boolean.TRUE);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult;
        DynamicObjectCollection entryEntity;
        int size;
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if (SWCStringUtils.equals((String)opKey, (String)"newentry") && (size = (entryEntity = this.getModel().getEntryEntity("entryentity")).size()) > 0) {
            DynamicObject dynamicObjects = (DynamicObject)entryEntity.get(size - 1);
            DynamicObject payType = dynamicObjects.getDynamicObject(PAY_TYPE);
            if (payType == null) {
                this.getModel().setValue(PAY_TYPE, null, size - 1);
            }
            String salaryFileId = (String)this.getView().getFormShowParameter().getCustomParam("salaryfileid");
            Long defaultCurrencyId = SWCSalaryFileServiceHelper.getCurrencyId((String)salaryFileId);
            this.getModel().setValue(CURRENCY, (Object)defaultCurrencyId, size - 1);
        }
        if ((SWCStringUtils.equals((String)opKey, (String)"saveafteraudit") || SWCStringUtils.equals((String)opKey, (String)"save") || SWCStringUtils.equals((String)opKey, (String)"formsave")) && null != (operationResult = args.getOperationResult())) {
            if (!operationResult.isSuccess()) {
                String name = this.getModel().getDataEntityType().getName();
                if ("hsas_paysetting".equals(name)) {
                    this.getModel().setValue("status", (Object)"A");
                }
            } else {
                DynamicObjectCollection entryEntity2 = this.getModel().getEntryEntity("entryentity");
                ArrayList<String> errorList = new ArrayList<String>(10);
                for (int index = 0; index < entryEntity2.size(); ++index) {
                    DynamicObject entryData = (DynamicObject)entryEntity2.get(index);
                    long payCategoryId = entryData.getLong("paytype.paycategory.id");
                    long perBankCardId = entryData.getLong("perbankcard.id");
                    if (!PaySalaryAccountConstants.NEEDBANKCARDIDS.contains(payCategoryId) || perBankCardId != 0L) continue;
                    errorList.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u85aa\u8d44\u53d1\u653e\u8bbe\u7f6e\u201d \u7b2c%s\u884c\uff1a\u672a\u7ef4\u62a4\u94f6\u884c\u5361\u4fe1\u606f\uff0c\u5c06\u65e0\u6cd5\u8fdb\u884c\u85aa\u8d44\u53d1\u653e\uff0c\u8bf7\u53ca\u65f6\u66f4\u65b0\u3002", (String)"SalaryPaySettingEdit_18", (String)"swc-hsas-formplugin", (Object[])new Object[0]), String.valueOf(index + 1)));
                }
                if (errorList.isEmpty()) {
                    return;
                }
                String title = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"SalaryPaySettingEdit_19", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter(null, (String)title, errorList);
                this.getView().showForm(parameters);
            }
        }
        if (SWCStringUtils.equals((String)opKey, (String)SELECTBANKCARD)) {
            this.showPersonBankForm();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMutexLock() {
        String entityId = this.getView().getEntityId();
        String pkId = this.getModel().getDataEntity().getString("id");
        DataMutex dataMutex = DataMutex.create();
        try {
            dataMutex.release(pkId, entityId, "modify");
        }
        finally {
            try {
                dataMutex.close();
            }
            catch (IOException e) {
                this.log.error("removeMutexLock error");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "hsas_perbankcardinsf": {
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)event.getReturnData();
                if (selectedRows == null) break;
                this.setRowValue(selectedRows);
                break;
            }
            case "call_back_create_rule": {
                Map returnData = (Map)event.getReturnData();
                if (returnData == null) {
                    return;
                }
                if (!((Boolean)returnData.get("isOk")).booleanValue()) break;
                List dataList = JSON.parseArray((String)((String)returnData.get("data")), PaySettingDTO.class);
                Long payRuleId = (Long)returnData.get("payRuleId");
                this.setDataToEntity(dataList, payRuleId);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "call_back_check_data": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                OperateOption operation = OperateOption.create();
                operation.setVariableValue("ignore", "1");
                this.getView().invokeOperation(this.getView().getPageCache().get("operateKey"), operation);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (!"status".equals(fieldKey)) {
            this.setDataChange(Boolean.TRUE);
        }
        switch (fieldKey) {
            case "paytype": {
                this.setEntryFieldEnable(changeData);
                break;
            }
            case "paymentway": {
                this.dealPayWayChange(changeData);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String control = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        switch (control) {
            case "paysubject": {
                String countryId = (String)this.getView().getFormShowParameter().getCustomParam("country");
                String orgId = (String)this.getView().getFormShowParameter().getCustomParam("org");
                QFilter filter = SWCStringUtils.isEmpty((String)countryId) ? new QFilter("1", "!=", (Object)1) : new QFilter("country.id", "=", (Object)Long.parseLong(countryId));
                if (SWCStringUtils.isNotEmpty((String)orgId)) {
                    filter.and(BaseDataServiceHelper.getBaseDataFilter((String)"hsbs_paysubject", (Long)Long.parseLong(orgId)));
                }
                showParameter.getListFilterParameter().setFilter(filter);
                break;
            }
        }
    }

    private void setDataChange(Boolean isChange) {
        this.getView().getPageCache().put(ISMANUALLYMODIFY, isChange.toString());
    }

    private void checkData(BeforeDoOperationEventArgs args, String operateKey) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        boolean isAllTarget = entryEntity.stream().noneMatch(obj -> PaySalaryAccountConstants.NOTTARGET.contains(obj.getString("salaryitemmark")));
        if (!entryEntity.isEmpty() && isAllTarget) {
            String msg = ResManager.loadKDString((String)"\u53d1\u653e\u8bbe\u7f6e\u4e2d\u672a\u5bf9\u201c\u5176\u4ed6\u201d\u5b9e\u53d1\u9879\u76ee\u8fdb\u884c\u8bbe\u7f6e\uff0c\u8bf7\u786e\u8ba4\u8be5\u5458\u5de5\u6240\u6709\u5b9e\u53d1\u9879\u90fd\u5df2\u8bbe\u7f6e\u3002\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"SalaryPaySettingEdit_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"SalaryPaySettingEdit_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"SalaryPaySettingEdit_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            ConfirmCallBackListener listener = new ConfirmCallBackListener(CALL_BACK_CHECK_DATA);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, listener, btnNameMaps);
            args.setCancel(true);
            this.getView().getPageCache().put("operateKey", operateKey);
        }
    }

    private void setChange(OperateOption option) {
        option.setVariableValue(ISMANUALLYMODIFY, this.getView().getPageCache().get(ISMANUALLYMODIFY));
    }

    private void initTips() {
        Map promptMap = (Map)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptIdAndContent", (Object[])new Object[]{this.getModel().getDataEntityType().getName(), "hintap", this.getModel().getDataEntity()});
        Boolean isShow = Boolean.FALSE;
        Hint hintAp = (Hint)this.getControl("hintap");
        if (hintAp != null) {
            for (Map.Entry entry : promptMap.entrySet()) {
                Long key = (Long)entry.getKey();
                String value = (String)entry.getValue();
                if (!SWCStringUtils.isNotEmpty((String)value)) continue;
                hintAp.setContent(key, value);
                isShow = Boolean.TRUE;
            }
        }
        this.getView().setVisible(isShow, new String[]{"hintap"});
        this.getView().setVisible(Boolean.valueOf(this.getModel().getDataEntity().getBoolean(ISMANUALLYMODIFY)), new String[]{"manuallylab"});
    }

    private void showPersonBankForm() {
        ListShowParameter perBankCardshowParameter = ShowFormHelper.createShowListForm((String)"hsas_perbankcardinsf", (boolean)false);
        perBankCardshowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_perbankcardinsf"));
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long personId = dataEntity.getLong("salaryfile.person.id");
        List qFilters = perBankCardshowParameter.getListFilterParameter().getQFilters();
        QFilter isDeleteFilter = new QFilter("isdelete", "=", (Object)"0");
        isDeleteFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        isDeleteFilter.and(new QFilter("person.id", "=", (Object)personId));
        qFilters.add(isDeleteFilter);
        perBankCardshowParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
        perBankCardshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        perBankCardshowParameter.setCaption(ResManager.loadKDString((String)"\u94f6\u884c\u5361", (String)"SalaryPaySettingEdit_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        perBankCardshowParameter.setShowTitle(false);
        this.getView().showForm((FormShowParameter)perBankCardshowParameter);
    }

    private void setRowValue(ListSelectedRowCollection selectedRows) {
        ListSelectedRow selectedRow = selectedRows.get(0);
        if (selectedRow != null) {
            this.getModel().beginInit();
            this.getModel().setValue(PERBANKCARD, (Object)this.getPerBankCard(selectedRow.getPrimaryKeyValue()).getLong("sourcevid"));
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    private DynamicObject getPerBankCard(Object id) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(KEY_HRPI_PER_BANK_CARD);
        QFilter filter = new QFilter("id", "=", id);
        return helper.queryOne("sourcevid", new QFilter[]{filter});
    }

    private void selectPaySettingConfig() {
        Long countryId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("country"));
        DynamicObject paySetting = this.getPaySetting();
        Long salaryFileId = paySetting.getLong("salaryfile.id");
        DynamicObject salaryFile = PaySalarySettingHelper.querySalaryFileInfoById((long)salaryFileId);
        if (salaryFile == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6863\u6848\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\u3002", (String)"ItemGroupConfigEdit_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        Long groupId = salaryFile.getLong("payrollgroup.id");
        DynamicObject calCurrency = PaySalarySettingHelper.getSalaryFileCalCurrency((Long)groupId);
        DynamicObject paySettingRule = PaySalarySettingHelper.getAuditAndEnableData((Long)salaryFile.getLong("org.id"), (Long)countryId);
        Long personId = salaryFile.getLong("person.id");
        List perBankCardList = PaySalarySettingHelper.queryBankCardAllInfoByPersonId((Long)personId);
        HashMap personFileInfo = new HashMap(16);
        PaySalarySettingHelper.getSalaryFilePersonRangeRule((DynamicObject)paySettingRule, Collections.singletonList(salaryFileId), personFileInfo);
        PersonRangeDTO personRangeDTO = (PersonRangeDTO)personFileInfo.get(salaryFileId);
        UpdatePaySettingDTO updatePaySetting = new UpdatePaySettingDTO(Boolean.FALSE, salaryFile, paySetting, UpdatePaySettingEnum.UPDATE_COVER, paySettingRule, perBankCardList, calCurrency);
        updatePaySetting.setPersonRange(personRangeDTO);
        HashSet<Long> groupIdSet = new HashSet<Long>(16);
        groupIdSet.add(groupId);
        updatePaySetting.setSalaryItem((Set)PaySalarySettingHelper.getPayRollGroupAndItemMap(groupIdSet).get(groupId));
        ErrorResultObserver observer = new ErrorResultObserver();
        UpdateCoverStrategy strategy = new UpdateCoverStrategy(observer);
        boolean isUpdate = strategy.strategyMethod(updatePaySetting);
        if (!isUpdate) {
            this.getView().showErrorNotification(((UpdateErrorResult)observer.getErrorList().get(0)).getErrorReason());
            return;
        }
        if (observer.getErrorList().size() > 0) {
            this.getView().showTipNotification(((UpdateErrorResult)observer.getErrorList().get(0)).getErrorReason());
        }
        Long payRuleId = updatePaySetting.getPaySetting().getLong("payrule.id");
        DynamicObjectCollection collection = updatePaySetting.getPaySetting().getDynamicObjectCollection("entryentity");
        List paySettingDataList = PaySalarySettingHelper.createPaySettingData((DynamicObjectCollection)collection);
        FormShowParameter show = new FormShowParameter();
        show.setFormId("hsas_paysettingbyrule");
        show.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_CREATE_RULE));
        show.setCustomParam("data", (Object)JSON.toJSONString((Object)paySettingDataList));
        show.setCustomParam("payRuleId", (Object)payRuleId);
        show.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(show);
    }

    private DynamicObject getPaySetting() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paysetting");
        String selectProperties = "id,sourcevid,bsed,bsled,ismanuallymodify,payrule.id,salaryfile.id,salaryfile.sourcevid,entryentity.salaryitemshow,entryentity.salaryitem,entryentity.salaryitemmark,entryentity.salaryitem.dataprecision.scale,entryentity.payrate,entryentity.paytype,entryentity.currency,entryentity.perbankcard,entryentity.paymentway,entryentity,payamount,entryentity.paysubject,entryentity.seq,entryentity.remarks,entryentity.entryboid";
        QFilter filter = new QFilter("id", "=", this.getModel().getValue("id"));
        DynamicObject paySetting = helper.queryOne(selectProperties, new QFilter[]{filter});
        if (paySetting == null) {
            paySetting = helper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)this.getModel().getDataEntity(), (DynamicObject)paySetting);
            paySetting.set("payrule", null);
        }
        return paySetting;
    }

    private void createTableSetter(TableValueSetter setter) {
        setter.addField(SALARY_ITEM_SHOW, new Object[0]);
        setter.addField("salaryitemmark", new Object[0]);
        setter.addField("salaryitem", new Object[0]);
        setter.addField(CURRENCY, new Object[0]);
        setter.addField(PAY_WAY, new Object[0]);
        setter.addField(PAY_RATE, new Object[0]);
        setter.addField(PAY_AMOUNT, new Object[0]);
        setter.addField(PAY_SUBJECT, new Object[0]);
        setter.addField(PAY_TYPE, new Object[0]);
        setter.addField(PERBANKCARD, new Object[0]);
    }

    private void setDataToEntity(List<PaySettingDTO> dataList, Long payRuleId) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        this.createTableSetter(vs);
        dataList.forEach(data -> vs.addRow(new Object[]{data.getSalaryName(), data.getSalaryItem(), data.getSalaryItemId(), data.getPayCurrencyId(), data.getPaymentWay(), data.getPayScale(), data.getPayAmount(), data.getPaySubjectId(), data.getPayType(), data.getPerBankCardId()}));
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.setValue("payrule", (Object)payRuleId);
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.setDataChange(Boolean.FALSE);
        this.getView().updateView("payrule");
        this.getView().updateView("entryentity");
    }

    private void setEntryFieldEnable(ChangeData changeData) {
        Object payTypeObj = changeData.getNewValue();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int index = proxy.getEntryState("entryentity").getFocusRow();
        if (null != payTypeObj) {
            if (-1 == index) {
                return;
            }
            if (!PaySalaryAccountConstants.NEEDBANKCARDIDS.contains(((DynamicObject)payTypeObj).getLong("paycategory.id"))) {
                this.getModel().setValue(PERBANKCARD, null, index);
            }
        }
        this.getView().updateView("entryentity", index);
    }

    private void dealPayWayChange(ChangeData changeData) {
        Object payWayNew = changeData.getNewValue();
        if (null != payWayNew) {
            this.getModel().beginInit();
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            int index = proxy.getEntryState("entryentity").getFocusRow();
            if (-1 == index) {
                this.getModel().endInit();
                this.getView().updateView("entryentity");
                return;
            }
            if ("0".equals(payWayNew)) {
                this.getModel().setValue(PAY_AMOUNT, null, index);
            } else if ("1".equals(payWayNew)) {
                DynamicObject amountSetting;
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                if (!this.checkIsHavePayProportionSalaryItem(entryEntity, amountSetting = (DynamicObject)entryEntity.get(index))) {
                    DynamicObject object = (DynamicObject)entryEntity.getDynamicObjectType().createInstance();
                    HRDynamicObjectUtils.copy((DynamicObject)amountSetting, (DynamicObject)object);
                    object.set(PAY_WAY, (Object)"0");
                    object.set(PAY_AMOUNT, (Object)0L);
                    object.set(PAY_RATE, (Object)100);
                    object.set(PERBANKCARD, null);
                    this.getModel().createNewEntryRow("entryentity", index + 1, object);
                }
                this.getModel().setValue(PAY_RATE, null, index);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity", index);
        }
    }

    private boolean checkIsHavePayProportionSalaryItem(DynamicObjectCollection entryEntity, DynamicObject amountSetting) {
        String salaryMark = amountSetting.getString("salaryitemmark");
        Long salaryItemId = amountSetting.getLong("salaryitem.id");
        Optional<DynamicObject> optional = entryEntity.stream().filter(e -> SWCStringUtils.equals((String)salaryMark, (String)e.getString("salaryitemmark")) && salaryItemId.equals(e.getLong("salaryitem.id")) && "0".equals(e.getString(PAY_WAY))).findAny();
        return optional.isPresent();
    }
}

