/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.formula;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.Submit;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.IListColumn;
import kd.bos.list.ListOperationColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.formula.helper.FormulaItemOrFuncTreeHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class FormulaList
extends AbstractListPlugin {
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"confirmchange"});
        this.hideCol(args);
    }

    private void hideCol(BeforeCreateListColumnsArgs args) {
        List columnList = args.getListColumns();
        Iterator it = columnList.iterator();
        boolean isCurrList = BaseDataHisHelper.isCurrList((IFormView)this.getView());
        while (it.hasNext()) {
            IListColumn col = (IListColumn)it.next();
            String fieldKey = col.getListFieldKey();
            if (isCurrList || !"listoperatecol".equals(fieldKey)) continue;
            ListOperationColumn opCol = (ListOperationColumn)col;
            Iterator it2 = opCol.getOperationColItems().iterator();
            while (it2.hasNext()) {
                OperationColItem col2 = (OperationColItem)it2.next();
                String opKey = col2.getOperationKey();
                if (!"confirmchange".equals(opKey)) continue;
                it2.remove();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "showformula": {
                FormulaItemOrFuncTreeHelper.openFormulaExamplePage((IFormView)this.getView(), (String)"hsas_formulaexamplepage", (ShowType)ShowType.MainNewTabPage, (String)FormulaItemOrFuncTreeHelper.getFormulaExample());
                break;
            }
            case "submit": {
                operate.getOption().setVariableValue("submit", Boolean.TRUE.toString());
                String appCacheKey = "formula_submit_" + UUID.randomUUID().toString();
                operate.getOption().setVariableValue("formulaOpVar", appCacheKey);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("submit".equals(operateKey)) {
            Submit submit = (Submit)args.getSource();
            Map variables = submit.getOption().getVariables();
            String appCacheKey = (String)variables.get("formulaOpVar");
            String subKeyStr = (String)variables.get("subKeySet");
            if (SWCStringUtils.isNotEmpty((String)subKeyStr)) {
                Set subKeySet = (Set)SerializationUtils.fromJsonString((String)subKeyStr, Set.class);
                ISWCAppCache appCache = SWCAppCache.get((String)appCacheKey);
                subKeySet.forEach(key -> appCache.remove(key));
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        switch (args.getFieldName()) {
            case "salaryitem.id": 
            case "salaryitem.name": {
                QFilter orgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_salaryitem", (Long)Long.valueOf(this.getPageCache().get("createOrg")));
                if (orgFilter == null) break;
                args.addCustomQFilter(orgFilter);
                break;
            }
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        switch (args.getFieldName()) {
            case "salaryitem.id": 
            case "salaryitem.name": {
                String createOrg = this.getPageCache().get("createOrg");
                QFilter orgFilter = null;
                if (StringUtils.isNotBlank((CharSequence)createOrg)) {
                    orgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_salaryitem", (Long)Long.valueOf(createOrg));
                }
                if (orgFilter == null) break;
                args.addCustomQFilter(orgFilter);
                break;
            }
        }
    }
}

