/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.guide;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.common.events.approve.CreateApproveBillValidateEvent;
import kd.sdk.swc.hsas.formplugin.extpoint.approve.ICreateApproveBillExtService;
import kd.swc.hsas.business.cal.helper.HSASCalApproveBillHelper;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.cal.vo.CalPayRollTaskContext;
import kd.swc.hsas.business.payrollscene.service.SWCPayRollSceneService;
import kd.swc.hsas.formplugin.web.approve.CreateApproveBillExtPlugin;
import kd.swc.hsas.formplugin.web.guide.AbstractCalPayRollTaskList;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalPayRollTaskApproveBillList
extends AbstractCalPayRollTaskList {
    private static final Log logger = LogFactory.getLog(CalPayRollTaskApproveBillList.class);

    @Override
    protected List<CalPersonOperationEnum> operationKey() {
        ArrayList<CalPersonOperationEnum> calPersonOperationEnums = new ArrayList<CalPersonOperationEnum>();
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_CREATEAPPROVE);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_SHOWAPPROVEDETAIL);
        return calPersonOperationEnums;
    }

    @Override
    protected boolean hasPerm(CalPersonOperationEnum calPersonOperationEnum) {
        switch (calPersonOperationEnum) {
            case OP_SHOWAPPROVEDETAIL: {
                return SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_approvebill", (String)"47150e89000000ac");
            }
        }
        return true;
    }

    @Override
    protected void execute() {
        switch (this.calPersonOperationEnum) {
            case OP_CREATEAPPROVE: {
                this.getPageCache().put("invokeOperation", "true");
                this.doOperation();
                break;
            }
            case OP_SHOWAPPROVEDETAIL: {
                this.showApproveDetail();
                break;
            }
        }
    }

    @Override
    public boolean doValidateChooseData() {
        boolean result = true;
        switch (this.calPersonOperationEnum) {
            case OP_CREATEAPPROVE: {
                List validDatas = this.calPayRollTaskContext.getValidDatas();
                HashSet<Long> orgIds = new HashSet<Long>(validDatas.size());
                HashSet<Long> currencyIds = new HashSet<Long>(validDatas.size());
                ArrayList<Long> calTaskIds = new ArrayList<Long>(validDatas.size());
                for (CalPayRollTask validData : validDatas) {
                    calTaskIds.add(validData.getCalPayRollTaskId());
                }
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
                DynamicObjectCollection calTasks = helper.queryOriginalCollection("id,payrollgroup.id,payrollgroup.number,org.id,payrollgroupv.currency.id", new QFilter[]{new QFilter("id", "in", calTaskIds)});
                for (DynamicObject calTask : calTasks) {
                    orgIds.add(calTask.getLong("org.id"));
                    currencyIds.add(calTask.getLong("payrollgroupv.currency.id"));
                }
                if (orgIds.size() > 1) {
                    result = false;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u5141\u8bb8\u5bf9\u540c\u4e00\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u7684\u6570\u636e\u751f\u6210\u5ba1\u6279\u5355\u3002", (String)"CalPayRollTaskApproveBillList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (currencyIds.size() > 1) {
                    result = false;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u5141\u8bb8\u5bf9\u4e00\u4e2a\u6838\u7b97\u5e01\u79cd\u7684\u6570\u636e\u8fdb\u884c\u751f\u6210\u5ba1\u6279\u5355\u64cd\u4f5c\u3002", (String)"CalPayRollTaskApproveBillList_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    break;
                }
                CreateApproveBillValidateEvent createApproveBillValidateEvent = new CreateApproveBillValidateEvent((List)calTasks);
                this.createBillDoValidate(createApproveBillValidateEvent);
                result = this.parseDoPreValidate(validDatas, createApproveBillValidateEvent);
                break;
            }
        }
        return result;
    }

    @Override
    protected void invokeOperation() {
        if (this.calPayRollTaskContext == null) {
            this.calPayRollTaskContext = this.getCalPayRollTaskContext();
        }
        if (this.calPayRollTaskContext == null) {
            return;
        }
        List validDatas = this.calPayRollTaskContext.getValidDatas();
        String createApproveBillParams = this.getPageCache().get("createApproveBillParams");
        Map operationParams = (Map)JSON.parseObject((String)createApproveBillParams, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        SWCThreadPoolFactory.getPayrolltaskOpThreadpool().execute(() -> {
            for (CalPayRollTask validData : validDatas) {
                List<Long> calPersons = validData.getCalPersons();
                OperateOption operateOption = OperateOption.create();
                operationParams.forEach((arg_0, arg_1) -> ((OperateOption)operateOption).setVariableValue(arg_0, arg_1));
                String operationKey = this.calPersonOperationEnum.getOperationKey();
                OperationServiceImpl opImpl = new OperationServiceImpl();
                List<Long> calPersonIds = calPersons;
                if (calPersonIds == null) {
                    calPersonIds = this.getCalPersonIds(validData);
                }
                if (calPersonIds.size() == 0) {
                    this.processHandler.update(0, 0, this.calPayRollTaskContext.getTraceId(), validData.getCalPayRollTaskId());
                    PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(validData.getCalPayRollTaskId()), (String)operationKey);
                    return;
                }
                List partitionIds = Lists.partition(calPersonIds, (int)5000);
                for (List partitionId : partitionIds) {
                    long invokeTime = System.currentTimeMillis();
                    Long[] partCalPersonIds = new Long[partitionId.size()];
                    this.invokeOp(validData.getCalPayRollTaskId(), operateOption, operationKey, opImpl, partitionId.size(), partitionId.toArray(partCalPersonIds));
                    logger.info("invoke {} op cost\uff1a{}", (Object)this.calPersonOperationEnum.getOperationName(), (Object)(System.currentTimeMillis() - invokeTime));
                }
                PayrollTaskHelper.updateCalPayRollTaskStatus((Long)validData.getCalPayRollTaskId());
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(validData.getCalPayRollTaskId()), (String)operationKey);
            }
        });
    }

    @Override
    protected void showConfirm(List<CalPayRollTask> confirmDatas) {
        this.openApproveView(confirmDatas);
    }

    @Override
    protected boolean operationMutex() {
        switch (this.calPersonOperationEnum) {
            case OP_SHOWAPPROVEDETAIL: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void beforeDoOperation(BeforeDoOperationEventArgs args, CalPayRollTask calPayRollTask) {
        Long taskId = calPayRollTask.getCalPayRollTaskId();
        if (taskId != null && taskId > 0L) {
            switch (this.calPersonOperationEnum) {
                case OP_SHOWAPPROVEDETAIL: 
                case OP_CREATEAPPROVE: {
                    boolean calapprove;
                    SWCPayRollSceneService sceneService = SWCPayRollSceneService.createInstance();
                    DynamicObject schemeAfterCalObj = sceneService.getAfterCalObjByTask(taskId);
                    if (schemeAfterCalObj == null || (calapprove = schemeAfterCalObj.getBoolean("calapprove"))) break;
                    calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                    calPayRollTask.setCalPayRollTaskValidatorErrorMsg(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4efb\u52a1\u7684\u6838\u7b97\u540e\u5904\u7406\u65b9\u6848{0}\u4e2d\u672a\u542f\u7528\u85aa\u8d44\u5ba1\u6279\u4e1a\u52a1\u3002", (String)"CalPayRollTaskApproveBillList_4", (String)"swc-hsas-formplugin", (Object[])new Object[]{schemeAfterCalObj.getString("number")}));
                    return;
                }
            }
        }
        switch (this.calPersonOperationEnum) {
            case OP_CREATEAPPROVE: {
                this.dealCreateApproveInfo(calPayRollTask);
                break;
            }
            case OP_SHOWAPPROVEDETAIL: {
                if (SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_approvebill", (String)"47150e89000000ac")) break;
                calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                calPayRollTask.setCalPayRollTaskValidatorErrorMsg(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u85aa\u8d44\u5ba1\u6279\u5355\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"CalPayRollTaskApproveBillList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actId;
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            this.releaseDistributedLock();
            return;
        }
        switch (actId = closedCallBackEvent.getActionId()) {
            case "calapproveviewclose": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                this.createApproveBill(returnData);
                break;
            }
        }
    }

    private void dealCreateApproveInfo(CalPayRollTask calPayRollTask) {
        if (!this.checkCalTaskStatus(calPayRollTask)) {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
        } else {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
        }
    }

    private boolean checkCalTaskStatus(CalPayRollTask calPayRollTask) {
        String payRollTaskStatus = calPayRollTask.getPayRollTaskStatus();
        if (CalPayrollTaskStateEnum.APPROVALED.getCode().equals(payRollTaskStatus)) {
            calPayRollTask.setCalPayRollTaskValidatorErrorMsg(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u5df2\u5ba1\u6279\u901a\u8fc7\uff0c\u4e0d\u80fd\u518d\u505a\u751f\u6210\u5ba1\u6279\u5355\u64cd\u4f5c\u3002", (String)"HSASCalTableListApproveBillPlugin_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void openApproveView(List<CalPayRollTask> calPayRollTasks) {
        FormShowParameter show = new FormShowParameter();
        show.setFormId("hsas_calviewapprovebill");
        show.getOpenStyle().setShowType(ShowType.Modal);
        show.setShowTitle(false);
        DynamicObject[] calPersonArr = this.queryCalPersonsByTasks(calPayRollTasks);
        HashSet<String> calPersonOnHoldSet = new HashSet<String>(16);
        HashMap<String, String> calPersonCalTableMap = new HashMap<String, String>(calPersonArr.length);
        for (DynamicObject calPersonDy : calPersonArr) {
            if ("E".equals(calPersonDy.getString("salaryfile.status"))) continue;
            String calStatus = calPersonDy.getString("calstatus");
            if ((CalStateEnum.AUDIT.getCode().equals(calStatus) || CalStateEnum.APPROVALED_NOT_PASS.getCode().equals(calStatus)) && !SWCStringUtils.equals((String)String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode()), (String)calPersonDy.getString("onholdstatus"))) {
                calPersonCalTableMap.put(String.valueOf(calPersonDy.getLong("id")), String.valueOf(calPersonDy.getLong("calresultid")));
            }
            if (!SWCStringUtils.equals((String)String.valueOf(OnHoldStatusEnum.STATUS_ONHOLD.getCode()), (String)calPersonDy.getString("onholdstatus"))) continue;
            calPersonOnHoldSet.add(calPersonDy.getString("id"));
        }
        if (calPersonCalTableMap.size() == 0) {
            for (CalPayRollTask calPayRollTask : calPayRollTasks) {
                calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                calPayRollTask.setCalPayRollTaskValidatorErrorMsg(ResManager.loadKDString((String)"{0}\uff1a\u53ea\u53ef\u5bf9\u6838\u7b97\u72b6\u6001\u4e3a\u201c\u5ba1\u6279\u4e0d\u901a\u8fc7\u201d\u6216\u201c\u5df2\u5ba1\u6838\u201d\u3001\u505c\u7f13\u53d1\u72b6\u6001\u4e3a\u7a7a\u6216\u201c\u5df2\u89e3\u85aa\u201d\u3001\u4e14\u6863\u6848\u672a\u5e9f\u5f03\u7684\u6838\u7b97\u8bb0\u5f55\u64cd\u4f5c\u751f\u6210\u5ba1\u6279\u5355\u3002", (String)"CalPayRollTaskApproveBillList_1", (String)"swc-hsas-formplugin", (Object[])new Object[]{calPayRollTask.getNumber()}));
                this.calPayRollTaskContext.getInvalidDatas().add(calPayRollTask);
                this.calPayRollTaskContext.getValidDatas().remove(calPayRollTask);
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTask.getCalPayRollTaskId()), (String)this.calPayRollTaskContext.getCalPersonOperationEnum().getOperationKey());
            }
            this.showErrMsg();
            return;
        }
        String taskIds = this.getTaskIdsStr(calPayRollTasks);
        String payRollGroupIds = HSASCalApproveBillHelper.getPayRollGroupStr(calPayRollTasks);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put("totalSize", (Object)calPersonArr.length);
        show.setCustomParam("calPersonCalTableMap", calPersonCalTableMap);
        show.setCustomParam("calPersonOnHoldSet", (Object)JSON.toJSONString(calPersonOnHoldSet));
        show.setCustomParam("calTaskId", (Object)taskIds);
        DynamicObject calTaskInfo = this.getCalTaskInfo(calPayRollTasks.get(0).getCalPayRollTaskId(), "org.id,org.name,payrollgroup,calrulev.id");
        show.setCustomParam("payrollgroupId", (Object)calTaskInfo.getLong("payrollgroup.id"));
        show.setCustomParam("orgName", (Object)calTaskInfo.getString("org.name"));
        show.setCustomParam("orgId", (Object)calTaskInfo.getLong("org.id"));
        show.setCustomParam("calRuleVid", (Object)calTaskInfo.getString("calrulev.id"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "calapproveviewclose");
        show.setCloseCallBack(closeCallBack);
        this.getView().showForm(show);
        Map operationParam = calPayRollTasks.get(0).getOperationParam();
        operationParam.put("orgId", String.valueOf(calTaskInfo.getLong("org.id")));
        operationParam.put("payrollgroupId", String.valueOf(calTaskInfo.getLong("payrollgroup.id")));
        operationParam.put("orgName", calTaskInfo.getString("org.name"));
        operationParam.put("pageId", show.getPageId());
        operationParam.put("taskId", taskIds);
        operationParam.put("payrollgroupid", payRollGroupIds);
        this.getPageCache().put("createApproveBillParams", JSON.toJSONString((Object)operationParam));
    }

    private String getTaskIdsStr(List<CalPayRollTask> calPayRollTasks) {
        StringBuilder sb = new StringBuilder();
        for (CalPayRollTask calPayRollTask : calPayRollTasks) {
            sb.append(calPayRollTask.getCalPayRollTaskId());
            sb.append(',');
        }
        String taskIds = sb.length() > 0 ? sb.substring(0, sb.length() - 1) : sb.toString();
        return taskIds;
    }

    private DynamicObject[] queryCalPersonsByTasks(List<CalPayRollTask> calPayRollTasks) {
        List caltaskIds = calPayRollTasks.stream().map(CalPayRollTask::getCalPayRollTaskId).collect(Collectors.toList());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter calPersonFilter = new QFilter("caltask", "in", caltaskIds);
        try {
            List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"47150e89000000ac");
            if (authorizedDataRuleQFilter != null) {
                for (QFilter qFilter : authorizedDataRuleQFilter) {
                    calPersonFilter.and(qFilter);
                }
            } else {
                calPersonFilter.and(new QFilter("1", "!=", (Object)1));
            }
        }
        catch (Exception exception) {
            logger.error("invoke hrcs IHRCSDataPermissionService error", (Object)exception.getMessage());
        }
        return helper.queryOriginalArray("id,onholdstatus,calstatus,calresultid,salaryfile.status", new QFilter[]{calPersonFilter});
    }

    private void showApproveDetail() {
        boolean permFlag = SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_approvebill", (String)"0VYYLFGYBR=D");
        if (!permFlag) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u770b\u5ba1\u6279\u5355", (String)"HSASCalTableListApproveBillPlugin_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        List<CalPayRollTask> approveCalPayRollTaskIds = this.getApproveCalPayRollTaskIds();
        if (approveCalPayRollTaskIds.size() <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u8bb0\u5f55\u672a\u751f\u6210\u5ba1\u6279\u5355\uff0c\u65e0\u53ef\u67e5\u8be2\u6570\u636e\u3002", (String)"HSASCalTableListApproveBillPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList defaultTaskNumbers = new ArrayList(this.calPayRollTaskContext.getValidDatas().size());
        approveCalPayRollTaskIds.forEach(calPayRollTask -> defaultTaskNumbers.add(calPayRollTask.getNumber()));
        ListShowParameter show = new ListShowParameter();
        show.setBillFormId("hsas_approvebill");
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        show.setCustomParam("defaultTaskNumbers", defaultTaskNumbers);
        this.getView().showForm((FormShowParameter)show);
    }

    private List<CalPayRollTask> getApproveCalPayRollTaskIds() {
        List validDatas = this.calPayRollTaskContext.getValidDatas();
        ArrayList<CalPayRollTask> calTasks = new ArrayList<CalPayRollTask>(validDatas.size());
        validDatas.forEach(calPayRollTask -> {
            SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hsas_approvebill");
            int approveBillCount = swcDataServiceHelper.count(new QFilter[]{new QFilter("caltasks.fbasedataid", "=", (Object)calPayRollTask.getCalPayRollTaskId())});
            if (approveBillCount > 0) {
                calTasks.add((CalPayRollTask)calPayRollTask);
            }
        });
        return calTasks;
    }

    protected void createApproveBill(Map<String, Object> returnData) {
        IAppCache appCache = AppCache.get((String)this.getView().getPageId());
        appCache.remove("approveBillNo");
        appCache.remove("allCalTableIdList");
        Long approveBillTplId = (Long)returnData.get("approveBillTplId");
        Boolean isAll = (Boolean)returnData.getOrDefault("isAll", Boolean.FALSE);
        Boolean isOnHold = (Boolean)returnData.getOrDefault("isOnHold", Boolean.FALSE);
        String calPersons = (String)returnData.getOrDefault("calPersons", "");
        String errorCustomMsg = (String)returnData.getOrDefault("errorCustomMsg", "");
        SWCDataServiceHelper approveBillTplHisHelper = new SWCDataServiceHelper("hsas_approvebilltpl");
        QFilter approveBillTplHisFilter = new QFilter("boid", "=", (Object)approveBillTplId);
        approveBillTplHisFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        BaseDataHisHelper.addHisVerFilter((QFilter)approveBillTplHisFilter);
        DynamicObject approveBillTplHisDy = approveBillTplHisHelper.queryOne("id", new QFilter[]{approveBillTplHisFilter});
        Long approveBillTplHisId = approveBillTplHisDy.getLong("id");
        CalPayRollTaskContext calPayRollTaskContext = this.getCalPayRollTaskContext();
        String createApproveBillParams = this.getPageCache().get("createApproveBillParams");
        Map operationParams = (Map)JSON.parseObject((String)createApproveBillParams, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        operationParams.put("approveBillTplId", String.valueOf(approveBillTplId));
        operationParams.put("approveBillTplHisId", String.valueOf(approveBillTplHisId));
        operationParams.put("isAll", String.valueOf(isAll));
        operationParams.put("isOnHold", String.valueOf(isOnHold));
        operationParams.put("calPersons", calPersons);
        operationParams.put("errorCustomMsg", errorCustomMsg);
        this.getPageCache().put("createApproveBillParams", JSON.toJSONString((Object)operationParams));
        this.getView().getPageCache().put("calPayRollTaskContext", SerializationUtils.toJsonString((Object)calPayRollTaskContext));
        OperateOption option = OperateOption.create();
        option.setVariableValue("CallBackInvoke", "true");
        this.getView().invokeOperation(CalPersonOperationEnum.OP_CREATEAPPROVE.getOperationKey(), option);
    }

    @Override
    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        ISWCAppCache appCache = SWCAppCache.get((String)this.getView().getPageId());
        appCache.remove("approveBillNo");
        appCache.remove("approvePersonSet");
        appCache.remove("approveFileSet");
    }

    private void createBillDoValidate(CreateApproveBillValidateEvent event) {
        CreateApproveBillExtPlugin createApproveBillExtService = new CreateApproveBillExtPlugin();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)createApproveBillExtService, ICreateApproveBillExtService.class, (String)"kd.sdk.swc.hsas.formplugin.extpoint.approve.ICreateApproveBillExtService#doPreValidate", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.doPreValidate(event);
            return null;
        });
        logger.info("end doValidate event");
    }

    private boolean parseDoPreValidate(List<CalPayRollTask> validDatas, CreateApproveBillValidateEvent createApproveBillValidateEvent) {
        boolean result;
        if (createApproveBillValidateEvent.isCancel()) {
            result = false;
            String errorMessage = createApproveBillValidateEvent.getErrorMessage();
            if (SWCStringUtils.isNotEmpty((String)errorMessage)) {
                this.getView().showErrorNotification(errorMessage);
            } else {
                Map validateResult = createApproveBillValidateEvent.getValidateResult();
                Iterator<CalPayRollTask> iterator = validDatas.iterator();
                while (iterator.hasNext()) {
                    CalPayRollTask calPayRollTask = iterator.next();
                    Long taskId = calPayRollTask.getCalPayRollTaskId();
                    calPayRollTask.setCalPayRollTaskValidatorErrorMsg((String)validateResult.get(taskId));
                    iterator.remove();
                    this.calPayRollTaskContext.getInvalidDatas().add(calPayRollTask);
                    PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTask.getCalPayRollTaskId()), (String)this.calPersonOperationEnum.getOperationKey());
                }
                this.showErrMsg();
            }
        } else {
            result = true;
            Map validateResult = createApproveBillValidateEvent.getValidateResult();
            Iterator<CalPayRollTask> iterator = validDatas.iterator();
            while (iterator.hasNext()) {
                CalPayRollTask calPayRollTask = iterator.next();
                Long taskId = calPayRollTask.getCalPayRollTaskId();
                if (!SWCStringUtils.isNotEmpty((String)((String)validateResult.get(taskId)))) continue;
                calPayRollTask.setValidatorResult(false);
                calPayRollTask.setCalPayRollTaskValidatorErrorMsg((String)validateResult.get(taskId));
                iterator.remove();
                this.calPayRollTaskContext.getInvalidDatas().add(calPayRollTask);
                this.calPayRollTaskContext.getValidateCauseOfFailure().add(validateResult.get(taskId));
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTask.getCalPayRollTaskId()), (String)this.calPersonOperationEnum.getOperationKey());
            }
        }
        return result;
    }
}

