/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.guide;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.form.JobFormInfo;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.cal.helper.CalProcessHandler;
import kd.swc.hsas.common.vo.CalPayRollTaskProcessVO;
import kd.swc.hsas.common.vo.CalProcessVO;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalPayRollTaskCancelCalProcessPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(CalPayRollTaskCancelCalProcessPlugin.class);
    private static final String VIEW_CAL_RECORD = "donothing_viewcalrecord";
    private static final String PERMITEMID = "0SWBXI04K+PJ";
    private static final String MINIMIZE = "minimize";
    private static final String BTN_OK = "btn_ok";
    public static final String PROCESS = "cancelcalprocess";
    public static final String CAL_PROCESS = "calprocess";
    public static final String CANCEL_CAL_INFO = "cancelcalInfo_%s";
    private static final String CANCEL_CAL_SUCC_COUNT = "cancelcalsucccount";
    private static final String CANCEL_CAL_FAIL_COUNT = "cancelcalfailcount";
    private static final String CANCEL_CAL_TODO_LABEL = "cancelcaltodolabel";
    private static final String CANCEL_CAL_TODO_COUNT = "cancelcaltodocount";
    private static final String KEY_ONCANCELAP = "oncancelap";
    private static final String KEY_AFTERCANCELAP = "aftercancelap";
    private static final String VIEW_CAL_REQUEST = "donothing_viewcalrequestlist";

    public void initialize() {
        super.initialize();
        ProgressBar cancelCalProcess = (ProgressBar)this.getControl(PROCESS);
        cancelCalProcess.addProgressListener((ProgresssListener)this);
        logger.info("\u8ba1\u7b97\u56de\u6eda\u8fdb\u5ea6\u6761\u521d\u59cb\u5316");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setCalInfo();
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_OK, KEY_AFTERCANCELAP});
        ProgressBar cancelCalProcess = (ProgressBar)this.getControl(PROCESS);
        cancelCalProcess.start();
    }

    public void onProgress(ProgressEvent progressEvent) {
        Control control = (Control)progressEvent.getSource();
        String progressKey = control.getKey();
        if (StringUtils.equals((CharSequence)progressKey, (CharSequence)PROCESS)) {
            this.queryAndSetProgressDetails(progressEvent);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (SWCStringUtils.equals((String)operate.getOperateKey(), (String)VIEW_CAL_RECORD)) {
            if (!SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)PERMITEMID)) {
                this.getView().showErrorNotification(SWCPermissionServiceHelper.getNoPermTips((String)operate.getOperateName().getLocaleValue()));
                args.setCancel(true);
                return;
            }
            CalPayRollTaskProcessVO calPayRollTaskProcessVO = this.getCalPayRollTaskProcessVO();
            ArrayList calRecordIds = new ArrayList();
            calPayRollTaskProcessVO.getCalProcessVOs().forEach(calProcessVO -> calRecordIds.add(calProcessVO.getCalRecordId()));
            ArrayList calTaskIds = new ArrayList();
            calPayRollTaskProcessVO.getCalProcessVOs().forEach(calProcessVO -> calTaskIds.add(calProcessVO.getCalTaskId()));
            ListShowParameter show = new ListShowParameter();
            show.setBillFormId("hsas_calrecord");
            show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            show.setCustomParam("calRecordIds", calRecordIds);
            QFilter filter = new QFilter("caltask.id", "in", calTaskIds);
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(filter);
            show.setListFilterParameter(new ListFilterParameter(filters, ""));
            if (CalProcessHandler.isParentRequestList((IFormView)this.getView())) {
                CalProcessHandler.grandfatherShow((IFormView)this.getView(), (FormShowParameter)show);
                return;
            }
            if (this.getView().getView(calPayRollTaskProcessVO.getRootPageId()) != null) {
                this.getView().getParentView().showForm((FormShowParameter)show);
                this.getView().sendFormAction(this.getView().getParentView());
            }
            this.getView().close();
        } else if (SWCStringUtils.equals((String)operate.getOperateKey(), (String)VIEW_CAL_REQUEST)) {
            CalProcessHandler.openRequestList((IFormView)this.getView());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        CalPayRollTaskProcessVO calPayRollTaskProcessVO = this.getCalPayRollTaskProcessVO();
        this.toBackground(calPayRollTaskProcessVO);
    }

    private void toBackground(CalPayRollTaskProcessVO calPayRollTaskProcessVO) {
        String traceId = calPayRollTaskProcessVO.getTraceId();
        CalProcessHandler calProcessHandler = CalProcessHandler.buildCancelCalProcessHandler((CalPayRollTaskProcessVO)this.getCalPayRollTaskProcessVO());
        int calProcess = calProcessHandler.getCalProcess();
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_PROCESS_%s", traceId));
        JobFormInfo jobFormInfo = (JobFormInfo)appCache.get("platformTaskInfo_%s", JobFormInfo.class);
        if (calProcess < 100 && jobFormInfo == null) {
            this.dispatchTask();
        }
        String rootPageId = calPayRollTaskProcessVO.getRootPageId();
        IFormView rootPageView = this.getView().getView(rootPageId);
        if (rootPageView != null) {
            rootPageView.invokeOperation("refresh");
            this.getView().sendFormAction(rootPageView);
        }
    }

    private JobFormInfo dispatchTask() {
        CalPayRollTaskProcessVO calPayRollTaskProcessVO = this.getCalPayRollTaskProcessVO();
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_PROCESS_%s", calPayRollTaskProcessVO.getTraceId()));
        Map data = this.getView().getFormShowParameter().getCustomParams();
        HashMap<String, String> params = new HashMap<String, String>(data.size());
        params.putAll(data);
        HRBackgroundTaskHelper instance = HRBackgroundTaskHelper.getInstance();
        String bgTaskId = instance.createBaskgroundTask("swc_hsas_batchcancelcal", ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97(\u8ba1\u7b97\u56de\u6eda)", (String)"CalPayRollTaskCancelCalProcessPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), true, this.getView().getMainView().getPageId(), this.getView().getParentView().getPageId(), params);
        instance.showBaskgroundTask(bgTaskId);
        JobFormInfo jobFormInfo = instance.getJobFormInfoByTaskId(bgTaskId);
        params.put("parentpageid", this.getView().getFormShowParameter().getParentPageId());
        appCache.put("platformTaskInfo_%s", (Object)jobFormInfo);
        appCache.put(String.format(Locale.ROOT, CANCEL_CAL_INFO, bgTaskId), params);
        return jobFormInfo;
    }

    private void queryAndSetProgressDetails(ProgressEvent progressEvent) {
        Control control = (Control)progressEvent.getSource();
        String progressKey = control.getKey();
        CalProcessHandler calProcessHandler = CalProcessHandler.buildCancelCalProcessHandler((CalPayRollTaskProcessVO)this.getCalPayRollTaskProcessVO());
        int calProcess = calProcessHandler.getCalProcess();
        Label process = (Label)this.getControl(CAL_PROCESS);
        process.setText(String.valueOf(calProcess) + '%');
        progressEvent.setProgress(calProcess);
        IFormView view = this.getView();
        if (calProcess > 0) {
            Label calSuccessCount = (Label)this.getControl(CANCEL_CAL_SUCC_COUNT);
            calSuccessCount.setText(String.valueOf(calProcessHandler.getSuccessCount()));
            Label calFailCount = (Label)this.getControl(CANCEL_CAL_FAIL_COUNT);
            calFailCount.setText(String.valueOf(calProcessHandler.getFailCount()));
            Label calTodoCount = (Label)this.getControl(CANCEL_CAL_TODO_COUNT);
            calTodoCount.setText(String.valueOf(calProcessHandler.getPendingCount()));
            if (calProcess >= 100) {
                CalProcessHandler.changeGreenProgressColor((IFormView)this.getView(), (String)progressKey);
                view.setVisible(Boolean.FALSE, new String[]{MINIMIZE, KEY_ONCANCELAP, "viewcalrequest"});
                view.setVisible(Boolean.TRUE, new String[]{BTN_OK, KEY_AFTERCANCELAP});
                ProgressBar cancelCalProcess = (ProgressBar)this.getControl(PROCESS);
                cancelCalProcess.stop();
            }
        }
        String consumerTime = SWCDateTimeUtils.getConsumeTime((Date)calProcessHandler.getStartTime());
        this.setText("consumetimelabe", ResManager.loadKDString((String)"\uff08\u8017\u65f6\uff1a{0}\uff09", (String)"CalProgressPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[]{consumerTime}));
    }

    private CalPayRollTaskProcessVO getCalPayRollTaskProcessVO() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String customParam = (String)parameter.getCustomParam("params");
        return (CalPayRollTaskProcessVO)SerializationUtils.fromJsonString((String)customParam, CalPayRollTaskProcessVO.class);
    }

    private void setText(String key, String text) {
        Label control = (Label)this.getControl(key);
        if (control != null) {
            control.setText(text);
        }
    }

    private void setCalInfo() {
        CalPayRollTaskProcessVO calPayRollTaskProcessVO = this.getCalPayRollTaskProcessVO();
        int calCount = 0;
        for (CalProcessVO calProcessVO : calPayRollTaskProcessVO.getCalProcessVOs()) {
            calCount += calProcessVO.getCalCount();
        }
        this.setText("taskcount", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u672c\u6b21\u6838\u7b97\u4efb\u52a1\u603b\u6570\uff1a%s\u4e2a", (String)"CalPayRollTaskCalProcessPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]), calPayRollTaskProcessVO.getCalProcessVOs().size()));
        this.setText("personcount", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6838\u7b97\u8bb0\u5f55\u603b\u6570\uff1a%s\u6761", (String)"CalPayRollTaskCalProcessPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]), calCount));
    }
}

