/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.guide;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.mq.BatchPayDetailPublisher;
import kd.swc.hsas.business.payrollscene.service.SWCPayRollSceneService;
import kd.swc.hsas.formplugin.web.guide.AbstractCalPayRollTaskList;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CreatePayDetailType;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalPayRollTaskPayList
extends AbstractCalPayRollTaskList {
    private static final Log logger = LogFactory.getLog(CalPayRollTaskPayList.class);

    @Override
    protected List<CalPersonOperationEnum> operationKey() {
        ArrayList<CalPersonOperationEnum> calPersonOperationEnums = new ArrayList<CalPersonOperationEnum>();
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_CREATEPAY);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_VIEWPAYDETAIL);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_DELDETAIL);
        return calPersonOperationEnums;
    }

    @Override
    protected boolean hasPerm(CalPersonOperationEnum calPersonOperationEnum) {
        switch (calPersonOperationEnum) {
            case OP_CREATEPAY: 
            case OP_DELDETAIL: {
                return SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)calPersonOperationEnum.getPermission());
            }
        }
        return true;
    }

    @Override
    protected boolean operationMutex() {
        switch (this.calPersonOperationEnum) {
            case OP_VIEWPAYDETAIL: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void execute() {
        switch (this.calPersonOperationEnum) {
            case OP_CREATEPAY: 
            case OP_DELDETAIL: {
                this.getPageCache().put("invokeOperation", "true");
                this.doOperation();
                break;
            }
            case OP_VIEWPAYDETAIL: {
                this.openPayDetailList();
                break;
            }
        }
    }

    @Override
    protected void invokeOperation() {
        switch (this.calPersonOperationEnum) {
            case OP_CREATEPAY: {
                SWCThreadPoolFactory.getPayrolltaskOpThreadpool().execute(() -> {
                    String batchId = this.calPayRollTaskContext.getTraceId();
                    for (CalPayRollTask validData : this.calPayRollTaskContext.getValidDatas()) {
                        DynamicObject[] calPersonDynamicObjects = this.queryCalPersons("id", validData);
                        if (calPersonDynamicObjects != null && calPersonDynamicObjects.length > 0) {
                            ArrayList<Long> calPersons = new ArrayList<Long>(calPersonDynamicObjects.length);
                            for (DynamicObject calPersonDynamicObject : calPersonDynamicObjects) {
                                calPersons.add(calPersonDynamicObject.getLong("id"));
                            }
                            List split = SWCListUtils.split(calPersons, (int)20000);
                            split.forEach(calPersonList -> {
                                HashMap<String, Object> param = new HashMap<String, Object>(16);
                                param.put("calPersonList", calPersonList);
                                param.put("calPayRollTaskId", validData.getCalPayRollTaskId());
                                param.put("batchId", batchId);
                                param.put("createPayDetailType", CreatePayDetailType.NORMAL);
                                param.put("entityName", "hsas_calpayrolltask");
                                BatchPayDetailPublisher.publishBatchPayDetailMsg(param);
                            });
                            continue;
                        }
                        PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(validData.getCalPayRollTaskId()), (String)CalPersonOperationEnum.OP_CREATEPAY.getOperationKey());
                    }
                });
                break;
            }
            default: {
                this.doInvokeOperation();
            }
        }
    }

    @Override
    protected void beforeDoOperation(BeforeDoOperationEventArgs args, CalPayRollTask calPayRollTask) {
        Long taskId = calPayRollTask.getCalPayRollTaskId();
        if (taskId != null && taskId > 0L) {
            SWCPayRollSceneService sceneService = SWCPayRollSceneService.createInstance();
            DynamicObject schemeAfterCalObj = sceneService.getAfterCalObjByTask(taskId);
            switch (this.calPersonOperationEnum) {
                case OP_CREATEPAY: 
                case OP_DELDETAIL: 
                case OP_VIEWPAYDETAIL: {
                    String schemeAfterCalNumber;
                    if (schemeAfterCalObj == null || SWCStringUtils.equals((String)"1010_S", (String)(schemeAfterCalNumber = schemeAfterCalObj.getString("number")))) break;
                    calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                    calPayRollTask.setCalPayRollTaskValidatorErrorMsg(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4efb\u52a1\u7684\u6838\u7b97\u540e\u5904\u7406\u7c7b\u578b\u4e3a\u975e\u85aa\u8d44\u53d1\u653e\uff0c\u4e0d\u652f\u6301\u8fdb\u884c\u53d1\u653e\u53ca\u5de5\u8d44\u6761\u76f8\u5173\u64cd\u4f5c\u3002", (String)"CalPayrollTaskSalarySlipList_9", (String)"swc-hsas-formplugin", (Object[])new Object[]{schemeAfterCalObj.getString("number")}));
                    break;
                }
            }
        }
        switch (this.calPersonOperationEnum) {
            case OP_CREATEPAY: {
                String calTaskId = calPayRollTask.getCalPayRollTaskId().toString();
                if (!this.hasPayOutItem(Long.valueOf(calTaskId))) {
                    calPayRollTask.setValidatorResult(false);
                    calPayRollTask.setCalPayRollTaskValidatorErrorMsg(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u89c4\u5219\u4e0b\u65e0\u5b9e\u53d1\u9879\u76ee\uff0c\u65e0\u6cd5\u751f\u6210\u660e\u7ec6\u3002", (String)"HSASCalTableListPayPlugin_25", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                    return;
                }
                calPayRollTask.getOperationParam().put("caltaskid", calTaskId);
                break;
            }
        }
    }

    private boolean hasPayOutItem(Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String selectProperties = "calrulev.calruleitementry.ispayoutitem";
        DynamicObject taskInfo = helper.queryOne(selectProperties, (Object)calTaskId);
        DynamicObjectCollection ent = taskInfo.getDynamicObjectCollection("calrulev.calruleitementry");
        for (DynamicObject dynamicObject : ent) {
            boolean ispayoutitem = dynamicObject.getBoolean("ispayoutitem");
            if (!ispayoutitem) continue;
            return true;
        }
        return false;
    }

    private void openPayDetailList() {
        List validDatas = this.calPayRollTaskContext.getValidDatas();
        ArrayList<String> defaultTaskNumbers = new ArrayList<String>();
        Date beginDate = null;
        Date endPeriod = null;
        String selectProperties = "id,number,salaryfile.employee.empnumber,caltask.number,paystatus,onholdstatus,belongperiod";
        for (CalPayRollTask calPayRollTask : validDatas) {
            DynamicObject[] dyObjs = this.queryCalPersonsAndSetCalPersonIds(selectProperties, calPayRollTask);
            if (dyObjs == null) continue;
            HashMap<Long, String> onHoldDatasMap = new HashMap<Long, String>(dyObjs.length);
            boolean isCreateDetail = false;
            for (DynamicObject dyObj : dyObjs) {
                String paystatus = dyObj.getString("paystatus");
                Date belongPeriod = dyObj.getDate("belongperiod");
                beginDate = this.compareAndSetStartPeriod(beginDate, belongPeriod);
                endPeriod = this.compareAndSetEndPeriod(endPeriod, belongPeriod);
                if (SWCStringUtils.equals((String)PayStateEnum.UNPAY.getCode(), (String)paystatus) || SWCStringUtils.equals((String)PayStateEnum.PAYING.getCode(), (String)paystatus) || SWCStringUtils.equals((String)PayStateEnum.PAID.getCode(), (String)paystatus) || SWCStringUtils.equals((String)PayStateEnum.PREPAREPAY.getCode(), (String)paystatus)) {
                    isCreateDetail = true;
                    continue;
                }
                String onholdstatus = dyObj.getString("onholdstatus");
                if (!SWCStringUtils.isNotEmpty((String)onholdstatus) || !SWCStringUtils.equals((String)PayStateEnum.UNCREATE.getCode(), (String)paystatus)) continue;
                onHoldDatasMap.put(dyObj.getLong("id"), dyObj.getString("salaryfile.employee.empnumber"));
            }
            if (this.confirmAbandonPayDetails(onHoldDatasMap)) {
                isCreateDetail = true;
            }
            if (!isCreateDetail) continue;
            String defaultTaskNumber = calPayRollTask.getNumber();
            defaultTaskNumbers.add(defaultTaskNumber);
        }
        if (defaultTaskNumbers.size() > 0) {
            this.showPayDetail(defaultTaskNumbers, beginDate, endPeriod);
        } else {
            String msg = ResManager.loadKDString((String)"\u6240\u9009\u6838\u7b97\u4efb\u52a1\u672a\u751f\u6210\u53d1\u653e\u660e\u7ec6\uff0c\u65e0\u5bf9\u5e94\u53ef\u67e5\u8be2\u6570\u636e\u3002", (String)"HSASCalTableListPayPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
        }
    }

    private void showPayDetail(List<String> defaultTaskNumbers, Date beginDate, Date endPeriod) {
        ListShowParameter show = new ListShowParameter();
        show.setBillFormId("hsas_paydetail");
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        show.setCustomParam("defaultTaskNumbers", defaultTaskNumbers);
        show.setCustomParam("abandonedstatus", (Object)"0");
        if (beginDate != null) {
            if (beginDate.equals(endPeriod)) {
                HashMap<String, String> payRollDateMap = this.getPayRollDateMap(SWCDateTimeUtils.format((Date)beginDate, (String)"yyyy-MM-dd"));
                show.setCustomParam("beginDate", (Object)payRollDateMap.get("beginDate"));
                show.setCustomParam("endDate", (Object)payRollDateMap.get("endDate"));
            } else {
                show.setCustomParam("beginDate", (Object)SWCDateTimeUtils.format((Date)beginDate, (String)"yyyy-MM-dd"));
                show.setCustomParam("endDate", (Object)SWCDateTimeUtils.format((Date)endPeriod, (String)"yyyy-MM-dd"));
            }
        }
        this.getView().showForm((FormShowParameter)show);
    }

    private HashMap<String, String> getPayRollDateMap(String payRollDateStr) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        Date date = null;
        try {
            date = SWCDateTimeUtils.parseDate((String)payRollDateStr, (String)"yyyy-MM");
            Date beginDate = SWCDateTimeUtils.addMonth((Date)date, (int)1);
            String beginFormat = SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
            Date endDate = SWCDateTimeUtils.addDay((Date)beginDate, (long)-1L);
            String endFormat = SWCDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd");
            map.put("beginDate", beginFormat);
            map.put("endDate", endFormat);
            return map;
        }
        catch (ParseException e) {
            logger.error("date error", (Throwable)e);
            return map;
        }
    }

    private Date compareAndSetStartPeriod(Date beginDate, Date belongPeriod) {
        if (beginDate == null) {
            beginDate = belongPeriod;
        } else if (belongPeriod.before(beginDate)) {
            beginDate = belongPeriod;
        }
        return beginDate;
    }

    private Date compareAndSetEndPeriod(Date endPeriod, Date belongPeriod) {
        if (endPeriod == null) {
            endPeriod = belongPeriod;
        } else if (belongPeriod.after(endPeriod)) {
            endPeriod = belongPeriod;
        }
        return endPeriod;
    }

    private boolean confirmAbandonPayDetails(Map<Long, String> onHoldDatasMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter qFilter = new QFilter("calpersonid", "in", onHoldDatasMap.keySet());
        DynamicObject[] payDetailsObjs = helper.query("id,calpersonid", new QFilter[]{qFilter});
        return null != payDetailsObjs && payDetailsObjs.length > 0;
    }
}

