/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.guide;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.formplugin.web.guide.AbstractCalPayRollTaskList;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;

public class CalPayrollTaskAuditList
extends AbstractCalPayRollTaskList {
    private static final Log logger = LogFactory.getLog(CalPayrollTaskAuditList.class);

    @Override
    protected List<CalPersonOperationEnum> operationKey() {
        ArrayList<CalPersonOperationEnum> calPersonOperationEnums = new ArrayList<CalPersonOperationEnum>();
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_AUDIT);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_UNAUDIT);
        return calPersonOperationEnums;
    }

    @Override
    protected boolean hasPerm(CalPersonOperationEnum calPersonOperationEnum) {
        switch (calPersonOperationEnum) {
            case OP_AUDIT: 
            case OP_UNAUDIT: {
                return SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)calPersonOperationEnum.getPermission());
            }
        }
        return true;
    }

    @Override
    protected void execute() {
        switch (this.calPersonOperationEnum) {
            case OP_AUDIT: 
            case OP_UNAUDIT: {
                this.getPageCache().put("invokeOperation", "true");
                this.doOperation();
                break;
            }
        }
    }

    @Override
    protected void beforeDoOperation(BeforeDoOperationEventArgs args, CalPayRollTask calPayRollTask) {
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption operateOption = formOperate.getOption();
        switch (this.calPersonOperationEnum) {
            case OP_UNAUDIT: {
                if (operateOption.tryGetVariableValue("CallBackInvoke", new RefObject())) break;
                this.unAuditValidator(args, calPayRollTask);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        CalPersonOperationEnum calPersonOperationEnum = CalPersonOperationEnum.getCalOperationEnum((String)callBackId);
        if (calPersonOperationEnum == null) {
            return;
        }
        switch (calPersonOperationEnum) {
            case OP_UNAUDIT: {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    if (SWCPermissionServiceHelper.checkCancelDataAndFunctionRight((IFormView)this.getView(), (boolean)true)) {
                        this.releaseDistributedLock();
                        return;
                    }
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("CallBackInvoke", "true");
                    this.getView().invokeOperation(CalPersonOperationEnum.OP_UNAUDIT.getOperationKey(), operateOption);
                    break;
                }
                this.releaseDistributedLock();
                break;
            }
        }
    }

    private void unAuditValidator(BeforeDoOperationEventArgs args, CalPayRollTask calPayRollTask) {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u65f6\uff0c\u4f1a\u5220\u9664\u751f\u6210\u7684\u53d1\u653e\u660e\u7ec6\u548c\u5206\u644a\u660e\u7ec6\uff0c\u540c\u65f6\u5e9f\u5f03\u6389\u62a5\u76d8\u5931\u6548\u3001\u5df2\u89e3\u85aa\u3001\u94f6\u884c\u5361\u53d8\u66f4\u4e2d\u7684\u53d1\u653e\u660e\u7ec6\uff0c\u662f\u5426\u786e\u8ba4?", (String)"HSASCalTableList_118", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(this.calPersonOperationEnum.getOperationKey()));
        calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
        args.setCancel(true);
    }
}

