/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.guide;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.helper.CalPersonListHelper;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsas.business.payrollscene.service.SWCPayRollSceneService;
import kd.swc.hsas.business.payrolltask.helper.PayRollTaskHelper;
import kd.swc.hsas.business.payrolltask.service.PayRollTaskService;
import kd.swc.hsas.business.payrolltask.service.PayRollTaskSummaryService;
import kd.swc.hsas.business.payrolltask.service.TaskConfirmEnum;
import kd.swc.hsas.common.enums.AfterCalEnum;
import kd.swc.hsbp.business.addperson.entity.CalPersonAddProgressInfo;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.calperson.CalPersonHelper;
import kd.swc.hsbp.business.datachanged.BizChangedHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.constants.CalPayrollTaskConstants;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.enums.CalPersonLockEnum;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class CalPayrollTaskNewEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(CalPayrollTaskNewEdit.class);
    private static final String ISHANDLEPRORATION = "ishandleproration";
    private static final String[] BATCH_DISABLE_FIELDS = new String[]{"payrollscene", "period", "calrulev", "exratedate", "paydate", "ishandleproration"};
    private static final String DEFAULT_START_DATE = "0001-01-01";
    private static final String RESULT_COVER_CALLBACK_KEY = "result_cover_callback";
    private static final String HRQXX0183 = "2B+PAOIVQZOE";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        SWCPayRollSceneService.createInstance().multiSetBeforeF7SelectListener((Object)this, new String[]{"payrollscene", "payrollgroup", "calrulev", "period"});
    }

    public void createNewData(BizDataEventArgs e) {
        for (String field : BATCH_DISABLE_FIELDS) {
            this.getView().setEnable(Boolean.FALSE, new String[]{field});
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        this.setDefaultTracker();
        this.getModel().setDataChanged(false);
        this.getView().setVisible(Boolean.FALSE, new String[]{"attdaterange"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String isFirstCopy = "isFirstCopy";
        IPageCache pageCache = this.getPageCache();
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("iscopy") && !Boolean.FALSE.toString().equals(pageCache.get(this.getView().getPageId() + isFirstCopy))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"calrulev", "exratedate", "paydate"});
            this.setDefaultTracker();
            IDataModel iDataModel = this.getModel();
            iDataModel.setValue("tasknewmethod", (Object)"1");
            iDataModel.setValue("tasknewtplhis", null);
            iDataModel.setValue("calrulev", null);
            iDataModel.setValue("period", null);
            iDataModel.setValue("calcount", null);
            iDataModel.setValue("number", null);
            DynamicObject dataEntity = iDataModel.getDataEntity();
            List<String> orderFieldList = Arrays.asList("payrollgroup.id", "payrollgroupv.id", "payrollscene.id", "payrollscenev.id", "calrule.id", "periodtype.id", "callistrule.id");
            ArrayList<String> allOrderFieldList = new ArrayList<String>(orderFieldList);
            allOrderFieldList.addAll(Arrays.asList(CalPayrollTaskConstants.CAL_LIST_VIEW_IN_GROUP.toString(), CalPayrollTaskConstants.CAL_LIST_VIEW_IN_SCENE.toString()));
            PayRollTaskService payRollTaskService = PayRollTaskService.createInstance();
            int index = payRollTaskService.checkFieldValid(orderFieldList, dataEntity);
            if (index >= 0 || (index = payRollTaskService.checkCalListViewValid(dataEntity, orderFieldList.size())) >= 0) {
                if (index == 0) {
                    this.clearFields("payrollgroup", "payrollgroupv", "payrollscene", "payrollscenev", "calrule", "periodtype", "calfrequency", "aftercal", "callistviewv", "org");
                } else {
                    this.clearFields("payrollgroupv", "payrollscene", "payrollscenev", "calrule", "periodtype", "calfrequency", "aftercal", "callistviewv");
                }
                Map fieldErrMsgWhenCopyMap = payRollTaskService.getFieldErrMsgWhenCopyMap();
                String errFieldKey = (String)allOrderFieldList.get(index);
                String errMsg = (String)fieldErrMsgWhenCopyMap.get(errFieldKey);
                this.getView().showErrorNotification(errMsg);
            } else {
                payRollTaskService.checkPeriodTypeInfoAndSetFilterForPeriod((AbstractFormPlugin)this, Long.valueOf(dataEntity.getLong("periodtype.id")));
            }
            pageCache.put(this.getView().getPageId() + isFirstCopy, Boolean.FALSE.toString());
            this.setProrationCalEnable(true);
        }
        this.setAttDaterangeVisible();
        this.getView().setVisible(Boolean.valueOf("1".equals(this.getModel().getDataEntity().getString("tasktype"))), new String[]{"islimitadd"});
        DynamicObject scene = this.getModel().getDataEntity().getDynamicObject("payrollscene");
        this.getView().setEnable(Boolean.valueOf(scene != null), new String[]{"islimitadd"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setViewLockableForModify();
        this.setFilterForPeriod();
        this.setPayrollYearShow();
        this.setTrackerFilter();
        this.clearDataChangeForFirstInit();
        this.updateSummary();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
    }

    private void setProrationCalEnable(boolean isInit) {
        DynamicObject data = this.getModel().getDataEntity();
        long payrollgroupVid = data.getLong("payrollgroupv.id");
        long payrollsceneId = data.getLong("payrollscene.id");
        if (payrollgroupVid == 0L || payrollsceneId == 0L) {
            return;
        }
        String prorationCal = PayRollTaskHelper.getProrationCalValue((long)payrollgroupVid, (long)payrollsceneId);
        if ("1".equals(prorationCal) && SWCStringUtils.equals((String)data.getString("taskstatus"), (String)CalPayrollTaskStateEnum.CREATE.getCode())) {
            this.getView().setEnable(Boolean.TRUE, new String[]{ISHANDLEPRORATION});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{ISHANDLEPRORATION});
        }
        if (!isInit) {
            this.getModel().setValue(ISHANDLEPRORATION, (Object)prorationCal);
        }
    }

    private void updateSummary() {
        PayRollTaskSummaryService.createInstance().setTaskSummary((Object)this);
    }

    private void setViewLockableForModify() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        String from = (String)formShowParameter.getCustomParam("from");
        if (OperationStatus.EDIT.equals((Object)status) && SWCStringUtils.equalsIgnoreCase((String)from, (String)"modify")) {
            this.setFieldsEditAndLock();
            this.setProrationCalEnable(true);
        }
    }

    private void clearDataChangeForFirstInit() {
        String isFirstInit = "IsFirstInit";
        IPageCache pageCache = this.getPageCache();
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("iscopy") && !Boolean.FALSE.toString().equals(pageCache.get(this.getView().getPageId() + isFirstInit))) {
            this.getModel().setDataChanged(false);
            pageCache.put(this.getView().getPageId() + isFirstInit, Boolean.FALSE.toString());
        }
    }

    private void setFilterForPeriod() {
        IDataModel iDataModel = this.getModel();
        DynamicObject dataEntity = iDataModel.getDataEntity();
        Long periodTypeId = dataEntity.getLong("periodtype.id");
        if (periodTypeId != 0L) {
            PayRollTaskService.createInstance().checkPeriodTypeInfoAndSetFilterForPeriod((AbstractFormPlugin)this, periodTypeId);
        }
    }

    private void setCalCount() {
        boolean isNeedRollBackCalCount;
        Long taskId = (Long)this.getModel().getDataEntity().getPkValue();
        DynamicObject srcTaskDyObj = null;
        if (taskId != 0L) {
            srcTaskDyObj = CalPayrollTaskHelper.queryOriginalTaskInfoById((String)"id,payrollgroup.id,payrollscene.id,period.id,calcount", (Long)taskId);
        }
        PayRollTaskService payRollTaskService = PayRollTaskService.createInstance();
        String srcPayRollGrpSceneAndPeriodKey = payRollTaskService.getPayRollGrpSceneAndPeriodKey(srcTaskDyObj);
        String currPayRollGrpSceneAndPeriodKey = payRollTaskService.getPayRollGrpSceneAndPeriodKey(this.getModel().getDataEntity());
        boolean bl = isNeedRollBackCalCount = srcPayRollGrpSceneAndPeriodKey != null && srcTaskDyObj != null && srcPayRollGrpSceneAndPeriodKey.equals(currPayRollGrpSceneAndPeriodKey);
        if (isNeedRollBackCalCount) {
            this.getModel().setValue("calcount", srcTaskDyObj.get("calcount"));
            return;
        }
        String calCount = payRollTaskService.getCalCount(this.getModel().getDataEntity());
        this.getModel().setValue("calcount", (Object)(calCount == null ? "1" : calCount));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        Object[] changeSets = args.getChangeSet();
        if (SWCArrayUtils.isEmpty((Object[])changeSets)) {
            return;
        }
        switch (name = args.getProperty().getName()) {
            case "payrollgroup": {
                PayRollTaskService payRollTaskService = PayRollTaskService.createInstance();
                Long oldPayRollGroupId = payRollTaskService.getFieldPkId((DynamicObject)changeSets[0].getOldValue());
                Long newPayRollGroupId = payRollTaskService.getFieldPkId((DynamicObject)changeSets[0].getNewValue());
                if (newPayRollGroupId == null) {
                    this.clearFields("payrollgroupv", "payrollscene", "payrollscenev", "calrule", "calrulev", "periodtype", "period", "callistviewv", "org", "exratedate", "paydate");
                    this.getView().setEnable(Boolean.FALSE, new String[]{"payrollscene", "period", "calrulev", "exratedate", "paydate"});
                    break;
                }
                if (!newPayRollGroupId.equals(oldPayRollGroupId)) {
                    this.clearFields("payrollgroupv", "payrollscene", "payrollscenev", "calrule", "calrulev", "periodtype", "period", "callistviewv", "org", "exratedate", "paydate");
                    this.getModel().setValue("org", (Object)PayRollTaskService.createInstance().getDyObjFieldId((DynamicObject)changeSets[0].getNewValue(), "org"));
                    this.getView().setEnable(Boolean.TRUE, new String[]{"payrollscene"});
                    break;
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{"payrollscene"});
                break;
            }
            case "tasktype": {
                this.adjustAutoAddPersonSwitch((String)args.getChangeSet()[0].getNewValue());
                break;
            }
            case "payrollscenev": {
                this.adjustCalRuleAndPeriodType((DynamicObject)changeSets[0].getNewValue());
                this.setAttDaterangeVisible();
                break;
            }
            case "payrollscene": {
                DynamicObject scene = this.getModel().getDataEntity().getDynamicObject("payrollscene");
                if (scene != null) {
                    this.getModel().setValue("islimitadd", scene.get("islimitadd"));
                }
                this.getView().setEnable(Boolean.valueOf(scene != null), new String[]{"islimitadd"});
                break;
            }
            case "periodtype": {
                DynamicObject periodTypeInfo = (DynamicObject)changeSets[0].getNewValue();
                if (periodTypeInfo == null || periodTypeInfo.getLong("id") == 0L) {
                    this.getModel().setValue("calfrequency", null);
                    break;
                }
                this.getModel().setValue("calfrequency", (Object)periodTypeInfo.getLong("calfrequency.id"));
                break;
            }
            case "period": {
                if (this.checkDataUnChanged((ChangeData[])changeSets)) break;
                this.adjustFieldAboutPeriod((DynamicObject)changeSets[0].getNewValue());
                this.setAttDaterangeVisible();
                break;
            }
            case "calrulev": {
                this.verifyCalRuleVHasPayoutItem();
                break;
            }
        }
    }

    private boolean checkDataUnChanged(ChangeData[] changeSets) {
        DynamicObject oldDyObj = (DynamicObject)changeSets[0].getOldValue();
        DynamicObject newDyObj = (DynamicObject)changeSets[0].getNewValue();
        return oldDyObj != null && newDyObj != null && oldDyObj.getLong("id") == newDyObj.getLong("id");
    }

    private void adjustFieldAboutPeriod(DynamicObject periodDyObj) {
        String errMsg;
        Long calListRuleID;
        this.clearFields("calrulev", "STARTDATE", "ENDDATE", "payrollyearshow", "payrolldate", "payrollyear", "payrollmonth", "exratedate", "paydate", "ATTSTARTDATE", "ATTENDDATE");
        if (periodDyObj == null || periodDyObj.getLong("id") == 0L) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"calrulev", "exratedate", "paydate"});
            return;
        }
        PayRollTaskService payRollTaskService = PayRollTaskService.createInstance();
        DynamicObject payRollSceneVDyObj = this.getModel().getDataEntity().getDynamicObject("payrollscenev");
        if (payRollSceneVDyObj != null && (calListRuleID = Long.valueOf(payRollSceneVDyObj.getLong("callistrule.id"))) != 0L && (errMsg = payRollTaskService.checkCalListRuleV(calListRuleID, periodDyObj.getDate("enddate"))) != null) {
            this.getView().showErrorNotification(errMsg);
            this.getView().setEnable(Boolean.FALSE, new String[]{"calrulev", "exratedate", "paydate"});
            this.clearFields("period");
            return;
        }
        long calRuleId = this.getModel().getDataEntity().getLong("calrule.id");
        payRollTaskService.setDateAboutPeriodAndCalRuleV(this.getView(), periodDyObj, calRuleId);
        this.setCalCount();
        String defaultPayRollTaskName = payRollTaskService.getCalPayRollTaskDefaultName(this.getModel().getDataEntity());
        if (defaultPayRollTaskName.length() > 0) {
            this.getModel().setValue("name", (Object)defaultPayRollTaskName);
        } else {
            this.getModel().setValue("name", null);
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"exratedate", "paydate"});
        this.getView().updateView();
    }

    private void adjustCalRuleAndPeriodType(DynamicObject paySceneVDyObj) {
        if (!SWCObjectUtils.isEmpty((Object)paySceneVDyObj)) {
            this.clearFields("calrulev", "period", "aftercal", "exratedate", "paydate", "ATTENDDATE", "ATTSTARTDATE");
            this.getModel().setValue("aftercal", (Object)paySceneVDyObj.getString("aftercal"));
            this.getView().setEnable(Boolean.TRUE, new String[]{"period"});
        } else {
            this.clearFields("payrollgroupv", "calrule", "calrulev", "periodtype", "period", "aftercal", "callistviewv", "exratedate", "paydate", "ATTENDDATE", "ATTSTARTDATE");
            this.getView().setEnable(Boolean.FALSE, new String[]{"period"});
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"calrulev", "exratedate", "paydate"});
    }

    private void adjustAutoAddPersonSwitch(String taskType) {
        if (taskType == null) {
            return;
        }
        Boolean isCommonSwitch = "0".equals(taskType);
        this.getModel().setValue("isautoaddperson", (Object)isCommonSwitch);
        this.getView().setVisible(Boolean.valueOf("1".equals(taskType)), new String[]{"islimitadd"});
        DynamicObject scene = this.getModel().getDataEntity().getDynamicObject("payrollscene");
        if (scene != null && "1".equals(taskType)) {
            this.getModel().setValue("islimitadd", scene.get("islimitadd"));
        }
        if (!"1".equals(taskType)) {
            this.getModel().setValue("islimitadd", (Object)Boolean.FALSE);
        }
        this.getView().updateView("isautoaddperson");
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
        switch (fieldKey) {
            case "payrollgroup": {
                List qFilters = param.getListFilterParameter().getQFilters();
                PayRollTaskService.setOrgAuthorFilter((List)qFilters);
                break;
            }
            case "payrollscene": {
                long payRollGrpId;
                event.setCancel(true);
                DynamicObject payRollGrpDyObj = (DynamicObject)this.getModel().getValue("payrollgroup");
                if (payRollGrpDyObj == null || (payRollGrpId = payRollGrpDyObj.getLong("id")) == 0L) break;
                ListShowParameter showParameter = PayRollTaskService.createInstance().getPayRollGroupEntityInfoShowParameter(payRollGrpId, SWCDateTimeUtils.getDateWithoutMinTs((Date)new Date()));
                if (SWCStringUtils.equalsIgnoreCase((String)((String)this.getView().getFormShowParameter().getCustomParam("from")), (String)"modify")) {
                    showParameter.setCustomParam("permissionId", (Object)"4715a0df000000ac");
                } else {
                    showParameter.setCustomParam("permissionId", (Object)HRQXX0183);
                }
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_payrollgrpschis"));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "calrulev": {
                DynamicObject calRuleDy = (DynamicObject)this.getModel().getValue("calrule");
                if (calRuleDy == null) break;
                long calRuleId = calRuleDy.getLong("id");
                QFilter qFilter = new QFilter("boid", "=", (Object)calRuleId);
                qFilter.and("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
                Date enddate = this.getModel().getDataEntity().getDate("period.enddate");
                Date startdate = null;
                try {
                    startdate = SWCDateTimeUtils.parseDate((String)DEFAULT_START_DATE);
                }
                catch (ParseException e) {
                    log.error((Throwable)e);
                }
                param.setCustomParam("effdatestart", (Object)startdate);
                param.setCustomParam("effdateend", (Object)enddate);
                param.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String taskStatus = dataEntity.getString("taskstatus");
        switch (operateKey) {
            case "save": {
                TaskConfirmEnum taskConfirmEnum;
                if (!CalPayrollTaskStateEnum.CREATE.getCode().equals(taskStatus) && !CalPayrollTaskStateEnum.UNCAL.getCode().equals(taskStatus)) {
                    return;
                }
                SWCPageCache pageCache = new SWCPageCache(this.getView());
                Boolean isContinueChange = (Boolean)pageCache.get("saveContinueConfirm", Boolean.class);
                if (!Boolean.TRUE.equals(isContinueChange) && this.checkResultCoverChanged()) {
                    String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u8c03\u6574\u540e\u7684\u8ba1\u7b97\u89c4\u5219\u7248\u672c\u4e2d\uff0c\u5b58\u5728\u85aa\u916c\u9879\u76ee\u88ab\u8c03\u6574\u4e3a\u4e0d\u5141\u8bb8\u7ed3\u679c\u8986\u76d6\u3002\u82e5\u5b58\u5728\u8986\u76d6\u6570\u636e\uff0c\u7cfb\u7edf\u5c06\u4f1a\u6e05\u7a7a\u3002", (String)"CalPayrollTaskNewEdit_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(RESULT_COVER_CALLBACK_KEY));
                    args.setCancel(true);
                    break;
                }
                if (Long.valueOf(0L).equals(this.getModel().getDataEntity().getPkValue()) && (taskConfirmEnum = TaskConfirmEnum.getInstance((String)this.getView().getEntityId(), (Boolean)"0".equals(this.getModel().getValue("tasktype")))) != null && taskConfirmEnum.confirmBeforeSave((Object)this)) {
                    args.setCancel(true);
                    break;
                }
                if (this.checkIsOpenAddPersonTable(args)) {
                    return;
                }
                if (SWCPermissionServiceHelper.checkCancelDataAndFunctionRight((IFormView)this.getView().getParentView(), (boolean)true)) {
                    args.setCancel(true);
                    return;
                }
                if (this.checkBeforeSave(args)) {
                    return;
                }
                this.setCalCount();
                this.setCreateTaskInfo();
                if (!SWCStringUtils.equals((String)CalPayrollTaskStateEnum.UNCAL.getCode(), (String)this.getModel().getDataEntity().getString("taskstatus"))) break;
                OperateOption operateOption = formOperate.getOption();
                operateOption.setVariableValue("allmodify", Boolean.FALSE.toString());
                break;
            }
            case "modify": {
                if (SWCPermissionServiceHelper.checkCancelDataAndFunctionRight((IFormView)this.getView().getParentView(), (boolean)true)) {
                    args.setCancel(true);
                    return;
                }
                if (!PayRollTaskService.checkDataPermission((Object)this.getModel().getDataEntity(true).getPkValue(), (String)"modify")) {
                    String entityName = EntityMetadataCache.getDataEntityType((String)"hsas_calpayrolltask").getDisplayName().getLocaleValue();
                    String permItemName = PayrollTaskHelper.getPermItemName((String)formOperate.getPermissionItemId());
                    String msg = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c{0}\u201d\u201c{1}\u201d\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalPayrollTaskNewEdit_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]), formOperate.getOperateName(), entityName, permItemName);
                    this.getView().showErrorNotification(msg);
                    args.setCancel(true);
                    break;
                }
                if (CalPayrollTaskStateEnum.DISUSED.getCode().equals(taskStatus)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5e9f\u5f03\uff0c\u65e0\u6cd5\u4fee\u6539\u3002", (String)"CalPayrollTaskNewEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (this.checkIsOpenAddPersonTable(args)) {
                    return;
                }
                this.checkBeforeModify();
                break;
            }
            case "donothing_closenotice": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"noticeflex"});
                break;
            }
        }
    }

    private boolean checkResultCoverChanged() {
        PayRollTaskService payRollTaskService = PayRollTaskService.createInstance();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long calRuleVid = dataEntity.getLong("calrulev.id");
        long calTaskId = dataEntity.getLong("id");
        return payRollTaskService.checkResultCoverChanged(calTaskId, calRuleVid);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (SWCObjectUtils.isEmpty((Object)returnDataObj)) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "hsas_payrollgrpschis": {
                ListSelectedRowCollection returnDataList = (ListSelectedRowCollection)returnDataObj;
                Object result = PayRollTaskService.checkAndGetPayRollGroupInfo((Long)((Long)returnDataList.get(0).getPrimaryKeyValue()));
                if (result instanceof List) {
                    for (String errMsg : (List)result) {
                        this.getView().showErrorNotification(errMsg);
                    }
                    break;
                }
                if (!(result instanceof Map)) break;
                Map resultMap = (Map)result;
                boolean isInValid = PayRollTaskService.createInstance().checkPeriodTypeInfoAndSetFilterForPeriod((AbstractFormPlugin)this, (Long)resultMap.get("periodtype"));
                if (isInValid) {
                    return;
                }
                resultMap.forEach((k, value) -> this.getModel().setValue(k, value));
                this.setProrationCalEnable(false);
                this.getView().updateView();
                BizChangedHelper.operateBizChangedSet((DynamicObject)this.getModel().getDataEntity(true), Collections.singletonList("payrollscene"), (BizChangedHelper.OperateEnum)BizChangedHelper.OperateEnum.ADD);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        IFormView parentView = null;
        switch (operateKey) {
            case "save": {
                DynamicObject dataEntity;
                OperationResult operationResult = args.getOperationResult();
                if (operationResult != null && !operationResult.isSuccess()) {
                    OperateOption option = formOperate.getOption();
                    String variableValue = option.getVariableValue("isSaveErrorMark", "");
                    this.updateViewByOpMark(variableValue);
                    return;
                }
                this.getView().getFormShowParameter().getCustomParams().remove("iscopy");
                parentView = this.getView().getParentView();
                if (parentView != null) {
                    parentView.invokeOperation("refresh");
                    this.getView().sendFormAction(parentView);
                }
                if (!args.getOperationResult().isSuccess()) break;
                PayRollTaskService payRollTaskService = PayRollTaskService.createInstance();
                Long taskPkId = payRollTaskService.getPkId((dataEntity = this.getModel().getDataEntity()).getPkValue());
                if (taskPkId == null) {
                    return;
                }
                if (Boolean.TRUE.equals(this.getModel().getValue("isautoaddperson")) && CalPersonListHelper.validateRuleVersion((Long)taskPkId, (IFormView)this.getView(), (boolean)true)) {
                    if (!CalPayrollTaskStateEnum.CREATE.getCode().equals(dataEntity.getString("taskstatus"))) break;
                    this.getView().close();
                    String errorCode = payRollTaskService.autoAddCalPerson(taskPkId);
                    if (SWCStringUtils.isNotEmpty((String)errorCode)) {
                        String desc = CalPersonLockEnum.getDesc((String)errorCode);
                        if (SWCStringUtils.isEmpty((String)desc)) {
                            desc = errorCode;
                        }
                        this.getView().getParentView().showErrorNotification(desc);
                        this.getView().sendFormAction(this.getView().getParentView());
                        break;
                    }
                    CalPersonHelper.showAddPersonProgress((Long)taskPkId, (String)dataEntity.getString("name"), (IFormView)this.getView().getParentView(), (boolean)true, (boolean)false);
                    this.getView().sendFormAction(this.getView().getParentView());
                    break;
                }
                PayRollTaskSummaryService.createInstance().updateSummaryCache((Object)this);
                this.getModel().setDataChanged(false);
                this.getView().updateView();
                break;
            }
        }
    }

    private void updateViewByOpMark(String variableValue) {
        if (SWCStringUtils.isEmpty((String)variableValue)) {
            return;
        }
        switch (variableValue) {
            case "payrollgroup": {
                this.clearFields("payrollgroup", "payrollgroupv", "payrollscene", "payrollscenev", "calrule", "periodtype", "calfrequency", "aftercal", "callistviewv", "calcount", "org");
                this.getView().setEnable(Boolean.FALSE, new String[]{"payrollscene"});
                break;
            }
            case "payrollscene": {
                this.clearFields("payrollgroupv", "payrollscene", "payrollscenev", "calrule", "periodtype", "calfrequency", "aftercal", "callistviewv", "calcount");
                break;
            }
            case "period": {
                this.clearFields("period", "calrulev", "exratedate", "paydate");
                break;
            }
            case "calrulev": {
                this.clearFields("calrulev");
                break;
            }
        }
        this.getView().updateView();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String callBackId = messageBoxClosedEvent.getCallBackId();
            if (RESULT_COVER_CALLBACK_KEY.equals(callBackId)) {
                SWCPageCache pageCache = new SWCPageCache(this.getView());
                pageCache.put("saveContinueConfirm", (Object)Boolean.TRUE);
                long calTaskId = this.getModel().getDataEntity().getLong("id");
                ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "cal_task_check_value_cache_key_%s", calTaskId));
                String cacheKey = String.format(Locale.ROOT, "cal_task_check_cache_key_%s", calTaskId);
                List itemIdList = (List)appCache.get(cacheKey, List.class);
                PayRollTaskService payRollTaskService = PayRollTaskService.createInstance();
                payRollTaskService.deleteItemCoverData(calTaskId, itemIdList);
                this.getView().invokeOperation("save");
            } else {
                TaskConfirmEnum.confirmCallBack((Object)((Object)this), (String)callBackId);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        List<String> allNeedShowFieldBorderList = Arrays.asList("name", "tasktype", "payrollgroup", "payrollscene", "period", "isautoaddperson", "tracker", "calrulev", "exratedate", "paydate");
        BizChangedHelper.operateBizChangedSet((DynamicObject)this.getModel().getDataEntity(true), allNeedShowFieldBorderList, (BizChangedHelper.OperateEnum)BizChangedHelper.OperateEnum.RETAIN);
    }

    private void setDefaultTracker() {
        IDataModel model = this.getModel();
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.add((Object)PayRollTaskHelper.queryDefaultTracker());
        model.setValue("tracker", (Object)collection);
    }

    private void setTrackerFilter() {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        BasedataEdit trackerF7 = (BasedataEdit)this.getControl("tracker");
        trackerF7.setQFilter(qFilter);
    }

    private void verifyCalRuleVHasPayoutItem() {
        DynamicObject calRuleVObj;
        String afterCal = (String)this.getModel().getValue("aftercal");
        if (SWCStringUtils.isEmpty((String)afterCal) || !afterCal.contains(AfterCalEnum.PERSONALPAY.getCode()) || (calRuleVObj = (DynamicObject)this.getModel().getValue("calrulev")) == null) {
            return;
        }
        if (!PayRollTaskService.createInstance().verifyHasPayoutItem(calRuleVObj)) {
            this.getModel().setValue("calrulev", null);
            String msg = ResManager.loadKDString((String)"\u6838\u7b97\u540e\u5904\u7406\u65b9\u5f0f\u542b\u4e2a\u4f53\u53d1\u653e\uff0c\u6240\u9009\u8ba1\u7b97\u89c4\u5219\u7248\u672c\u9700\u5305\u542b\u81f3\u5c11\u4e00\u9879\u5b9e\u53d1\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CalPayrollTaskNewEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
        }
    }

    private boolean checkAllowModified() {
        PayRollTaskService payRollTaskService = PayRollTaskService.createInstance();
        Long taskPkId = payRollTaskService.getPkId(this.getModel().getDataEntity().getPkValue());
        if (taskPkId == null) {
            return true;
        }
        String errMsg = payRollTaskService.checkAllowModified(taskPkId, this.getModel().getDataEntity().getString("taskstatus"));
        if (errMsg != null) {
            this.getView().showErrorNotification(errMsg);
            return false;
        }
        return true;
    }

    private void setCreateTaskInfo() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        if (dataEntity.getLong("id") == 0L) {
            dataEntity.set("tasknewmethod", (Object)"1");
            dataEntity.set("tasknewtplhis", null);
            dataEntity.set("tasknewperson", model.getDataEntity().get("creator.name"));
        }
    }

    private void setPartModifyPage() {
        this.getView().setEnable(Boolean.FALSE, new String[]{ISHANDLEPRORATION, "payrollgroup", "description", "period", "tasktype", "org", "tracker", "payrollscene", "callistviewv", "isautoaddperson", "islimitadd"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"calrulev", "exratedate", "paydate", "name"});
    }

    private void setPayrollYearShow() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        int payrollYear = dataEntity.getInt("payrollyear");
        Date lastYear = dataEntity.getDate("payrollyearshow");
        if (payrollYear != 0 && (lastYear == null || lastYear.getYear() + 1900 != payrollYear)) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, payrollYear);
            model.setValue("payrollyearshow", (Object)calendar.getTime());
        }
    }

    private boolean checkIsOpenAddPersonTable(BeforeDoOperationEventArgs args) {
        CalPersonAddProgressInfo progressMap = (CalPersonAddProgressInfo)SWCAppCache.get((String)"hsas").get(String.format(Locale.ROOT, "cache_addperson_key_%s", this.getModel().getDataEntity().getPkValue()), CalPersonAddProgressInfo.class);
        if (progressMap != null && 2 != progressMap.getStatus()) {
            args.setCancel(true);
            String format = ResManager.loadKDString((String)"%s\uff1a\u8be5\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\u6b63\u5728\u6dfb\u52a0\u6838\u7b97\u4eba\u5458\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u3002", (String)"CalPayrollTaskNewEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            String errorMsg = String.format(Locale.ROOT, format, this.getModel().getDataEntity().getString("number"));
            this.getView().showErrorNotification(errorMsg);
            return true;
        }
        return false;
    }

    private boolean checkBeforeSave(BeforeDoOperationEventArgs args) {
        boolean notAllowModified = !this.checkAllowModified();
        args.setCancel(notAllowModified);
        return notAllowModified;
    }

    private void checkBeforeModify() {
        this.setFieldsEditAndLock();
    }

    private void setFieldsEditAndLock() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String taskStatus = dataEntity.getString("taskstatus");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        formShowParameter.setCustomParam("from", (Object)"modify");
        formShowParameter.setStatus(OperationStatus.VIEW);
        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
        if (CalPayrollTaskStateEnum.CREATE.getCode().equals(taskStatus) || CalPayrollTaskStateEnum.UNCAL.getCode().equals(taskStatus)) {
            if (SWCStringUtils.equals((String)CalPayrollTaskStateEnum.UNCAL.getCode(), (String)dataEntity.getString("taskstatus"))) {
                this.setPartModifyPage();
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{ISHANDLEPRORATION, "payrollgroup", "description", "period", "tasktype", "org", "tracker", "payrollscene", "callistviewv", "isautoaddperson", "calrulev", "exratedate", "paydate", "islimitadd"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"name"});
        }
    }

    private void clearFields(String ... fieldNameArr) {
        for (String fieldName : fieldNameArr) {
            this.getModel().setValue(fieldName, null);
        }
    }

    private void setAttDaterangeVisible() {
        Boolean flag = Boolean.FALSE;
        DynamicObject payRollScene = (DynamicObject)this.getModel().getValue("payrollscenev");
        if (!SWCObjectUtils.isEmpty((Object)payRollScene)) {
            flag = payRollScene.getBoolean("isenableatt");
        }
        this.getView().setVisible(flag, new String[]{"attdaterange"});
        if (flag.booleanValue()) {
            DynamicObject calTask = this.getModel().getDataEntity();
            PayRollTaskService payRollTaskService = PayRollTaskService.createInstance();
            DynamicObject calPeriodObj = payRollTaskService.getAttDateRange(payRollScene, calTask.getDynamicObject("period"), payRollScene.getDynamicObject("periodtype"));
            if (!SWCObjectUtils.isEmpty((Object)calPeriodObj)) {
                this.getModel().setValue("ATTSTARTDATE", (Object)calPeriodObj.getDate("STARTDATE"));
                this.getModel().setValue("ATTENDDATE", (Object)calPeriodObj.getDate("ENDDATE"));
            }
            FieldEdit fieldEdit = (FieldEdit)this.getView().getControl("attdaterange");
            fieldEdit.setMustInput(true);
        } else {
            this.getModel().setValue("ATTSTARTDATE", null);
            this.getModel().setValue("ATTENDDATE", null);
            FieldEdit fieldEdit = (FieldEdit)this.getView().getControl("attdaterange");
            fieldEdit.setMustInput(false);
        }
    }
}

