/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.guide;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.cal.helper.PaySalarySlipHelper;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.payrollscene.service.SWCPayRollSceneService;
import kd.swc.hsas.common.enums.ReleaseSalarySlipEnum;
import kd.swc.hsas.formplugin.web.guide.AbstractCalPayRollTaskList;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.dto.salary.CalSalarySlipViewDTO;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.ReleaseStateEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalPayrollTaskSalarySlipList
extends AbstractCalPayRollTaskList {
    private static final Log logger = LogFactory.getLog(CalPayrollTaskSalarySlipList.class);

    @Override
    protected List<CalPersonOperationEnum> operationKey() {
        ArrayList<CalPersonOperationEnum> calPersonOperationEnums = new ArrayList<CalPersonOperationEnum>();
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_CREATESALARY);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_RECOVERSALARY);
        return calPersonOperationEnums;
    }

    @Override
    protected boolean hasPerm(CalPersonOperationEnum calPersonOperationEnum) {
        switch (calPersonOperationEnum) {
            case OP_CREATESALARY: 
            case OP_RECOVERSALARY: {
                return SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)calPersonOperationEnum.getPermission());
            }
        }
        return true;
    }

    @Override
    protected void execute() {
        List<Long> calPayRollTaskIds = this.calPayRollTaskContext.getValidDatas().stream().map(CalPayRollTask::getCalPayRollTaskId).collect(Collectors.toList());
        switch (this.calPersonOperationEnum) {
            case OP_CREATESALARY: {
                SWCDataServiceHelper helper;
                DLockInfo lockInfo = DLock.getLockInfo((String)"salaryslipparameterlock");
                if (null != lockInfo) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u5de5\u8d44\u6761\u6570\u636e\u52a0\u5bc6\u65b9\u5f0f\u914d\u7f6e\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CalPayrollTaskSalarySlipList_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    this.releaseDistributedLock();
                    return;
                }
                Map paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((String)"salaryslip_encrypt");
                String encryptLevel = "";
                if (paramMap == null || paramMap.get("encryptlevel") == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u5de5\u8d44\u6761\u5931\u8d25\uff0c\u8bf7\u5148\u8fdb\u884c\u5de5\u8d44\u6761\u5b89\u5168\u8bbe\u7f6e\u3002", (String)"CalPayrollTaskList_17", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    this.releaseDistributedLock();
                    return;
                }
                encryptLevel = paramMap.get("encryptlevel").toString();
                String encryptType = "1";
                this.getPageCache().put("encryptlevel", encryptLevel);
                this.getPageCache().put("encrypttype", encryptType);
                if ("1".equals(encryptLevel) && (helper = new SWCDataServiceHelper("hsas_secretkey")).count(new QFilter[0]) == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u5de5\u8d44\u6761\u5931\u8d25\uff0c\u8bf7\u5148\u8fdb\u884c\u5de5\u8d44\u6761\u5b89\u5168\u8bbe\u7f6e\u3002", (String)"CalPayrollTaskList_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    this.releaseDistributedLock();
                    return;
                }
                this.analyzeCalTaskList(calPayRollTaskIds);
                break;
            }
            case OP_RECOVERSALARY: {
                Map<String, String> resultMap = this.getRecoverData(this.getTaskList(calPayRollTaskIds));
                this.showSecondConfirm(resultMap, calPayRollTaskIds);
                break;
            }
        }
    }

    @Override
    protected void beforeDoOperation(BeforeDoOperationEventArgs args, CalPayRollTask calPayRollTask) {
        Long taskId = calPayRollTask.getCalPayRollTaskId();
        if (taskId != null && taskId > 0L) {
            switch (this.calPersonOperationEnum) {
                case OP_CREATESALARY: 
                case OP_RECOVERSALARY: {
                    String schemeAfterCalNumber;
                    SWCPayRollSceneService sceneService = SWCPayRollSceneService.createInstance();
                    DynamicObject schemeAfterCalObj = sceneService.getAfterCalObjByTask(taskId);
                    if (schemeAfterCalObj == null || SWCStringUtils.equals((String)"1010_S", (String)(schemeAfterCalNumber = schemeAfterCalObj.getString("number")))) break;
                    calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                    calPayRollTask.setCalPayRollTaskValidatorErrorMsg(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4efb\u52a1\u7684\u6838\u7b97\u540e\u5904\u7406\u7c7b\u578b\u4e3a\u975e\u85aa\u8d44\u53d1\u653e\uff0c\u4e0d\u652f\u6301\u8fdb\u884c\u53d1\u653e\u53ca\u5de5\u8d44\u6761\u76f8\u5173\u64cd\u4f5c\u3002", (String)"CalPayrollTaskSalarySlipList_9", (String)"swc-hsas-formplugin", (Object[])new Object[]{schemeAfterCalObj.getString("number")}));
                    break;
                }
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Map returnData = (Map)event.getReturnData();
        if (returnData != null) {
            if (((Boolean)returnData.get("isOk")).booleanValue()) {
                switch (actionId) {
                    case "recoverSalarySlip": {
                        this.recoverSalarySlip();
                        String msgRecover = ResManager.loadKDString((String)"\u540e\u53f0\u5df2\u5f00\u59cb\u8fdb\u884c\u5de5\u8d44\u6761\u56de\u6536\u5904\u7406\uff0c\u8bf7\u8010\u5fc3\u7b49\u5019\u3002", (String)"CalPayrollTaskList_33", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                        this.getView().showSuccessNotification(msgRecover);
                        break;
                    }
                    case "createsalary": {
                        this.showReleaseSalaryViewForm();
                        break;
                    }
                    case "releaseSalaryFormCloseCallBack": {
                        if (!this.releaseSalarySlip(returnData)) break;
                        String msg = ResManager.loadKDString((String)"\u540e\u53f0\u5df2\u5f00\u59cb\u8fdb\u884c\u53d1\u5e03\u5de5\u8d44\u6761\u5904\u7406\uff0c\u8bf7\u8010\u5fc3\u7b49\u5019\u3002", (String)"CalPayrollTaskList_32", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                        this.getView().showSuccessNotification(msg);
                        break;
                    }
                }
            } else {
                this.releaseDistributedLock();
            }
        }
    }

    private void analyzeCalTaskList(List<Long> calPayRollTaskIds) {
        HasPermOrgResult permOrgs;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter qFilter = new QFilter("id", "in", calPayRollTaskIds);
        DynamicObjectCollection tasks = helper.queryOriginalCollection("id,number,country.id,org.id", new QFilter[]{qFilter});
        Map releaseSalarySlip = PaySalarySlipHelper.getReleaseSalarySlip(calPayRollTaskIds);
        ArrayList<Long> enableReleaseList = new ArrayList<Long>(calPayRollTaskIds.size());
        List permFilter = PaySalarySlipHelper.getPermFilter();
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter salaryUnPayFilter = PaySalarySlipHelper.getCanReleaseSalaryCalPersonSalaryStatusUnPayFilter();
        QFilter salaryPayedFilter = PaySalarySlipHelper.getCanReleaseSalaryCalPersonSalaryStatusPayedFilter();
        int payedTotalCount = 0;
        int unPayTotalCount = 0;
        int calPersonTotalCount = 0;
        HashSet<String> countrySet = new HashSet<String>(tasks.size());
        String countryId = "";
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        for (DynamicObject task : tasks) {
            long calTaskId = task.getLong("id");
            countryId = task.getString("country.id");
            orgIdSet.add(task.getLong("org.id"));
            if (StringUtils.isNotBlank((CharSequence)countryId)) {
                countrySet.add(countryId);
            }
            if (countrySet.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u6838\u7b97\u4efb\u52a1\u4e2d\u56fd\u5bb6/\u5730\u533a\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u53d1\u5e03\u5de5\u8d44\u6761\u3002", (String)"CalPayrollTaskList_34", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                this.releaseDistributedLock();
                return;
            }
            int payedNum = 0;
            int unPayNum = 0;
            ReleaseSalarySlipEnum releaseSalarySlipEnum = (ReleaseSalarySlipEnum)releaseSalarySlip.get(calTaskId);
            QFilter calTaskFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
            int total = calPersonHelper.count("hsas_calperson", "id", PaySalarySlipHelper.getQFilterArray((QFilter[])new QFilter[]{calTaskFilter}, (List)permFilter), (Distinctable)WithDistinctable.get());
            calPersonTotalCount += total;
            if (releaseSalarySlipEnum != null) {
                QFilter calStatusFilter = PaySalarySlipHelper.getCanReleaseSalaryCalPersonFilter((ReleaseSalarySlipEnum)releaseSalarySlipEnum);
                payedNum = calPersonHelper.count("hsas_calperson", "id", PaySalarySlipHelper.getQFilterArray((QFilter[])new QFilter[]{calTaskFilter, calStatusFilter, salaryPayedFilter}, (List)permFilter), (Distinctable)WithDistinctable.get());
                unPayNum = calPersonHelper.count("hsas_calperson", "id", PaySalarySlipHelper.getQFilterArray((QFilter[])new QFilter[]{calTaskFilter, calStatusFilter, salaryUnPayFilter}, (List)permFilter), (Distinctable)WithDistinctable.get());
            }
            if (payedNum + unPayNum != 0) {
                enableReleaseList.add(calTaskId);
            } else {
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)this.calPersonOperationEnum.getOperationKey());
            }
            payedTotalCount += payedNum;
            unPayTotalCount += unPayNum;
        }
        if (enableReleaseList.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u8fdb\u884c\u5de5\u8d44\u6761\u53d1\u5e03\uff1a\u6240\u9009\u6570\u636e\u5df2\u53d1\u5e03\u6216\u4e0d\u53d1\u5e03\u5de5\u8d44\u6761\u3001\u672a\u8fbe\u5230\u6216\u672a\u8bbe\u7f6e\u53d1\u5e03\u65f6\u70b9\u3002", (String)"HSASCalTableListSalaryPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        List orgIdList = orgIdSet.size() > 1 ? ((permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)CalPersonOperationEnum.OP_CREATESALARY.getPermission())) != null && !permOrgs.hasAllOrgPerm() ? permOrgs.getHasPermOrgs() : new ArrayList(10)) : new ArrayList(orgIdSet);
        SWCPageCache cache = new SWCPageCache(this.getView());
        cache.put("enableList", enableReleaseList);
        this.getView().getPageCache().put("unPayCount", String.valueOf(unPayTotalCount));
        this.getView().getPageCache().put("payedCount", String.valueOf(payedTotalCount));
        this.getView().getPageCache().put("countryId", countryId);
        this.getView().getPageCache().put("orgIdList", JSON.toJSONString(orgIdList));
        if (unPayTotalCount + payedTotalCount == calPersonTotalCount) {
            this.showReleaseSalaryViewForm();
            return;
        }
        FormShowParameter parameters = PaySalarySlipHelper.getPaySalConfirm((int)unPayTotalCount, (int)payedTotalCount, (int)calPersonTotalCount, (String)"payRollTask", (int)calPayRollTaskIds.size());
        parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.calPayRollTaskContext.getCalPersonOperationEnum().getOperationKey()));
        this.getView().showForm(parameters);
    }

    private void showReleaseSalaryViewForm() {
        IPageCache pageCache = this.getPageCache();
        String unPayCount = pageCache.get("unPayCount");
        String payedCount = pageCache.get("payedCount");
        String countryId = pageCache.get("countryId");
        String orgString = pageCache.get("orgIdList");
        FormShowParameter releaseSalaryViewForm = PaySalarySlipHelper.getReleaseSalaryViewForm((int)Integer.parseInt(unPayCount), (int)Integer.parseInt(payedCount));
        releaseSalaryViewForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "releaseSalaryFormCloseCallBack"));
        releaseSalaryViewForm.setCustomParam("countryId", (Object)countryId);
        releaseSalaryViewForm.setCustomParam("orgIdList", (Object)orgString);
        List<Long> calTaskIds = this.getCalTaskIds();
        if (calTaskIds.size() == 1) {
            List orgList = new ArrayList(10);
            if (SWCStringUtils.isNotEmpty((String)orgString)) {
                orgList = JSON.parseArray((String)orgString, Long.class);
            }
            releaseSalaryViewForm.setCustomParam("salaryViewId", (Object)PaySalarySlipHelper.getDefaultSalarySlipView((Long)calTaskIds.get(0), orgList));
        } else {
            releaseSalaryViewForm.setCustomParam("salaryViewId", null);
        }
        this.getView().showForm(releaseSalaryViewForm);
    }

    private List<Long> getTaskList(List<Long> selectIds) {
        ArrayList<Long> enableTaskList = new ArrayList<Long>(10);
        List pFilter = PaySalarySlipHelper.getPermFilter();
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter salaryFilter = new QFilter("salarystatus", "=", (Object)ReleaseStateEnum.RELEASED.getCode());
        for (Long taskId : selectIds) {
            QFilter qFilter = new QFilter("caltask.id", "=", (Object)taskId);
            int enableNum = calTableHelper.count("hsas_calperson", "id", PaySalarySlipHelper.getQFilterArray((QFilter[])new QFilter[]{qFilter, salaryFilter}, (List)pFilter), (Distinctable)WithDistinctable.get());
            if (enableNum == 0) {
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(taskId), (String)this.calPersonOperationEnum.getOperationKey());
                continue;
            }
            enableTaskList.add(taskId);
        }
        if (enableTaskList.size() == 0) {
            String msg = ResManager.loadKDString((String)"\u56de\u6536\u5931\u8d25\uff0c\u6240\u9009\u6838\u7b97\u4efb\u52a1\u4e2d\u6838\u7b97\u8bb0\u5f55\u672a\u53d1\u5e03\u5de5\u8d44\u6761\uff0c\u6216\u53d1\u5e03\u7684\u5de5\u8d44\u6761\u5df2\u56de\u6536\u6216\u5df2\u5931\u6548\u3002", (String)"CalPayrollTaskList_19", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
        }
        return enableTaskList;
    }

    private Map<String, String> getRecoverData(List<Long> selectIds) {
        if (selectIds == null || selectIds.size() == 0) {
            return null;
        }
        List pFilter = PaySalarySlipHelper.getPermFilter();
        HashMap<String, String> resultMap = new HashMap<String, String>(3);
        int totalNum = 0;
        int enableNum = 0;
        int disenableNum = 0;
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter salaryFilter = new QFilter("salarystatus", "=", (Object)ReleaseStateEnum.RELEASED.getCode());
        QFilter qFilter = new QFilter("caltask.id", "in", selectIds);
        qFilter.and(new QFilter("calmainid", "=", (Object)0L));
        totalNum = calTableHelper.count("hsas_calperson", "id", PaySalarySlipHelper.getQFilterArray((QFilter[])new QFilter[]{qFilter}, (List)pFilter), (Distinctable)WithDistinctable.get());
        enableNum = calTableHelper.count("hsas_calperson", "id", PaySalarySlipHelper.getQFilterArray((QFilter[])new QFilter[]{qFilter, salaryFilter}, (List)pFilter), (Distinctable)WithDistinctable.get());
        disenableNum = totalNum - enableNum;
        resultMap.put("total", String.valueOf(totalNum));
        resultMap.put("enable", String.valueOf(enableNum));
        resultMap.put("disenable", String.valueOf(disenableNum));
        return resultMap;
    }

    private void showSecondConfirm(Map<String, String> resultMap, List<Long> selectIds) {
        if (resultMap == null) {
            return;
        }
        String enableNum = resultMap.get("enable");
        if ("0".equals(enableNum)) {
            String msg = ResManager.loadKDString((String)"\u56de\u6536\u5931\u8d25\uff0c\u6240\u9009\u6838\u7b97\u4efb\u52a1\u4e2d\u6838\u7b97\u8bb0\u5f55\u672a\u53d1\u5e03\u5de5\u8d44\u6761\uff0c\u6216\u53d1\u5e03\u7684\u5de5\u8d44\u6761\u5df2\u56de\u6536\u6216\u5df2\u5931\u6548\u3002", (String)"CalPayrollTaskList_19", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            this.releaseDistributedLock();
            return;
        }
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "recoverSalarySlip"));
        parameters.setCustomParam("totalNum", (Object)Integer.parseInt(resultMap.get("total")));
        parameters.setCustomParam("calTableNum", (Object)selectIds.size());
        parameters.setCustomParam("enable", (Object)Integer.parseInt(enableNum));
        parameters.setCustomParam("disenable", (Object)Integer.parseInt(resultMap.get("disenable")));
        parameters.setFormId("hsas_recoverconfirm");
        this.getView().showForm(parameters);
    }

    private boolean releaseSalarySlip(Map<String, Object> returnData) {
        SWCPageCache cache = new SWCPageCache(this.getView());
        CalSalarySlipViewDTO dto = (CalSalarySlipViewDTO)returnData.get("calSalarySlipView");
        Boolean isUseOldView = returnData.get("useview") == null ? Boolean.FALSE : (Boolean)returnData.get("useview");
        List taskIdList = (List)cache.get("enableList", List.class);
        return PaySalarySlipHelper.releaseSalarySlip((IFormView)this.getView(), (CalSalarySlipViewDTO)dto, (List)taskIdList, null, (Boolean)isUseOldView, (Boolean)Boolean.FALSE, (Boolean)Boolean.FALSE);
    }

    private void recoverSalarySlip() {
        List<Long> taskIds = this.getCalTaskIds();
        PaySalarySlipHelper.recoverSalarySlip(taskIds, null);
    }
}

