/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.insurancedata;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.SWCShowType;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.dynamiclist.SWCDynamicListPlugin;

public class InsuranceDataList
extends SWCDynamicListPlugin {
    private final Log log = LogFactory.getLog(InsuranceDataList.class);
    public static final String DONOTHING_VIEWPUSHLOG = "donothing_viewpushlog";
    public static final String DONOTHING_CHANGGEWITHHOLDDATE = "changgewithholddate";
    public static final String DONOTHING_CHANGGEWITHHOLDDATEOP = "changgewithholddateop";
    private DynamicObjectCollection insuranceItems;

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate fo = (FormOperate)args.getSource();
        String operateKey = fo.getOperateKey();
        IListView listView = (IListView)this.getView();
        switch (operateKey) {
            case "donothing_viewpushlog": {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                listShowParameter.setBillFormId("hcsi_insurpushlog");
                listShowParameter.setFormId("bos_list");
                listShowParameter.setHasRight(true);
                listShowParameter.setCustomParam("isHsas", (Object)Boolean.TRUE);
                listView.showForm((FormShowParameter)listShowParameter);
                break;
            }
            case "changgewithholddate": {
                Object[] primaryKeyValues = listView.getSelectedRows().getPrimaryKeyValues();
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_insurancedata");
                QFilter filter = new QFilter("id", "in", (Object)primaryKeyValues);
                filter.and("usestatus", "=", (Object)"0");
                int count = helper.count(filter.toArray());
                if (count == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u4f7f\u7528\u72b6\u6001\u4e3a\u201c\u672a\u4f7f\u7528\u201d\u7684\u793e\u4fdd\u6570\u636e\u8c03\u6574\u4ee3\u6263\u5e74\u6708\u3002", (String)"InsuranceDataList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("hsas_changewithholddate");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_changewithholddate"));
                listView.showForm(formShowParameter);
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("withholddate desc,perioddate desc,employee.empnumber asc");
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List listColumns = args.getListColumns();
        DynamicObjectCollection insuranceItems = this.getInsuranceItems();
        for (DynamicObject insuranceItem : insuranceItems) {
            String dataType = insuranceItem.getString("datatype.storagetype");
            if (!SWCStringUtils.equals((String)dataType, (String)SWCShowType.AMOUNT.getCode()) && !SWCStringUtils.equals((String)dataType, (String)SWCShowType.NUM.getCode())) continue;
            DecimalListColumn decimalCol = new DecimalListColumn();
            decimalCol.setCaption(new LocaleString(insuranceItem.getString("name")));
            decimalCol.setKey(insuranceItem.getString("id"));
            decimalCol.setListFieldKey(insuranceItem.getString("id"));
            decimalCol.setZeroShow(true);
            listColumns.add(decimalCol);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "hsas_changewithholddate": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (returnData == null) break;
                String withholddate = (String)returnData.get("withholddate");
                String withholdtype = (String)returnData.get("withholdtype");
                OperateOption option = OperateOption.create();
                option.setVariableValue("withholddate", withholddate);
                option.setVariableValue("withholdtype", withholdtype);
                this.getView().invokeOperation(DONOTHING_CHANGGEWITHHOLDDATEOP, option);
                ((IListView)this.getView()).refresh();
                break;
            }
        }
    }

    public MainEntityType getEntityType() {
        MainEntityType mainType = super.getEntityType();
        MainEntityType mainEntityType = null;
        try {
            mainEntityType = (MainEntityType)mainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            this.log.error("getNewEntityType: ", (Throwable)e1);
        }
        if (mainEntityType == null) {
            return mainType;
        }
        this.addItemProp((DynamicObjectType)mainEntityType);
        return mainEntityType;
    }

    private DynamicObjectCollection getInsuranceItems() {
        if (this.insuranceItems == null) {
            QFilter filter = new QFilter("status", "=", (Object)"C");
            filter.and("enable", "=", (Object)"1");
            SWCDataServiceHelper helper = new SWCDataServiceHelper("sitbs_insuranceitem");
            this.insuranceItems = helper.queryOriginalCollection("id,group.number,number,name,datatype.storagetype,dataprecision.scale", filter.toArray(), "group.number asc,number asc");
        }
        return this.insuranceItems;
    }

    private void addItemProp(DynamicObjectType mainEntityType) {
        DynamicObjectCollection insuranceItems = this.getInsuranceItems();
        for (DynamicObject item : insuranceItems) {
            TextProp property;
            int dataLength = 200;
            long insuredItemId = item.getLong("id");
            String insuredItemName = item.getString("name");
            String dataType = item.getString("datatype.storagetype");
            String columnKey = String.valueOf(insuredItemId);
            if (SWCStringUtils.equals((String)dataType, (String)SWCShowType.TEXT.getCode())) {
                property = new TextProp();
                property.setName(columnKey);
                property.setDisplayName(new LocaleString(insuredItemName));
                property.setMaxLenth(dataLength);
                mainEntityType.addProperty((DynamicProperty)property);
                continue;
            }
            if (SWCStringUtils.equals((String)dataType, (String)SWCShowType.NUM.getCode())) {
                property = new DecimalProp();
                property.setName(columnKey);
                property.setDisplayName(new LocaleString(insuredItemName));
                property.setPrecision(23);
                property.setScale(4);
                property.setZeroShow(true);
                property.setEnableNull(true);
                mainEntityType.addProperty((DynamicProperty)property);
                continue;
            }
            if (SWCStringUtils.equals((String)dataType, (String)SWCShowType.AMOUNT.getCode())) {
                property = new DecimalProp();
                property.setName(columnKey);
                property.setDisplayName(new LocaleString(insuredItemName));
                property.setPrecision(23);
                property.setScale(2);
                property.setZeroShow(true);
                property.setEnableNull(true);
                mainEntityType.addProperty((DynamicProperty)property);
                continue;
            }
            if (!SWCStringUtils.equals((String)dataType, (String)SWCShowType.DATE.getCode())) continue;
            property = new DateProp();
            property.setName(columnKey);
            property.setDisplayName(new LocaleString(insuredItemName));
            mainEntityType.addProperty((DynamicProperty)property);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new InsuranceLoadDataImpl());
    }

    public class InsuranceLoadDataImpl
    extends ListDataProvider {
        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection detailDataCol = super.getData(start, limit);
            if (this.getQueryBuilder().isSelectedAllRows()) {
                return detailDataCol;
            }
            InsuranceDataList.this.addItemProp(detailDataCol.getDynamicObjectType());
            List itemIds = InsuranceDataList.this.insuranceItems.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            List ids = detailDataCol.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", ids);
            qFilter.and("entryentity.insuranceitem", "in", itemIds);
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_insurancedata");
            DynamicObjectCollection itemDatas = helper.queryOriginalCollection("id,entryentity.numvalue,entryentity.amountvalue,entryentity.insuranceitem,entryentity.storagetype", qFilter.toArray());
            Map<Long, Map<Long, List<DynamicObject>>> dataItemValueMap = itemDatas.stream().collect(Collectors.groupingBy(o -> o.getLong("id"), Collectors.groupingBy(o -> o.getLong("entryentity.insuranceitem"))));
            for (DynamicObject data : detailDataCol) {
                long id = data.getLong("id");
                Map<Long, List<DynamicObject>> itemValueMap = dataItemValueMap.get(id);
                if (itemValueMap == null) continue;
                for (Map.Entry<Long, List<DynamicObject>> entry : itemValueMap.entrySet()) {
                    Long itemId = entry.getKey();
                    List<DynamicObject> details = entry.getValue();
                    if (SWCListUtils.isEmpty(details)) continue;
                    DynamicObject detail = details.get(0);
                    String storagetype = detail.getString("entryentity.storagetype");
                    BigDecimal numvalue = SWCStringUtils.equals((String)"number", (String)storagetype) ? detail.getBigDecimal("entryentity.numvalue") : detail.getBigDecimal("entryentity.amountvalue");
                    data.set(String.valueOf(itemId), (Object)numvalue);
                }
            }
            return detailDataCol;
        }
    }
}

