/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.integlog.attinteglog;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.swc.hsas.business.attintegrate.enums.OperationType;
import kd.swc.hsas.formplugin.web.integlog.attinteglog.AttIntegLogEntryGridControl;
import kd.swc.hsbp.business.tab.UpdateTabNameHelper;
import kd.swc.hsbp.common.enums.ProcessResultEnum;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class AttIntegSummaryLogEdit
extends SWCDataBaseEdit
implements IConfirmCallBack {
    private static Log log = LogFactory.getLog(AttIntegSummaryLogEdit.class);
    private static final String DONOTHING_DETAIL = "donothing_detail";
    private static final String OPERATIONTYPE = "operationtype";
    public static final String ROW_COUNT = "rowCount";
    private static final String ADVCONTOOL_BARAP = "advcontoolbarap";
    private static final String EXPORT_ENTRY = "exportentry";

    public void initialize() {
        super.initialize();
        this.getView().setStatus(OperationStatus.VIEW);
        this.getView().addCustomControls(new String[]{"entryentity"});
        IFormView view = this.getView().getViewNoPlugin(this.getView().getPageId());
        Control oldGrid = view.getControl("entryentity");
        EntryGrid entryGrid = this.rewriteEntryGridControl(oldGrid);
        this.setEntryGridControlIndex(entryGrid, view);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{DONOTHING_DETAIL});
        this.addItemClickListeners(new String[]{ADVCONTOOL_BARAP});
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        UpdateTabNameHelper.updateTabName((IFormView)this.getView(), (String)"batchversionid");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection datas = dataEntity.getDynamicObjectCollection("entryentity");
        String operationType = dataEntity.getString(OPERATIONTYPE);
        if (OperationType.PUSH.getCode().equals(operationType)) {
            for (int i = 0; i < datas.size(); ++i) {
                this.getModel().setValue("status", (Object)operationType, i);
            }
        }
        Control oldGrid = this.getView().getControl("entryentity");
        EntryGrid entryGrid = this.rewriteEntryGridControl(oldGrid);
        this.setEntryGridControlIndex(entryGrid, this.getView());
        int pageRow = entryGrid.getPageRow();
        dataEntity.getDataEntityState().setEntryRowCount("entryentity", this.getRowCount());
        dataEntity.getDataEntityState().setEntryPageSize("entryentity", pageRow);
        this.getModel().setDataChanged(false);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "exportentry": {
                EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
                grid.clearEntryState();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int[] rows = grid.getSelectRows();
        switch (formOperate.getOperateKey()) {
            case "donothing_detail": {
                if (rows == null || rows.length == 0) break;
                DynamicObjectCollection coll = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                int index = rows[0];
                this.showItemLogF7((DynamicObject)coll.get(index));
                break;
            }
        }
    }

    private void showItemLogF7(DynamicObject dyObj) {
        ListShowParameter formShow = ShowFormHelper.createShowListForm((String)"hsas_attintegitemlog", (boolean)false);
        formShow.getOpenStyle().setShowType(ShowType.Modal);
        String operationType = (String)this.getModel().getValue(OPERATIONTYPE);
        HashMap map = Maps.newHashMap();
        map.put("operationType", operationType);
        formShow.setCustomParams((Map)map);
        formShow.setHasRight(true);
        ListFilterParameter listFilterParameter = formShow.getListFilterParameter();
        listFilterParameter.setFilter(new QFilter("integdetailedlog", "=", (Object)dyObj.getLong("id")));
        formShow.setCustomParam("storePage", this.getModel().getValue("storepage"));
        this.getView().showForm((FormShowParameter)formShow);
    }

    public void onGetControl(OnGetControlArgs args) {
        if (StringUtils.equals((CharSequence)args.getKey(), (CharSequence)"entryentity")) {
            Control oldGrid = args.getControl();
            EntryGrid entryGrid = this.rewriteEntryGridControl(oldGrid);
            args.setControl((Control)entryGrid);
            this.setEntryGridControlIndex(entryGrid, this.getView());
        }
    }

    private EntryGrid rewriteEntryGridControl(Control oldGrid) {
        AttIntegLogEntryGridControl entryGrid = new AttIntegLogEntryGridControl();
        entryGrid.setView(this.getView());
        entryGrid.setKey("entryentity");
        entryGrid.setEntryKey("entryentity");
        entryGrid.setSplitPage(true);
        if (oldGrid == null) {
            this.findControl("entryentity");
        }
        if (oldGrid instanceof EntryGrid) {
            entryGrid.setPageRow(((EntryGrid)oldGrid).getPageRow());
            entryGrid.getItems().addAll(((EntryGrid)oldGrid).getItems());
        }
        return entryGrid;
    }

    private Control findControl(String key) {
        FormRoot root = (FormRoot)this.getView().getRootControl();
        return this.findControl(key, root.getItems());
    }

    private Control findControl(String key, List<Control> items) {
        for (Control ctl : items) {
            Control subCtl;
            if (StringUtils.equals((CharSequence)key, (CharSequence)ctl.getKey())) {
                return ctl;
            }
            if (!(ctl instanceof Container) || (subCtl = this.findControl(key, ((Container)ctl).getItems())) == null) continue;
            return subCtl;
        }
        return null;
    }

    private void setEntryGridControlIndex(EntryGrid entryGrid, IFormView formView) {
        Container advconchildpanelap = (Container)this.findControl("advconchildpanelap");
        if (advconchildpanelap == null) {
            return;
        }
        List items = advconchildpanelap.getItems();
        for (int i = 0; i < items.size(); ++i) {
            Control item = (Control)items.get(i);
            if (!"entryentity".equals(item.getKey())) continue;
            advconchildpanelap.getItems().set(i, entryGrid);
        }
        formView.createControlIndex(advconchildpanelap.getItems());
    }

    private int getRowCount() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        QFilter filter = new QFilter("attintegsumlog", "=", (Object)dataEntity.getLong("id"));
        filter.and(new QFilter("processresult", "=", (Object)ProcessResultEnum.FAILURE.getCode()));
        DynamicObjectCollection queryAll = QueryServiceHelper.query((String)"hsas_attintegdetaillog", (String)"id", (QFilter[])filter.toArray());
        int rowCount = queryAll.size();
        this.getView().getPageCache().put(ROW_COUNT, String.valueOf(rowCount));
        return rowCount;
    }
}

