/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.integlog.attinteglog;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.TextProp;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;

public class AttIntegSummaryLogList
extends SWCDataBaseList {
    private static Log log = LogFactory.getLog(AttIntegSummaryLogList.class);

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                Set sumLogIds = rows.stream().map(row -> row.getLong("id")).collect(Collectors.toSet());
                SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_attintegsumlog");
                QFilter filter = new QFilter("id", "in", sumLogIds);
                DynamicObjectCollection sumLogColl = serviceHelper.queryColl("id,timeconsume", filter.toArray(), null);
                Map sumLogMaps = sumLogColl.stream().collect(Collectors.toMap(col -> col.getLong("id"), Function.identity()));
                TextProp property = new TextProp();
                property.setName("timeconsumedisplay");
                property.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u8017\u65f6", (String)"AttIntegSummaryLogList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
                rows.getDynamicObjectType().addProperty((DynamicProperty)property);
                for (DynamicObject row2 : rows) {
                    long sumLogId = row2.getLong("id");
                    DynamicObject dynamicObject = (DynamicObject)sumLogMaps.get(sumLogId);
                    long timeConsume = dynamicObject == null ? 0L : dynamicObject.getLong("timeconsume");
                    row2.set("timeconsumedisplay", (Object)AttIntegSummaryLogList.this.getConsumeTime(timeConsume));
                }
                return rows;
            }
        });
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        ListColumn colText = this.createListColumn("timeconsumedisplay", ResManager.loadKDString((String)"\u8017\u65f6", (String)"AttIntegSummaryLogList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        List listColumns = args.getListColumns();
        int index = listColumns.size() + 1;
        for (int i = 0; i < listColumns.size(); ++i) {
            IListColumn listColumn = (IListColumn)listColumns.get(i);
            String fieldKey = listColumn.getListFieldKey();
            if (!"failquantity".equals(fieldKey)) continue;
            index = i + 1;
            break;
        }
        listColumns.add(index, colText);
    }

    private ListColumn createListColumn(String key, String caption) {
        ListColumn col = new ListColumn();
        col.setCaption(new LocaleString(caption));
        col.setKey(key);
        col.setListFieldKey(key);
        return col;
    }

    private String getConsumeTime(long timeConsume) {
        long hour = timeConsume / 3600L;
        long minute = (timeConsume %= 3600L) / 60L;
        return String.format("%02d:%02d:%02d", hour, minute, timeConsume %= 60L);
    }
}

