/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.onhold;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IBaseDataService;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsas.business.onhold.helper.OnHoldBillHelper;
import kd.swc.hsas.business.onhold.helper.OnHoldDetailHelper;
import kd.swc.hsas.business.onhold.service.OnHoldDetailService;
import kd.swc.hsas.business.person.PersonHelper;
import kd.swc.hsas.business.salaryfile.SWCSalaryFileServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class OnHoldDetailEdit
extends SWCDataBaseEdit
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static final String CALLBACK_CLOSE = "confirm_callback_close";
    private static final Log LOGGER = LogFactory.getLog(OnHoldDetailEdit.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        showParameter.setListentimerElapsed(true);
        if (!SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)showParameter.getFormId(), (String)"47150e89000000ac")) {
            e.setCancel(true);
            String msg = ResManager.loadKDString((String)"\u65e0\"\u505c\u7f13\u53d1\u8be6\u60c5\"\u67e5\u770b\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnHoldDetailEdit_19", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            e.setCancelMessage(msg);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showContent();
        this.getModel().setDataChanged(false);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        boolean dataChanged = this.getModel().getDataChanged();
        if (dataChanged) {
            e.setCancel(true);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"OnHoldDetailEdit_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"OnHoldDetailEdit_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"OnHoldDetailEdit_17", (String)"swc-hsas-formplugin", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\uff0c\u5426\u5219\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"OnHoldDetailEdit_20", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            String changeDesc = this.getModel().getChangeDesc();
            this.getView().showConfirm(msg, changeDesc, options, ConfirmTypes.Default, new ConfirmCallBackListener(CALLBACK_CLOSE), btnNameMaps);
        }
    }

    private void showContent() {
        Long personId = PersonHelper.getPersonId((IFormView)this.getView());
        Object onHoldId = this.getView().getFormShowParameter().getCustomParam("onHoldId");
        OnHoldBillHelper.showOnholdPreviewPage((Long)personId, (IFormView)this.getView());
        DynamicObject onHold = OnHoldBillHelper.queryOnHoldById((Object)onHoldId);
        if (onHold != null) {
            long calTableId = onHold.getLong("caltableid");
            if (calTableId > 0L) {
                this.setCalTableInfoEntryValue(onHold);
            } else {
                this.setSalaryInfoEntryValue(onHold);
            }
            this.setPublicFieldVal(onHold);
            this.getView().setVisible(Boolean.FALSE, new String[]{"save", "caltablenewentry", "caltabledeleteentry", "salaryfilenewentry", "salaryfiledeleteentry"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"releasedate", "remark", "attachment", "caltabledeleteentry", "salaryfiledeleteentry"});
            int onHoldStatus = onHold.getInt("status");
            if (onHoldStatus > OnHoldStatusEnum.STATUS_RELEASE.getCode()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"onholdmodify", "submit"});
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"OnHoldDetailEdit_18", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        this.getView().getPageCache().put("isOpened", Boolean.TRUE.toString());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        this.setEditStatus(fieldKey);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "donothing_save": 
            case "donothing_formsubmit": {
                this.checkEntryNull(args, operateKey);
                break;
            }
        }
    }

    private void checkEntryNull(BeforeDoOperationEventArgs args, String operateKey) {
        DynamicObjectCollection salaryEntryObj = this.getModel().getEntryEntity("salaryentry");
        DynamicObjectCollection calPersonEntity = this.getModel().getEntryEntity("caltableentry");
        if (!(salaryEntryObj != null && salaryEntryObj.size() != 0 || calPersonEntity != null && calPersonEntity.size() != 0)) {
            if (SWCStringUtils.equals((String)operateKey, (String)"donothing_save")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848/\u6838\u7b97\u4efb\u52a1\u4efb\u610f\u5206\u5f55\u6700\u5c11\u9700\u8981\u586b\u5199\u4e00\u884c\u6570\u636e\uff0c\u8bf7\u586b\u5199\u540e\u518d\u4fdd\u5b58\u3002", (String)"OnHoldDetailEdit_22", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            } else if (SWCStringUtils.equals((String)operateKey, (String)"donothing_formsubmit")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848/\u6838\u7b97\u4efb\u52a1\u4efb\u610f\u5206\u5f55\u6700\u5c11\u9700\u8981\u586b\u5199\u4e00\u884c\u6570\u636e\uff0c\u8bf7\u586b\u5199\u540e\u518d\u63d0\u4ea4\u5e76\u751f\u6548\u3002", (String)"OnHoldDetailEdit_21", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        Long personId = PersonHelper.getPersonId((IFormView)this.getView());
        switch (operateKey) {
            case "donothing_save": {
                this.confirmOperate(true);
                break;
            }
            case "donothing_formsubmit": {
                this.confirmOperate(false);
                break;
            }
            case "donothing_modify": {
                this.doModifyOperate();
                break;
            }
            case "donothing_calnewentry": {
                this.openCalPersonListF7(personId);
                break;
            }
            case "donothing_salaryfilenewentry": {
                OnHoldBillHelper.openSalaryfileListF7((IFormView)this.getView(), (String)this.getPluginName(), (Long)personId);
                break;
            }
            case "caltable_deleteentry": {
                this.delCaltableEntryRow();
                this.updateEditStatus("caltable");
                break;
            }
            case "salaryfile_deleteentry": {
                this.delSalaryEntryRow();
                this.updateEditStatus("salary");
                break;
            }
        }
    }

    private void delCaltableEntryRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("caltableentry");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        if (selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"OnHoldDetailEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> errorMsgList = new ArrayList<String>(selectedRows.length);
        int[] delIndexArr = this.getDelIndexArr(selectedRows, errorMsgList);
        this.getModel().deleteEntryRows("caltableentry", delIndexArr);
        int totalCount = selectedRows.length;
        OnHoldDetailHelper.showDetailResultMsg((int)totalCount, errorMsgList, (String)"caltable_deleteentry", (IFormView)this.getView());
    }

    private int[] getDelIndexArr(int[] selectedRows, List<String> errorMsgList) {
        String pageId;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("caltableentry");
        ArrayList<Object> selectedOnHoldList = new ArrayList<Object>(selectedRows.length);
        ArrayList<Long> calPersonIdList = new ArrayList<Long>(selectedRows.length);
        for (int selectedRow : selectedRows) {
            selectedOnHoldList.add(entryEntity.get(selectedRow));
            calPersonIdList.add(Long.valueOf(((DynamicObject)entryEntity.get(selectedRow)).getString("caltableinfo.id")));
        }
        int selectedOnHoldListSize = selectedOnHoldList.size();
        ArrayList<Integer> delIndexList = new ArrayList<Integer>(selectedOnHoldListSize);
        ISWCAppCache appCache = SWCAppCache.get((String)"delonholdId_appcache");
        JSONArray delOnHoldIdArr = (JSONArray)appCache.get(pageId = this.getView().getPageId(), JSONArray.class);
        if (delOnHoldIdArr == null) {
            delOnHoldIdArr = new JSONArray();
        }
        Map onHoldCalPersonMap = OnHoldBillHelper.queryOnHoldedCalPersonMap(calPersonIdList);
        List<Long> calPersonDeledIdList = this.getCaltableDeledIdListFromCache();
        for (DynamicObject dynamicObject : selectedOnHoldList) {
            int calPersonStatus = dynamicObject.getInt("caltablestatus");
            String calPersonId = dynamicObject.getString("caltableinfo.id");
            DynamicObject calPersonOnHoldDb = (DynamicObject)onHoldCalPersonMap.get(calPersonId);
            if (!SWCObjectUtils.isEmpty((Object)calPersonOnHoldDb)) {
                calPersonStatus = calPersonOnHoldDb.getInt("status");
            }
            if (calPersonStatus >= OnHoldStatusEnum.STATUS_RELEASE.getCode()) {
                String salaryFileNumber = dynamicObject.getString("caltableinfo.salaryfile.number");
                String calTaskNumber = dynamicObject.getString("caltableinfo.caltask.number");
                String onHoldStatusDec = OnHoldStatusEnum.getDesc((Integer)calPersonStatus);
                errorMsgList.add(MessageFormat.format(ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7\uff1a{0}\uff0c\u6838\u7b97\u4efb\u52a1\u7f16\u7801\uff1a{1}\u4e3a{2}\uff0c\u65e0\u6cd5\u5220\u9664\u505c\u7f13\u53d1\u3002", (String)"OnHoldDetailEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]), salaryFileNumber, calTaskNumber, onHoldStatusDec));
                continue;
            }
            Integer delIndex = dynamicObject.getInt("seq") - 1;
            delIndexList.add(delIndex);
            String onHoldId = dynamicObject.getString("caltableonhold");
            calPersonDeledIdList.add(Long.valueOf(calPersonId));
            if (SWCStringUtils.equals((String)"0", (String)onHoldId)) continue;
            delOnHoldIdArr.add((Object)onHoldId);
        }
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put("caltableDeledIdList", calPersonDeledIdList);
        appCache.put(pageId, (Object)delOnHoldIdArr);
        int[] nArray = OnHoldDetailHelper.integerListToArray(delIndexList);
        return nArray;
    }

    private List<Long> getCaltableDeledIdListFromCache() {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        ArrayList caltableDeledIdList = (ArrayList)pageCache.get("caltableDeledIdList", List.class);
        if (caltableDeledIdList == null) {
            caltableDeledIdList = new ArrayList(10);
        }
        return caltableDeledIdList;
    }

    private void delSalaryEntryRow() {
        String pageId;
        EntryGrid entryGrid = (EntryGrid)this.getControl("salaryentry");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        if (selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"OnHoldDetailEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("salaryentry");
        ArrayList<Object> selectedOnHoldList = new ArrayList<Object>(selectedRows.length);
        for (int selectedRow : selectedRows) {
            selectedOnHoldList.add(entryEntity.get(selectedRow));
        }
        int selectedOnHoldListSize = selectedOnHoldList.size();
        ArrayList<String> errorMsgList = new ArrayList<String>(selectedOnHoldListSize);
        ArrayList<Integer> delIndexList = new ArrayList<Integer>(selectedOnHoldListSize);
        ISWCAppCache appCache = SWCAppCache.get((String)"delonholdId_appcache");
        JSONArray delOnHoldIdArr = (JSONArray)appCache.get(pageId = this.getView().getPageId(), JSONArray.class);
        if (delOnHoldIdArr == null) {
            delOnHoldIdArr = new JSONArray(10);
        }
        for (DynamicObject dynamicObject : selectedOnHoldList) {
            int onHoldStatus = dynamicObject.getInt("salaryfilestatus");
            if (onHoldStatus >= OnHoldStatusEnum.STATUS_RELEASE.getCode()) {
                String salaryFileNumber = dynamicObject.getString("salaryfileinfo.number");
                String onHoldStatusDec = OnHoldStatusEnum.getDesc((Integer)onHoldStatus);
                errorMsgList.add(MessageFormat.format(ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7({0})\uff1a\u4e3a{1}\uff0c\u65e0\u6cd5\u5220\u9664\u505c\u7f13\u53d1\u3002", (String)"OnHoldDetailEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), salaryFileNumber, onHoldStatusDec));
                continue;
            }
            Integer delIndex = dynamicObject.getInt("seq") - 1;
            delIndexList.add(delIndex);
            String onHoldId = dynamicObject.getString("salaryfileonhold");
            if (SWCStringUtils.equals((String)"0", (String)onHoldId)) continue;
            delOnHoldIdArr.add((Object)onHoldId);
        }
        appCache.put(pageId, (Object)delOnHoldIdArr);
        int[] delIndexArr = OnHoldDetailHelper.integerListToArray(delIndexList);
        this.getModel().deleteEntryRows("salaryentry", delIndexArr);
        int n = selectedRows.length;
        OnHoldDetailHelper.showDetailResultMsg((int)n, errorMsgList, (String)"salaryfile_deleteentry", (IFormView)this.getView());
    }

    private void confirmOperate(boolean isSave) {
        if (isSave) {
            this.saveOnHoldInfo();
        } else {
            this.submitOnHoldInfo();
        }
    }

    private void saveOnHoldInfo() {
        Map<String, DynamicObjectCollection> currentEntityOnHoldInfoMap = this.getCurrentEntityOnHoldInfoMap();
        Map<String, Object> publicFieldValMap = this.getPublicFieldVal();
        OnHoldDetailService onHoldDetailService = new OnHoldDetailService(this.getView().getPageId());
        Map resultMap = onHoldDetailService.saveOnHold(currentEntityOnHoldInfoMap, publicFieldValMap, this.getView().getPageId());
        OnHoldDetailHelper.showDetailResultMsg((Map)resultMap, (String)"donothing_save", (IFormView)this.getView());
        this.getView().updateView("caltableentry");
        this.getView().updateView("salaryentry");
        this.updateEditStatus("caltable");
        this.updateEditStatus("salary");
        this.getModel().setDataChanged(false);
    }

    private void submitOnHoldInfo() {
        Map<String, DynamicObjectCollection> currentEntityOnHoldInfoMap = this.getCurrentEntityOnHoldInfoMap();
        Map<String, Object> publicFieldValMap = this.getPublicFieldVal();
        OnHoldDetailService onHoldDetailService = new OnHoldDetailService(this.getView().getPageId());
        Map resultMap = onHoldDetailService.submitOnHold(currentEntityOnHoldInfoMap, publicFieldValMap, this.getView().getPageId());
        OnHoldDetailHelper.showDetailResultMsg((Map)resultMap, (String)"donothing_formsubmit", (IFormView)this.getView());
        this.getView().updateView("caltableentry");
        this.getView().updateView("salaryentry");
        this.updateEditStatus("caltable");
        this.updateEditStatus("salary");
        this.getModel().setDataChanged(false);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "save_confirm_callback": {
                if (!MessageBoxResult.Yes.equals((Object)event.getResult())) break;
                this.saveOnHoldInfo();
                break;
            }
            case "submit_confirm_callback": {
                if (!MessageBoxResult.Yes.equals((Object)event.getResult())) break;
                this.submitOnHoldInfo();
                break;
            }
            case "confirm_callback_close": {
                if (!MessageBoxResult.Yes.equals((Object)event.getResult())) break;
                this.getModel().setDataChanged(false);
                this.clearCacheInfo();
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "hsas_onholdcaltablef7": {
                this.addCalPersonUpdateEntry(closedCallBackEvent);
                this.updateEditStatus("caltable");
                break;
            }
            case "hsas_onholdsalaryfilef7": {
                this.addSalaryUpdateEntry(closedCallBackEvent);
                this.updateEditStatus("salary");
                break;
            }
        }
    }

    private void doModifyOperate() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"onholdmodify"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"save", "caltablenewentry", "caltabledeleteentry", "salaryfilenewentry", "salaryfiledeleteentry"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"remark", "attachment"});
        this.updateEditStatus("caltable");
        this.updateEditStatus("salary");
    }

    private void addCalPersonUpdateEntry(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (selectedCollection != null && !selectedCollection.isEmpty()) {
            Object[] primaryKeyValues = selectedCollection.getPrimaryKeyValues();
            List pkIds = OnHoldDetailHelper.changeToList((Object[])primaryKeyValues);
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            List<Long> calPersonDeledIdList = this.getCaltableDeledIdListFromCache();
            calPersonDeledIdList.removeAll(pkIds);
            pageCache.put("caltableDeledIdList", calPersonDeledIdList);
            DynamicObject[] calPersonArr = OnHoldBillHelper.queryCalPersonArrByIds((Object[])primaryKeyValues);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            if (calPersonArr == null || calPersonArr.length < 1) {
                return;
            }
            model.beginInit();
            TableValueSetter setter = OnHoldBillHelper.getSetter((DynamicObject[])calPersonArr);
            model.batchCreateNewEntryRow("caltableentry", setter);
            this.getView().updateView("caltableentry");
            model.endInit();
        }
    }

    private void addSalaryUpdateEntry(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (selectedCollection != null && !selectedCollection.isEmpty()) {
            Object[] primaryKeyValues = selectedCollection.getPrimaryKeyValues();
            DynamicObject[] salaryFileArr = OnHoldBillHelper.querySalaryFileArrByIds((Object[])primaryKeyValues);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            if (salaryFileArr == null || salaryFileArr.length < 1) {
                return;
            }
            model.beginInit();
            TableValueSetter setter = new TableValueSetter(new String[0]);
            setter.addField("salaryfileinfo", new Object[0]);
            setter.addField("salaryonholdreason", new Object[0]);
            setter.addField("payrollgroup", new Object[0]);
            setter.addField("adminorg", new Object[0]);
            setter.addField("company", new Object[0]);
            setter.addField("department", new Object[0]);
            setter.addField("position", new Object[0]);
            setter.addField("firstbsed", new Object[0]);
            setter.addField("bsed", new Object[0]);
            setter.addField("bsled", new Object[0]);
            int salarySize = this.getEntrySize("salaryentry");
            for (DynamicObject salaryFile : salaryFileArr) {
                Long salaryFileId = salaryFile.getLong("id");
                String payrollgroup = salaryFile.getString("payrollgroup.id");
                String adminOrgId = salaryFile.getString("adminorg.id");
                String company = salaryFile.getString("empposinfo.company.id");
                String department = salaryFile.getString("empposinfo.adminorg.id");
                String position = salaryFile.getString("empposinfo.position.id");
                Date firstBsed = salaryFile.getDate("firstbsed");
                Date bsed = salaryFile.getDate("bsed");
                Date bsled = salaryFile.getDate("bsled");
                setter.addRow(new Object[]{salaryFileId, 0L, payrollgroup, adminOrgId, company, department, position, firstBsed, bsed, bsled});
                this.getView().setEnable(Boolean.FALSE, salarySize++, new String[]{"salaryonholdrange", "salaryonholdreason"});
            }
            model.batchCreateNewEntryRow("salaryentry", setter);
            this.getView().updateView("salaryentry");
            model.endInit();
        }
    }

    private void updateEditStatus(String module) {
        if ("salary".equals(module)) {
            DynamicObjectCollection salaryEntity = this.getModel().getEntryEntity("salaryentry");
            Boolean isSalaryDelEnable = Boolean.FALSE;
            for (int i = 0; i < salaryEntity.size(); ++i) {
                DynamicObject salaryObj = (DynamicObject)salaryEntity.get(i);
                int salaryfileStatus = salaryObj.getInt("salaryfilestatus");
                if (salaryfileStatus == OnHoldStatusEnum.STATUS_ONHOLD.getCode() || salaryfileStatus == OnHoldStatusEnum.STATUS_TOPAY.getCode() || salaryfileStatus == OnHoldStatusEnum.STATUS_STOPPAY.getCode()) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"salaryonholdreason", "salaryisallowcal", "salaryonholdstartdate", "salaryreleasedate"});
                    continue;
                }
                isSalaryDelEnable = Boolean.TRUE;
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"salaryonholdreason", "salaryisallowcal", "salaryonholdstartdate", "salaryreleasedate"});
            }
            this.getView().setEnable(isSalaryDelEnable, new String[]{"salaryfiledeleteentry"});
        } else {
            DynamicObjectCollection caltableEntity = this.getModel().getEntryEntity("caltableentry");
            Boolean isCaltableDelEnable = Boolean.FALSE;
            for (int i = 0; i < caltableEntity.size(); ++i) {
                DynamicObject caltableObj = (DynamicObject)caltableEntity.get(i);
                boolean caltableOnholdStatus = caltableObj.getBoolean("caltableonholdstatus");
                this.getView().setEnable(Boolean.valueOf(caltableOnholdStatus), i, new String[]{"caltableonholdreason"});
                int caltableStatus = caltableObj.getInt("caltablestatus");
                if (caltableStatus == OnHoldStatusEnum.STATUS_ONHOLD.getCode() || caltableStatus == OnHoldStatusEnum.STATUS_TOPAY.getCode() || caltableStatus == OnHoldStatusEnum.STATUS_STOPPAY.getCode()) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"caltableonholdstatus", "caltableonholdreason"});
                } else {
                    isCaltableDelEnable = Boolean.TRUE;
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"caltableonholdstatus", "caltableonholdreason"});
                }
                this.getView().setEnable(isCaltableDelEnable, new String[]{"caltabledeleteentry"});
            }
        }
    }

    private Map<String, DynamicObjectCollection> getCurrentEntityOnHoldInfoMap() {
        DynamicObjectCollection salaryEntity = this.getModel().getEntryEntity("salaryentry");
        DynamicObjectCollection calPersonEntity = this.getModel().getEntryEntity("caltableentry");
        HashMap<String, DynamicObjectCollection> onHoldEntityMap = new HashMap<String, DynamicObjectCollection>(16);
        onHoldEntityMap.put("salaryfileList", salaryEntity);
        onHoldEntityMap.put("caltableList", calPersonEntity);
        return onHoldEntityMap;
    }

    private Map<String, Object> getPublicFieldVal() {
        HashMap<String, Object> publicFieldValMap = new HashMap<String, Object>(16);
        Object personNo = this.getView().getFormShowParameter().getCustomParam("personNo");
        Object personName = this.getView().getFormShowParameter().getCustomParam("personName");
        publicFieldValMap.put("personNo", personNo);
        publicFieldValMap.put("personName", personName);
        publicFieldValMap.put("remark", this.getModel().getValue("remark"));
        publicFieldValMap.put("attachment", (DynamicObjectCollection)this.getModel().getValue("attachment"));
        return publicFieldValMap;
    }

    private void setSalaryInfoEntryValue(DynamicObject onHold) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("salaryentry");
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("salaryfileinfo", new Object[0]);
        setter.addField("salaryfilestatus", new Object[0]);
        setter.addField("salaryonholdstartdate", new Object[0]);
        setter.addField("salaryreleasedate", new Object[0]);
        setter.addField("salaryisallowcal", new Object[0]);
        setter.addField("salaryonholdreason", new Object[0]);
        setter.addField("salaryfileonhold", new Object[0]);
        setter.addField("payrollgroup", new Object[0]);
        setter.addField("adminorg", new Object[0]);
        setter.addField("company", new Object[0]);
        setter.addField("department", new Object[0]);
        setter.addField("position", new Object[0]);
        setter.addField("firstbsed", new Object[0]);
        setter.addField("bsed", new Object[0]);
        setter.addField("bsled", new Object[0]);
        String onHoldId = onHold.getString("id");
        String salaryfileId = onHold.getString("salaryfile.id");
        Date startDate = onHold.getDate("startdate");
        Date releaseDate = onHold.getDate("releasedate");
        String salaryOnholdReason = onHold.getString("cause.id");
        String payrollgroup = onHold.getString("salaryfile.payrollgroup.id");
        int salaryfilestatus = onHold.getInt("status");
        String adminorg = onHold.getString("adminorg.id");
        String company = onHold.getString("company.id");
        String department = onHold.getString("department.id");
        String position = onHold.getString("position.id");
        Date firstBredDate = onHold.getDate("salaryfile.firstbsed");
        Date bredDate = onHold.getDate("salaryfile.bsed");
        Date brledDate = onHold.getDate("salaryfile.bsled");
        String isAllowCal = onHold.getString("isallowcal");
        setter.addRow(new Object[]{salaryfileId, salaryfilestatus, startDate, releaseDate, isAllowCal, salaryOnholdReason, onHoldId, payrollgroup, adminorg, company, department, position, firstBredDate, bredDate, brledDate});
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"salaryfilestatus", "salaryisallowcal", "salaryonholdstartdate", "salaryreleasedate", "salaryonholdreason"});
        model.batchCreateNewEntryRow("salaryentry", setter);
        this.getView().updateView("salaryentry");
        model.endInit();
    }

    private void setCalTableInfoEntryValue(DynamicObject onHold) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("caltableentry");
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("caltableinfo", new Object[0]);
        setter.addField("caltableonholdstatus", new Object[0]);
        setter.addField("orgname", new Object[0]);
        setter.addField("calpayoutitem", new Object[0]);
        setter.addField("caltableamount", new Object[0]);
        setter.addField("caltablecalamount", new Object[0]);
        setter.addField("caltablecalcurrency", new Object[0]);
        setter.addField("caltablestatus", new Object[0]);
        setter.addField("caltableonholdreason", new Object[0]);
        setter.addField("caltableonhold", new Object[0]);
        setter.addField("caltablestartdate", new Object[0]);
        setter.addField("caltableenddate", new Object[0]);
        setter.addField("payrolldate", new Object[0]);
        setter.addField("calcount", new Object[0]);
        setter.addField("caltaskent", new Object[0]);
        setter.addField("salaryfileent", new Object[0]);
        String onHoldId = onHold.getString("id");
        String orgName = onHold.getString("org.name");
        String calTableId = onHold.getString("caltableid");
        String calPayoutItemId = onHold.getString("payoutitem.id");
        int calTableStatus = onHold.getInt("status");
        Date startDate = onHold.getDate("startdate");
        Date endDate = onHold.getDate("enddate");
        String calTableOnHoldReason = onHold.getString("cause.id");
        String calTableCalCount = onHold.getString("caltask.calcount");
        Date payrollDate = onHold.getDate("caltask.payrolldate");
        BigDecimal calAmount = onHold.getBigDecimal("calamount");
        String calCurrency = onHold.getString("calcurrency.id");
        String calTaskId = onHold.getString("caltask.id");
        String salaryFileId = onHold.getString("salaryfile.id");
        String calTableAmount = "";
        if (calPayoutItemId != null) {
            HashSet<Long> salaryItemIdSet = new HashSet<Long>(1);
            salaryItemIdSet.add(Long.valueOf(calPayoutItemId));
            Map salaryItemDataPrecisionInfoMap = OnHoldDetailHelper.getSalaryItemDataPrecisionInfoMap(salaryItemIdSet);
            DynamicObject dataPrecision = (DynamicObject)salaryItemDataPrecisionInfoMap.get(calPayoutItemId);
            int scale = 2;
            if (dataPrecision != null) {
                scale = dataPrecision.getInt("scale");
            }
            if (calAmount != null && calAmount.intValue() != 0) {
                calAmount = OnHoldDetailHelper.getScaleFormatValue((BigDecimal)calAmount, (int)scale);
                String signStr = onHold.getString("calcurrency.sign");
                String calCurrencySign = SWCStringUtils.isEmpty((String)signStr) ? "" : signStr;
                calTableAmount = String.join((CharSequence)"", calCurrencySign, calAmount.toPlainString());
            }
        }
        setter.addRow(new Object[]{Long.valueOf(calTableId), Boolean.TRUE, orgName, calPayoutItemId, calTableAmount, calAmount, calCurrency, calTableStatus, calTableOnHoldReason, onHoldId, startDate, endDate, payrollDate, calTableCalCount, calTaskId, salaryFileId});
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"calpayoutitem", "caltableonholdamount", "caltablestatus", "caltableonholdstatus", "caltableonholdreason"});
        model.batchCreateNewEntryRow("caltableentry", setter);
        this.getView().updateView("caltableentry");
        model.endInit();
    }

    private void setPublicFieldVal(DynamicObject onHoldInfo) {
        this.getModel().setValue("releasedate", (Object)onHoldInfo.getDate("releasedate"));
        this.getModel().setValue("remark", (Object)onHoldInfo.getString("remark"));
        DynamicObjectCollection objColl = (DynamicObjectCollection)onHoldInfo.get("attachment");
        Long[] attIds = new Long[objColl.size()];
        int index = 0;
        for (DynamicObject obj : objColl) {
            attIds[index++] = obj.getLong("fbasedataid_id");
        }
        this.getModel().setValue("attachment", (Object)attIds);
        this.getView().updateView("releasedate");
        this.getView().updateView("remark");
        this.getView().updateView("attachment");
    }

    private void openCalPersonListF7(Long personId) {
        ListShowParameter showParam = ShowFormHelper.createShowListForm((String)"hsas_onholdcalpersonf7", (boolean)true);
        QFilter qFilter = new QFilter("employee.id", "=", (Object)personId);
        List calPersonOnHoldedIdList = OnHoldBillHelper.queryOnHoldCalPersonIdListByPersonId((Long)personId);
        List<Long> calPersonIdList = this.getCurrentCaltableEntryIdList();
        calPersonOnHoldedIdList.addAll(calPersonIdList);
        calPersonOnHoldedIdList.removeAll(this.getCaltableDeledIdListFromCache());
        qFilter.and("id", "not in", (Object)calPersonOnHoldedIdList);
        qFilter.and("paystatus", "not in", (Object)new String[]{PayStateEnum.PAYING.getCode(), PayStateEnum.PAID.getCode()});
        qFilter.and("caltask.tasktype", "in", (Object)new String[]{"0", "1"});
        qFilter.and("onholdstatus", "not in", (Object)new String[]{"2", "4"});
        showParam.getListFilterParameter().setFilter(qFilter);
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_onholdcaltablef7"));
        this.getView().showForm((FormShowParameter)showParam);
    }

    private List<Long> getCurrentCaltableEntryIdList() {
        ArrayList<Long> caltableIdList = new ArrayList<Long>();
        DynamicObjectCollection caltableEntity = this.getModel().getEntryEntity("caltableentry");
        for (DynamicObject caltable : caltableEntity) {
            Long caltableId = caltable.getLong("caltableinfo.id");
            caltableIdList.add(caltableId);
        }
        return caltableIdList;
    }

    private void setEditStatus(String fieldKey) {
        int entryIndex = this.getEntryIndexByField(fieldKey);
        switch (fieldKey) {
            case "salaryonholdstatus": {
                Boolean salaryonholdstatus = (Boolean)this.getModel().getValue(fieldKey);
                this.getModel().setValue("startdate", null);
                this.getModel().setValue("salaryonholdreason", null);
                this.getView().setEnable(salaryonholdstatus, entryIndex, new String[]{"salaryonholdrange", "salaryonholdreason"});
                break;
            }
            case "caltableonholdstatus": {
                Boolean caltableonholdstatus = (Boolean)this.getModel().getValue(fieldKey);
                this.getModel().setValue("caltableonholdreason", null);
                this.getView().setEnable(caltableonholdstatus, entryIndex, new String[]{"caltableonholdreason"});
                break;
            }
        }
    }

    private int getEntrySize(String entryName) {
        DynamicObjectCollection entryEntry = this.getModel().getEntryEntity(entryName);
        return entryEntry == null ? 0 : entryEntry.size();
    }

    private int getEntryIndexByField(String field) {
        int[] salaryGridSelectRows;
        String entryName = "caltableentry";
        if (field.startsWith("salary")) {
            entryName = "salaryentry";
        }
        int entryIndex = (salaryGridSelectRows = this.getEntryIndexArrByEntryName(entryName)).length > 0 ? salaryGridSelectRows[0] : 0;
        return entryIndex;
    }

    private int[] getEntryIndexArrByEntryName(String entryName) {
        EntryGrid salaryGrid = (EntryGrid)this.getView().getControl(entryName);
        int[] salaryGridSelectRows = salaryGrid.getSelectRows();
        return salaryGridSelectRows;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid caltableEntry = (EntryGrid)this.getControl("caltableentry");
        caltableEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid salaryfileEntry = (EntryGrid)this.getControl("salaryentry");
        salaryfileEntry.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit salaryfileControl = (BasedataEdit)this.getView().getControl("salaryonholdreason");
        BasedataEdit caltableControl = (BasedataEdit)this.getView().getControl("caltableonholdreason");
        salaryfileControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        caltableControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String fieldName = args.getFieldName();
        EntryGrid entry = (EntryGrid)args.getSource();
        String entryName = entry.getEntryKey();
        DynamicObject currentRowObject = this.getCurrentSelectedRowObject(entryName);
        switch (fieldName) {
            case "caltablesalaryfileno": {
                Long caltableSalaryFileId = currentRowObject.getLong("salaryfileent.id");
                SWCSalaryFileServiceHelper.assembleSalaryFileDataAndOpenFormView((Long)caltableSalaryFileId, (IFormView)this.getView());
                break;
            }
            case "caltaskno": {
                Long calTaskId = currentRowObject.getLong("caltaskent.id");
                ListShowParameter calTaskShowParameter = CalPayrollTaskHelper.getCalTableListForm((String)this.getView().getPageId(), (long)calTaskId);
                this.getView().showForm((FormShowParameter)calTaskShowParameter);
                break;
            }
            case "salaryfileno": {
                Long salaryFileId = currentRowObject.getLong("salaryfileinfo.id");
                SWCSalaryFileServiceHelper.assembleSalaryFileDataAndOpenFormView((Long)salaryFileId, (IFormView)this.getView());
                break;
            }
        }
    }

    private DynamicObject getCurrentSelectedRowObject(String entryName) {
        int[] entryGridSelectRows = this.getEntryIndexArrByEntryName(entryName);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryName);
        return (DynamicObject)entryEntity.get(entryGridSelectRows[0]);
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        this.clearCacheInfo();
    }

    private void clearCacheInfo() {
        ISWCAppCache appCache = SWCAppCache.get((String)"delonholdId_appcache");
        String pageId = this.getView().getPageId();
        appCache.remove(pageId);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.remove("caltableDeledIdList");
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propertyName = e.getProperty().getName();
        int entryIndex = this.getEntryIndexByField(propertyName);
        switch (propertyName) {
            case "caltableonholdreason": {
                DynamicObjectCollection caltableCol = this.getModel().getEntryEntity("caltableentry");
                Long caltableOrgId = ((DynamicObject)caltableCol.get(entryIndex)).getLong("caltableinfo.org.id");
                this.setOnHoldFilter(e, caltableOrgId);
                break;
            }
            case "salaryonholdreason": {
                DynamicObjectCollection salaryfileCol = this.getModel().getEntryEntity("salaryentry");
                Long salaryfileOrgId = ((DynamicObject)salaryfileCol.get(entryIndex)).getLong("salaryfileinfo.org.id");
                this.setOnHoldFilter(e, salaryfileOrgId);
                break;
            }
        }
    }

    private void setOnHoldFilter(BeforeF7SelectEvent e, Long orgId) {
        IBaseDataService baseDataService = (IBaseDataService)this.getModel().getService(IBaseDataService.class);
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        QFilter qFilter = baseDataService.getBaseDataFilter("hsbs_onholdcause", orgId);
        param.getListFilterParameter().setFilter(qFilter);
    }
}

