/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.payschedule;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;

public class PaySchImportPlugin
extends BatchImportPlugin {
    protected void beforeSave(List<ImportBillData> billData, ImportLogger logger) {
        super.beforeSave(billData, logger);
        Iterator<ImportBillData> iterator = billData.iterator();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        while (iterator.hasNext()) {
            JSONObject data;
            ImportBillData bill2;
            block19: {
                String startDateStr;
                bill2 = iterator.next();
                if (bill2.isEmpty()) continue;
                data = bill2.getData();
                if (data.getJSONObject("payrollgrp") == null) {
                    this.log(bill2.getStartIndex(), ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u3002", (String)"PaySchImportPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]), logger);
                    iterator.remove();
                    continue;
                }
                if (data.getJSONObject("payrollgrpv") == null) {
                    this.log(bill2.getStartIndex(), ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u7248\u672c\u201d\u3002", (String)"PaySchImportPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]), logger);
                    iterator.remove();
                    continue;
                }
                if (data.getJSONObject("payrollscene") == null) {
                    this.log(bill2.getStartIndex(), ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u85aa\u8d44\u6838\u7b97\u573a\u666f\u201d\u3002", (String)"PaySchImportPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]), logger);
                    iterator.remove();
                    continue;
                }
                if (data.getJSONObject("calperiod") == null) {
                    this.log(bill2.getStartIndex(), ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u671f\u95f4\u201d\u3002", (String)"PaySchImportPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]), logger);
                    iterator.remove();
                }
                if (!StringUtils.isEmpty((String)(startDateStr = data.getString("startdate")))) {
                    try {
                        simpleDateFormat.parse(startDateStr);
                        break block19;
                    }
                    catch (ParseException e) {
                        iterator.remove();
                        this.log(bill2.getStartIndex(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\uff1a%s\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"PaySchImportPlugin_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]), startDateStr), logger);
                        continue;
                    }
                }
                this.log(bill2.getStartIndex(), ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5f00\u59cb\u65e5\u671f\u201d\u3002", (String)"PaySchImportPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]), logger);
                iterator.remove();
                continue;
            }
            String endDateStr = data.getString("enddate");
            if (endDateStr != null) {
                try {
                    simpleDateFormat.parse(endDateStr);
                }
                catch (ParseException e) {
                    this.log(bill2.getStartIndex(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\uff1a%s\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"PaySchImportPlugin_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]), endDateStr), logger);
                    iterator.remove();
                }
                continue;
            }
            this.log(bill2.getStartIndex(), ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7ed3\u675f\u65e5\u671f\u201d\u3002", (String)"PaySchImportPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]), logger);
            iterator.remove();
        }
        Object[] payrollSceneNumbers = billData.stream().map(bill -> bill.getData().getJSONObject("payrollscene").getString("number")).toArray();
        Object[] calPeriodNumbers = billData.stream().map(bill -> bill.getData().getJSONObject("calperiod").getString("number")).toArray();
        Object[] payrollGrpNumbers = billData.stream().map(bill -> bill.getData().getJSONObject("payrollgrp").getString("number")).toArray();
        Object[] payrollGrpvNumbers = billData.stream().map(bill -> bill.getData().getJSONObject("payrollgrpv").getString("number")).toArray();
        SWCDataServiceHelper payrollGrpHelper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter grpFilter = new QFilter("number", "in", (Object)payrollGrpNumbers);
        BaseDataHisHelper.addHisCurrFilter((QFilter)grpFilter);
        Set payrollGrpIds = SWCPermissionServiceHelper.getPayrollGrpSetByPermItem((String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)"47150e89000000ac");
        if (payrollGrpIds != null) {
            grpFilter.and("id", "in", (Object)payrollGrpIds);
        }
        DynamicObject[] payrollGrpDys = payrollGrpHelper.query("number,org.id", grpFilter.toArray());
        QFilter grpvFilter = new QFilter("number", "in", (Object)payrollGrpvNumbers);
        grpvFilter.and("datastatus", "=", (Object)"1");
        BaseDataHisHelper.addHisVerFilter((QFilter)grpvFilter);
        DynamicObject[] payrollGrpvDys = payrollGrpHelper.query("id", grpvFilter.toArray());
        Map payrollGrpvMap = Arrays.stream(payrollGrpvDys).collect(Collectors.toMap(dy -> dy.getString("number"), Function.identity(), (v1, v2) -> v1));
        Map payrollGrpMap = Arrays.stream(payrollGrpDys).collect(Collectors.toMap(dy -> dy.getString("number"), Function.identity(), (v1, v2) -> v1));
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollscene");
        QFilter sceneFilter = new QFilter("number", "in", (Object)payrollSceneNumbers);
        BaseDataHisHelper.addHisCurrFilter((QFilter)sceneFilter);
        Set payrollSceneIds = SWCPermissionServiceHelper.getPayrollSceneSetByPermItem((String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)"47150e89000000ac");
        if (payrollSceneIds != null) {
            sceneFilter.and("id", "in", (Object)payrollSceneIds);
        }
        DynamicObject[] payrollSceneDys = helper.query("number,periodtype.id,periodtype.number", new QFilter[]{sceneFilter});
        Map payRollSceneMap = Arrays.stream(payrollSceneDys).collect(Collectors.toMap(dy -> dy.getString("number"), Function.identity(), (v1, v2) -> v1));
        SWCDataServiceHelper calPeriodHelper = new SWCDataServiceHelper("hsbs_calperiod");
        QFilter qFilter = new QFilter("number", "in", (Object)calPeriodNumbers);
        DynamicObject[] calPeriodDys = calPeriodHelper.query("number,periodtypeid", new QFilter[]{qFilter});
        Map<String, List<DynamicObject>> collect = Arrays.stream(calPeriodDys).collect(Collectors.groupingBy(dy -> dy.getString("number")));
        Iterator<ImportBillData> it = billData.iterator();
        while (it.hasNext()) {
            ImportBillData bill3 = it.next();
            if (bill3.isEmpty()) continue;
            JSONObject data = bill3.getData();
            String grpNumber = data.getJSONObject("payrollgrp").getString("number");
            DynamicObject payrollGrpDy = (DynamicObject)payrollGrpMap.get(grpNumber);
            if (payrollGrpDy == null) {
                it.remove();
                this.log(bill3.getStartIndex(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u3010%s\u3011\u85aa\u8d44\u6838\u7b97\u7ec4\u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u6570\u636e\u6743\u9650\u3002", (String)"PaySchImportPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]), grpNumber), logger);
                continue;
            }
            String grpvNumber = data.getJSONObject("payrollgrpv").getString("number");
            DynamicObject payrollGrpvDy = (DynamicObject)payrollGrpvMap.get(grpvNumber);
            if (payrollGrpvDy == null) {
                it.remove();
                this.log(bill3.getStartIndex(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u3010%s\u3011\u751f\u6548\u4e2d\u7684\u85aa\u8d44\u6838\u7b97\u7ec4\u7248\u672c\u4e0d\u5b58\u5728\u3002", (String)"PaySchImportPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]), grpvNumber), logger);
                continue;
            }
            String sceneNumber = data.getJSONObject("payrollscene").getString("number");
            DynamicObject sceneDy = (DynamicObject)payRollSceneMap.get(sceneNumber);
            if (sceneDy == null) {
                it.remove();
                this.log(bill3.getStartIndex(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u3010%s\u3011\u85aa\u8d44\u6838\u7b97\u573a\u666f\u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u6570\u636e\u6743\u9650\u3002", (String)"PaySchImportPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), sceneNumber), logger);
                continue;
            }
            long periodId = sceneDy.getLong("periodtype.id");
            String calperiodNumber = data.getJSONObject("calperiod").getString("number");
            List<DynamicObject> calPeriodDy = collect.get(calperiodNumber);
            if (calPeriodDy == null || calPeriodDy.isEmpty()) {
                it.remove();
                this.log(bill3.getStartIndex(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u3010%s\u3011\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"PaySchImportPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]), calperiodNumber), logger);
                continue;
            }
            Optional<DynamicObject> periodTypeDy = calPeriodDy.stream().filter(dy -> periodId == dy.getLong("periodtypeid")).findFirst();
            if (!periodTypeDy.isPresent()) {
                it.remove();
                this.log(bill3.getStartIndex(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%s\u201d\u671f\u95f4\u6240\u5c5e\u7684\u201c\u671f\u95f4\u7c7b\u578b\u201d\u4e0e\u85aa\u8d44\u6838\u7b97\u573a\u666f\u4e2d\u7684\u201c\u671f\u95f4\u7c7b\u578b\u201d\u4e0d\u5339\u914d\u3002", (String)"PaySchImportPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), calperiodNumber), logger);
                continue;
            }
            JSONObject calPeriod = data.getJSONObject("calperiod");
            calPeriod.remove((Object)"number");
            calPeriod.put("id", periodTypeDy.get().getPkValue());
            JSONObject periodJo = new JSONObject();
            periodJo.put("importprop", (Object)"number");
            periodJo.put("id", (Object)periodTypeDy.get().getLong("periodtypeid"));
            data.put("calperiodtype", (Object)periodJo);
            JSONObject orgJo = new JSONObject();
            orgJo.put("importprop", (Object)"number");
            orgJo.put("id", (Object)payrollGrpDy.getLong("org.id"));
            data.put("org", (Object)orgJo);
            data.put("generatesource", (Object)"1");
            JSONObject payrollGrpv = data.getJSONObject("payrollgrpv");
            payrollGrpv.remove((Object)"number");
            payrollGrpv.put("id", (Object)payrollGrpvDy.getLong("id"));
        }
    }

    private void log(int rowIndex, String errorMsg, ImportLogger logger) {
        Map logCache = logger.getLogCache();
        if (logCache.get(rowIndex) != null) {
            ((List)logCache.get(rowIndex)).add(new ImportLogger.ImportLog(errorMsg));
            logger.setLogCache(logCache);
        } else {
            logger.log(Integer.valueOf(rowIndex), errorMsg).fail();
        }
    }
}

