/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.payschedule;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;

public class PaySchTplConfirmPlugin
extends AbstractFormPlugin {
    private static final String KEY_CANCEL = "btncancel";
    private static final String KEY_YES = "btnyes";
    private static final String KEY_NO = "btnno";
    private static final String KEY_MORE = "btnmore";
    private static final String KEY_FTITLE = "ftitle";
    private static final String KEY_FCONTENT = "fcontent";
    private static final String KEY_CONTENT = "content";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_CANCEL, KEY_YES, KEY_NO, KEY_MORE});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Label label = (Label)this.getControl(KEY_FTITLE);
        label.setText((String)parameter.getCustomParam("title"));
        Object errObj = parameter.getCustomParam("errorMsg");
        if (errObj != null) {
            String errStr = this.extractMesage((String)errObj);
            this.getModel().setValue(KEY_CONTENT, (Object)errStr);
            if (Boolean.TRUE != parameter.getCustomParam("hasMore")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_MORE});
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "btnyes": {
                Map<String, Object> returnData = this.getReturnData();
                returnData.put("KEY", "Yes");
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                break;
            }
            case "btnno": {
                Map<String, Object> returnData = this.getReturnData();
                returnData.put("KEY", "No");
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                break;
            }
            case "btncancel": {
                Map<String, Object> returnData = this.getReturnData();
                returnData.put("KEY", "Cancel");
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                break;
            }
            case "btnmore": {
                break;
            }
        }
    }

    private Map<String, Object> getReturnData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        int index = (Integer)formShowParameter.getCustomParam("index");
        int periodCountInt = (Integer)formShowParameter.getCustomParam("periodCountInt");
        String startPeriodDyStr = (String)formShowParameter.getCustomParam("startPeriodDyStr");
        Map existSchMap = (Map)formShowParameter.getCustomParam("existSchMap");
        HashMap<String, Object> returnData = new HashMap<String, Object>(6);
        returnData.put("index", String.valueOf(index));
        returnData.put("periodCountInt", String.valueOf(periodCountInt));
        returnData.put("startPeriodDyStr", startPeriodDyStr);
        returnData.put("existSchMap", existSchMap);
        returnData.put("KEY", " ");
        return returnData;
    }

    private String extractMesage(String errStr) {
        int index = errStr.indexOf(62);
        if (index == 0) {
            return errStr;
        }
        String[] lines = StringUtils.substring((String)errStr, (int)(errStr.indexOf(62) + 1)).split("<br/>");
        StringBuilder val = new StringBuilder();
        val.append(lines[0]);
        for (int i = 1; i < lines.length - 1; ++i) {
            val.append(System.lineSeparator());
            val.append(lines[i]);
        }
        return val.toString();
    }
}

