/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.payschedule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.KDDateUtils;
import kd.swc.hsas.business.cal.service.WorkCalendarLoadService;
import kd.swc.hsas.business.payschedule.PaySchTplHelper;
import kd.swc.hsas.common.enums.PayScheduleStatusEnum;
import kd.swc.hsas.common.vo.PaySchedule;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.entity.MultiLangEnumBridge;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PayScheduleCalendarPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(PayScheduleCalendarPlugin.class);
    private static final int ROW = 7;
    private static final int COL = 8;
    private static final String TIME_KEY = "datefield";
    private static final String CHOOSE_DATE = "choosedate";
    private static final String KEY_OPENFILTERAP = "openfilterap";
    private static final String KEY_CLOSEFILTERAP = "closefilterap";
    private static final String KEY_FILTERCONTENT = "filtercontent";
    private static final String KEY_WEEKDAY = "weekday";
    private static final String KEY_SELECTEDORGAP = "selectedorgap";
    private static final String KEY_SELECTEDGROUPAP = "selectedgroupap";
    private static final String KEY_SELECTEDSCENEAP = "selectedsceneap";
    private static final String KEY_SELECTEDPERIODAP = "selectedperiodap";
    private static final String KEY_SELECTEDORG = "selectedorg";
    private static final String KEY_SELECTEDGROUP = "selectedgroup";
    private static final String KEY_SELECTEDSCENE = "selectedscene";
    private static final String KEY_SELECTEDPERIOD = "selectedperiod";
    private static final String KEY_filterflex = "filterflex";
    private static final String KEY_CLOSEORGFILTER = "closeorgfilter";
    private static final String KEY_CLOSEGROUPFILTER = "closegroupfilter";
    private static final String KEY_CLOSESCENEFILTER = "closescenefilter";
    private static final String KEY_CLOSEPERIODFILTER = "closeperiodfilter";
    private static final String KEY_PREVREGION = "KEY_PREVREGION";
    private static final String BTN_PREV = "prevbtn";
    private static final String BTN_NEXT = "nextbtn";
    private static final String BTN_SELECT = "select";
    private static final String BTN_RESET = "reset";
    private static final String BTN_BACK_TODAY = "backtoday";
    private static final String BTN_MONTH = "month";
    private static final String BTN_YEAR = "year";
    private static final String BG_BLUE = "#F2F9FF";
    private static final String LINE_SP = "&#10";
    private static final String ENTRY = "entryentity";
    private static final String PAYROLLSCENE = "payrollscene";
    private static final String CAL_PERIOD = "calperiod";
    private static final String PAY_ROLL_GRP = "payrollgrp";
    private static final String SELECT_SCHEME = "selectscheme";
    private static final String PAY_SCHEDULE = "payschedule";
    private static final String PAY_SCHEDULE_NAME = "payschedulename";
    private static final String CAL_PERIOD_NAME = "calperiodname";
    private static final String PAY_SCHEDULE_STATUS = "payschedulestatus";
    private static final String PAY_SCHEDULE_STATUS_ENUM = "payschedulestatusenum";
    private static final String ORG_NAME = "orgname";
    private static final String PAY_ROLLGRP_NAME = "payrollgrpname";
    private static final String PAYROLLSCENE_NAME = "payrollscenename";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String GROUP_PAY_SCH_BY_DATE_CHAHE_KEY = "groupPaySchByDateMap";
    private static final String OP_DONOTHING_CHANGESTATUS = "donothing_changestatus";
    private static final String CALLBACKID_STATUSMARK = "callbackid_statusmark";
    private static final String KEY_PAYSCHEDULE = "payschedule";
    private static final String KEY_WORKSTATUS_WORK = "1";
    private static final String KEY_WORKSTATUS_HOLIDAY = "2";
    private static Map<Integer, MultiLangEnumBridge> weekLangMap = new HashMap<Integer, MultiLangEnumBridge>(7);

    public PayScheduleCalendarPlugin() {
        weekLangMap.put(1, new MultiLangEnumBridge("\u5468\u4e00", "PaySchedulePlatformPlugin_0", "swc-hsas-formplugin"));
        weekLangMap.put(2, new MultiLangEnumBridge("\u5468\u4e8c", "PaySchedulePlatformPlugin_1", "swc-hsas-formplugin"));
        weekLangMap.put(3, new MultiLangEnumBridge("\u5468\u4e09", "PaySchedulePlatformPlugin_2", "swc-hsas-formplugin"));
        weekLangMap.put(4, new MultiLangEnumBridge("\u5468\u56db", "PaySchedulePlatformPlugin_3", "swc-hsas-formplugin"));
        weekLangMap.put(5, new MultiLangEnumBridge("\u5468\u4e94", "PaySchedulePlatformPlugin_4", "swc-hsas-formplugin"));
        weekLangMap.put(6, new MultiLangEnumBridge("\u5468\u516d", "PaySchedulePlatformPlugin_5", "swc-hsas-formplugin"));
        weekLangMap.put(7, new MultiLangEnumBridge("\u5468\u65e5", "PaySchedulePlatformPlugin_6", "swc-hsas-formplugin"));
    }

    public void afterBindData(EventObject e) {
        Boolean isCalPlatform = (Boolean)this.getView().getFormShowParameter().getCustomParam("isCalPlatform");
        if (isCalPlatform != null && isCalPlatform.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_filterflex});
        }
    }

    public void afterCreateNewData(EventObject e) {
        Boolean isCalPlatform = (Boolean)this.getView().getFormShowParameter().getCustomParam("isCalPlatform");
        if (isCalPlatform != null && isCalPlatform.booleanValue()) {
            DynamicObject parentModel = this.getView().getParentView().getModel().getDataEntity();
            this.getModel().setValue(PAY_ROLL_GRP, (Object)parentModel.getLong("payrollgroup.id"));
            this.getModel().setValue(PAYROLLSCENE, (Object)parentModel.getLong("payrollscene.id"));
            if (parentModel.getLong("calperiod.id") != 0L) {
                this.getModel().setValue(CAL_PERIOD, (Object)new Long[]{parentModel.getLong("calperiod.id")});
            }
        }
        this.initCalendarTitle();
        Map<String, List<PaySchedule>> groupPaySchByDate = this.getGroupPaySchByDate();
        Date currentDate = new Date();
        this.setCalendar(currentDate, groupPaySchByDate);
        this.getView().setEnable(Boolean.FALSE, new String[]{PAYROLLSCENE, CAL_PERIOD});
        this.getModel().setValue(CHOOSE_DATE, (Object)currentDate);
        this.setWeekDayLabelValue(currentDate);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_CLOSEFILTERAP, KEY_FILTERCONTENT, KEY_SELECTEDGROUPAP, KEY_SELECTEDSCENEAP, KEY_SELECTEDORGAP, KEY_SELECTEDPERIODAP});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (int i = 1; i < 7; ++i) {
            for (int j = 1; j < 8; ++j) {
                Container flex = (Container)this.getControl("flex_" + i + "_" + j);
                flex.addClickListener((ClickListener)this);
            }
        }
        this.addClickListeners(new String[]{BTN_YEAR, BTN_PREV, BTN_NEXT, BTN_SELECT, BTN_RESET, BTN_BACK_TODAY, BTN_MONTH, KEY_CLOSEFILTERAP, KEY_OPENFILTERAP, KEY_CLOSEGROUPFILTER, KEY_CLOSEORGFILTER, KEY_CLOSEPERIODFILTER, KEY_CLOSESCENEFILTER});
        BasedataEdit frequency = (BasedataEdit)this.getView().getControl(CAL_PERIOD);
        frequency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payrollScene = (BasedataEdit)this.getView().getControl(PAYROLLSCENE);
        payrollScene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payrollgrp = (BasedataEdit)this.getView().getControl(PAY_ROLL_GRP);
        payrollgrp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (OP_DONOTHING_CHANGESTATUS.equals(operateKey)) {
            boolean isHasPerm = SWCPermissionServiceHelper.hasPerm((String)"hsas", (String)"hsas_payschedule", (String)"1UZC/H005XC6");
            if (!isHasPerm) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u85aa\u8d44\u65e5\u7a0b\u201d\u7684\u201c\u72b6\u6001\u6807\u8bb0\u201d\u6743\u9650\u3002", (String)"PayScheduleCalendarPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY);
            Object payScheduleStr = this.getModel().getValue("payschedule", entryCurrentRowIndex);
            if (payScheduleStr instanceof String) {
                SWCDataServiceHelper paySchHelper = new SWCDataServiceHelper("hsas_payschedule");
                String payScheduleId = (String)payScheduleStr;
                QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(payScheduleId));
                DynamicObject payScheduleDy = paySchHelper.queryOne("schedulestatus", qFilter.toArray());
                if (payScheduleDy == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u85aa\u8d44\u65e5\u7a0b\u6570\u636e\u4e22\u5931\u3002", (String)"PayScheduleStatusMarkPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                String scheduleStatus = payScheduleDy.getString("schedulestatus");
                if (PayScheduleStatusEnum.OVERDUE_FINISHED.getCode().equals(scheduleStatus)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u72b6\u6001\u4e3a\u201c\u903e\u671f\u5b8c\u6210\u201d\u7684\u65e5\u7a0b\uff0c\u4e0d\u5141\u8bb8\u6807\u8bb0\u3002", (String)"PayScheduleCalendarPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showStatusMark(payScheduleId);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        boolean isHasPerm = SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)"47150e89000000ac");
        switch (fieldKey) {
            case "payrollscene": {
                HasPermOrgResult permOrgs;
                if (!isHasPerm) {
                    beforeF7SelectEvent.addCustomQFilter(new QFilter(KEY_WORKSTATUS_WORK, "!=", (Object)1));
                    return;
                }
                DynamicObject payRollGrp = (DynamicObject)this.getModel().getValue(PAY_ROLL_GRP);
                DynamicObjectCollection payrollSceneEntry = payRollGrp.getDynamicObjectCollection("payrollsceneentry");
                ArrayList payrollSceneIds = new ArrayList(payrollSceneEntry.size());
                payrollSceneEntry.forEach(entryObj -> payrollSceneIds.add(entryObj.getLong("payrollscene.id")));
                ArrayList<QFilter> ruleQFilters = new ArrayList<QFilter>(10);
                ruleQFilters.add(new QFilter("id", "in", payrollSceneIds));
                ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().setQFilters(ruleQFilters);
                QFilter dataRuleForBdProp = SWCPermissionServiceHelper.getDataRuleForBdProp((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)PAYROLLSCENE, (String)"47150e89000000ac");
                if (dataRuleForBdProp != null) {
                    beforeF7SelectEvent.addCustomQFilter(dataRuleForBdProp);
                }
                if ((permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)"47150e89000000ac")).hasAllOrgPerm()) break;
                QFilter orgFilter = new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs());
                beforeF7SelectEvent.addCustomQFilter(orgFilter);
                break;
            }
            case "calperiod": {
                ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().setQFilters(this.buildCalPeriodTypeFilters());
                break;
            }
            case "payrollgrp": {
                HasPermOrgResult permOrgs;
                if (!isHasPerm) {
                    beforeF7SelectEvent.addCustomQFilter(new QFilter(KEY_WORKSTATUS_WORK, "!=", (Object)1));
                    return;
                }
                QFilter dataRuleForBdProp = SWCPermissionServiceHelper.getDataRuleForBdProp((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)PAY_ROLL_GRP, (String)"47150e89000000ac");
                if (dataRuleForBdProp != null) {
                    beforeF7SelectEvent.addCustomQFilter(dataRuleForBdProp);
                }
                if ((permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)"47150e89000000ac")).hasAllOrgPerm()) break;
                QFilter orgFilter = new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs());
                beforeF7SelectEvent.addCustomQFilter(orgFilter);
                break;
            }
            case "org": {
                if (!isHasPerm) {
                    beforeF7SelectEvent.addCustomQFilter(new QFilter(KEY_WORKSTATUS_WORK, "!=", (Object)1));
                    return;
                }
                HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)"47150e89000000ac");
                if (permOrgs.hasAllOrgPerm()) break;
                ArrayList<QFilter> orgQFilters = new ArrayList<QFilter>(10);
                orgQFilters.add(new QFilter("id", "in", (Object)permOrgs.getHasPermOrgs()));
                ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().setQFilters(orgQFilters);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (key) {
            case "datefield": {
                Object dateValue = this.getModel().getValue(TIME_KEY);
                if (dateValue != null) {
                    Date dateField = (Date)dateValue;
                    Map<String, List<PaySchedule>> groupPaySchByDates = this.getGroupPaySchByDate();
                    this.setCalendar(dateField, groupPaySchByDates);
                    this.getModel().setValue(CHOOSE_DATE, (Object)dateField);
                    this.setWeekDayLabelValue(dateField);
                    break;
                }
                this.getModel().beginInit();
                for (ChangeData changeData : changeSet) {
                    this.getModel().setValue(TIME_KEY, changeData.getOldValue());
                }
                this.getModel().endInit();
                break;
            }
            case "payrollgrp": {
                DynamicObject payRollGrp = (DynamicObject)changeSet[0].getNewValue();
                if (payRollGrp == null) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{PAYROLLSCENE, CAL_PERIOD});
                } else {
                    this.getModel().setValue("org", payRollGrp.get("org"));
                    this.getView().setEnable(Boolean.TRUE, new String[]{PAYROLLSCENE});
                }
                this.getModel().setValue(PAYROLLSCENE, null);
                this.getModel().setValue(CAL_PERIOD, null);
                this.setFilterContent(KEY_SELECTEDGROUPAP, KEY_SELECTEDGROUP, payRollGrp != null ? payRollGrp.getString("name") : null);
                break;
            }
            case "payrollscene": {
                DynamicObject rule = (DynamicObject)changeSet[0].getNewValue();
                if (rule == null) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{CAL_PERIOD});
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{CAL_PERIOD});
                }
                this.getModel().setValue(CAL_PERIOD, null);
                this.setFilterContent(KEY_SELECTEDSCENEAP, KEY_SELECTEDSCENE, rule != null ? rule.getString("name") : null);
                break;
            }
            case "org": {
                DynamicObject org = (DynamicObject)changeSet[0].getNewValue();
                this.setFilterContent(KEY_SELECTEDORGAP, KEY_SELECTEDORG, org != null ? org.getString("name") : null);
                break;
            }
            case "calperiod": {
                DynamicObjectCollection periods = (DynamicObjectCollection)changeSet[0].getNewValue();
                if (periods != null) {
                    List nameList = periods.stream().map(o -> o.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toList());
                    this.setFilterContent(KEY_SELECTEDPERIODAP, KEY_SELECTEDPERIOD, String.join((CharSequence)",", nameList));
                    break;
                }
                this.setFilterContent(KEY_SELECTEDPERIODAP, KEY_SELECTEDPERIOD, null);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        IDataModel model = this.getModel();
        if (source instanceof Control) {
            String key = ((Control)source).getKey();
            if (SWCStringUtils.equals((String)BTN_BACK_TODAY, (String)key)) {
                model.setValue(TIME_KEY, (Object)new Date());
                model.setValue(CHOOSE_DATE, (Object)new Date());
                this.setWeekDayLabelValue(new Date());
                return;
            }
            if (key.startsWith("flex_")) {
                String[] region = key.replace("flex_", "").split("_");
                if (region.length == 2) {
                    Date currChooseDay = this.getDay(Integer.parseInt(region[0]), Integer.parseInt(region[1]));
                    if (!this.isSameMonth(currChooseDay)) {
                        model.setValue(TIME_KEY, (Object)currChooseDay);
                        return;
                    }
                    model.setValue(CHOOSE_DATE, (Object)currChooseDay);
                    this.setWeekDayLabelValue(currChooseDay);
                    this.fillEntryData(currChooseDay);
                    this.markItemChosen(currChooseDay);
                }
            } else {
                Date currDate = (Date)model.getValue(TIME_KEY);
                switch (key) {
                    case "prevbtn": {
                        this.nextMonth(currDate, -1);
                        break;
                    }
                    case "nextbtn": {
                        this.nextMonth(currDate, 1);
                        break;
                    }
                    case "month": {
                        Button yearBtn = (Button)this.getControl(BTN_YEAR);
                        yearBtn.setCustomeStyles("");
                        break;
                    }
                    case "year": {
                        Button monthBtn = (Button)this.getControl(BTN_MONTH);
                        monthBtn.setCustomeStyles("");
                        break;
                    }
                    case "select": {
                        Map<String, List<PaySchedule>> payScheduleGroupByDates = this.queryPaySchedule();
                        this.setCalendar((Date)model.getValue(TIME_KEY), payScheduleGroupByDates);
                        model.setValue(CHOOSE_DATE, (Object)currDate);
                        this.setWeekDayLabelValue(new Date());
                        break;
                    }
                    case "reset": {
                        model.setValue(PAY_ROLL_GRP, null);
                        model.setValue(PAYROLLSCENE, null);
                        model.setValue(CAL_PERIOD, null);
                        model.setValue("org", null);
                        model.setValue(SELECT_SCHEME, (Object)"all");
                        break;
                    }
                    case "openfilterap": {
                        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_CLOSEFILTERAP, KEY_FILTERCONTENT});
                        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_OPENFILTERAP});
                        break;
                    }
                    case "closefilterap": {
                        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_OPENFILTERAP});
                        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_CLOSEFILTERAP, KEY_FILTERCONTENT});
                        break;
                    }
                    case "closegroupfilter": {
                        this.clickCloseFilter(KEY_SELECTEDGROUPAP, PAY_ROLL_GRP);
                        break;
                    }
                    case "closeorgfilter": {
                        this.clickCloseFilter(KEY_SELECTEDORGAP, "org");
                        break;
                    }
                    case "closescenefilter": {
                        this.clickCloseFilter(KEY_SELECTEDSCENEAP, PAYROLLSCENE);
                        break;
                    }
                    case "closeperiodfilter": {
                        this.clickCloseFilter(KEY_SELECTEDPERIODAP, CAL_PERIOD);
                        break;
                    }
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (CALLBACKID_STATUSMARK.equals(actionId) && (returnData = e.getReturnData()) != null) {
            DynamicObject[] payScheduleDys = (DynamicObject[])returnData;
            Map<Long, String> changeSchMap = Arrays.stream(payScheduleDys).collect(Collectors.toMap(o -> o.getLong("id"), o -> o.getString("schedulestatus"), (v1, v2) -> v1));
            LOGGER.info("markStatusInfo{}", changeSchMap);
            String groupPaySchByDateMapJson = this.getPageCache().get(GROUP_PAY_SCH_BY_DATE_CHAHE_KEY);
            if (SWCStringUtils.isNotEmpty((String)groupPaySchByDateMapJson)) {
                Map payScheduleGroupByDates = (Map)JSON.parseObject((String)groupPaySchByDateMapJson, (TypeReference)new TypeReference<Map<String, List<PaySchedule>>>(){}, (Feature[])new Feature[0]);
                for (Map.Entry ListEntry : payScheduleGroupByDates.entrySet()) {
                    List paySchedules = (List)ListEntry.getValue();
                    for (PaySchedule paySchedule : paySchedules) {
                        String changeStatus = changeSchMap.get(paySchedule.getPkValue());
                        if (!SWCStringUtils.isNotEmpty((String)changeStatus)) continue;
                        paySchedule.setPayScheduleStatus(changeStatus);
                    }
                }
                this.getPageCache().put(GROUP_PAY_SCH_BY_DATE_CHAHE_KEY, JSON.toJSONString((Object)payScheduleGroupByDates));
                Date chooseDate = (Date)this.getModel().getValue(CHOOSE_DATE);
                this.setCalendar(chooseDate, payScheduleGroupByDates);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"PayScheduleList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
    }

    private void setWeekDayLabelValue(Date currChooseDay) {
        int weekDay = PayScheduleCalendarPlugin.getWeekDay(currChooseDay);
        Label weekday = (Label)this.getControl(KEY_WEEKDAY);
        weekday.setText(weekLangMap.get(weekDay).loadKDString());
    }

    private static boolean isWeekend(Date date) {
        return PayScheduleCalendarPlugin.getWeekDay(date) > 5;
    }

    private static int getWeekDay(Date date) {
        Calendar cal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        cal.setFirstDayOfWeek(2);
        cal.setTime(date);
        int week = cal.get(7) - 1;
        if (week == 0) {
            week = 7;
        }
        return week;
    }

    private void nextMonth(Date currDate, int type) {
        String prevRegionStr = this.getPageCache().get(KEY_PREVREGION);
        if (SWCStringUtils.isNotEmpty((String)prevRegionStr)) {
            int[] prevRegion = (int[])SerializationUtils.fromJsonString((String)prevRegionStr, int[].class);
            this.getModel().setValue(TIME_KEY, (Object)SWCDateTimeUtils.addMonth((Date)this.getDay(prevRegion[0], prevRegion[1]), (int)type, (boolean)true));
        } else {
            this.getModel().setValue(TIME_KEY, (Object)SWCDateTimeUtils.addMonth((Date)currDate, (int)type, (boolean)true));
        }
    }

    private void initCalendarTitle() {
        Label label0 = (Label)this.getControl("labelap0");
        Label label1 = (Label)this.getControl("labelap1");
        Label label2 = (Label)this.getControl("labelap2");
        Label label3 = (Label)this.getControl("labelap3");
        Label label4 = (Label)this.getControl("labelap4");
        Label label5 = (Label)this.getControl("labelap5");
        Label label6 = (Label)this.getControl("labelap6");
        if (SWCStringUtils.equals((String)RequestContext.get().getLang().getLocale().getLanguage(), (String)Locale.CHINESE.toString())) {
            label0.setText(ResManager.loadKDString((String)"\u5468\u4e00", (String)"PaySchedulePlatformPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            label1.setText(ResManager.loadKDString((String)"\u5468\u4e8c", (String)"PaySchedulePlatformPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            label2.setText(ResManager.loadKDString((String)"\u5468\u4e09", (String)"PaySchedulePlatformPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            label3.setText(ResManager.loadKDString((String)"\u5468\u56db", (String)"PaySchedulePlatformPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            label4.setText(ResManager.loadKDString((String)"\u5468\u4e94", (String)"PaySchedulePlatformPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            label5.setText(ResManager.loadKDString((String)"\u5468\u516d", (String)"PaySchedulePlatformPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            label6.setText(ResManager.loadKDString((String)"\u5468\u65e5", (String)"PaySchedulePlatformPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        } else {
            label0.setText(ResManager.loadKDString((String)"\u5468\u65e5", (String)"PaySchedulePlatformPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            label1.setText(ResManager.loadKDString((String)"\u5468\u4e00", (String)"PaySchedulePlatformPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            label2.setText(ResManager.loadKDString((String)"\u5468\u4e8c", (String)"PaySchedulePlatformPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            label3.setText(ResManager.loadKDString((String)"\u5468\u4e09", (String)"PaySchedulePlatformPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            label4.setText(ResManager.loadKDString((String)"\u5468\u56db", (String)"PaySchedulePlatformPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            label5.setText(ResManager.loadKDString((String)"\u5468\u4e94", (String)"PaySchedulePlatformPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            label6.setText(ResManager.loadKDString((String)"\u5468\u516d", (String)"PaySchedulePlatformPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
    }

    private void setCalendar(Date date, Map<String, List<PaySchedule>> groupPaySchByDate) {
        this.resetPrevBgColor();
        this.getPageCache().remove(KEY_PREVREGION);
        Calendar current = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        Calendar calendar = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        calendar.setTime(date);
        calendar.set(5, 1);
        int weekday = this.getWeekDay(calendar);
        int maxDay = calendar.getActualMaximum(5);
        calendar.add(5, 0 - weekday);
        Map<String, String> caldendarMap = this.getCalendarMap(calendar);
        int index = 0;
        for (int i = 1; i < 7; ++i) {
            for (int j = 1; j < 8; ++j) {
                calendar.add(5, 1);
                Html html = (Html)this.getControl("htmlap_" + i + '_' + j);
                StringBuilder sb = new StringBuilder();
                String currDateStr = SWCDateTimeUtils.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
                String currDayStr = String.valueOf(calendar.get(5));
                List<PaySchedule> paySchedules = groupPaySchByDate.get(currDateStr);
                String maxpPaySchStatus = null;
                if (paySchedules != null) {
                    for (PaySchedule paySchedule : paySchedules) {
                        String payScheduleStatus = paySchedule.getPayScheduleStatus();
                        if (maxpPaySchStatus != null && PayScheduleStatusEnum.getOrder(maxpPaySchStatus) >= PayScheduleStatusEnum.getOrder((String)payScheduleStatus)) continue;
                        maxpPaySchStatus = payScheduleStatus;
                    }
                }
                sb.append("<div  style=\"height: 100%;\">");
                sb.append(" <div style=\"height: 30%;\"></div>");
                sb.append("<div style=\"height: 40%;\">");
                sb.append("<div style=\"text-align:center;position: relative;top: 50%;left: 50%;transform: translate(-50%, -50%)\">");
                sb.append("<span style=\"width:26px;font-size:18px;height:26px;border-radius:50%;display:inline-block;line-height:26px;text-align:center;");
                if (index < weekday - 1 || index - weekday - maxDay + 2 > 0) {
                    sb.append("color:#B2B2B2;");
                } else if (caldendarMap != null && caldendarMap.get(currDateStr) != null && !SWCStringUtils.equals((String)KEY_WORKSTATUS_WORK, (String)caldendarMap.get(currDateStr))) {
                    sb.append("color:#F7231E;");
                } else {
                    sb.append("color:#212121;");
                }
                if (SWCDateTimeUtils.format((Date)current.getTime(), (String)"yyyy-MM-dd").equals(currDateStr)) {
                    sb.append("background:rgba(39,111,245,1);");
                    sb.append("color:#ffffff;");
                }
                sb.append("\">").append(currDayStr).append("</span>");
                sb.append("</div>");
                sb.append("</div>");
                sb.append(" <div style=\"height: 30%;text-align:center;\">");
                if (SWCStringUtils.isNotEmpty((String)maxpPaySchStatus)) {
                    sb.append("<span  style=\"width:6px;font-size:6px;height:6px;border-radius:50%;display:inline-block;line-height:20px;text-align:center;");
                    sb.append("background:");
                    sb.append(PayScheduleStatusEnum.getColor((String)maxpPaySchStatus));
                    sb.append(';');
                    sb.append("\"></span>");
                }
                sb.append("</div>");
                sb.append("</div>");
                html.setConent(sb.toString());
                ++index;
            }
        }
        this.fillEntryData(date);
        this.markItemChosen(date);
    }

    private Map<String, String> getCalendarMap(Calendar calendar) {
        HashMap<String, String> caldendarMap;
        QFilter cstFilter;
        List<Long> personIds;
        List result;
        Map resultMap;
        Date startDate = calendar.getTime();
        Date endDate = SWCDateTimeUtils.addDay((Date)startDate, (long)42L);
        Map personUserMap = (Map)SWCMServiceUtils.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonModelId", (Object[])new Object[0]);
        Long personId = 0L;
        Long workcalenderId = 0L;
        Boolean success = (Boolean)personUserMap.get("success");
        if (success != null && success.booleanValue() && (resultMap = (Map)personUserMap.get("data")).get("person") != null) {
            personId = (Long)resultMap.get("person");
        }
        if (personId != 0L && !SWCListUtils.isEmpty((List)(result = (List)SWCMServiceUtils.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listBatchEmployeeByPerson", (Object[])new Object[]{personIds = Collections.singletonList(RequestContext.get().getCurrUserId()), cstFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE), "hrpi_workcalenrel"})))) {
            workcalenderId = (Long)((Map)result.get(0)).get("workcalendar.id");
        }
        if (workcalenderId != 0L) {
            caldendarMap = WorkCalendarLoadService.getHrcsCalendarData((Long)workcalenderId, (Date)startDate, (Date)endDate);
        } else {
            caldendarMap = new HashMap<String, String>(16);
            Date date = startDate;
            while (SWCDateTimeUtils.dayBefore((Date)date, (Date)endDate) || SWCDateTimeUtils.dayEquals((Date)date, (Date)endDate)) {
                String workStatus = KEY_WORKSTATUS_WORK;
                if (PayScheduleCalendarPlugin.isWeekend(date)) {
                    workStatus = KEY_WORKSTATUS_HOLIDAY;
                }
                caldendarMap.put(SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd"), workStatus);
                date = SWCDateTimeUtils.addDay((Date)date, (long)1L);
            }
        }
        return caldendarMap;
    }

    private int getWeekDay(Calendar current) {
        Lang lang = RequestContext.get().getLang();
        if (SWCStringUtils.equals((String)lang.getLocale().toString(), (String)Locale.SIMPLIFIED_CHINESE.toString())) {
            boolean isFirstSunday = current.getFirstDayOfWeek() == 1;
            int weekDay = current.get(7);
            if (isFirstSunday && --weekDay == 0) {
                weekDay = 7;
            }
            return weekDay;
        }
        return current.get(7);
    }

    private void fillEntryData(Date day) {
        Map payScheduleGroupByDates;
        List paySchedules;
        this.getModel().deleteEntryData(ENTRY);
        String groupPaySchByDateMapJson = this.getPageCache().get(GROUP_PAY_SCH_BY_DATE_CHAHE_KEY);
        if (SWCStringUtils.isNotEmpty((String)groupPaySchByDateMapJson) && (paySchedules = (List)(payScheduleGroupByDates = (Map)JSON.parseObject((String)groupPaySchByDateMapJson, (TypeReference)new TypeReference<Map<String, List<PaySchedule>>>(){}, (Feature[])new Feature[0])).get(SWCDateTimeUtils.format((Date)day, (String)"yyyy-MM-dd"))) != null && paySchedules.size() > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("payschedule", new Object[0]);
            vs.addField(PAY_SCHEDULE_NAME, new Object[0]);
            vs.addField(PAY_SCHEDULE_STATUS, new Object[0]);
            vs.addField(PAY_SCHEDULE_STATUS_ENUM, new Object[0]);
            vs.addField(CAL_PERIOD_NAME, new Object[0]);
            vs.addField(ORG_NAME, new Object[0]);
            vs.addField(PAY_ROLLGRP_NAME, new Object[0]);
            vs.addField(PAYROLLSCENE_NAME, new Object[0]);
            vs.addField(START_DATE, new Object[0]);
            vs.addField(END_DATE, new Object[0]);
            for (PaySchedule paySchedule : paySchedules) {
                try {
                    vs.addRow(new Object[]{paySchedule.getPkValue(), paySchedule.getName(), PayScheduleStatusEnum.getDesc((String)paySchedule.getPayScheduleStatus()), paySchedule.getPayScheduleStatus(), paySchedule.getCalPeriodName(), paySchedule.getOrgName(), paySchedule.getPayrollGrpName(), paySchedule.getPayrollSceneName(), SWCDateTimeUtils.parseDate((String)paySchedule.getStartDate()), SWCDateTimeUtils.parseDate((String)paySchedule.getEndDate())});
                }
                catch (ParseException e) {
                    LOGGER.error("Date conversion exception");
                }
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(ENTRY, vs);
        }
    }

    private void markItemChosen(Date day) {
        int[] currRegion = this.getRegion(day);
        this.resetPrevBgColor();
        String currKey = "flex_" + currRegion[0] + "_" + currRegion[1];
        this.getPageCache().put(KEY_PREVREGION, SerializationUtils.toJsonString((Object)currRegion));
        this.updateBgColor(currKey, BG_BLUE);
    }

    private void resetPrevBgColor() {
        String prevRegionStr = this.getPageCache().get(KEY_PREVREGION);
        if (prevRegionStr == null) {
            return;
        }
        int[] prevRegion = (int[])SerializationUtils.fromJsonString((String)prevRegionStr, int[].class);
        String prevKey = "flex_" + prevRegion[0] + "_" + prevRegion[1];
        this.updateBgColor(prevKey, null);
    }

    private void updateBgColor(String key, String color) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bc", color);
        this.getView().updateControlMetadata(key, map);
    }

    private Date getDay(int row, int col) {
        Calendar calendar = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        calendar.setTime((Date)this.getModel().getValue(TIME_KEY));
        calendar.set(5, 1);
        int weekday = this.getWeekDay(calendar);
        calendar.add(5, 0 - weekday);
        calendar.add(5, (row - 1) * 7 + col);
        return calendar.getTime();
    }

    private int[] getRegion(Date day) {
        Date firstDay = this.getDay(1, 1);
        long diff = (day.getTime() - firstDay.getTime()) / 86400000L;
        int dayDiff = (int)diff;
        return new int[]{dayDiff / 7 + 1, dayDiff % 7 + 1};
    }

    private boolean isSameMonth(Date date) {
        Calendar currMonthCal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        currMonthCal.setTime(date);
        Calendar currDayCal = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        currDayCal.setTime((Date)this.getModel().getValue(TIME_KEY));
        int monthDiff = currMonthCal.get(1) * 100 + currMonthCal.get(2) - (currDayCal.get(1) * 100 + currDayCal.get(2));
        return monthDiff == 0;
    }

    private DynamicObject getCalPeriodType(DynamicObject payrollSceneDy) {
        return payrollSceneDy.getDynamicObject("periodtype");
    }

    private List<QFilter> buildCalPeriodTypeFilters() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        DynamicObject calPeriodType = this.getCalPeriodType((DynamicObject)this.getModel().getValue(PAYROLLSCENE));
        if (calPeriodType != null) {
            QFilter qFilter = new QFilter("periodtypeid", "=", calPeriodType.getPkValue());
            qFilters.add(qFilter);
            this.getView().getPageCache().put("periodtypename", calPeriodType.getString("name"));
        }
        return qFilters;
    }

    private Map<String, List<PaySchedule>> getGroupPaySchByDate() {
        String groupPaySchByDateMapJson = this.getView().getPageCache().get(GROUP_PAY_SCH_BY_DATE_CHAHE_KEY);
        Map payScheduleGroupByDates = SWCStringUtils.isNotEmpty((String)groupPaySchByDateMapJson) ? (Map)JSON.parseObject((String)groupPaySchByDateMapJson, (TypeReference)new TypeReference<Map<String, List<PaySchedule>>>(){}, (Feature[])new Feature[0]) : this.queryPaySchedule();
        return payScheduleGroupByDates;
    }

    private Map<String, List<PaySchedule>> queryPaySchedule() {
        Map<String, List<DynamicObject>> groupPaySchByDateMap = this.getGroupPaySchByDateFormDataBase();
        return this.putPageCache(groupPaySchByDateMap);
    }

    private Map<String, List<DynamicObject>> getGroupPaySchByDateFormDataBase() {
        DynamicObject payRollGrp = (DynamicObject)this.getModel().getValue(PAY_ROLL_GRP);
        DynamicObject payrollScene = (DynamicObject)this.getModel().getValue(PAYROLLSCENE);
        DynamicObjectCollection calPeriods = (DynamicObjectCollection)this.getModel().getValue(CAL_PERIOD);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long payRollGroupId = null;
        Long payrollSceneId = null;
        List calPeriodIds = null;
        String selectScheme = (String)this.getModel().getValue(SELECT_SCHEME);
        List<Long> orgIds = new ArrayList<Long>(16);
        if (org != null) {
            orgIds.add((Long)org.getPkValue());
        } else {
            List hasPermOrgIds = SWCPermissionServiceHelper.getUserHasPermOrgs((Long)RequestContext.get().getCurrUserId());
            orgIds = hasPermOrgIds != null ? hasPermOrgIds : null;
        }
        if (payRollGrp != null) {
            payRollGroupId = (Long)payRollGrp.getPkValue();
        }
        if (payrollScene != null) {
            payrollSceneId = (Long)payrollScene.getPkValue();
        }
        if (calPeriods != null && calPeriods.size() > 0) {
            calPeriodIds = calPeriods.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
        }
        return PaySchTplHelper.groupPaySchByDate(orgIds, (Long)payRollGroupId, (Long)payrollSceneId, calPeriodIds, (String)selectScheme, (Long)RequestContext.get().getCurrUserId());
    }

    private Map<String, List<PaySchedule>> putPageCache(Map<String, List<DynamicObject>> groupPaySchByDateMap) {
        HashMap<String, List<PaySchedule>> payScheduleGroupByDates = new HashMap<String, List<PaySchedule>>(groupPaySchByDateMap.size());
        for (Map.Entry<String, List<DynamicObject>> entry : groupPaySchByDateMap.entrySet()) {
            List<DynamicObject> list = entry.getValue();
            ArrayList<PaySchedule> paySchedules = new ArrayList<PaySchedule>(list.size());
            for (DynamicObject paySchedule : list) {
                PaySchedule payScheduleTemp = new PaySchedule();
                payScheduleTemp.setPkValue((Long)paySchedule.getPkValue());
                payScheduleTemp.setName(paySchedule.getString("name"));
                payScheduleTemp.setPayScheduleStatus(paySchedule.getString("schedulestatus"));
                payScheduleTemp.setStartDate(SWCDateTimeUtils.format((Date)paySchedule.getDate(START_DATE), (String)"yyyy-MM-dd"));
                payScheduleTemp.setEndDate(SWCDateTimeUtils.format((Date)paySchedule.getDate(END_DATE), (String)"yyyy-MM-dd"));
                payScheduleTemp.setOrgId(Long.valueOf(paySchedule.getLong("org.id")));
                payScheduleTemp.setOrgName(paySchedule.getString("org.name"));
                payScheduleTemp.setPayrollGrpId(Long.valueOf(paySchedule.getLong("payrollgrp.id")));
                payScheduleTemp.setPayrollGrpName(paySchedule.getString("payrollgrp.name"));
                payScheduleTemp.setPayrollSceneId(Long.valueOf(paySchedule.getLong("payrollscene.id")));
                payScheduleTemp.setPayrollSceneName(paySchedule.getString("payrollscene.name"));
                payScheduleTemp.setCalPeriodId(Long.valueOf(paySchedule.getLong("calperiod.id")));
                payScheduleTemp.setCalPeriodName(paySchedule.getString("calperiod.name"));
                paySchedules.add(payScheduleTemp);
            }
            payScheduleGroupByDates.put(entry.getKey(), paySchedules);
        }
        this.getView().getPageCache().put(GROUP_PAY_SCH_BY_DATE_CHAHE_KEY, JSON.toJSONString(payScheduleGroupByDates));
        return payScheduleGroupByDates;
    }

    private void setFilterContent(String ap, String label, String value) {
        if (SWCStringUtils.isNotEmpty((String)value)) {
            Label labelcontorl = (Label)this.getControl(label);
            labelcontorl.setText(value);
            this.getView().setVisible(Boolean.TRUE, new String[]{ap});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{ap});
        }
    }

    private void clickCloseFilter(String ap, String filed) {
        this.getView().setVisible(Boolean.FALSE, new String[]{ap});
        this.getModel().setValue(filed, null);
    }

    private void showStatusMark(String payScheduleId) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("hsas_payschedulestatmark");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setShowTitle(true);
        para.setCustomParam("payScheduleId", (Object)payScheduleId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACKID_STATUSMARK);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }
}

