/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.payschedule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.swc.hsas.business.payschedule.PayScheduleHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class PayScheduleEdit
extends SWCDataBaseEdit {
    private static final String KEY_LABELCONFIG = "labelconfig";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_LABELCONFIG});
    }

    public void beforeBindData(EventObject e) {
        long currUserId = RequestContext.get().getCurrUserId();
        long orgId = RequestContext.get().getOrgId();
        String appId = this.getView().getFormShowParameter().getAppId();
        if (!SWCPermissionServiceHelper.hasPermission((Long)currUserId, (Long)orgId, (String)appId, (String)"hsas_payschedule", (String)"4715a0df000000ac")) {
            this.getModel().setValue("status", (Object)"C");
            this.getModel().setDataChanged(false);
        }
        this.refreshLabelConfig();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "tracker": {
                PayScheduleHelper.setEntryByTrackersChanged((IFormView)this.getView(), (boolean)false, (String)"entryentity");
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "labelconfig": {
                DynamicObjectCollection dyColl = this.getModel().getDataEntity().getDynamicObjectCollection("tracker");
                String status = this.getModel().getDataEntity().getString("status");
                if (dyColl.isEmpty() && "A".equals(status)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u9700\u8981\u901a\u77e5\u7684\u201c\u534f\u4f5c\u4eba\u201d\u3002", (String)"PayScheduleEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
                ArrayList<Long> trackerIds = new ArrayList<Long>(dyColl.size());
                for (DynamicObject dyObj : dyColl) {
                    trackerIds.add(dyObj.getLong("fbasedataid.id"));
                }
                PayScheduleHelper.showMsgCfg((DynamicObjectCollection)entryentity, trackerIds, (String)status, (IFormView)this.getView(), (String)this.getPluginName());
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        switch (actionId = event.getActionId()) {
            case "action_msgcfg": {
                Object returnData = event.getReturnData();
                if (!(returnData instanceof Map)) break;
                this.packageEntryData((Map)returnData);
                break;
            }
        }
    }

    private void packageEntryData(Map<String, Object> returnData) {
        Object entryData = returnData.get("entry_data");
        if (entryData instanceof DynamicObjectCollection) {
            this.getModel().deleteEntryData("entryentity");
            int index = 0;
            for (DynamicObject dyObj : (DynamicObjectCollection)entryData) {
                this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("isenable", dyObj.get("isenable"), index);
                this.getModel().setValue("receiver", dyObj.get("receiver"), index);
                this.getModel().setValue("msgtpl", dyObj.get("msgtpl.id"), index);
                this.getModel().setValue("msgpushstep", dyObj.get("msgpushstep"), index);
                this.getModel().setValue("msgpushnum", dyObj.get("msgpushnum"), index);
                this.getModel().setValue("msgpushdaytype", dyObj.get("msgpushdaytype"), index);
                this.getModel().setValue("msgpushtime", dyObj.get("msgpushtime"), index);
                ++index;
            }
        }
    }

    protected void refreshLabelConfig() {
        Label notifyConfig = (Label)this.getControl(KEY_LABELCONFIG);
        if ("A".equals(this.getModel().getValue("status"))) {
            notifyConfig.setText(ResManager.loadKDString((String)"\u914d\u7f6e", (String)"PayScheduleEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[]{3000}));
        } else {
            notifyConfig.setText(ResManager.loadKDString((String)"\u67e5\u770b", (String)"PayScheduleEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[]{3000}));
        }
    }
}

