/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.payschedule;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.AbstractFormView;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.payschedule.PaySchTplHelper;
import kd.swc.hsas.business.payschedule.PayScheduleHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class PayScheduleTplEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String ACTION_CHANGE_PAYBIZPROC = "action_change_paybizproc";
    private static final String ACTION_CONTINUE_CLOSE = "continue_close";
    private static final String ACTION_PREVIEW_CONFIRM = "action_preview_confirm";
    private static final String AFTER_CONFIRM_PARAM = "after_confirm_param";
    private static final String AFTER_PREVIEW_CONFIRM_PARAM = "after_preview_confirm_param";
    private static final String IS_MSGINFO_CHG = "is_msginfo_chg";
    private static final String KEY_MSGCFGOP = "msgcfgop";
    private static final BigDecimal FREQUENCY_HALF_MONTH = new BigDecimal("24");
    private static final BigDecimal FREQUENCY_MONTH = new BigDecimal("12");
    private static final String DELETE_ENTRY_ROW_ID = "delete_entry_row_id";
    private static final String[] KEY_ENTRY_FIELD_COLL = new String[]{"actdaynum", "actdaytype", "paybizaction", "tracker", "paybizactiondesc"};
    private static final String[] KEY_ENTRY_FIELD_COLL_FIRST = new String[]{"actdaynum", "actdaytype", "paybizaction", "tracker", "paybizactiondesc", "prepaybizaction"};
    private static final String PAYBIZACTIONPOINT_ID = "paybizactionpoint.id";
    private static final String PAYBIZACTION_ID = "paybizaction.id";
    private static final String TAG_DEL = "tag_del";
    private static final String PAYTASK_SORT = "paytask_sort";
    private static final String CACHE_SELECTED_PAYTASK = "cache_selected_paytask";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setEntryFieldName();
        long payBizActId = this.getModel().getDataEntity().getLong(PAYBIZACTIONPOINT_ID);
        FieldEdit control = (FieldEdit)this.getView().getControl("actdateboundary");
        if (payBizActId == 1139088596750377984L || payBizActId == 1139088905400819712L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"actdateboundary"});
            control.setMustInput(false);
        } else {
            control.setMustInput(true);
        }
        boolean showOperateIcon = this.isSaveStatus();
        this.hasOperateIcon(showOperateIcon);
    }

    private void hasOperateIcon(boolean showOperateIcon) {
        HashMap param = Maps.newHashMapWithExpectedSize((int)1);
        param.put("hasOperateIcon", showOperateIcon);
        this.getView().updateControlMetadata("entryentity", (Map)param);
    }

    public void afterBindData(EventObject e) {
        if (null == this.getModel().getValue("payrollgrp")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"payrollgrpv"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"payrollgrpv"});
        }
        if (null == this.getModel().getValue("payrollgrpv")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"payrollscene", "workplan"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"payrollscene", "workplan"});
        }
        this.setPayrollPanelShow();
        if (this.getModel().getEntryRowCount("entryentity") > 0) {
            this.setEntryRowsDisable();
            this.getView().updateView("entryentity");
        }
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("iscopy")) {
            this.getModel().setDataChanged(false);
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit payrollGrp = (BasedataEdit)this.getView().getControl("payrollgrp");
        payrollGrp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payrollGrpV = (BasedataEdit)this.getView().getControl("payrollgrpv");
        payrollGrpV.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payrollScene = (BasedataEdit)this.getControl("payrollscene");
        payrollScene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payTask = (BasedataEdit)this.getControl("paybizactionpoint");
        payTask.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payBiz = (BasedataEdit)this.getControl("paybizaction");
        payBiz.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit edit = (BasedataEdit)this.getView().getControl("prepaybizaction");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit workPlan = (BasedataEdit)this.getControl("workplan");
        workPlan.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSets = e.getChangeSet();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        switch (name) {
            case "paybizproc": {
                this.changePayBizProc(changeSets);
                break;
            }
            case "payrollgrp": {
                PayScheduleHelper.changePayRollGrp((ChangeData[])changeSets, (IFormView)this.getView(), (IDataModel)this.getModel());
                break;
            }
            case "payrollgrpv": {
                this.changePayrollGrpv(changeSets);
                break;
            }
            case "payrollscene": {
                this.changePayrollScene(changeSets);
                break;
            }
            case "country": {
                this.changeCountry(changeSets);
                break;
            }
            case "actdatetype": {
                DynamicObject calFrequencyDy;
                if ("1".equals(changeSets[0].getNewValue()) && this.checkPeriod(calFrequencyDy = this.getModel().getDataEntity().getDynamicObject("calfrequency"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u5386\u89c4\u5219\u4ec5\u9002\u7528\u4e8e\u9891\u5ea6\u4e3a\u201c\u6708\u201d\u7684\u671f\u95f4\u7c7b\u578b\u3002", (String)"PayScheduleTplEdit_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("actdatetype", (Object)"0");
                    return;
                }
                this.setPayrollPanelShow();
                break;
            }
            case "paybizactionpoint": {
                long payBizActionId = dataEntity.getLong(PAYBIZACTIONPOINT_ID);
                FieldEdit control = (FieldEdit)this.getView().getControl("actdateboundary");
                if (1139088905400819712L == payBizActionId || 1139088596750377984L == payBizActionId) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"actdateboundary"});
                    control.setMustInput(false);
                    break;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"actdateboundary"});
                control.setMustInput(true);
                break;
            }
            case "tracker": {
                PayScheduleHelper.setEntryByTrackersChanged((IFormView)this.getView(), (boolean)true, (String)"subentryentity");
                break;
            }
            case "isworkday": {
                boolean isWorkDay = (Boolean)this.getModel().getValue("isworkday");
                FieldEdit selWorkDayEdit = (FieldEdit)this.getView().getControl("selworkday");
                selWorkDayEdit.setMustInput(isWorkDay);
                break;
            }
            case "everymonthday": {
                int everyMonthDay = dataEntity.getInt("everymonthday");
                if (everyMonthDay < 29) break;
                this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5982\u679c\u8be5\u6708\u65e0%s\u53f7\uff0c\u5219\u53d6\u8be5\u6708\u6700\u540e\u4e00\u5929\u3002", (String)"PayScheduleTplEdit_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]), everyMonthDay));
                break;
            }
            case "paybizaction": {
                Object oldValue = changeSets[0].getOldValue();
                Object newValue = changeSets[0].getNewValue();
                DynamicObject payTaskDy = this.getModel().getDataEntity().getDynamicObject("paybizactionpoint");
                if (oldValue != null && payTaskDy != null && ((DynamicObject)oldValue).getPkValue().equals(payTaskDy.getPkValue())) {
                    this.getModel().setValue("paybizactionpoint", null);
                }
                if (oldValue != null) {
                    this.deleteEntryAdjustPreActs(String.valueOf(((DynamicObject)oldValue).getPkValue()));
                    this.setEntryRowsDisable();
                    this.getView().updateView("entryentity");
                }
                if (newValue == null || !Objects.isNull(this.getPageCache().get(CACHE_SELECTED_PAYTASK))) break;
                ListSelectedRowCollection rows = new ListSelectedRowCollection();
                rows.add((Object)new ListSelectedRow(((DynamicObject)newValue).getPkValue()));
                this.checkContinuity(rows, changeSets[0].getRowIndex());
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        Object source = hyperLinkClickEvent.getSource();
        if (source instanceof EntryGrid && KEY_MSGCFGOP.equals(hyperLinkClickEvent.getFieldName())) {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            List<Long> currentryRowTrackerIds = this.getCurrentryRowTrackerIds();
            if (currentryRowTrackerIds.isEmpty() && this.isSaveStatus()) {
                this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u534f\u4f5c\u4eba\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u65e5\u7a0b\u5217\u8868\u7b2c%s\u884c\u534f\u4f5c\u4eba", (String)"PayScheduleTplEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), rowIndex + 1));
                return;
            }
            DynamicObjectCollection subEntry = this.getModel().getEntryEntity("subentryentity");
            String status = this.isSaveStatus() ? "A" : "C";
            PayScheduleHelper.showMsgCfg((DynamicObjectCollection)subEntry, currentryRowTrackerIds, (String)status, (IFormView)this.getView(), (String)this.getPluginName());
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        this.initEntryNode();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        this.getModel().setValue("paybizactionpoint", ((DynamicObject)entryEntity.get(entryEntity.size() - 1)).get(PAYBIZACTION_ID));
    }

    private void initEntryNode() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List payBizIds = entryEntity.stream().map(dy -> dy.getString(PAYBIZACTION_ID)).collect(Collectors.toList());
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (i != 0 && i != entryEntity.size() - 1) continue;
            DynamicObject entity = (DynamicObject)entryEntity.get(i);
            entity.set("actdaynum", (Object)0);
            entity.set(KEY_MSGCFGOP, (Object)"");
            entity.set("actdaytype", (Object)"-");
            DynamicObjectCollection coll = entity.getDynamicObjectCollection("prepaybizaction");
            if (coll.isEmpty()) continue;
            ArrayList attIds = Lists.newArrayList();
            for (DynamicObject obj : coll) {
                if (!payBizIds.contains(obj.getString("fbasedataid_id"))) continue;
                attIds.add(obj.getLong("fbasedataid_id"));
            }
            this.getModel().setValue("prepaybizaction", (Object)attIds.toArray(), i);
        }
        this.setEntryRowsDisable();
        this.getView().updateView("entryentity");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": 
            case "submit": {
                if (!this.checkDayNumInput(args)) break;
                this.beforeSaveAndSubmit(args);
                break;
            }
            case "newentry": {
                this.insertEmptyPayTaskEntry();
                args.setCancel(true);
                break;
            }
            case "sortbyauto": 
            case "viewflowchart": {
                this.setEntryRowsDisable();
                break;
            }
            case "deleteentry": {
                DynamicObjectCollection dyColl = this.getModel().getEntryEntity("entryentity");
                DynamicObject dy = (DynamicObject)dyColl.get(this.getModel().getEntryCurrentRowIndex("entryentity"));
                String stepType = dy.getString("paybizaction.steptype");
                if ("0".equals(stepType)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u64cd\u4f5c\u7c7b\u7684\u65e5\u7a0b\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PayScheduleTplEdit_31", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                formOperate.getOption().setVariableValue(DELETE_ENTRY_ROW_ID, dy.getString(PAYBIZACTION_ID));
                break;
            }
            case "donothing_preview": {
                this.beforePreview(args);
                break;
            }
        }
    }

    private boolean checkDayNumInput(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        ArrayList errors = Lists.newArrayListWithCapacity((int)0);
        for (int i = 1; i < entryEntity.size() - 1; ++i) {
            if (((DynamicObject)entryEntity.get(i)).getInt("actdaynum") != 0) continue;
            errors.add(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u8bf7\u586b\u5199\u201c\u7b97\u53d1\u85aa\u4f5c\u4e1a\u6d41\u7a0b\u201d\u7b2c{1}\u884c:\u201c\u5929\u6570\u201d\u3002", (String)"PayScheduleTplEdit_33", (String)"swc-hsas-formplugin", (Object[])new Object[0]), this.getModel().getValue("number"), i + 1));
        }
        if (errors.isEmpty()) {
            return true;
        }
        String cancelMessage = args.getCancelMessage();
        if ("fail".equals(cancelMessage)) {
            return true;
        }
        args.setCancel(true);
        FormShowParameter form = SWCShowFormServiceHelper.getOperationResultParameter((String)"checkDayNumInput", (String)ResManager.loadKDString((String)"\u51711\u6761\u5355\u636e\uff0c\u4fdd\u5b58\u6210\u529f0\u6761\uff0c\u5931\u8d251\u6761\u3002", (String)"PayScheduleTplEdit_34", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (List)errors);
        this.getView().showForm(form);
        return false;
    }

    private void beforeSaveAndSubmit(BeforeDoOperationEventArgs args) {
        OperationResult operationResult = this.getView().invokeOperation("sortbyauto");
        if ("0".equals(operationResult.getMessage())) {
            args.setCancel(true);
            this.replaceShowTip();
            return;
        }
        this.checkBeforeSave(args);
    }

    private void beforePreview(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        if (formOperate.getOption().tryGetVariableValue(AFTER_CONFIRM_PARAM, new RefObject())) {
            return;
        }
        if (this.getModel().getDataChanged()) {
            args.setCancel(true);
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6709\u4fee\u6539\u4fe1\u606f\uff0c\u662f\u5426\u5148\u4fdd\u5b58\u518d\u9884\u89c8\uff1f", (String)"PayScheduleTplEdit_18", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener(ACTION_PREVIEW_CONFIRM, (IFormPlugin)this));
        }
    }

    private void replaceShowTip() {
        String tip = this.getShowErrMsg();
        this.getView().showErrorNotification(tip.replace(ResManager.loadKDString((String)"\u7b97\u53d1\u85aa\u6b65\u9aa4", (String)"PayScheduleTplEdit_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u65e5\u7a0b", (String)"PayScheduleTplEdit_17", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
    }

    private String getShowErrMsg() {
        ClientViewProxy clientProxy = (ClientViewProxy)((AbstractFormView)this.getView()).getClientProxy();
        List actionResult = clientProxy.getActionResult();
        return actionResult.stream().map(HashMap.class::cast).filter(objMap -> "ShowNotificationMsg".equals(objMap.get("a"))).findFirst().map(objMap -> objMap.get("p")).map(ArrayList.class::cast).map(list -> (HashMap)list.get(0)).map(map -> String.valueOf(map.get("content"))).orElse("");
    }

    private void deleteEntryAdjustPreActs(String payBizActId) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        block0: for (int m = 1; m < entryEntity.size(); ++m) {
            DynamicObject entryDy = (DynamicObject)entryEntity.get(m);
            DynamicObjectCollection prePayBizActDyColl = entryDy.getDynamicObjectCollection("prepaybizaction");
            if (prePayBizActDyColl.isEmpty()) continue;
            for (DynamicObject prePayBizActDy : prePayBizActDyColl) {
                if (prePayBizActDy.get("fbasedataid") != null && !SWCObjectUtils.equals((Object)prePayBizActDy.getString("fbasedataid_id"), (Object)payBizActId)) continue;
                this.copyMulBaseDataField(entryDy, "prepaybizaction", payBizActId);
                continue block0;
            }
        }
    }

    private void copyMulBaseDataField(DynamicObject newDyObj, String mulBaseDataField, String payBizActId) {
        DynamicObjectCollection newMulBasedataColl = new DynamicObjectCollection();
        DynamicObjectCollection mulBasedataColl = newDyObj.getDynamicObjectCollection(mulBaseDataField);
        for (DynamicObject mulBasedataDy : mulBasedataColl) {
            DynamicObject copyDynObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)mulBasedataDy, (boolean)false, (boolean)true);
            copyDynObj.getDataEntityState().setDirty(true);
            if (SWCObjectUtils.equals((Object)mulBasedataDy.getString("fbasedataid_id"), (Object)payBizActId)) continue;
            newMulBasedataColl.add((Object)copyDynObj);
        }
        newDyObj.set(mulBaseDataField, (Object)newMulBasedataColl);
    }

    private void insertEmptyPayTaskEntry() {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        this.getModel().insertEntryRow("entryentity", entryRowCount - 1);
        String msg = ResManager.loadKDString((String)"\u914d\u7f6e", (String)"PayScheduleTplEdit_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        this.getModel().setValue(KEY_MSGCFGOP, (Object)msg, entryRowCount - 1);
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String operateKey;
        super.afterDoOperation(event);
        FormOperate formOperate = (FormOperate)event.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "unsubmit": 
            case "unaudit": 
            case "save": 
            case "audit": 
            case "submit": {
                OperationResult operationResult;
                if ("save".equals(operateKey) && formOperate.getOption().tryGetVariableValue(AFTER_PREVIEW_CONFIRM_PARAM, new RefObject()) && event.getOperationResult().isSuccess()) {
                    this.invokePreView();
                }
                if (!(operationResult = event.getOperationResult()).isSuccess()) break;
                if ("submit".equals(operateKey)) {
                    this.hasOperateIcon(false);
                }
                if ("unsubmit".equals(operateKey)) {
                    this.hasOperateIcon(true);
                }
                if ("unaudit".equals(operateKey)) {
                    this.hasOperateIcon(true);
                }
                if ("save".equals(operateKey) && !SWCPermissionServiceHelper.hasPermission((Long)RequestContext.get().getCurrUserId(), (Long)RequestContext.get().getOrgId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"hsas_payscheduletpl", (String)"4715a0df000000ac")) {
                    this.getView().setStatus(OperationStatus.VIEW);
                    this.hasOperateIcon(false);
                }
                this.setEntryFieldName();
                this.getView().updateView("entryentity");
                this.setEntryRowsDisable();
                this.getPageCache().remove(IS_MSGINFO_CHG);
                break;
            }
            case "deleteentry": {
                String payBizActId = formOperate.getOption().getVariableValue(DELETE_ENTRY_ROW_ID);
                if (!SWCObjectUtils.isEmpty((Object)payBizActId)) {
                    if (payBizActId.equals(this.getModel().getDataEntity().getString(PAYBIZACTIONPOINT_ID))) {
                        this.getModel().setValue("paybizactionpoint", null);
                        this.getView().updateView("paybizactionpoint");
                    }
                    this.deleteEntryAdjustPreActs(payBizActId);
                }
                this.setEntryRowsDisable();
                this.getView().updateView("entryentity");
                break;
            }
            case "sortbyauto": 
            case "viewflowchart": {
                OperationResult operationResult = event.getOperationResult();
                if (!"0".equals(operationResult.getMessage())) break;
                this.replaceShowTip();
                break;
            }
            case "donothing_preview": {
                if (!event.getOperationResult().isSuccess()) break;
                PaySchTplHelper.showPage((AfterDoOperationEventArgs)event, (String)"hsas_payschtplnewpreview", (AbstractFormPlugin)this);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
        switch (fieldKey) {
            case "payrollgrp": {
                ListShowParameter formShowParameter = (ListShowParameter)parameter;
                QFilter qFilter = this.buildPayRollGrpFilter();
                formShowParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "payrollgrpv": {
                long payrollGrpId = this.getModel().getDataEntity().getLong("payrollgrp.id");
                QFilter qFilter = new QFilter("boid", "=", (Object)payrollGrpId);
                qFilter.and("datastatus", "in", (Object)new String[]{"0", "1"});
                ListShowParameter formShowParameter = (ListShowParameter)parameter;
                formShowParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "payrollscene": {
                PayScheduleHelper.clickPayrollSceneF7((BeforeF7SelectEvent)beforeF7SelectEvent, (IDataModel)this.getModel());
                break;
            }
            case "paybizactionpoint": {
                ListShowParameter formShowParameter = (ListShowParameter)parameter;
                formShowParameter.setMultiSelect(false);
                DynamicObjectCollection dyColl = this.getModel().getEntryEntity("entryentity");
                ArrayList<Long> payTaskIds = new ArrayList<Long>(dyColl.size());
                for (DynamicObject entry : dyColl) {
                    long payTaskId = entry.getLong(PAYBIZACTION_ID);
                    payTaskIds.add(payTaskId);
                }
                QFilter qFilter = new QFilter("id", "in", payTaskIds);
                formShowParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "paybizaction": {
                ListShowParameter formShowParameter = (ListShowParameter)parameter;
                QFilter qFilter = new QFilter("steptype", "=", (Object)"1");
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                List ids = entryEntity.stream().map(dy -> dy.get(PAYBIZACTION_ID)).filter(Objects::nonNull).collect(Collectors.toList());
                QFilter qFilterNotSelf = new QFilter("id", "not in", ids);
                formShowParameter.getListFilterParameter().setFilter(qFilter);
                formShowParameter.getListFilterParameter().setFilter(qFilterNotSelf);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PAYTASK_SORT));
                break;
            }
            case "workplan": {
                ListShowParameter formShowParameter = (ListShowParameter)parameter;
                DynamicObject countryDy = this.getModel().getDataEntity().getDynamicObject("country");
                if (countryDy == null) break;
                QFilter qFilter = new QFilter("countryid", "=", (Object)countryDy.getLong("id"));
                formShowParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int lastIndex = this.getModel().getEntryEntity("entryentity").size() - 1;
        if (!"entryentity".equals(e.getEntryProp().getName())) {
            return;
        }
        if (Arrays.stream(e.getRowIndexs()).anyMatch(index -> index == 0)) {
            e.setCancel(true);
            return;
        }
        boolean isLast = Arrays.stream(e.getRowIndexs()).anyMatch(index -> index == lastIndex);
        if (isLast && !"1".equals(this.getPageCache().get(TAG_DEL))) {
            e.setCancel(true);
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        ArrayList fixedIndex = Lists.newArrayListWithExpectedSize((int)1);
        for (int i = 0; i < entryEntity.size(); ++i) {
            String stepType = ((DynamicObject)entryEntity.get(i)).getString("paybizaction.steptype");
            if (!"0".equals(stepType)) continue;
            fixedIndex.add(i);
        }
        if (Arrays.stream(e.getRowIndexs()).anyMatch(fixedIndex::contains)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u64cd\u4f5c\u7c7b\u7684\u65e5\u7a0b\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PayScheduleTplEdit_31", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
        this.getPageCache().put(TAG_DEL, null);
        this.resetPreTask(e, entryEntity);
    }

    public void resetPreTask(BeforeDeleteRowEventArgs e, DynamicObjectCollection entryEntity) {
        int index = e.getRowIndexs()[0];
        String payBizActId = ((DynamicObject)entryEntity.get(index)).getString(PAYBIZACTION_ID);
        if (SWCObjectUtils.isEmpty((Object)payBizActId)) {
            return;
        }
        if (payBizActId.equals(this.getModel().getDataEntity().getString(PAYBIZACTIONPOINT_ID))) {
            this.getModel().setValue("paybizactionpoint", null);
        }
        block0: for (int i = 1; i < entryEntity.size(); ++i) {
            DynamicObjectCollection prePayBizActDyColl = ((DynamicObject)entryEntity.get(i)).getDynamicObjectCollection("prepaybizaction");
            DynamicObject entryDy = (DynamicObject)entryEntity.get(i);
            if (prePayBizActDyColl.isEmpty()) continue;
            for (DynamicObject prePayBizActDy : prePayBizActDyColl) {
                if (prePayBizActDy.get("fbasedataid") != null && !SWCObjectUtils.equals((Object)prePayBizActDy.getString("fbasedataid_id"), (Object)payBizActId)) continue;
                this.copyMulBaseDataField(entryDy, "prepaybizaction", payBizActId);
                continue block0;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (!"entryentity".equals(e.getEntryProp().getName())) {
            return;
        }
        if (e.getRowIndexs().length > 1) {
            return;
        }
        this.getView().updateView("entryentity");
        this.setEntryRowsDisable();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (!"entryentity".equals(e.getEntryProp().getName())) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.size() - 1 == e.getInsertRow()) {
            this.getPageCache().put(TAG_DEL, "1");
            this.getModel().deleteEntryRow("entryentity", e.getInsertRow());
            this.getModel().getEntryEntity("entryentity").remove(e.getInsertRow());
        } else {
            String msg = ResManager.loadKDString((String)"\u914d\u7f6e", (String)"PayScheduleTplEdit_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getModel().setValue(KEY_MSGCFGOP, (Object)msg, e.getInsertRow());
        }
        this.setEntryRowsDisable();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        switch (callBackId) {
            case "action_change_paybizproc": {
                if (MessageBoxResult.No.equals((Object)result)) {
                    String customVaule = event.getCustomVaule();
                    IDataModel model = this.getModel();
                    model.beginInit();
                    model.setValue("paybizproc", (Object)customVaule);
                    model.endInit();
                    this.getView().updateView("paybizproc");
                    break;
                }
                long payBizProcId = this.getModel().getDataEntity().getLong("paybizproc.id");
                this.setEntryByPayBizProc(payBizProcId);
                break;
            }
            case "continue_close": {
                if (event.getResult() != MessageBoxResult.Yes) break;
                this.getPageCache().remove(IS_MSGINFO_CHG);
                this.getView().invokeOperation("close");
                break;
            }
            case "action_preview_confirm": {
                if (MessageBoxResult.No.equals((Object)result)) {
                    this.invokePreView();
                    break;
                }
                OperateOption save = OperateOption.create();
                save.setVariableValue(AFTER_PREVIEW_CONFIRM_PARAM, "true");
                this.getView().invokeOperation("save", save);
                break;
            }
            case "paytask_sort": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    String customValue = event.getCustomVaule();
                    this.insertWithContinuity(Integer.valueOf(customValue));
                } else {
                    ListSelectedRowCollection coll = (ListSelectedRowCollection)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_SELECTED_PAYTASK), ListSelectedRowCollection.class);
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                    this.insertPayTaskNormal(coll, Integer.parseInt(event.getCustomVaule()), entryEntity);
                }
                this.getPageCache().put(CACHE_SELECTED_PAYTASK, null);
                this.setEntryRowsDisable();
                break;
            }
        }
    }

    private void insertWithContinuity(Integer entryCurrentRowIndex) {
        ListSelectedRowCollection coll = (ListSelectedRowCollection)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_SELECTED_PAYTASK), ListSelectedRowCollection.class);
        List<DynamicObject> payTaskDys = this.getPayTasks(coll);
        DynamicObjectCollection dyColl = this.getModel().getEntryEntity("entryentity");
        DynamicObjectType entryType = dyColl.getDynamicObjectType();
        DynamicObjectCollection dyCollNew = new DynamicObjectCollection();
        DynamicObject preDy = (DynamicObject)dyColl.get(entryCurrentRowIndex - 1);
        DynamicObject preTask = preDy.getDynamicObject("paybizaction");
        for (DynamicObject taskDy : payTaskDys) {
            DynamicObject entryObj = new DynamicObject(entryType);
            entryObj.set("paybizaction", (Object)taskDy);
            DynamicObjectCollection mulBaseDataVal = this.getMulBaseDataVal(preTask, preDy.getDynamicObjectCollection("prepaybizaction"));
            entryObj.set("prepaybizaction", (Object)mulBaseDataVal);
            preTask = taskDy;
            dyCollNew.add((Object)entryObj);
        }
        if (dyCollNew.size() == 1) {
            this.insertPayBizRow(dyCollNew, entryCurrentRowIndex);
        }
        DynamicObject nextDy = (DynamicObject)dyColl.get(entryCurrentRowIndex + 1);
        DynamicObjectCollection mulBaseDataVal = this.getMulBaseDataVal(preTask, preDy.getDynamicObjectCollection("prepaybizaction"));
        DynamicObjectCollection oldDyColl = nextDy.getDynamicObjectCollection("prepaybizaction");
        oldDyColl.removeIf(dy -> dy.getLong("fbasedataid.id") == preDy.getDynamicObject("paybizaction").getLong("id"));
        oldDyColl.addAll((Collection)mulBaseDataVal);
        this.getModel().setValue("prepaybizaction", (Object)oldDyColl, entryCurrentRowIndex + 1);
        if (dyCollNew.size() > 1) {
            this.insertPayBizRow(dyCollNew, entryCurrentRowIndex);
        }
        EntryGrid control = (EntryGrid)this.getControl("entryentity");
        control.selectRows(entryCurrentRowIndex.intValue(), true);
    }

    private void insertPayBizRow(DynamicObjectCollection dyCollNew, int entryCurrentRowIndex) {
        Collections.reverse(dyCollNew);
        EntryProp entryProp = (EntryProp)this.getModel().getProperty("entryentity");
        DynamicObject currentDy = dyCollNew.remove(0);
        this.getModel().setValue("paybizaction", currentDy.get("paybizaction"), entryCurrentRowIndex);
        this.getModel().setValue("prepaybizaction", currentDy.get("prepaybizaction"), entryCurrentRowIndex);
        if (!dyCollNew.isEmpty()) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            entryEntity.addAll(entryCurrentRowIndex, (Collection)dyCollNew);
            this.getModel().batchInsertEntryRow(entryProp, entryCurrentRowIndex, dyCollNew);
        }
    }

    private DynamicObjectCollection getMulBaseDataVal(DynamicObject preTask, DynamicObjectCollection dyColMul) {
        DynamicObjectCollection newMulBasedataColl = new DynamicObjectCollection();
        DynamicObjectType mulBasedataType = dyColMul.getDynamicObjectType();
        DynamicObject mulBasedataDy = new DynamicObject(mulBasedataType);
        mulBasedataDy.set("fbasedataid", (Object)preTask);
        newMulBasedataColl.add((Object)mulBasedataDy);
        return newMulBasedataColl;
    }

    private List<DynamicObject> getPayTasks(ListSelectedRowCollection selectedRows) {
        Object[] pkIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_paybizaction");
        Object[] query = helper.query("name,number,steptype", new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
        return Lists.newArrayList((Object[])query);
    }

    private void invokePreView() {
        OperateOption preview = OperateOption.create();
        preview.setVariableValue(AFTER_CONFIRM_PARAM, "true");
        this.getView().invokeOperation("donothing_preview", preview);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "action_msgcfg": {
                Object returnData = e.getReturnData();
                if (!(returnData instanceof Map)) break;
                this.packageSubEntryData((Map)returnData);
                break;
            }
            case "paytask_sort": {
                ListSelectedRowCollection coll = (ListSelectedRowCollection)e.getReturnData();
                if (CollectionUtils.isEmpty((Collection)coll)) {
                    return;
                }
                this.checkContinuity(coll, this.getModel().getEntryCurrentRowIndex("entryentity"));
                break;
            }
        }
    }

    private void checkContinuity(ListSelectedRowCollection coll, int rowIndex) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String payBizActId = ((DynamicObject)entryEntity.get(rowIndex - 1)).getString(PAYBIZACTION_ID);
        DynamicObjectCollection prePayBizActDyColl = ((DynamicObject)entryEntity.get(rowIndex + 1)).getDynamicObjectCollection("prepaybizaction");
        if (StringUtils.isEmpty((String)payBizActId) || CollectionUtils.isEmpty((Collection)prePayBizActDyColl)) {
            this.insertPayTaskNormal(coll, rowIndex, entryEntity);
            return;
        }
        boolean continuity = false;
        for (DynamicObject prePayBizActDy : prePayBizActDyColl) {
            if (!SWCObjectUtils.equals((Object)prePayBizActDy.getString("fbasedataid_id"), (Object)payBizActId)) continue;
            continuity = true;
            break;
        }
        if (continuity) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u5426", (String)"PayScheduleTplEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u662f", (String)"PayScheduleTplEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5c06\u4e0a\u4e00\u884c\u3001\u4e0b\u4e00\u884c\u4fe1\u606f\u81ea\u52a8\u6dfb\u52a0\u524d\u540e\u5e8f\u8282\u70b9?", (String)"PayScheduleTplEdit_19", (String)"swc-hsas-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(PAYTASK_SORT), btnNameMaps, String.valueOf(rowIndex));
            this.getPageCache().put(CACHE_SELECTED_PAYTASK, SerializationUtils.toJsonString((Object)coll));
        } else {
            this.insertPayTaskNormal(coll, rowIndex, entryEntity);
        }
    }

    private void insertPayTaskNormal(ListSelectedRowCollection coll, int rowIndex, DynamicObjectCollection entryEntity) {
        List<DynamicObject> payTaskDys = this.getPayTasks(coll);
        DynamicObjectCollection dyCollNew = new DynamicObjectCollection();
        for (DynamicObject dy : payTaskDys) {
            DynamicObject entryObj = new DynamicObject(entryEntity.getDynamicObjectType());
            entryObj.set("paybizaction", (Object)dy);
            dyCollNew.add((Object)entryObj);
        }
        this.insertPayBizRow(dyCollNew, rowIndex);
        this.setEntryRowsDisable();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (!this.getModel().getDataChanged() && "true".equals(this.getPageCache().get(IS_MSGINFO_CHG))) {
            e.setCancel(true);
            String info = ResManager.loadKDString((String)"\u5206\u5f55\u5185\u5bb9\u53d8\u52a8\uff1a\u6d88\u606f\u901a\u77e5", (String)"PayScheduleTplEdit_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.showChangeForm(this.getView(), (IFormPlugin)this, info);
        }
    }

    private void checkBeforeSave(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.size() == 2) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65e5\u7a0b\u5217\u8868\u4e0d\u80fd\u53ea\u5305\u542b\u5f00\u59cb\u8282\u70b9\u548c\u7ed3\u675f\u8282\u70b9\u3002", (String)"PayScheduleTplEdit_32", (String)"swc-hsas-formplugin", (Object[])new Object[0]), new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject calFrequencyDy = this.getModel().getDataEntity().getDynamicObject("calfrequency");
        if (this.checkPeriod(calFrequencyDy)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u5386\u89c4\u5219\u4ec5\u9002\u7528\u4e8e\u9891\u5ea6\u4e3a\u201c\u6708\u201d\u7684\u671f\u95f4\u7c7b\u578b\u3002", (String)"PayScheduleTplEdit_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payscheduletpl");
        long payRollGrpId = this.getModel().getDataEntity().getLong("payrollgrp.id");
        long payrollsceneId = this.getModel().getDataEntity().getLong("payrollscene.id");
        long calPeriodTypeId = this.getModel().getDataEntity().getLong("calperiodtype.id");
        QFilter qFilter = new QFilter("payrollgrp", "=", (Object)payRollGrpId);
        qFilter.and("payrollscene", "=", (Object)payrollsceneId);
        qFilter.and("calperiodtype", "=", (Object)calPeriodTypeId);
        DynamicObject[] paySchTplDys = helper.queryOriginalArray("id", qFilter.toArray());
        if (paySchTplDys != null && paySchTplDys.length > 0 && paySchTplDys[0].getLong("id") != this.getModel().getDataEntity().getLong("id")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u85aa\u8d44\u6838\u7b97\u7ec4\u3001\u85aa\u8d44\u6838\u7b97\u573a\u666f\u3001\u671f\u95f4\u7c7b\u578b\u5df2\u5b58\u5728\u65e5\u7a0b\u521b\u5efa\u6a21\u677f\u3002", (String)"PayScheduleTplEdit_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    private boolean checkPeriod(DynamicObject calFrequencyDy) {
        if (Objects.isNull(calFrequencyDy)) {
            return false;
        }
        String payTaskDateType = this.getModel().getDataEntity().getString("actdatetype");
        if ("1".equals(payTaskDateType)) {
            BigDecimal coefficient = calFrequencyDy.getBigDecimal("coefficient");
            return coefficient.compareTo(FREQUENCY_MONTH) != 0;
        }
        return false;
    }

    private void changePayrollGrpv(ChangeData[] changeSets) {
        if (changeSets != null && changeSets.length > 0) {
            this.getModel().setValue("payrollscene", null);
            this.getModel().setValue("calperiodtype", null);
            this.getModel().setValue("calfrequency", null);
            if (SWCObjectUtils.isEmpty((Object)changeSets[0].getNewValue())) {
                this.getModel().setValue("country", null);
                this.getView().setEnable(Boolean.FALSE, new String[]{"payrollscene"});
            } else {
                DynamicObject payrollGrpvDy = this.getModel().getDataEntity().getDynamicObject("payrollgrpv");
                if (payrollGrpvDy != null) {
                    this.getModel().setValue("country", (Object)payrollGrpvDy.getLong("country.id"));
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{"payrollscene"});
            }
        }
    }

    private void changePayrollScene(ChangeData[] changeSets) {
        if (changeSets == null || changeSets.length < 1) {
            return;
        }
        if (SWCObjectUtils.isEmpty((Object)changeSets[0].getNewValue())) {
            this.getModel().setValue("calperiodtype", null);
            this.getModel().setValue("calfrequency", null);
        } else {
            SWCDataServiceHelper helperFrequency;
            DynamicObject calFrequencyDy;
            long payrollSceneId = this.getModel().getDataEntity().getLong("payrollscene.id");
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollscene");
            QFilter qFilter = new QFilter("boid", "=", (Object)payrollSceneId);
            qFilter.and("datastatus", "=", (Object)"1");
            BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
            DynamicObject payrollScenevDy = helper.queryOne("id,periodtype.id,periodtype.calfrequency.id,periodtype.calfrequency", qFilter.toArray());
            if (payrollScenevDy == null) {
                this.getModel().setValue("calperiodtype", null);
                this.getModel().setValue("calfrequency", null);
                return;
            }
            long periodTypeId = payrollScenevDy.getLong("periodtype.id");
            long calFrequencyId = payrollScenevDy.getLong("periodtype.calfrequency.id");
            String actDateType = this.getModel().getDataEntity().getString("actdatetype");
            if ("1".equals(actDateType) && this.checkPeriod(calFrequencyDy = (helperFrequency = new SWCDataServiceHelper("hsbs_calfrequency")).queryOne((Object)calFrequencyId))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u5386\u89c4\u5219\u4ec5\u9002\u7528\u4e8e\u9891\u5ea6\u4e3a\u201c\u6708\u201d\u7684\u671f\u95f4\u7c7b\u578b\u3002", (String)"PayScheduleTplEdit_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("payrollscene", null);
                return;
            }
            this.getModel().setValue("calperiodtype", (Object)periodTypeId);
            this.getModel().setValue("calfrequency", (Object)calFrequencyId);
        }
    }

    private void changeCountry(ChangeData[] changeSets) {
        if (changeSets == null || changeSets.length < 1) {
            return;
        }
        this.getModel().setValue("workplan", null);
        if (SWCObjectUtils.isEmpty((Object)changeSets[0].getNewValue())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"workplan"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"workplan"});
        }
    }

    private QFilter buildPayRollGrpFilter() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        QFilter qFilter = new QFilter("org", "=", (Object)dataEntity.getLong("org.id"));
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        return qFilter;
    }

    private void changePayBizProc(ChangeData[] changeSets) {
        if (changeSets != null && changeSets.length > 0) {
            DynamicObject oldValue = (DynamicObject)changeSets[0].getOldValue();
            if (oldValue != null || this.getModel().getEntryEntity("entryentity").size() > 2) {
                this.modifyConfirm(oldValue == null ? "" : oldValue.getString("id"));
                return;
            }
            DynamicObject payBizProcDy = (DynamicObject)changeSets[0].getNewValue();
            long payBizProcId = 0L;
            if (payBizProcDy != null) {
                payBizProcId = payBizProcDy.getLong("id");
            }
            this.setEntryByPayBizProc(payBizProcId);
        }
    }

    private void setEntryByPayBizProc(long payBizProcId) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (0L == payBizProcId) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            ArrayList delIndex = Lists.newArrayListWithCapacity((int)1);
            for (int i = entryEntity.size() - 2; i > 0; --i) {
                delIndex.add(i);
            }
            this.getModel().beginInit();
            this.getModel().deleteEntryRows("entryentity", delIndex.stream().mapToInt(Integer::intValue).toArray());
            this.getModel().endInit();
            if (entryEntity.size() > 2) {
                entryEntity.subList(1, entryEntity.size() - 1).clear();
            }
            this.initEntryNode();
            if (1139088905400819712L != dataEntity.getLong(PAYBIZACTIONPOINT_ID)) {
                this.getModel().setValue("paybizactionpoint", null);
            }
            this.getView().updateView("entryentity");
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        if (1139088905400819712L != dataEntity.getLong(PAYBIZACTIONPOINT_ID)) {
            this.getModel().setValue("paybizactionpoint", null);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_paybizproc");
        QFilter qFilter = new QFilter("id", "=", (Object)payBizProcId);
        DynamicObject payBizProcDy = helper.queryOne("entryentity,paybizaction,paybizaction.id,paybizaction.name,paybizaction.number,paybizaction.steptype,prepaybizaction", qFilter.toArray());
        DynamicObjectCollection dyColl = payBizProcDy.getDynamicObjectCollection("entryentity");
        int size = dyColl.size() - 1;
        int entryIndex = 0;
        String msg = ResManager.loadKDString((String)"\u914d\u7f6e", (String)"PayScheduleTplEdit_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        for (DynamicObject dyObj : dyColl) {
            DynamicObject payTaskDy = dyObj.getDynamicObject("paybizaction");
            DynamicObjectCollection prePayBizActionDys = dyObj.getDynamicObjectCollection("prepaybizaction");
            this.insertEntry(payTaskDy, entryIndex, prePayBizActionDys, size, msg);
            ++entryIndex;
        }
        this.initEntryNode();
    }

    private void modifyConfirm(String oldPayBizProcId) {
        String msg = ResManager.loadKDString((String)"\u5207\u6362\u7b97\u53d1\u85aa\u4f5c\u4e1a\u6d41\u7a0b\u540e\uff0c\u5206\u5f55\u7684\u65e5\u7a0b\u4fe1\u606f\u5c06\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayScheduleTplEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ACTION_CHANGE_PAYBIZPROC, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u5426", (String)"PayScheduleTplEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u662f", (String)"PayScheduleTplEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        this.getView().showConfirm(msg, "", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks, btnNameMaps, oldPayBizProcId);
    }

    private void setEntryRowsDisable() {
        this.getView().setEnable(Boolean.FALSE, 0, KEY_ENTRY_FIELD_COLL_FIRST);
        this.getView().setEnable(Boolean.FALSE, this.getModel().getEntryRowCount("entryentity") - 1, KEY_ENTRY_FIELD_COLL);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dy = (DynamicObject)entryEntity.get(i);
            String stepType = dy.getString("paybizaction.steptype");
            if (i > 0 && i < entryEntity.size() - 1) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"actdaynum", "actdaytype", "tracker", "paybizactiondesc", "prepaybizaction"});
                this.getView().setEnable(Boolean.valueOf(!"0".equals(stepType)), i, new String[]{"paybizaction"});
                continue;
            }
            if (!"0".equals(stepType)) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"paybizaction"});
        }
    }

    private void insertEntry(DynamicObject payTask, int entryentityIndex, DynamicObjectCollection prepaybizactionDys, int entrySize, String msg) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        this.getModel().getDataEntity(true);
        model.beginInit();
        model.createNewEntryRow("entryentity");
        model.setValue("paybizaction", (Object)payTask, entryentityIndex);
        model.setValue("prepaybizaction", (Object)prepaybizactionDys, entryentityIndex);
        if (entryentityIndex != 0 && entryentityIndex != entrySize) {
            model.setValue(KEY_MSGCFGOP, (Object)msg, entryentityIndex);
        } else {
            model.setValue(KEY_MSGCFGOP, (Object)"", entryentityIndex);
            model.setValue("actdaynum", (Object)0, entryentityIndex);
        }
        model.endInit();
        this.getView().setEnable(Boolean.FALSE, entryentityIndex, new String[]{"paybizaction"});
        this.getView().updateView("entryentity");
    }

    private void setPayrollPanelShow() {
        if ("1".equals(this.getModel().getValue("actdatetype"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"workcalflexpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"payrollflexpanel"});
            this.getModel().setValue("oprationdays", (Object)0);
            this.setMustInputByActDateType(false);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"payrollflexpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"workcalflexpanel"});
            this.getModel().setValue("everymonthday", (Object)1);
            this.setMustInputByActDateType(true);
        }
    }

    private void setMustInputByActDateType(boolean isPeriod) {
        FieldEdit periodDateBoundaryEdit = (FieldEdit)this.getView().getControl("perioddateboundary");
        FieldEdit operationEdit = (FieldEdit)this.getView().getControl("operation");
        FieldEdit operationDaysEdit = (FieldEdit)this.getView().getControl("oprationdays");
        FieldEdit selperiodEdit = (FieldEdit)this.getView().getControl("selperiod");
        FieldEdit everyMonthDayEdit = (FieldEdit)this.getView().getControl("everymonthday");
        periodDateBoundaryEdit.setMustInput(isPeriod);
        operationEdit.setMustInput(isPeriod);
        operationDaysEdit.setMustInput(isPeriod);
        selperiodEdit.setMustInput(!isPeriod);
        everyMonthDayEdit.setMustInput(!isPeriod);
    }

    private void packageSubEntryData(Map<String, Object> returnData) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        this.getModel().deleteEntryData("subentryentity");
        model.setEntryCurrentRowIndex("entryentity", entryCurrentRowIndex);
        TableValueSetter subEntryEntity = this.setSubEntryEntity(returnData);
        model.batchCreateNewEntryRow("subentryentity", subEntryEntity);
        if (((Boolean)returnData.get("data_change")).booleanValue()) {
            this.getView().getPageCache().put(IS_MSGINFO_CHG, "true");
        }
    }

    private TableValueSetter setSubEntryEntity(Map<String, Object> returnData) {
        Object entryData = returnData.get("entry_data");
        TableValueSetter subEntryEntity = new TableValueSetter(new String[0]);
        if (entryData instanceof DynamicObjectCollection) {
            DynamicObjectCollection subEntryData = (DynamicObjectCollection)entryData;
            int index = 0;
            for (DynamicObject dyObj : subEntryData) {
                TableValueSetter row = subEntryEntity.addRow(new Object[0]);
                row.set("isenable", dyObj.get("isenable"), index);
                row.set("receiver", dyObj.get("receiver"), index);
                row.set("msgtpl", dyObj.get("msgtpl.id"), index);
                row.set("msgpushstep", dyObj.get("msgpushstep"), index);
                row.set("msgpushnum", dyObj.get("msgpushnum"), index);
                row.set("msgpushdaytype", dyObj.get("msgpushdaytype"), index);
                row.set("msgpushtime", dyObj.get("msgpushtime"), index);
                ++index;
            }
        }
        return subEntryEntity;
    }

    private List<Long> getCurrentryRowTrackerIds() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject entryRowDy = (DynamicObject)entryEntity.get(entryCurrentRowIndex);
        DynamicObjectCollection dyColl = entryRowDy.getDynamicObjectCollection("tracker");
        ArrayList<Long> trackerIds = new ArrayList<Long>(dyColl.size());
        for (DynamicObject dyObj : dyColl) {
            trackerIds.add(dyObj.getLong("fbasedataid.id"));
        }
        return trackerIds;
    }

    private boolean isSaveStatus() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        return "A".equals(this.getModel().getDataEntity().getString("status")) && (status == OperationStatus.EDIT && SWCPermissionServiceHelper.hasPermission((Long)RequestContext.get().getCurrUserId(), (Long)RequestContext.get().getOrgId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"hsas_payscheduletpl", (String)"4715a0df000000ac") || status == OperationStatus.ADDNEW && SWCPermissionServiceHelper.hasPermission((Long)RequestContext.get().getCurrUserId(), (Long)RequestContext.get().getOrgId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"hsas_payscheduletpl", (String)"47156aff000000ac"));
    }

    private void setEntryFieldName() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String operationName = this.isSaveStatus() ? ResManager.loadKDString((String)"\u914d\u7f6e", (String)"PayScheduleTplEdit_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u67e5\u770b", (String)"PayScheduleTplEdit_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        int i = 1;
        for (DynamicObject dynamicObject : entryEntity) {
            if (i == 1 || i == entryEntity.size()) {
                ++i;
                continue;
            }
            dynamicObject.set(KEY_MSGCFGOP, (Object)operationName);
            ++i;
        }
        this.getModel().setDataChanged(false);
    }

    private void showChangeForm(IFormView view, IFormPlugin plugin, String desc) {
        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(ACTION_CONTINUE_CLOSE, plugin);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"PayScheduleTplEdit_10", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"PayScheduleTplEdit_11", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String str1 = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f", (String)"PayScheduleTplEdit_12", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        String str2 = ResManager.loadKDString((String)"\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"PayScheduleTplEdit_13", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        String message = str1 + "\\r\\n" + str2;
        view.showConfirm(message, desc, options, ConfirmTypes.Save, confirmCallBack, btnNameMaps);
    }
}

