/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.payschedule;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class PayScheduleTplMsgCfgPlugin
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String KEY_BTNSAVE = "btnsave";
    private static final String ENTRY_DATA = "entry_data";
    private static final String DATA_CHANGE = "data_change";
    private static Log logger = LogFactory.getLog(PayScheduleTplMsgCfgPlugin.class);

    public void beforeBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object sendEntryData = formShowParameter.getCustomParam("subEntryEntity");
        Object trackerIds = formShowParameter.getCustomParam("trackerIds");
        if (trackerIds instanceof JSONArray && ((JSONArray)trackerIds).isEmpty()) {
            return;
        }
        if (sendEntryData instanceof JSONArray) {
            JSONArray subEntryEntity = (JSONArray)sendEntryData;
            this.initEntryData(subEntryEntity);
        }
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BTNSAVE});
        BasedataEdit receiver = (BasedataEdit)this.getView().getControl("receiver");
        receiver.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit msgTpl = (BasedataEdit)this.getView().getControl("msgtpl");
        msgTpl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey;
        switch (fieldKey = event.getProperty().getName()) {
            case "receiver": {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                Object trackerIds = formShowParameter.getCustomParam("trackerIds");
                if (trackerIds == null) break;
                ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
                QFilter qFilter = new QFilter("id", "in", trackerIds);
                param.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "msgtpl": {
                ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
                QFilter qFilter = new QFilter("msgentity", "=", (Object)"hsas_payschedule");
                param.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnsave": {
                HashMap returnData = Maps.newHashMapWithExpectedSize((int)16);
                DynamicObjectCollection dyColl = this.getModel().getEntryEntity("entryentity");
                returnData.put(ENTRY_DATA, dyColl);
                returnData.put(DATA_CHANGE, this.getModel().getDataChanged());
                this.getView().returnDataToParent((Object)returnData);
                this.getView().close();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (name) {
            case "msgpushnum": {
                BigDecimal newValue;
                if (changeSet == null || changeSet.length <= 0 || (newValue = (BigDecimal)changeSet[0].getNewValue()).compareTo(BigDecimal.ZERO) >= 0 && newValue.compareTo(new BigDecimal(30)) <= 0) break;
                this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u201c\u6d88\u606f\u914d\u7f6e\u201d\u7b2c{0}\u884c\uff0c\u5b57\u6bb5\u201c\u6570\u91cf\u201d\u7684\u503c{1}\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,30]\u3002", (String)"PayScheduleTplMsgCfgPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), changeSet[0].getRowIndex() + 1, newValue));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("moveentryup".equals(operateKey) || "moveentrydown".equals(operateKey)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            int seq = 1;
            for (DynamicObject dyObj : entryEntity) {
                dyObj.set("seq", (Object)seq++);
            }
        }
    }

    private void initEntryData(JSONArray subEntryEntity) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        for (int index = 0; index < subEntryEntity.size(); ++index) {
            JSONObject dyObj = subEntryEntity.getJSONObject(index);
            model.createNewEntryRow("entryentity");
            this.getModel().setValue("isenable", dyObj.get((Object)"isenable"), index);
            DynamicObject oldEntryRow = this.getOldEntryRow(dyObj);
            DynamicObject entryRow = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(index);
            this.copyMulBaseDataField(oldEntryRow, entryRow, "receiver");
            JSONObject msgTplJson = dyObj.getJSONObject("msgtpl");
            this.getModel().setValue("msgtpl", msgTplJson.get((Object)"id"), index);
            this.getModel().setValue("msgpushstep", dyObj.get((Object)"msgpushstep"), index);
            this.getModel().setValue("msgpushnum", dyObj.get((Object)"msgpushnum"), index);
            this.getModel().setValue("msgpushdaytype", dyObj.get((Object)"msgpushdaytype"), index);
            this.getModel().setValue("msgpushtime", dyObj.get((Object)"msgpushtime"), index);
        }
    }

    private DynamicObject getOldEntryRow(JSONObject dyObj) {
        JSONArray receivers = dyObj.getJSONArray("receiver");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payscheduletpl");
        DynamicObject paySchTplDy = helper.generateEmptyDynamicObject();
        BasedataEntityType dataEntityType = (BasedataEntityType)paySchTplDy.getDataEntityType();
        Map allEntities = dataEntityType.getAllEntities();
        EntityType entityType = (EntityType)allEntities.get("subentryentity");
        DynamicObject subDy = new DynamicObject((DynamicObjectType)entityType);
        DynamicObjectCollection dyColl = subDy.getDynamicObjectCollection("receiver");
        DynamicObjectType mulBasedataType = dyColl.getDynamicObjectType();
        for (int i = 0; i < receivers.size(); ++i) {
            JSONObject jsonObject = receivers.getJSONObject(i);
            JSONObject fBaseDataId = jsonObject.getJSONObject("fbasedataid");
            if (fBaseDataId == null) {
                logger.error("The SubEntryEntity's data receivers of PayScheduleTpl has lost !");
                continue;
            }
            DynamicObject mulBasedataDy = new DynamicObject(mulBasedataType);
            DynamicObject personDy = helper.generateEmptyDynamicObject("bos_user");
            personDy.set("masterid", fBaseDataId.get((Object)"masterid"));
            personDy.set("name", fBaseDataId.get((Object)"name"));
            personDy.set("number", fBaseDataId.get((Object)"number"));
            personDy.set("id", fBaseDataId.get((Object)"id"));
            mulBasedataDy.set("fbasedataid", (Object)personDy);
            dyColl.add((Object)mulBasedataDy);
        }
        return subDy;
    }

    private void copyMulBaseDataField(DynamicObject oldDyObj, DynamicObject newDyObj, String mulBaseDataField) {
        DynamicObjectCollection newMulBasedataColl = new DynamicObjectCollection();
        DynamicObjectCollection mulBasedataColl = oldDyObj.getDynamicObjectCollection(mulBaseDataField);
        for (DynamicObject mulBasedataDy : mulBasedataColl) {
            DynamicObject copyDynObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)mulBasedataDy, (boolean)false, (boolean)true);
            copyDynObj.getDataEntityState().setDirty(true);
            newMulBasedataColl.add((Object)copyDynObj);
        }
        newDyObj.set(mulBaseDataField, (Object)newMulBasedataColl);
    }
}

