/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.report;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Label;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.salaryrpt.SalaryRptService;
import kd.swc.hsas.formplugin.web.report.ISalaryReportSchemeHandler;
import kd.swc.hsas.formplugin.web.report.SalaryDetailReportSchemeHandler;
import kd.swc.hsas.formplugin.web.report.SalaryDiffReportSchemeHandler;
import kd.swc.hsas.formplugin.web.report.SalaryDptReportSchemeHandler;
import kd.swc.hsas.formplugin.web.report.SalaryReportSchemeBaseHandler;
import kd.swc.hsas.formplugin.web.report.SalarySummaryReportSchemeHandler;
import kd.swc.hsbp.business.report.RptShowNodeVo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.entity.RptDisplayColumnEntity;
import kd.swc.hsbp.formplugin.report.AbstractRptDisplayPlugin;

public class SalaryDisplaySchemeCommonPlugin
extends AbstractRptDisplayPlugin {
    private SalaryRptService salaryRptService;

    private SalaryRptService getSalaryRptService() {
        if (this.salaryRptService == null) {
            this.salaryRptService = new SalaryRptService(this.getReportFormId());
        }
        return this.salaryRptService;
    }

    private ISalaryReportSchemeHandler getHandler() {
        String reportFormId = this.getReportFormId();
        SalaryReportSchemeBaseHandler handler = null;
        switch (reportFormId) {
            case "hsas_monthdeptsalsumrpt": {
                handler = new SalaryDptReportSchemeHandler(this.getView(), this, this.getSalaryRptService());
                break;
            }
            case "hsas_salarydetailrpt": {
                handler = new SalaryDetailReportSchemeHandler(this.getView(), this, this.getSalaryRptService());
                break;
            }
            case "hsas_salarysumrpt": {
                handler = new SalarySummaryReportSchemeHandler(this.getView(), this, this.getSalaryRptService());
                break;
            }
            case "hsas_salarydiffrpt": {
                handler = new SalaryDiffReportSchemeHandler(this.getView(), this, this.getSalaryRptService());
                break;
            }
        }
        return handler;
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.getSalaryRptService().refreshField();
    }

    public void afterBindData(EventObject e) {
        String schmViewShrink;
        String reportFormId = this.getReportFormId();
        if ("hsas_monthdeptsalsumrpt".equals(reportFormId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"lblsort"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"sort"});
        }
        if (!"hsas_salarysumrpt".equals(reportFormId) && !"hsas_salarydiffrpt".equals(reportFormId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"isdimension"});
            Label o = (Label)this.getControl("label_columntree");
            o.hideTips();
        }
        if ((schmViewShrink = (String)this.getView().getFormShowParameter().getCustomParam("schmview_hide")) == null) {
            SplitContainer splitContainer = (SplitContainer)this.getView().getControl("splitcontainerap");
            splitContainer.hidePanel(SplitDirection.left, true);
        }
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection entryEntity = this.getView().getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntity) {
            RptShowNodeVo field = this.getSalaryRptService().getSelectFieldAtt(entry.getString("fieldvalue"));
            if (field == null) continue;
            entry.set("fieldname", (Object)field.getName());
        }
    }

    public void initialize() {
        DynamicObject shareSchemeObj;
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        Object pkId = showParameter.getPkId();
        if (pkId != null && (shareSchemeObj = SalaryDisplaySchemeCommonPlugin.queryRptDisplaySchemeObj(this.getModel().getDataEntityType().getName(), Long.parseLong(String.valueOf(pkId)))) != null) {
            Long sourceId = shareSchemeObj.getLong("sourceid");
            if (sourceId == 0L) {
                this.getView().getFormShowParameter().setCustomParam("reportformid", (Object)shareSchemeObj.getString("reportformid"));
            } else {
                DynamicObject sourceSchemeObj = SalaryDisplaySchemeCommonPlugin.queryRptDisplaySchemeObj(this.getModel().getDataEntityType().getName(), sourceId);
                if (sourceSchemeObj != null) {
                    this.getView().getFormShowParameter().setCustomParam("reportformid", (Object)sourceSchemeObj.getString("reportformid"));
                }
            }
        }
    }

    public static DynamicObject queryRptDisplaySchemeObj(String formId, Long pkId) {
        String selectProperties = SWCHisBaseDataHelper.getSelectProperties((String)formId);
        selectProperties = selectProperties + ", entryentity.seq";
        QFilter qFilter = new QFilter("id", "=", (Object)pkId);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(formId);
        return serviceHelper.queryOne(selectProperties, new QFilter[]{qFilter});
    }

    protected List<RptDisplayColumnEntity> getLeftTreeDataList() {
        ISalaryReportSchemeHandler handler = this.getHandler();
        if (handler == null) {
            return null;
        }
        return handler.getLeftTreeDataList();
    }

    protected boolean beforeDoSaveOperation() {
        ISalaryReportSchemeHandler handler = this.getHandler();
        if (handler == null) {
            return false;
        }
        return handler.beforeDoSaveOperation();
    }

    protected List<RptDisplayColumnEntity> getDefaultColumns() {
        ISalaryReportSchemeHandler handler = this.getHandler();
        if (handler == null) {
            return null;
        }
        return handler.getDefaultColumns();
    }

    protected Map<String, Object> getExtendFieldValue(RptDisplayColumnEntity rowData) {
        ISalaryReportSchemeHandler handler = this.getHandler();
        if (handler == null) {
            return null;
        }
        return handler.getExtendFieldValue(rowData);
    }

    protected void afterDeleteDisplaySchema(String schemaId) {
        ISalaryReportSchemeHandler handler = this.getHandler();
        if (handler != null) {
            handler.afterDeleteDisplaySchema(schemaId);
        }
    }

    protected boolean beforeAddColumns(List<RptDisplayColumnEntity> entities) {
        ISalaryReportSchemeHandler handler = this.getHandler();
        if (handler == null) {
            return false;
        }
        return handler.beforeAddColumns(entities);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (evt.getResult() == MessageBoxResult.Yes) {
            switch (callBackId) {
                case "CONFIRM_CALLBACK_SUMRPT_SAVE": {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("SAVE_AFTERCONFIRM", "1");
                    this.getView().invokeOperation("save", operateOption);
                    break;
                }
            }
        }
    }

    protected void afterClosedCallBack(ClosedCallBackEvent evt) {
        ISalaryReportSchemeHandler handler = this.getHandler();
        if (handler != null) {
            handler.afterClosedCallBack(evt);
        }
    }
}

