/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.report;

import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.swc.hsas.business.salaryrpt.SalaryRptService;
import kd.swc.hsas.formplugin.web.report.SalaryRptAbstractForm;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public abstract class SalarySchemeRptBaseForm
extends SalaryRptAbstractForm {
    private static Log LOGGER = LogFactory.getLog(SalarySchemeRptBaseForm.class);
    private static String yearMonStr = "yyyy-MM";

    @Override
    public void initialize() {
        IFormView parentView;
        super.initialize();
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String openWay = (String)showParam.getCustomParam("openway");
        if (openWay == null) {
            showParam.setCustomParam("openway", (Object)"1");
            this.getView().setVisible(Boolean.TRUE, new String[]{"reportfilterap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
        } else if (openWay.equals("2") && (parentView = this.getView().getParentView()) != null) {
            SWCPageCache pageCache = new SWCPageCache(parentView);
            pageCache.put("pageId", (Object)this.getView().getPageId());
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit periodType = (BasedataEdit)this.getControl("periodtype");
        periodType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit calPeriod = (BasedataEdit)this.getControl("calperiod");
        if (calPeriod != null) {
            calPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String openWay = (String)showParam.getCustomParam("openway");
        if (openWay.equals("2")) {
            this.getView().refresh();
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDateIsVisible((String)this.getModel().getValue("period"));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent args) {
        super.beforeF7Select(args);
        ListShowParameter formShowParameter = (ListShowParameter)args.getFormShowParameter();
        String permEntity = this.getRptTypeVo().getPermEntityNum();
        switch (args.getProperty().getName()) {
            case "periodtype": {
                HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)permEntity, (String)"47150e89000000ac");
                if (permOrgs == null || permOrgs.hasAllOrgPerm()) break;
                QFilter baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_calperiodtype", (List)permOrgs.getHasPermOrgs(), (boolean)true);
                formShowParameter.getListFilterParameter().setFilter(baseDataFilter);
                break;
            }
            case "calperiod": {
                this.filterPeriodF7(args);
                break;
            }
        }
    }

    protected void filterPeriodF7(BeforeF7SelectEvent args) {
        ListShowParameter formShowParameter = (ListShowParameter)args.getFormShowParameter();
        DynamicObject data = this.getModel().getDataEntity();
        QFilter calPeriodFilter = new QFilter("periodtypeid", "=", (Object)data.getLong("periodtype.id"));
        formShowParameter.getListFilterParameter().setFilter(calPeriodFilter);
        this.getView().getPageCache().put("periodtypename", data.getString("periodtype.name"));
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String openWay = (String)showParam.getCustomParam("openway");
        if (openWay.equals("1")) {
            return this.originalVerifyQuery(queryParam, showParam);
        }
        return this.citeVerifyQuery(queryParam, showParam);
    }

    @Override
    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String openWay = (String)showParameter.getCustomParam("openway");
        if (openWay.equals("1")) {
            this.originaBeforeQuery(queryParam);
        }
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        ReportColumn source = (ReportColumn)packageDataEvent.getSource();
        String fieldKey = source.getFieldKey();
        DynamicObject rowData = packageDataEvent.getRowData();
        if (fieldKey.equals("hsas_calpayrolltask.payrolldate")) {
            packageDataEvent.setFormatValue((Object)this.formatDateField(rowData, "hsas_calpayrolltask.payrolldate", yearMonStr));
        } else if (fieldKey.equals("hsas_salaryfile.startpaydate")) {
            packageDataEvent.setFormatValue((Object)this.formatDateField(rowData, "hsas_salaryfile.startpaydate", yearMonStr));
        }
    }

    public void preProcessExportData(List<AbstractReportColumn> exportColumns, DynamicObjectCollection data, NumberFormatProvider numberFormatProvider) {
        DynamicObjectType dynamicObjectType = data.getDynamicObjectType();
        DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
        HashSet fields = Sets.newHashSetWithExpectedSize((int)properties.size());
        properties.forEach(obj -> fields.add(obj.getName()));
        boolean containPayrollDate = fields.contains("hsas_calpayrolltask.payrolldate");
        boolean containStartPayDate = fields.contains("hsas_salaryfile.startpaydate");
        if (!containPayrollDate && !containStartPayDate) {
            return;
        }
        for (DynamicObject rowData : data) {
            if (containPayrollDate) {
                rowData.set("hsas_calpayrolltask.payrolldate", (Object)this.formatDateField(rowData, "hsas_calpayrolltask.payrolldate", yearMonStr));
            }
            if (!containStartPayDate) continue;
            rowData.set("hsas_salaryfile.startpaydate", (Object)this.formatDateField(rowData, "hsas_salaryfile.startpaydate", yearMonStr));
        }
    }

    private String formatDateField(DynamicObject rowData, String fieldCode, String formatStr) {
        String valueStr = rowData.getString(fieldCode);
        if (StringUtils.isEmpty((Object)valueStr)) {
            return valueStr;
        }
        String result = null;
        Date date = rowData.getDate(fieldCode);
        if (date != null) {
            result = SWCDateTimeUtils.format((Date)date, (String)formatStr);
        }
        return result;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object value = e.getChangeSet()[0].getNewValue();
        DynamicObject data = this.getModel().getDataEntity();
        switch (propertyName) {
            case "period": {
                this.setDateIsVisible((String)value);
                break;
            }
            case "belongstartdate": 
            case "belongenddate": {
                Date belongstartdate = data.getDate("belongstartdate");
                Date belongenddate = data.getDate("belongenddate");
                if (belongstartdate == null || belongenddate == null) break;
                this.compareDate(propertyName, belongstartdate, belongenddate);
                break;
            }
            case "startperiod": 
            case "endperiod": {
                Date startPeriod = data.getDate("startperiod");
                Date endPeriod = data.getDate("endperiod");
                if (startPeriod == null || endPeriod == null) break;
                startPeriod = this.getMonthFirstDay(startPeriod, 0);
                endPeriod = this.getMonthFirstDay(endPeriod, 0);
                this.compareDate(propertyName, startPeriod, endPeriod);
                break;
            }
            case "periodtype": {
                this.setValue("calperiod", null);
                break;
            }
        }
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        String[] formatFilterStr = evt.getFormatedFilterString().split(";");
        int len = formatFilterStr.length;
        FilterInfo filterInfo = evt.getFilter();
        String startPeroidStr = ResManager.loadKDString((String)"\u85aa\u8d44\u8d77\u59cb\u5e74\u6708", (String)"SalarySumFormRpt_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String endPeroidStr = ResManager.loadKDString((String)"\u85aa\u8d44\u622a\u6b62\u5e74\u6708", (String)"SalarySumFormRpt_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String calPeroidStr = ResManager.loadKDString((String)"\u671f\u95f4", (String)"SalarySumFormRpt_34", (String)"swc-hsas-formplugin", (Object[])new Object[0]).concat("\uff1a");
        StringBuilder formatStringBuilder = new StringBuilder();
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM");
        int calPeroidCount = 0;
        boolean isCount = false;
        for (int i = 0; i < len; ++i) {
            Date startPeroid;
            String filterStr = formatFilterStr[i];
            if (filterStr.contains(startPeroidStr)) {
                startPeroid = filterInfo.getDate("startperiod");
                filterStr = startPeroidStr + " : " + format.format(startPeroid);
            } else if (filterStr.contains(endPeroidStr)) {
                startPeroid = filterInfo.getDate("endperiod");
                filterStr = endPeroidStr + " : " + format.format(startPeroid);
            } else if (filterStr.contains(calPeroidStr)) {
                isCount = true;
            }
            if (isCount && ++calPeroidCount > 3) {
                formatStringBuilder = formatStringBuilder.delete(formatStringBuilder.lastIndexOf("; "), formatStringBuilder.length()).append(" ... ");
                break;
            }
            formatStringBuilder = formatStringBuilder.append(filterStr).append("; ");
        }
        evt.setFormatedFilterString(formatStringBuilder.toString());
    }

    protected void originaBeforeQuery(ReportQueryParam queryParam) {
        Map displaySetMap = SalaryRptService.getDisplaySetting((IFormView)this.getView(), (int)this.getSalaryRptTypeEnum().getCode());
        this.addTotalSet(queryParam, displaySetMap);
        this.addDisplaySet(queryParam, displaySetMap);
    }

    protected abstract boolean citeVerifyQuery(ReportQueryParam var1, FormShowParameter var2);

    protected void addDisplaySet(ReportQueryParam queryParam, Map<String, Object> displaySetMap) {
    }

    protected boolean originalVerifyQuery(ReportQueryParam queryParam, FormShowParameter showParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        boolean isSuccess = this.validOrg(filterInfo);
        if (!isSuccess) {
            return false;
        }
        isSuccess = this.validPeriod(filterInfo);
        if (!isSuccess) {
            return false;
        }
        isSuccess = this.validCalCurrency(filterInfo);
        if (!isSuccess) {
            return false;
        }
        isSuccess = this.validDisplayScheme(filterInfo);
        if (!isSuccess) {
            return false;
        }
        this.addFilterItem(filterInfo, showParam);
        return true;
    }

    protected void addFilterItem(FilterInfo filterInfo, FormShowParameter showParam) {
        filterInfo.addFilterItem("openway", showParam.getCustomParam("openway"));
        filterInfo.addFilterItem("isshowzero", (Object)Boolean.TRUE);
        filterInfo.addFilterItem("isshownull", (Object)Boolean.TRUE);
    }

    protected boolean validDisplayScheme(FilterInfo filterInfo) {
        DynamicObject schemeObj;
        DynamicObject rptDisplaySchemeObj;
        if (SWCStringUtils.isEmpty((String)filterInfo.getString("displayscheme"))) {
            this.getView().getModel().setValue("displayscheme", null);
            this.getView().updateView("displayscheme");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u663e\u793a\u65b9\u6848\u3002", (String)"SalarySumFormRpt_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!Objects.isNull(filterInfo.getDynamicObject("displayscheme")) && (rptDisplaySchemeObj = SalaryRptService.queryRptDisplaySchemeObj((Long)(schemeObj = filterInfo.getDynamicObject("displayscheme")).getLong("id"))) == null) {
            this.getView().getModel().setValue("displayscheme", null);
            this.getView().updateView("displayscheme");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u663e\u793a\u65b9\u6848\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65b0\u7684\u65b9\u6848\u3002", (String)"SalarySumFormRpt_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean validCalCurrency(FilterInfo filterInfo) {
        if (filterInfo.getLong("calcurrency") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u5e01\u79cd\u3002", (String)"SalarySumFormRpt_56", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean validPeriod(FilterInfo filterInfo) {
        String period = filterInfo.getString("period");
        if (SWCStringUtils.isEmpty((String)period)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u85aa\u8d44\u671f\u95f4\u3002", (String)"SalarySumFormRpt_35", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        switch (period) {
            case "A": {
                Date belongStartDate = filterInfo.getDate("belongstartdate");
                Date belongEndDate = filterInfo.getDate("belongenddate");
                if (belongStartDate == null || belongEndDate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u85aa\u8d44\u8d77\u59cb\u65e5\u671f\u548c\u85aa\u8d44\u622a\u6b62\u65e5\u671f\u5747\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SalarySumFormRpt_27", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (!belongEndDate.before(belongStartDate)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u85aa\u8d44\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u85aa\u8d44\u8d77\u59cb\u65e5\u671f\u3002", (String)"SalarySumFormRpt_28", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return false;
            }
            case "B": {
                Date starPeriod = filterInfo.getDate("startperiod");
                Date endPeriod = filterInfo.getDate("endperiod");
                if (starPeriod == null || endPeriod == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u85aa\u8d44\u8d77\u59cb\u5e74\u6708\u548c\u85aa\u8d44\u622a\u6b62\u5e74\u6708\u5747\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SalarySumFormRpt_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (!this.getMonthFirstDay(endPeriod, 0).before(this.getMonthFirstDay(starPeriod, 0))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u85aa\u8d44\u622a\u6b62\u5e74\u6708\u4e0d\u80fd\u65e9\u4e8e\u85aa\u8d44\u8d77\u59cb\u5e74\u6708\u3002", (String)"SalarySumFormRpt_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return false;
            }
            case "C": {
                String periodType = filterInfo.getString("periodtype");
                String calPeriod = filterInfo.getString("calperiod");
                if (!SWCStringUtils.isEmpty((String)periodType) && !SWCStringUtils.isEmpty((String)calPeriod)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u671f\u95f4\u7c7b\u578b\u201d\u548c\u201c\u671f\u95f4\u201d\u3002", (String)"SalarySumFormRpt_32", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    protected boolean validOrg(FilterInfo filterInfo) {
        if (SWCStringUtils.isEmpty((String)filterInfo.getString("org"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"SalarySumFormRpt_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean compareDate(String changedKey, Date startDate, Date endDate) {
        if (endDate.before(startDate)) {
            switch (changedKey) {
                case "belongstartdate": {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u85aa\u8d44\u8d77\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u85aa\u8d44\u622a\u6b62\u65e5\u671f\u3002", (String)"SalarySumFormRpt_29", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "belongenddate": {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u85aa\u8d44\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u85aa\u8d44\u8d77\u59cb\u65e5\u671f\u3002", (String)"SalarySumFormRpt_28", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "startperiod": {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u85aa\u8d44\u8d77\u59cb\u5e74\u6708\u4e0d\u80fd\u665a\u4e8e\u85aa\u8d44\u622a\u6b62\u5e74\u6708\u3002", (String)"SalarySumFormRpt_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "endperiod": {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u85aa\u8d44\u622a\u6b62\u5e74\u6708\u4e0d\u80fd\u65e9\u4e8e\u85aa\u8d44\u8d77\u59cb\u5e74\u6708\u3002", (String)"SalarySumFormRpt_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    break;
                }
            }
        }
        return true;
    }

    protected void setDateIsVisible(String value) {
        if (null == value) {
            this.resetControl(new String[0], new String[]{"belongstartdate", "belongenddate", "startperiod", "endperiod", "periodtype", "calperiod"});
            return;
        }
        switch (value) {
            case "A": {
                this.resetControl(new String[]{"belongstartdate", "belongenddate"}, new String[]{"startperiod", "endperiod", "periodtype", "calperiod"});
                break;
            }
            case "B": {
                this.resetControl(new String[]{"startperiod", "endperiod"}, new String[]{"belongstartdate", "belongenddate", "periodtype", "calperiod"});
                break;
            }
            case "C": {
                this.resetControl(new String[]{"periodtype", "calperiod"}, new String[]{"belongstartdate", "belongenddate", "startperiod", "endperiod"});
                break;
            }
        }
    }
}

