/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.report;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.swc.hsas.business.approve.ApproveBillTplService;
import kd.swc.hsas.business.salaryrpt.SalaryRptItemService;
import kd.swc.hsas.business.salaryrpt.SalaryRptService;
import kd.swc.hsas.formplugin.web.report.SalaryReportSchemeBaseHandler;
import kd.swc.hsbp.business.report.RptDisplayService;
import kd.swc.hsbp.common.constants.RptDisplayConstants;
import kd.swc.hsbp.common.entity.RptDisplayColumnEntity;
import kd.swc.hsbp.formplugin.report.AbstractRptDisplayPlugin;

public class SalarySummaryReportSchemeHandler
extends SalaryReportSchemeBaseHandler
implements RptDisplayConstants {
    public SalarySummaryReportSchemeHandler(IFormView formView, AbstractRptDisplayPlugin formPlugin, SalaryRptService salaryRptService) {
        this.formView = formView;
        this.formPlugin = formPlugin;
        this.salaryRptService = salaryRptService;
    }

    @Override
    public List<RptDisplayColumnEntity> getLeftTreeDataList() {
        return this.buildLeftTree();
    }

    @Override
    public Map<String, Object> getExtendFieldValue(RptDisplayColumnEntity rowData) {
        return rowData.getCustomParams();
    }

    @Override
    public boolean beforeAddColumns(List<RptDisplayColumnEntity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return true;
        }
        HashSet<String> countSet = new HashSet<String>();
        for (RptDisplayColumnEntity entity : entities) {
            if (!"1".equals(entity.getCustomParamValue("isdimension")) || !CollectionUtils.isEmpty((Collection)entity.getChildren())) continue;
            countSet.add(entity.getFieldValue());
        }
        this.getIsDimensionCount(countSet);
        if (countSet.size() > 10) {
            this.formView.showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6700\u591a\u5b58\u5728%d\u4e2a\u6c47\u603b\u7ef4\u5ea6\u3002", (String)"SalarySummaryReportSchemeHandler_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), 10));
            return false;
        }
        return true;
    }

    @Override
    public List<RptDisplayColumnEntity> getDefaultColumns() {
        return RptDisplayService.getFixColumns((String)this.getReportFormId());
    }

    private void getIsDimensionCount(Set<String> countSet) {
        DynamicObjectCollection entryEntity = this.formView.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        for (DynamicObject dynamicObject : entryEntity) {
            if (!"1".equals(dynamicObject.getString("isdimension"))) continue;
            countSet.add(dynamicObject.getString("fieldvalue"));
        }
    }

    private List<RptDisplayColumnEntity> buildLeftTree() {
        ArrayList<RptDisplayColumnEntity> treeList = new ArrayList<RptDisplayColumnEntity>();
        List groupDimNodes = RptDisplayService.getRptDisplayColumnEntity((String)this.getReportFormId());
        RptDisplayColumnEntity groupDataNode = this.assembleSammaryData((RptDisplayColumnEntity)groupDimNodes.get(0));
        treeList.addAll(groupDimNodes);
        treeList.add(groupDataNode);
        return treeList;
    }

    private RptDisplayColumnEntity assembleSammaryData(RptDisplayColumnEntity groupDimNode) {
        Map itemMap = SalaryRptItemService.queryItemMap((String)this.getReportPermEntityCode());
        LinkedHashMap numItemMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        LinkedHashMap noNumItemMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        if (itemMap != null) {
            for (Map.Entry itemTypeEntry : itemMap.entrySet()) {
                DynamicObjectCollection itemColl = (DynamicObjectCollection)itemTypeEntry.getValue();
                if (CollectionUtils.isEmpty((Collection)itemColl)) continue;
                if ("hsbs_statisticstag".equals(itemTypeEntry.getKey())) {
                    numItemMap.put(itemTypeEntry.getKey(), itemColl);
                    continue;
                }
                String itemType = (String)itemTypeEntry.getKey();
                DynamicObjectCollection numItemColl = numItemMap.computeIfAbsent(itemType, k -> new DynamicObjectCollection());
                DynamicObjectCollection noNumItemColl = noNumItemMap.computeIfAbsent(itemType, k -> new DynamicObjectCollection());
                for (DynamicObject itemDyn : itemColl) {
                    String dataType = itemDyn.getString("datatype.storagetype");
                    if (StringUtils.isEmpty((Object)dataType)) {
                        dataType = "";
                        throw new KDBizException("Item( " + itemDyn.getString("name") + ") datatype.storagetype can not null");
                    }
                    if (dataType.equals("amount") || dataType.equals("num")) {
                        numItemColl.add((Object)itemDyn);
                        continue;
                    }
                    noNumItemColl.add((Object)itemDyn);
                }
            }
        }
        this.addNoNumItemNodes(groupDimNode, noNumItemMap);
        List<RptDisplayColumnEntity> numItemNodes = this.buildItemTreeNode(numItemMap, false);
        String salaryItemColumnRes = ResManager.loadKDString((String)"\u6c47\u603b\u6570\u636e", (String)"SalarySummaryReportSchemeHandler_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        RptDisplayColumnEntity salaryItemNode = new RptDisplayColumnEntity();
        salaryItemNode.setFieldValue("groupdata");
        salaryItemNode.setFieldName(salaryItemColumnRes);
        salaryItemNode.setChildren(numItemNodes);
        salaryItemNode.addCustomParam("isdimension", (Object)"0");
        this.setDefaultFieldValue(salaryItemNode, RptDisplayService.getDefaultColWidth((String)this.getReportFormId()));
        return salaryItemNode;
    }

    protected void addNoNumItemNodes(RptDisplayColumnEntity groupDimNode, Map<String, DynamicObjectCollection> noNumItemMap) {
        groupDimNode.getChildren().addAll(this.buildItemTreeNode(noNumItemMap, true));
    }

    @Override
    public boolean beforeDoSaveOperation() {
        DynamicObject dataEntity = this.formView.getModel().getDataEntity();
        DynamicObjectCollection columns = dataEntity.getDynamicObjectCollection("entryentity");
        HashSet tipColumns = Sets.newHashSet((Object[])new String[]{"empnumber", "name"});
        StringBuilder msgBuilder = new StringBuilder();
        for (DynamicObject column : columns) {
            if (!tipColumns.contains(column.getString("fieldalias"))) continue;
            msgBuilder.append('\u3010').append(column.getString("fieldname")).append('\u3011');
        }
        String msg = msgBuilder.toString();
        if (!StringUtils.isEmpty((Object)msg)) {
            ConfirmCallBackListener listener = new ConfirmCallBackListener("CONFIRM_CALLBACK_SUMRPT_SAVE", (IFormPlugin)this.formPlugin);
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u663e\u793a\u65b9\u6848\u4e2d\u5305\u542b\u7279\u6b8a\u7ef4\u5ea6%s\u53ef\u80fd\u5bfc\u81f4\u6c47\u603b\u8868\u7ef4\u5ea6\u62c6\u5206\u8fc7\u7ec6\uff0c\u5f71\u54cd\u67e5\u8be2\u6027\u80fd\uff0c\u8bf7\u8c28\u614e\u4f7f\u7528\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SalarySummaryReportSchemeHandler_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]), msg);
            this.formView.showConfirm(msg, MessageBoxOptions.YesNo, listener);
            return false;
        }
        return true;
    }

    @Override
    public String getReportFormId() {
        return "hsas_salarysumrpt";
    }

    @Override
    public void afterDeleteDisplaySchema(String schemaId) {
        ApproveBillTplService.sendMsg((Long)Long.parseLong(schemaId), (String)"2");
    }
}

