/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.salarydetailresult;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.common.events.salarydetailresultexport.AfterBuildHeadEvent;
import kd.sdk.swc.hsas.formplugin.extpoint.salarydetailresult.ISalaryDetailResultExportExtPlugin;
import kd.swc.hsas.business.cal.export.SWCExportDataHelper;
import kd.swc.hsas.business.salarydeatilresult.export.SalaryDetailResultExportHelper;
import kd.swc.hsas.business.salarydeatilresult.helper.SalaryDetailResultListHelper;
import kd.swc.hsas.business.salarydeatilresult.service.SalaryDetailResultListService;
import kd.swc.hsas.business.salaryresultlist.service.HSASCalResultTplService;
import kd.swc.hsas.common.constants.CalTableExportProgressConstants;
import kd.swc.hsas.common.utils.TaskUtil;
import kd.swc.hsas.common.vo.CalTableExportProgressInfo;
import kd.swc.hsas.formplugin.web.salarydetailresult.AbstractCalPersonListViewBasePlugin;
import kd.swc.hsas.formplugin.web.salarydetailresult.SalaryDetailResultExportExtPlugin;
import kd.swc.hsas.formplugin.web.salarydetailresult.dto.SalaryResultTplExportDto;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class SalaryDetailListExportPlugin
extends AbstractCalPersonListViewBasePlugin {
    private static final Log logger = LogFactory.getLog(SalaryDetailListExportPlugin.class);
    private static final String EXPORT = "donothing_export";
    private static final String PROGRESS = "progress";
    private static final String COMPLETE = "complete";
    private static final String MODULE_NAME = "swc-hsas-formplugin";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        if (operationResult.isSuccess() && EXPORT.equals(opKey)) {
            this.doExport();
        }
    }

    private void doExport() {
        logger.info("start to export SalaryDetailResult info!");
        HSASCalResultTplService service = new HSASCalResultTplService();
        BillList billListAp = new BillList();
        billListAp.setKey("billlistap");
        billListAp.setEntityId("hsas_calperson");
        ListView listView = (ListView)this.getView();
        billListAp.setBillFormId(listView.getBillFormId());
        billListAp.setView((IFormView)listView);
        ListSelectedRowCollection selectedRows = billListAp.getSelectedRows();
        int size = selectedRows.size();
        long[] selectRows = new long[size];
        for (int index = 0; index < size; ++index) {
            selectRows[index] = (Long)selectedRows.get(index).getPrimaryKeyValue();
        }
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        QFilter[] filters = this.getQueryFilters(calTaskId, selectRows);
        ISWCAppCache appCache = SWCAppCache.get((String)"hsas_calresulttpl_appcache");
        String parentPageId = this.getView().getPageId();
        Long calResultTplId = (Long)appCache.get(parentPageId + "_calResultTplCache", Long.class);
        String pageId = this.getView().getPageId();
        SalaryDetailResultListHelper tplHelper = new SalaryDetailResultListHelper();
        DynamicObject taskInfo = this.getTaskInfo(calTaskId);
        if (SWCObjectUtils.isEmpty((Object)taskInfo)) {
            return;
        }
        Map gridItemInfo = tplHelper.getCalResultTplInfo(calResultTplId, this.getView(), calTaskId);
        logger.info("export get gridItemInfo is:{}", (Object)gridItemInfo.toString());
        Map calPersonInfo = tplHelper.getCalPersonListInfo(calResultTplId, this.getView());
        logger.info("export get calPersonInfo is:{}", (Object)calPersonInfo.toString());
        Map headers = tplHelper.getExportHeaders(calResultTplId.longValue(), pageId, false, gridItemInfo, calPersonInfo);
        logger.info("export get getExportHeaders is:{}", (Object)calPersonInfo.toString());
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Boolean showCurrency = (Boolean)pageCache.get("showcurrency", Boolean.class);
        if (showCurrency == null) {
            showCurrency = Boolean.FALSE;
        }
        logger.info("export get showCurrency is:{}", (Object)showCurrency);
        String orderStr = (String)pageCache.get("orderStr", String.class);
        logger.info("export get orderStr is:{}", (Object)orderStr);
        SalaryResultTplExportDto.Builder builder = new SalaryResultTplExportDto.Builder();
        builder.setFilters(filters).setCalTaskId(calTaskId).setGridItemInfo(gridItemInfo).setTaskInfo(taskInfo).setHeaders(headers).setService(service).setPageId(pageId).setShowCurrency(showCurrency);
        String downLoadTaskId = TaskUtil.getExportTaskID();
        logger.info("export get downLoadTaskId is:{}", (Object)downLoadTaskId);
        this.doExport(builder, downLoadTaskId, calPersonInfo, orderStr);
    }

    private void doExport(SalaryResultTplExportDto.Builder builder, String downLoadTaskId, Map<String, String> calPersonInfo, String orderStr) {
        SalaryResultTplExportDto dto = builder.build();
        SalaryDetailResultListService service = new SalaryDetailResultListService();
        QFilter[] filters = dto.getFilters();
        int totalElements = ORM.create().count("BusinessDataServiceHelper.load", "hsas_calperson", filters);
        int totalPages = (int)Math.ceil((double)totalElements * 1.0 / (double)CalTableExportProgressConstants.PAGE_SIZE.intValue());
        CountDownLatch countDownLatch = new CountDownLatch(totalPages);
        String floatingTaskId = this.openExportProgressBar(totalElements, totalPages, countDownLatch, downLoadTaskId);
        Long calTaskId = dto.getCalTaskId();
        DynamicObject taskInfo = dto.getTaskInfo();
        Map<String, Map<String, Object>> gridItemInfo = dto.getGridItemInfo();
        Map<String, String> headers = dto.getHeaders();
        LocalDate now = LocalDate.now();
        String date = String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
        String fileName = MessageFormat.format(ResManager.loadKDString((String)"\u85aa\u8d44\u660e\u7ec6\u7ed3\u679c\u8868\u5bfc\u51fa_{0}_{1}", (String)"SalaryDetailListExportPlugin_0", (String)MODULE_NAME, (Object[])new Object[0]), taskInfo.getString("name"), date);
        RequestContext ctx = RequestContext.get();
        CalTableExportProgressInfo progressInfo = new CalTableExportProgressInfo();
        progressInfo.setFloatingTaskId(floatingTaskId);
        Boolean isShowCurrency = dto.getShowCurrency();
        HashMap totalValMap = new HashMap(16);
        DynamicObject currencyObj = taskInfo.getDynamicObject("payrollgroupv.currency");
        HashMap columnWidthMap = new HashMap(headers.size());
        ThreadPools.executeOnce((String)"EXPORT_EXCEL_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            logger.info("starting export data: {}", (Object)stopWatch.toString());
            try (SXSSFWorkbook wb = new SXSSFWorkbook(CalTableExportProgressConstants.ROW_ACCESS_WINDOWS_SIZE);){
                SXSSFSheet sheet = wb.createSheet();
                sheet.setRandomAccessWindowSize(-1);
                wb.setSheetName(0, fileName);
                SalaryDetailResultExportHelper helper = new SalaryDetailResultExportHelper();
                int rowIndex = helper.writeAbstractRows(sheet, taskInfo, columnWidthMap, 0);
                logger.info("export get rowindex columnWidthMap is:{}, rowIndex is:{}", (Object)columnWidthMap, (Object)rowIndex);
                rowIndex = helper.write2ExportHead(sheet, headers, gridItemInfo, columnWidthMap, rowIndex + 1);
                int currRowIndex = rowIndex = this.invokeAfterBuildHead(new AfterBuildHeadEvent(sheet, taskInfo, gridItemInfo, headers, rowIndex));
                ReentrantLock lock = new ReentrantLock();
                int pageIndex = 0;
                while (pageIndex < totalPages) {
                    int currentPage = pageIndex++;
                    SWCThreadPoolFactory.getCalresultExportNewThreadpool().execute(() -> {
                        try {
                            RequestContext.copyAndSet((RequestContext)ctx);
                            List data = service.getExportData(filters, gridItemInfo, calTaskId, calPersonInfo, isShowCurrency, currencyObj, currentPage, CalTableExportProgressConstants.PAGE_SIZE.intValue(), totalValMap, orderStr);
                            logger.info("export get export data end");
                            lock.lock();
                            helper.write2ExportContent(sheet, Integer.valueOf(currentPage * CalTableExportProgressConstants.PAGE_SIZE + currRowIndex), null, null, data, headers, gridItemInfo, columnWidthMap, false);
                            logger.info("export write export data end");
                        }
                        catch (Exception e) {
                            logger.error("CalTableExportPlugin.doExportAll.error. ", (Throwable)e);
                        }
                        finally {
                            lock.unlock();
                            countDownLatch.countDown();
                            SWCPageCache pageCache = new SWCPageCache(this.getView());
                            double percent = (double)((long)totalPages - countDownLatch.getCount()) * 100.0 / (double)totalPages;
                            double progress = BigDecimal.valueOf(percent).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
                            long complete = 0L;
                            if (totalElements < 100) {
                                complete = totalElements;
                            } else {
                                complete = ((long)totalPages - countDownLatch.getCount()) * (long)CalTableExportProgressConstants.PAGE_SIZE.intValue();
                                if (complete > (long)totalElements) {
                                    complete = totalElements;
                                }
                            }
                            pageCache.put(PROGRESS + downLoadTaskId, (Object)progress);
                            pageCache.put(COMPLETE + downLoadTaskId, (Object)complete);
                            pageCache.saveChanges();
                            logger.info("export write getFloatingCustom start");
                            Map<String, Object> customData = this.getFloatingCustom(downLoadTaskId);
                            logger.info("export write getFloatingCustom end");
                            HRBackgroundTaskHelper.getInstance().feedbackProgress(floatingTaskId, (int)progress, "", customData);
                            if (complete >= (long)totalElements) {
                                HRBackgroundTaskHelper.getInstance().feedbackStatus(floatingTaskId, "COMPLETED", "", customData);
                            }
                            logger.info("export write feedbackProgress end");
                            TaskUtil.addTaskInfoToCache((CalTableExportProgressInfo)progressInfo, (int)totalElements, (Double)progress, (int)((int)complete), (String)downLoadTaskId);
                            logger.info("export write addTaskInfoToCache end");
                        }
                    });
                }
                if (countDownLatch.await(30L, TimeUnit.MINUTES)) {
                    int columnIndex;
                    HashMap<Object, String> totalRowMap = new HashMap<Object, String>(16);
                    List headList = helper.HeadMapToListMap(headers, gridItemInfo);
                    totalRowMap.put(((Map)headList.get(0)).get("key"), ResManager.loadKDString((String)"\u5408\u8ba1", (String)"SalaryDetailResultListService_0", (String)"swc-hsas-business", (Object[])new Object[0]));
                    for (Map.Entry entry : totalValMap.entrySet()) {
                        totalRowMap.put(entry.getKey(), (String)entry.getValue());
                    }
                    int beginIndex = totalElements + currRowIndex;
                    SXSSFRow contentRow = sheet.createRow(beginIndex);
                    logger.info("export start total headList start");
                    HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>(16);
                    for (columnIndex = 0; columnIndex < headList.size(); ++columnIndex) {
                        Object value;
                        SXSSFCell columnCell = contentRow.createCell(columnIndex);
                        String key = (String)((Map)headList.get(columnIndex)).get("key");
                        if (null == key || (value = totalRowMap.get(key)) == null) continue;
                        String dataType = "";
                        dataType = value instanceof String ? "text" : "amount";
                        if (value != null) {
                            logger.info("export start total getColumnWidth start");
                            int columnWidth = SalaryDetailResultExportHelper.getColumnWidth((String)String.valueOf(value));
                            if (columnWidth > (Integer)columnWidthMap.get(columnIndex)) {
                                columnWidthMap.put(columnIndex, columnWidth);
                            }
                            logger.info("export start total getColumnWidth end");
                        }
                        SalaryDetailResultExportHelper.parseCellValue((SXSSFCell)columnCell, value, (String)dataType);
                        columnCell.setCellType(SalaryDetailResultExportHelper.getCellType((String)dataType));
                        logger.info("export start total getItemInfo start");
                        Map itemInfo = SalaryDetailResultExportHelper.getItemInfo((Map)gridItemInfo, (String)key);
                        String sign = (String)totalRowMap.get(key + "_sign");
                        String cellStyleKey = SalaryDetailResultExportHelper.getCellStyleKey((Map)itemInfo, (String)sign);
                        CellStyle defaultStyle = (CellStyle)cellStyleMap.get(cellStyleKey);
                        if (defaultStyle == null) {
                            defaultStyle = SalaryDetailResultExportHelper.getDefaultCellStyle((Map)itemInfo, (String)sign, (SXSSFWorkbook)wb);
                            cellStyleMap.put(cellStyleKey, defaultStyle);
                        }
                        columnCell.setCellStyle(defaultStyle);
                    }
                    for (columnIndex = 0; columnIndex < headList.size(); ++columnIndex) {
                        Integer columnWidth = (Integer)columnWidthMap.get(columnIndex);
                        if (columnWidth == null) continue;
                        sheet.setColumnWidth(columnIndex, columnWidth.intValue());
                    }
                    logger.info("export start flushAll start");
                    this.flushAll(headers, sheet, fileName, totalPages, stopWatch, countDownLatch, downLoadTaskId, progressInfo, totalElements);
                    logger.info("export start flushAll end");
                }
            }
            catch (Exception e) {
                logger.error("CalTableExportPlugin.SXSSFWorkbook.error. ", (Throwable)e);
            }
        });
    }

    private int invokeAfterBuildHead(AfterBuildHeadEvent arg) {
        SalaryDetailResultExportExtPlugin iSalaryDetailResultExportPlugin = new SalaryDetailResultExportExtPlugin();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)iSalaryDetailResultExportPlugin, ISalaryDetailResultExportExtPlugin.class, (String)"kd.sdk.swc.hsas.formplugin.extpoint.salarydetailresult.ISalaryDetailResultExportExtPlugin#afterBuildHead", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.afterBuildHead(arg);
            return null;
        });
        return arg.getCurrRowIndex();
    }

    private void flushAll(Map<String, String> headers, SXSSFSheet sheet, String fileName, int totalPages, StopWatch stopWatch, CountDownLatch countDownLatch, String downLoadTaskId, CalTableExportProgressInfo progressInfo, int totalElements) throws IOException {
        List headList = SWCExportDataHelper.HeadMapToListMap(headers);
        for (int i = 0; i < headList.size(); ++i) {
            int columnWidth = sheet.getColumnWidth(i);
            sheet.setColumnWidth(i, columnWidth * 4);
        }
        String url = SWCExportDataHelper.writeFile((SXSSFWorkbook)sheet.getWorkbook(), (String)fileName);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Double percent = totalPages <= 0 ? Double.valueOf(100.0) : Double.valueOf((double)((long)totalPages - countDownLatch.getCount()) * 100.0 / (double)totalPages);
        String floatingTaskId = progressInfo.getFloatingTaskId();
        if (!StringUtils.isEmpty((String)floatingTaskId)) {
            Map<String, Object> customData = this.getFloatingCustom(downLoadTaskId);
            HRBackgroundTaskHelper.getInstance().feedbackProgress(floatingTaskId, percent.intValue(), "", customData);
        }
        if (percent.intValue() >= 100) {
            pageCache.put("url" + downLoadTaskId, (Object)url);
            pageCache.put(PROGRESS + downLoadTaskId, (Object)percent);
            pageCache.put(COMPLETE + downLoadTaskId, (Object)totalElements);
            pageCache.saveChanges();
            progressInfo.setUrl(url);
            if (!StringUtils.isEmpty((String)floatingTaskId)) {
                HRBackgroundTaskHelper.getInstance().feedbackStatus(floatingTaskId, "COMPLETED", "", null);
            }
        }
        double progress = BigDecimal.valueOf(percent).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
        TaskUtil.addTaskInfoToCache((CalTableExportProgressInfo)progressInfo, (int)totalElements, (Double)progress, (int)totalElements, (String)downLoadTaskId);
        stopWatch.stop();
        logger.info("ending export data: {},countdown: {}", (Object)stopWatch.toString(), (Object)countDownLatch.getCount());
    }

    private String openExportProgressBar(int totalCount, int totalPages, CountDownLatch countDownLatch, String downLoadTaskId) {
        String pageId = this.getView().getPageId();
        FormShowParameter para = new FormShowParameter();
        para.setFormId("hsas_caltableexportprog");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCustomParam("pageId", (Object)pageId);
        para.setCustomParam("totalCount", (Object)totalCount);
        para.setCustomParam("status", (Object)0);
        para.setCustomParam("downLoadTaskId", (Object)downLoadTaskId);
        String caption = ResManager.loadKDString((String)"\u85aa\u8d44\u660e\u7ec6\u7ed3\u679c\u8868\u5bfc\u51fa\u8fdb\u5ea6", (String)"SalaryResultListExportPlugin_1", (String)MODULE_NAME, (Object[])new Object[0]);
        para.setCaption(caption);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        if (totalPages <= 0) {
            pageCache.put(PROGRESS + downLoadTaskId, (Object)100);
            para.setCustomParam(PROGRESS, (Object)100);
        } else {
            pageCache.put(PROGRESS + downLoadTaskId, (Object)(((long)totalPages - countDownLatch.getCount()) / (long)totalPages));
            pageCache.put(COMPLETE + downLoadTaskId, (Object)(((long)totalPages - countDownLatch.getCount()) * 100L));
        }
        pageCache.saveChanges();
        Map<String, Object> customData = this.getFloatingCustom(downLoadTaskId);
        String taskName = ResManager.loadKDString((String)"\u5bfc\u51fa - \u85aa\u8d44\u660e\u7ec6\u7ed3\u679c\u8868", (String)"SalaryResultListExportPlugin_2", (String)MODULE_NAME, (Object[])new Object[0]);
        String floatingTaskId = HRBackgroundTaskHelper.getInstance().createBaskgroundTask("swc_hsas_exportsalarydetaillist", taskName, true, pageId, customData);
        this.cacheFloatingTaskId(downLoadTaskId, floatingTaskId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "openExportProgressBar");
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
        return floatingTaskId;
    }

    public DynamicObject getTaskInfo(Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String field = "name,simplename,payrollgroup.name,payrollgroupv.name,payrollgroupv.bsed,payrollgroupv.bsled,calrule.name,calrulev,calrulev.name,calrulev.bsed,calrulev.bsled,paysubjectv.name,paysubjectv.bsed,paysubjectv.bsled,payrolldate,calcount,aftercal,periodcategory,period.name,payrollgroupv.currency.amtprecision,STARTDATE,ENDDATE,payrollgroupv.currency.name,payrollgroupv.currency.number,exratedate";
        QFilter taskFilter = new QFilter("id", "=", (Object)calTaskId);
        QFilter[] filters = new QFilter[]{taskFilter};
        DynamicObject taskInfo = helper.queryOne(field, filters);
        return taskInfo;
    }

    private void cacheFloatingTaskId(String downLoadTaskId, String floatingTaskId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CALTABLE_%s", downLoadTaskId));
        appCache.put("className", (Object)SalaryDetailListExportPlugin.class.getName());
        appCache.put("floatingTaskId", (Object)floatingTaskId);
    }

    private Map<String, Object> getFloatingCustom(String downLoadTaskId) {
        HashMap<String, Object> customData = new HashMap<String, Object>(2);
        customData.put("downLoadTaskId", downLoadTaskId);
        String caption = ResManager.loadKDString((String)"\u85aa\u8d44\u660e\u7ec6\u7ed3\u679c\u8868\u5bfc\u51fa\u8fdb\u5ea6", (String)"SalaryResultListExportPlugin_1", (String)MODULE_NAME, (Object[])new Object[0]);
        customData.put("caption", caption);
        return customData;
    }
}

