/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.salarydetailresult.mark;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.salarydeatilresult.helper.SalaryDetailResultMarkListHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class CalPersonMarkListPlugin
extends SWCDataBaseEdit {
    private static final String MARK_LIST_ENTRY = "marklistentry";
    private static final String DEL_MARK = "donothing_delmark";
    private static final String DEL_MARK_CALL_BACK = "delMarkCallBack";

    public void beforeBindData(EventObject e) {
        this.loadMarkInfoToEntry();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String optKey = formOperate.getOperateKey();
        if (SWCStringUtils.equals((String)optKey, (String)DEL_MARK)) {
            this.delMarkCheck(args);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if (SWCStringUtils.equals((String)callBackId, (String)DEL_MARK_CALL_BACK) && MessageBoxResult.Yes.equals((Object)result)) {
            this.delSelectedMarkInfo();
            MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u53d6\u6d88\u6807\u8bb0\u6210\u529f", "CalPersonMarkListPlugin_5", "swc-hsas-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)DEL_MARK, (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
        }
    }

    private void delSelectedMarkInfo() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(MARK_LIST_ENTRY);
        int[] selectRows = grid.getSelectRows();
        int size = selectRows.length;
        if (size == 0) {
            return;
        }
        DynamicObjectCollection markList = this.getModel().getEntryEntity(MARK_LIST_ENTRY);
        if (markList == null) {
            return;
        }
        long[] markIds = new long[size];
        for (int i = 0; i < size; ++i) {
            int index = selectRows[i];
            DynamicObject markObj = (DynamicObject)markList.get(index);
            markIds[i] = markObj.getLong("markid");
        }
        this.getModel().deleteEntryRows(MARK_LIST_ENTRY, selectRows);
        long calPersonId = (Long)this.getView().getFormShowParameter().getCustomParam("calPersonId");
        SalaryDetailResultMarkListHelper helper = new SalaryDetailResultMarkListHelper();
        helper.delCalPersonMarkInfo(markIds, calPersonId);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f\u3002", (String)"CalPersonMarkListPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
    }

    private void delMarkCheck(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection markColl = this.getModel().getEntryEntity(MARK_LIST_ENTRY);
        if (markColl == null || markColl.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"CalPersonMarkListPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(MARK_LIST_ENTRY);
        int[] selectRows = grid.getSelectRows();
        int size = selectRows.length;
        if (size == 0) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CalPersonMarkListPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean checkResult = this.markOperationCheck(args);
        if (!checkResult) {
            return;
        }
        args.setCancel(true);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u53d6\u6d88\u6807\u8bb0\u540e\u65e0\u6cd5\u6062\u590d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u53d6\u6d88\u6807\u8bb0\u3002", (String)"CalPersonMarkListPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DEL_MARK_CALL_BACK));
    }

    private boolean markOperationCheck(BeforeDoOperationEventArgs args) {
        String entityName = EntityMetadataCache.getDataEntityType((String)"hsas_calperson").getDisplayName().getLocaleValue();
        Long calPersonId = (Long)this.getView().getFormShowParameter().getCustomParam("calPersonId");
        if (!this.checkDataPermission(calPersonId, "donothing_cancelmark")) {
            String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0d\u80fd\u53d6\u6d88\u6807\u8bb0\u3002\u60a8\u6ca1\u6709\u3010%1$s\u3011\u3010\u53d6\u6d88\u6807\u8bb0\u3011\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalPersonMarkListPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]), entityName);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private boolean checkDataPermission(Long calPersonId, String opKey) {
        QFilter filter = new QFilter("id", "in", (Object)calPersonId);
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilterByOpKey((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)opKey);
        if (authorizedDataRuleQFilter == null) {
            filter.and(new QFilter("1", "!=", (Object)1));
        } else {
            authorizedDataRuleQFilter.forEach(arg_0 -> ((QFilter)filter).and(arg_0));
        }
        return new SWCDataServiceHelper("hsas_calperson").count(filter.toArray()) == 1;
    }

    private void loadMarkInfoToEntry() {
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        if (calTaskId == null) {
            return;
        }
        Long calPersonId = (Long)this.getView().getFormShowParameter().getCustomParam("calPersonId");
        if (calPersonId == null) {
            return;
        }
        SalaryDetailResultMarkListHelper markHelper = new SalaryDetailResultMarkListHelper();
        Map allCalPersonMarkMap = markHelper.getAllCalPersonMarkInfoByCalTaskId(calTaskId);
        if (allCalPersonMarkMap == null || allCalPersonMarkMap.size() == 0) {
            return;
        }
        List markList = (List)allCalPersonMarkMap.get(calPersonId);
        if (markList == null || markList.size() == 0) {
            return;
        }
        this.getModel().deleteEntryData(MARK_LIST_ENTRY);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("markreason", new Object[0]);
        vs.addField("marktime", new Object[0]);
        vs.addField("markid", new Object[0]);
        for (DynamicObject dataObj : markList) {
            String markReason = dataObj.getString("markreason");
            Date markTime = dataObj.getDate("createtime");
            long markId = dataObj.getLong("id");
            vs.addRow(new Object[]{markReason, markTime, markId});
        }
        model.batchCreateNewEntryRow(MARK_LIST_ENTRY, vs);
        model.endInit();
        this.getView().updateView(MARK_LIST_ENTRY);
    }
}

