/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.salaryfile;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.bankoffer.vo.BaseDataConverter;
import kd.swc.hsas.business.salaryfile.SalaryTaxFileRelViewHelper;
import kd.swc.hsas.common.utils.GlobalParam;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;

public class SalaryFileAddTaxFileTmpPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String APP_ID_ITC = "17/+CT1QBPNP";
    public static final String APP_ITC = "itc";
    private static final String PAGE_ITC_TAX_FILE = "itc_taxfile";
    private static final String TAX_UNIT = "taxunit";
    public static final String VALUE_NOT_SAME_TIPS = "VALUE_NOT_SAME_TIPS_";
    private static final Log LOGGER = LogFactory.getLog(SalaryFileAddTaxFileTmpPlugin.class);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter parameter = (FormShowParameter)e.getSource();
        parameter.setCustomParam("customHREntityNumber", (Object)PAGE_ITC_TAX_FILE);
        parameter.setCustomParam("customHRPermItemId", (Object)"47156aff000000ac");
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        String parentPageId = showParameter.getParentPageId();
        if (SWCStringUtils.isEmpty((String)parentPageId)) {
            e.setCancel(true);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit empGroup = (BasedataEdit)this.getControl("empgroup");
        empGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxUnit = (BasedataEdit)this.getControl(TAX_UNIT);
        taxUnit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String countryId = (String)this.getView().getFormShowParameter().getCustomParam("countryId");
        if (StringUtils.isEmpty((CharSequence)countryId) || StringUtils.equals((CharSequence)"0", (CharSequence)countryId)) {
            return;
        }
        ArrayList dataProps = Lists.newArrayList();
        EntityMetadataCache.getDataEntityType((String)this.getView().getEntityId()).getAllFields().forEach((field, property) -> {
            if (property instanceof ComboProp && CollectionUtils.isEmpty((Collection)((ComboProp)property).getComboItems())) {
                dataProps.add(field);
            }
        });
        Map result = (Map)SWCMServiceUtils.invokeSITService((String)"iit", (String)"TaxBaseDataApiService", (String)"findDataByCountry", (Object[])new Object[]{Lists.newArrayList((Object[])new Long[]{Long.valueOf(countryId)}), dataProps});
        Boolean success = (Boolean)BaseDataConverter.convert(result.get("success"), Boolean.class, (Object)Boolean.FALSE);
        LOGGER.info("by ns findDataByCountry success = {} result = {}", (Object)success, (Object)result);
        if (!success.booleanValue()) {
            String message = String.valueOf(result.get("message"));
            this.getView().showErrorNotification(message);
            return;
        }
        HashBasedTable data = (HashBasedTable)result.get("data");
        Map rowMap = data.rowMap();
        ((Map)rowMap.get(Long.valueOf(countryId))).forEach((dataProp, valueMap) -> {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(valueMap.size());
            for (Map.Entry valuePair : valueMap.entrySet()) {
                items.add(new ComboItem(new LocaleString((String)valuePair.getValue()), (String)valuePair.getKey()));
            }
            ComboEdit comboEdit = (ComboEdit)this.getControl((String)dataProp);
            comboEdit.setComboItems(items);
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        SalaryTaxFileRelViewHelper.propertyOfTaxChanged((IFormView)this.getView(), (IDataEntityProperty)e.getProperty(), (Object)e.getChangeSet()[0].getNewValue());
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.startsWith(VALUE_NOT_SAME_TIPS)) {
            String substring = callBackId.substring(VALUE_NOT_SAME_TIPS.length());
            Control control = this.getView().getControl(substring);
            if (control instanceof FieldEdit) {
                ((FieldEdit)control).setFocus(false);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (parentView != null && parentView.getFormShowParameter().getFormId().startsWith("hsas_")) {
            SalaryTaxFileRelViewHelper.initTaxFileBySalaryFile((IFormView)parentView, (IFormView)view, (boolean)false);
        }
        List empGroupIds = SWCPermissionServiceHelper.getEmpgroupByAppNumber((String)APP_ITC);
        QFilter qFilter = new QFilter("id", "in", (Object)empGroupIds);
        BasedataEdit empGroupEdit = (BasedataEdit)this.getControl("empgroup");
        empGroupEdit.setQFilters(Collections.singletonList(qFilter));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        String permItemId = "47156aff000000ac";
        switch (fieldKey) {
            case "empgroup": {
                Set empgrpSetByPermItem;
                if (SWCPermissionServiceHelper.isSuperUser() || (empgrpSetByPermItem = SWCPermissionServiceHelper.getEmpgrpSetByPermItem((String)APP_ID_ITC, (String)PAGE_ITC_TAX_FILE)) == null) break;
                ListShowParameter paramEmp = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter filterEmp = new QFilter("id", "in", (Object)empgrpSetByPermItem);
                paramEmp.getListFilterParameter().setFilter(filterEmp);
                LOGGER.info("\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u6709\u6743\u9650\u7684\u4eba\u5458\u7ec4\uff1a{}", (Object)SerializationUtils.toJsonString((Object)empgrpSetByPermItem));
                break;
            }
            case "org": {
                HasPermOrgResult permOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)APP_ID_ITC, (String)PAGE_ITC_TAX_FILE, (String)permItemId);
                if (permOrgResult.hasAllOrgPerm()) break;
                LOGGER.info("SalaryFileAddTaxFileTmpPlugin permOrgResult.getHasPermOrgs\uff1a{}", (Object)permOrgResult.getHasPermOrgs());
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter filter = new QFilter("id", "in", (Object)permOrgResult.getHasPermOrgs());
                listShowParameter.getListFilterParameter().setFilter(filter);
                break;
            }
            case "taxunit": {
                Set taxUnitSetByPermItem;
                ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                long taxRegionId = this.getModel().getDataEntity().getLong("taxregion.id");
                if (taxRegionId != 0L) {
                    param.getListFilterParameter().setFilter(new QFilter("admindivision.country.id", "=", (Object)taxRegionId));
                }
                if ((taxUnitSetByPermItem = SWCPermissionServiceHelper.getTaxUnitSetByPermItem((String)APP_ID_ITC, (String)PAGE_ITC_TAX_FILE, (String)"47150e89000000ac")) == null) break;
                QFilter filterUnit = new QFilter("id", "in", (Object)taxUnitSetByPermItem);
                param.getListFilterParameter().setFilter(filterUnit);
                LOGGER.info("\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u6709\u6743\u9650\u7684\u7eb3\u7a0e\u5355\u4f4d\uff1a{}", (Object)SerializationUtils.toJsonString((Object)taxUnitSetByPermItem));
                break;
            }
        }
    }

    public void destory() {
        super.destory();
        GlobalParam.remove();
    }
}

