/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.salaryfile;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.salaryfile.ImportRowEntity;
import kd.swc.hsas.business.salaryfile.SalaryFileImportDataConvert2DyObj;
import kd.swc.hsas.business.salaryfile.SalaryFileImportDataOperate;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;

public class SalaryFileBlockBatchImportPlugin
extends BatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(SalaryFileBlockBatchImportPlugin.class);
    private static final String IMPORT_TYPE_NEW = "new";
    private static final String IMPORT_TYPE_OVERRIDE = "override";
    private static final String IMPORT_TYPE_OVERRIDENEW = "overridenew";
    private static final String SALARYFILE = "salaryfile";
    private static final String ENTRYENTITY = "entryentity";
    private static final String KEYFIELDS = "KeyFields";
    private static final String IMPORTTYPE = "importtype";
    private static final int BATCH_IMPORT_SIZE = 500;
    private long totalSpendTime = 0L;
    private long totalImportCount = 0L;

    public String getBillFormId() {
        return super.getBillFormId();
    }

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return 500;
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        String salaryfileField = ResManager.loadKDString((String)"\u85aa\u916c\u6863\u6848", (String)"SalaryFileBlockBatchImportPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        return Collections.singletonList(new ComboItem(new LocaleString(salaryfileField), SALARYFILE));
    }

    private void getImportRowInfo(List<List<ImportRowEntity>> duplicateGroupList, List<ImportBillData> rowdatas, ImportLogger importLogger) {
        LOGGER.info("SalaryFileBlockBatchImportPlugin#getImportRowInfo -----------start----{}", (Object)rowdatas.size());
        HashSet<String> salaryFileNumberSets = new HashSet<String>(16);
        ArrayList<ImportRowEntity> rowInfoList = new ArrayList<ImportRowEntity>(10);
        ArrayList<ImportBillData> leftRowDatas = new ArrayList<ImportBillData>(10);
        ImportRowEntity rowInfo = null;
        if (rowdatas.isEmpty()) {
            LOGGER.info("SalaryFileBlockBatchImportPlugin#getImportRowInfo -----------end----");
            return;
        }
        for (ImportBillData rowdata : rowdatas) {
            JSONObject jsonSalaryFile = rowdata.getData().getJSONObject(SALARYFILE);
            String salaryFileNumber = jsonSalaryFile.getString("number");
            if (salaryFileNumberSets.add(salaryFileNumber)) {
                rowInfo = new ImportRowEntity(rowdata.getStartIndex(), rowdata.getEndIndex(), rowdata.getData());
                importLogger.tick();
                rowInfoList.add(rowInfo);
                continue;
            }
            leftRowDatas.add(rowdata);
        }
        salaryFileNumberSets.clear();
        duplicateGroupList.add(rowInfoList);
        LOGGER.info("SalaryFileBlockBatchImportPlugin#getImportRowInfo -----------ing----{}", (Object)rowdatas.size());
        this.getImportRowInfo(duplicateGroupList, leftRowDatas, importLogger);
    }

    protected ApiResult save(List<ImportBillData> bills, ImportLogger logger) {
        long start = System.currentTimeMillis();
        LOGGER.info("-----------save()-----------------begin");
        List<ImportBillData> rightBills = this.getRightBills(bills, logger);
        rightBills.sort(Comparator.comparing(bill -> bill.getData().getDate("bsed")));
        ArrayList<List<ImportRowEntity>> duplicateGroupList = new ArrayList<List<ImportRowEntity>>();
        this.getImportRowInfo(duplicateGroupList, rightBills, logger);
        this.dealDuplicateGroupList(logger, duplicateGroupList);
        long end = System.currentTimeMillis();
        this.totalSpendTime += end - start;
        this.totalImportCount += (long)bills.size();
        LOGGER.info("SalaryFileBlockBatchImportPlugin#save,{} data use total time is\uff1a{}", (Object)this.totalImportCount, (Object)this.totalSpendTime);
        LOGGER.info("-----------save()-----------------end");
        return null;
    }

    private void dealDuplicateGroupList(ImportLogger logger, List<List<ImportRowEntity>> duplicateGroupList) {
        if (duplicateGroupList.isEmpty()) {
            return;
        }
        RequestContext rc = RequestContext.get();
        MainEntityType mainEntityType = super.buildMainEntityType(null);
        ArrayList<Future> futureResults = new ArrayList<Future>(duplicateGroupList.size());
        for (List<ImportRowEntity> rowInfos : duplicateGroupList) {
            Future futureResult = SWCThreadPoolFactory.getSalaryfileImportThreadPool().submit((Callable)new MutiThreadValidator(mainEntityType, rowInfos, logger, this.ctx, rc));
            futureResults.add(futureResult);
        }
        try {
            for (Future result : futureResults) {
                List rowInfos = (List)result.get();
                rowInfos = SalaryFileImportDataOperate.filterImportableData((MainEntityType)mainEntityType, (List)rowInfos, (ImportLogger)logger);
                this.verifyAddOrUpdateImport(rowInfos, mainEntityType, logger);
                SalaryFileImportDataOperate.executeImportData((MainEntityType)mainEntityType, (List)rowInfos, (ImportContext)this.ctx, (ImportLogger)logger);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("mutil thread validate error : ", (Throwable)e);
        }
    }

    private List<ImportBillData> getRightBills(List<ImportBillData> bills, ImportLogger logger) {
        ArrayList<ImportBillData> rightBills = new ArrayList<ImportBillData>(10);
        for (ImportBillData rowdata : bills) {
            Map logCache = logger.getLogCache();
            List logList = (List)logCache.get(rowdata.getStartIndex());
            if (logList != null && logList.size() > 0) {
                logger.tick();
                logger.fail();
                continue;
            }
            rightBills.add(rowdata);
        }
        return rightBills;
    }

    private void verifyAddOrUpdateImport(List<ImportRowEntity> rowInfos, MainEntityType mainEntityType, ImportLogger logger) {
        String importType = (String)this.ctx.getOption().get(IMPORTTYPE);
        String keyFields = (String)this.ctx.getOption().get(KEYFIELDS);
        switch (importType) {
            case "new": {
                this.verifyNewAddImport(rowInfos, mainEntityType, logger);
                break;
            }
            case "override": {
                this.verifyUpdateImport(rowInfos, mainEntityType, logger, keyFields);
                break;
            }
            case "overridenew": {
                this.verifyUpdateNewAddImport(rowInfos, mainEntityType, logger, keyFields);
                break;
            }
        }
    }

    private void verifyNewAddImport(List<ImportRowEntity> rowInfos, MainEntityType mainEntityType, ImportLogger logger) {
        String entityId = mainEntityType.getName();
        for (ImportRowEntity rowInfo : rowInfos) {
            DynamicObject entityDyobj = rowInfo.getEntityDyobj(entityId);
            DynamicObject salaryfileDyObj = entityDyobj.getDynamicObject(SALARYFILE);
            if (salaryfileDyObj == null) continue;
            String salaryfileNumber = salaryfileDyObj.getString("number");
            Long salaryfileId = salaryfileDyObj.getLong("id");
            Map<Long, List<DynamicObject>> salaryfileSubordinateMap = SalaryFileBlockBatchImportPlugin.getSalaryfileSubordinate(rowInfos, mainEntityType);
            List<DynamicObject> salaryfileSubordinate = salaryfileSubordinateMap.get(salaryfileId);
            if (salaryfileSubordinate == null) continue;
            String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848:{0}\u5df2\u5b58\u5728{1},\u8bf7\u9009\u62e9\u66f4\u65b0\u5bfc\u5165\u3002", (String)"SalaryFileBlockBatchImportPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), salaryfileNumber, mainEntityType.getDisplayName());
            SalaryFileImportDataOperate.log((int)rowInfo.getRowIndex(), (String)errorMsg, (ImportLogger)logger);
        }
    }

    private void verifyUpdateImport(List<ImportRowEntity> rowInfos, MainEntityType mainEntityType, ImportLogger logger, String keyFields) {
        String entityId = mainEntityType.getName();
        Map<Long, List<DynamicObject>> salaryfileSubordinateMap = SalaryFileBlockBatchImportPlugin.getSalaryfileSubordinate(rowInfos, mainEntityType);
        for (ImportRowEntity rowInfo : rowInfos) {
            String errorMsg;
            this.verifyKeyFields(rowInfo.getRowIndex(), keyFields, logger);
            DynamicObject entityDyobj = rowInfo.getEntityDyobj(entityId);
            DynamicObject salaryfileDyObj = entityDyobj.getDynamicObject(SALARYFILE);
            if (salaryfileDyObj == null) continue;
            String salaryfileNumber = salaryfileDyObj.getString("number");
            Long salaryfileId = salaryfileDyObj.getLong("id");
            List<DynamicObject> salaryfileSubordinates = salaryfileSubordinateMap.get(salaryfileId);
            if (salaryfileSubordinates == null) {
                errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848:{0}\u4e0d\u5b58\u5728{1}\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5bfc\u5165\u65b9\u5f0f\u3002", (String)"SalaryFileBlockBatchImportPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]), salaryfileNumber, mainEntityType.getDisplayName());
                SalaryFileImportDataOperate.log((int)rowInfo.getRowIndex(), (String)errorMsg, (ImportLogger)logger);
                continue;
            }
            if (salaryfileSubordinates != null && salaryfileSubordinates.size() > 1) {
                errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\uff1a%s\u5b58\u5728\u591a\u6761\u8bb0\u5f55\u3002", (String)"SalaryFileBlockBatchImportPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]), salaryfileNumber);
                SalaryFileImportDataOperate.log((int)rowInfo.getRowIndex(), (String)errorMsg, (ImportLogger)logger);
                continue;
            }
            DynamicObject salaryfileSubordinateDyObj = salaryfileSubordinates.get(0);
            rowInfo.putEntityDyobj(salaryfileNumber, salaryfileSubordinateDyObj);
        }
    }

    private void verifyUpdateNewAddImport(List<ImportRowEntity> rowInfos, MainEntityType mainEntityType, ImportLogger logger, String keyFields) {
        String entityId = mainEntityType.getName();
        Map<Long, List<DynamicObject>> salaryfileSubordinateMap = SalaryFileBlockBatchImportPlugin.getSalaryfileSubordinate(rowInfos, mainEntityType);
        for (ImportRowEntity rowInfo : rowInfos) {
            this.verifyKeyFields(rowInfo.getRowIndex(), keyFields, logger);
            DynamicObject entityDyobj = rowInfo.getEntityDyobj(entityId);
            DynamicObject salaryfileDyObj = entityDyobj.getDynamicObject(SALARYFILE);
            if (salaryfileDyObj == null) continue;
            String salaryfileNumber = salaryfileDyObj.getString("number");
            Long salaryfileId = salaryfileDyObj.getLong("id");
            List<DynamicObject> salaryfileSubordinates = salaryfileSubordinateMap.get(salaryfileId);
            if (salaryfileSubordinates != null && salaryfileSubordinates.size() > 1) {
                String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848:{0}\u5b58\u5728\u591a\u6761{1}\u3002", (String)"SalaryFileBlockBatchImportPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), salaryfileNumber, mainEntityType.getDisplayName());
                SalaryFileImportDataOperate.log((int)rowInfo.getRowIndex(), (String)errorMsg, (ImportLogger)logger);
                continue;
            }
            if (salaryfileSubordinates == null || salaryfileSubordinates.size() != 1) continue;
            DynamicObject salaryfileSubordinateDyObj = salaryfileSubordinates.get(0);
            rowInfo.putEntityDyobj(salaryfileNumber, salaryfileSubordinateDyObj);
        }
    }

    private void verifyKeyFields(int rowIndex, String keyFields, ImportLogger logger) {
        if (keyFields == null) {
            String errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u66ff\u6362\u89c4\u5219\u552f\u4e00\u503c\u5fc5\u987b\u9009\u62e9\u85aa\u8d44\u6863\u6848\u3002", (String)"SalaryFileBlockBatchImportPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            SalaryFileImportDataOperate.log((int)rowIndex, (String)errorMsg, (ImportLogger)logger);
        } else {
            String keyField = keyFields.replaceAll(",", "");
            if (keyField == null || !SALARYFILE.equals(keyField)) {
                String errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u66ff\u6362\u89c4\u5219\u552f\u4e00\u503c\u5fc5\u987b\u9009\u62e9\u85aa\u8d44\u6863\u6848\u3002", (String)"SalaryFileBlockBatchImportPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                SalaryFileImportDataOperate.log((int)rowIndex, (String)errorMsg, (ImportLogger)logger);
            }
        }
    }

    public static Map<Long, List<DynamicObject>> getSalaryfileSubordinate(List<ImportRowEntity> rowInfos, MainEntityType mainEntityType) {
        ArrayList<Long> salaryfileIds = new ArrayList<Long>(rowInfos.size());
        String entityId = mainEntityType.getName();
        for (ImportRowEntity rowInfo : rowInfos) {
            DynamicObject entityDyobj = rowInfo.getEntityDyobj(entityId);
            DynamicObject salaryfileDyObj = entityDyobj.getDynamicObject(SALARYFILE);
            if (salaryfileDyObj == null) continue;
            Long pkId = salaryfileDyObj.getLong("id");
            salaryfileIds.add(pkId);
        }
        HashMap<Long, List<DynamicObject>> salaryfileSubordinateMap = new HashMap<Long, List<DynamicObject>>();
        String selectProperties = SWCHisBaseDataHelper.getSelectProperties((MainEntityType)mainEntityType);
        DynamicObject[] dys = SalaryFileBlockBatchImportPlugin.querySalaryfileSubordinateInfo(entityId, selectProperties = selectProperties + ",entryentity.seq", salaryfileIds);
        if (dys != null) {
            ArrayList<DynamicObject> salaryfileSubordinates = null;
            for (DynamicObject dynamicObj : dys) {
                Long salaryfileId = dynamicObj.getLong("salaryfile.id");
                salaryfileSubordinates = (ArrayList<DynamicObject>)salaryfileSubordinateMap.get(salaryfileId);
                if (salaryfileSubordinates == null) {
                    salaryfileSubordinates = new ArrayList<DynamicObject>();
                    salaryfileSubordinates.add(dynamicObj);
                } else {
                    salaryfileSubordinates.add(dynamicObj);
                }
                salaryfileSubordinateMap.put(salaryfileId, salaryfileSubordinates);
            }
        }
        return salaryfileSubordinateMap;
    }

    public static DynamicObject[] querySalaryfileSubordinateInfo(String tableName, String selectProperties, List<Long> salaryfileIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(tableName);
        QFilter filter = new QFilter("salaryfile.id", "in", salaryfileIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        DynamicObject[] dys = helper.query(selectProperties, new QFilter[]{filter});
        return dys;
    }

    protected Map<String, List<String>> getSalaryItemNumberMap(String salaryfileNumber, List<DynamicObject> salaryfileSubordinates) {
        HashMap<String, List<String>> salaryItemNumberMap = new HashMap<String, List<String>>();
        ArrayList<String> salaryItemNumList = new ArrayList<String>();
        if (salaryfileSubordinates != null) {
            for (DynamicObject dynamicObj : salaryfileSubordinates) {
                DynamicObjectCollection entryEntityColl = dynamicObj.getDynamicObjectCollection(ENTRYENTITY);
                for (DynamicObject entryDy : entryEntityColl) {
                    String salaryItemNumber = entryDy.getString("salaryitem.number");
                    salaryItemNumList.add(salaryItemNumber);
                }
            }
        }
        salaryItemNumberMap.put(salaryfileNumber, salaryItemNumList);
        return salaryItemNumberMap;
    }

    static class MutiThreadValidator
    implements Callable<List<ImportRowEntity>> {
        private MainEntityType mainEntityType;
        private List<ImportRowEntity> rowInfos;
        private ImportLogger logger;
        private ImportContext ctx;
        private RequestContext rc;

        public MutiThreadValidator(MainEntityType mainEntityType, List<ImportRowEntity> rowInfos, ImportLogger logger, ImportContext ctx, RequestContext rc) {
            this.mainEntityType = mainEntityType;
            this.rowInfos = new ArrayList<ImportRowEntity>(rowInfos);
            this.logger = logger;
            this.ctx = ctx;
            this.rc = rc;
        }

        @Override
        public List<ImportRowEntity> call() throws Exception {
            try {
                RequestContext.copyAndSet((RequestContext)this.rc);
                LOGGER.info("SalaryFileBlockBatchImportPlugin assembleImportData begin 1-1");
                SalaryFileImportDataConvert2DyObj.assembleImportData((MainEntityType)this.mainEntityType, this.rowInfos, (ImportLogger)this.logger);
                LOGGER.info("SalaryFileBlockBatchImportPlugin validateImportData begin 1-2");
                SalaryFileImportDataOperate.validateImportData((MainEntityType)this.mainEntityType, this.rowInfos, (ImportLogger)this.logger, (ImportContext)this.ctx);
                LOGGER.info("SalaryFileBlockBatchImportPlugin validateImportData end 1-3");
            }
            catch (Throwable e) {
                LOGGER.error("MutiThreadValidate : ", e);
            }
            finally {
                RequestContext.set(null);
            }
            return new ArrayList<ImportRowEntity>(this.rowInfos);
        }
    }
}

