/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.secret;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import org.apache.commons.lang3.RandomStringUtils;

public class SecretKeyInitEdit
extends SWCDataBaseEdit {
    private static final String TEXTFIELD_SECRET = "textfield_secret";
    private static final String DONOTHING_RANDOM = "donothing_random";
    private static final String DONOTHING_SAVE = "donothing_save";
    private static final String DONOTHING_SAVECONFIRM = "donothing_saveconfirm";
    private static final String DONOTHING_SAVECONFIRM_YES = "donothing_saveconfirm_yes";
    private static final String DONOTHING_CLEAR = "donothing_clear";
    private static final String LABELAP_ERR = "labelap_err";
    private static int LEN_64 = 64;
    private static final String NORMAL = "0";
    private static final String FLEX_NORMAL = "flexpanelap_normal";
    private static final String FLEX_VIEW = "flexpanelap_view";
    private static final String FLEX_INPUT = "flexpanelap_input";
    private static final String FORMPLUGIN_NAME = "swc-hsas-formplugin";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String secretKey = this.getSeceetKeyData();
        Map paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((String)"salaryslip_encrypt");
        if (null == paramMap || paramMap.isEmpty()) {
            this.showNormal();
            return;
        }
        Object encryptObj = paramMap.get("encryptlevel");
        if (null == encryptObj) {
            return;
        }
        String encryptLevel = encryptObj.toString();
        if (null == encryptLevel || NORMAL.equals(encryptLevel)) {
            this.showNormal();
        } else if (SWCStringUtils.isEmpty((String)secretKey)) {
            this.showInput();
        } else {
            this.showView();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String opKey;
        FormOperate formOperate = (FormOperate)e.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "donothing_save": {
                this.saveShowConfirm();
                break;
            }
            case "donothing_random": {
                this.setSecretKey();
                break;
            }
            case "donothing_saveconfirm_yes": {
                this.validSecretKey(e);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String opKey;
        FormOperate formOperate = (FormOperate)e.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "donothing_saveconfirm_yes": {
                this.showView();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)(((Object)((Object)this)).getClass().getSimpleName() + "_3"), (String)FORMPLUGIN_NAME, (Object[])new Object[0]));
                break;
            }
            case "donothing_clear": {
                this.showInput();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (e.getResult() == MessageBoxResult.Yes) {
            switch (e.getCallBackId()) {
                case "donothing_saveconfirm": {
                    this.getView().invokeOperation(DONOTHING_SAVECONFIRM_YES);
                    break;
                }
            }
        }
    }

    private void saveShowConfirm() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(DONOTHING_SAVECONFIRM);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u5bc6\u94a5\u4fdd\u5b58\u540e\u65e0\u6cd5\u4fee\u6539\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)(((Object)((Object)this)).getClass().getSimpleName() + "_0"), (String)FORMPLUGIN_NAME, (Object[])new Object[0]);
        this.getView().showConfirm(msg, options, confirmCallBacks);
    }

    private void setSecretKey() {
        String secret = RandomStringUtils.randomAlphanumeric((int)LEN_64);
        this.getModel().setValue(TEXTFIELD_SECRET, (Object)secret);
        Label label = (Label)this.getView().getControl(LABELAP_ERR);
        label.setText("");
    }

    private void validSecretKey(BeforeDoOperationEventArgs e) {
        String secretKey = this.getModel().getDataEntity().getString(TEXTFIELD_SECRET);
        if (SWCStringUtils.isEmpty((String)secretKey)) {
            e.setCancel(true);
            String content = ResManager.loadKDString((String)"\u6709\u5185\u5bb9\u672a\u6309\u8981\u6c42\u586b\u5199\u3002", (String)(((Object)((Object)this)).getClass().getSimpleName() + "_1"), (String)FORMPLUGIN_NAME, (Object[])new Object[0]);
            this.getView().showErrorNotification(content);
            Label label = (Label)this.getView().getControl(LABELAP_ERR);
            label.setText(ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)(((Object)((Object)this)).getClass().getSimpleName() + "_2"), (String)FORMPLUGIN_NAME, (Object[])new Object[0]));
        }
    }

    private String getSeceetKeyData() {
        String result = "";
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_secretkey");
        DynamicObject dynamicObject = helper.queryOne("secretkey", new QFilter[0]);
        if (dynamicObject != null) {
            result = dynamicObject.getString("secretkey");
        }
        return result;
    }

    private void showInput() {
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_NORMAL});
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_VIEW});
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_INPUT});
        this.getModel().setValue(TEXTFIELD_SECRET, (Object)"");
    }

    private void showView() {
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_NORMAL});
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_VIEW});
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_INPUT});
    }

    private void showNormal() {
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_NORMAL});
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_VIEW});
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_INPUT});
    }
}

