/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.common.enums;

import kd.bos.dataentity.utils.StringUtils;

public enum SalaryRptItemTypeEnum {
    ITEMTAG("itemtag", "hsbs_statisticstag", "", "", "", "", "", "", "", ""),
    ITEM("item", "hsbs_salaryitem", "hsas_caltableentry", "salaryitem", "textvalue", "numvalue", "datevalue", "calamountvalue", "", "slprorationindex"),
    ITEMBC("itembc", "hsbs_fetchitem", "hsas_calbcentry", "fetchitem", "bctextvalue", "bcnumvalue", "bcdatevalue", "", "", "ftprorationindex"),
    ITEMSP("itemsp", "hsbs_supportitem", "hsas_calspentry", "supportitem", "sptextvalue", "spnumvalue", "spdatevalue", "", "", null),
    ITEMBS("itembs", "hsbs_bizitem", "hsas_calbsentry", "bizitem", "bstextvalue", "bsnumvalue", "bsdatevalue", "bscalamountvalue", "bsoriamountvalue", "bsprorationindex"),
    ATTITEMBS("itemattbs", "hsbs_attbizitem", "hsas_calbsentry", "bizitem", "bstextvalue", "bsnumvalue", "bsdatevalue", "bscalamountvalue", "bsoriamountvalue", "bsprorationindex");

    private String code;
    private String entityCode;
    private String entryCode;
    private String itemFieldCode;
    private String textFieldCode;
    private String numFieldCode;
    private String dateFieldCode;
    private String calAmountFieldCode;
    private String oriAmountFieldCode;
    private String prorationIndexCode;

    private SalaryRptItemTypeEnum(String code, String entityCode, String entryCode, String itemFieldCode, String textFieldCode, String numFieldCode, String dateFieldCode, String calAmountFieldCode, String oriAmountFieldCode, String prorationIndexCode) {
        this.code = code;
        this.entityCode = entityCode;
        this.entryCode = entryCode;
        this.itemFieldCode = itemFieldCode;
        this.textFieldCode = textFieldCode;
        this.numFieldCode = numFieldCode;
        this.dateFieldCode = dateFieldCode;
        this.calAmountFieldCode = calAmountFieldCode;
        this.oriAmountFieldCode = oriAmountFieldCode;
        this.prorationIndexCode = prorationIndexCode;
    }

    public static String getCodeByEntityCode(String entityCode) {
        SalaryRptItemTypeEnum[] values;
        for (SalaryRptItemTypeEnum typeEnum : values = SalaryRptItemTypeEnum.values()) {
            if (!typeEnum.getEntityCode().equals(entityCode)) continue;
            return typeEnum.getCode();
        }
        return "";
    }

    public static String getEntityCodeByCode(String code) {
        SalaryRptItemTypeEnum[] values;
        for (SalaryRptItemTypeEnum typeEnum : values = SalaryRptItemTypeEnum.values()) {
            if (!typeEnum.getCode().equals(code)) continue;
            return typeEnum.getEntityCode();
        }
        return "";
    }

    public static SalaryRptItemTypeEnum getEnumByCode(String code) {
        SalaryRptItemTypeEnum[] values;
        for (SalaryRptItemTypeEnum typeEnum : values = SalaryRptItemTypeEnum.values()) {
            if (!typeEnum.getCode().equals(code)) continue;
            return typeEnum;
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getEntityCode() {
        return this.entityCode;
    }

    public void setEntityCode(String entityCode) {
        this.entityCode = entityCode;
    }

    public String getEntryCode() {
        return this.entryCode;
    }

    public String getItemFieldCode() {
        return this.itemFieldCode;
    }

    public String getTextFieldCode() {
        return this.textFieldCode;
    }

    public String getNumFieldCode() {
        return this.numFieldCode;
    }

    public String getDateFieldCode() {
        return this.dateFieldCode;
    }

    public String getCalAmountFieldCode() {
        return this.calAmountFieldCode;
    }

    public String getOriAmountFieldCode() {
        return this.oriAmountFieldCode;
    }

    public String getProrationIndexCode() {
        return this.prorationIndexCode;
    }

    public String getWholeValueFieldCode(String dataType) {
        String valueFieldCode;
        String pre = this.entryCode + ".";
        switch (dataType) {
            case "text": 
            case "boolean": {
                valueFieldCode = pre + this.textFieldCode;
                break;
            }
            case "date": {
                valueFieldCode = pre + this.dateFieldCode;
                break;
            }
            case "integer": 
            case "decimal": {
                valueFieldCode = pre + this.numFieldCode;
                break;
            }
            case "amount": {
                valueFieldCode = pre + this.calAmountFieldCode;
                break;
            }
            default: {
                valueFieldCode = "";
            }
        }
        return valueFieldCode;
    }

    public String getSelectProperties() {
        StringBuilder builder = new StringBuilder("id");
        builder.append(',').append("calpersonid");
        builder.append(',').append(this.entryCode).append('.').append(this.itemFieldCode);
        builder.append(',').append(this.entryCode).append('.').append(this.textFieldCode);
        builder.append(',').append(this.entryCode).append('.').append(this.numFieldCode);
        builder.append(',').append(this.entryCode).append('.').append(this.dateFieldCode);
        if (StringUtils.isNotEmpty((CharSequence)this.calAmountFieldCode)) {
            builder.append(',').append(this.entryCode).append('.').append(this.calAmountFieldCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.oriAmountFieldCode)) {
            builder.append(',').append(this.entryCode).append('.').append(this.oriAmountFieldCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.prorationIndexCode)) {
            builder.append(',').append(this.entryCode).append('.').append(this.prorationIndexCode);
        }
        return builder.toString();
    }

    public String getWholeItemFieldCode() {
        return this.entryCode + '.' + this.itemFieldCode;
    }

    public String getWholeProrationIndexCode() {
        return this.entryCode + '.' + this.prorationIndexCode;
    }
}

