/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.common.enums.ResultStatusEnum;
import kd.swc.hsas.common.utils.BaseResult;
import kd.swc.hsbp.common.util.SWCJSONUtils;

public class BatchResult<T> {
    public static final int DATA_CASE_NONE = 0;
    public static final int DATA_CASE_SUCCESS = 1;
    public static final int DATA_CASE_FAIL = 2;
    public static final int DATA_CASE_ALL = 3;
    private boolean success;
    private int status;
    private String message;
    private List<T> successResult;
    private List<FailItem<T>> failResult;

    public BatchResult(boolean success, List<T> dataList) {
        this.success = success;
        if (success) {
            this.successResult = dataList == null ? new ArrayList(0) : dataList;
            this.failResult = new ArrayList<FailItem<T>>(0);
            this.status = ResultStatusEnum.INFO.getCode();
        } else {
            this.failResult = dataList == null ? new ArrayList(0) : FailItem.wrap(dataList, "");
            this.successResult = new ArrayList<T>(0);
        }
    }

    public void addFailItem(T data, String message) {
        this.failResult.add(new FailItem<T>(data, message));
    }

    public BatchResult<T> ofFailResult(List<T> failResult, String message) {
        this.failResult = FailItem.wrap(failResult, message);
        return this;
    }

    public static <T> BatchResult<T> fromBaseResult(BaseResult<?> baseResult) {
        BatchResult result = new BatchResult(baseResult.isSuccess(), null);
        result.setMessage(baseResult.getMessage());
        result.setStatus(baseResult.getStatus());
        ArrayList list = null;
        Object data = baseResult.getData();
        if (data instanceof List) {
            list = (ArrayList)data;
        } else if (data instanceof Collection) {
            list = new ArrayList((Collection)data);
        } else if (data != null) {
            list = new ArrayList(1);
            list.add(data);
        }
        if (list != null) {
            if (baseResult.isSuccess()) {
                result.setSuccessResult(list);
            } else {
                result.setFailResult(list);
            }
        }
        return result;
    }

    public void successItemToFail(T data, String message) {
        this.successResult.remove(data);
        this.addFailItem(data, message);
    }

    public Map<String, Object> toMap(boolean withData) {
        ObjToMap<Object> objToMap = null;
        if (withData) {
            objToMap = data -> SWCJSONUtils.jsonToMap((Object)data);
        }
        return this.toMap(objToMap, 3);
    }

    public Map<String, Object> toMap(ObjToMap<T> objToMap, int dataCase) {
        HashMap<String, Object> res = new HashMap<String, Object>(8);
        res.put("success", this.success);
        res.put("status", this.status);
        res.put("message", this.message);
        if (objToMap != null) {
            Map<String, Object> map;
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>(this.successResult.size() + this.failResult.size());
            if ((dataCase | 1) > 0 && !CollectionUtils.isEmpty(this.successResult)) {
                for (T t : this.successResult) {
                    map = objToMap.toMap(t);
                    map.put("success", Boolean.TRUE);
                    data.add(map);
                }
            }
            if ((dataCase | 2) > 0 && !CollectionUtils.isEmpty(this.failResult)) {
                for (FailItem failItem : this.failResult) {
                    map = objToMap.toMap(failItem.data);
                    map.put("success", Boolean.FALSE);
                    map.put("message", failItem.message);
                    data.add(map);
                }
            }
            res.put("data", data);
        }
        return res;
    }

    public boolean isFailForUnKnown() {
        return this.status < ResultStatusEnum.DEBUG.getCode();
    }

    public boolean isEqualSuccess() {
        return this.status < ResultStatusEnum.INFO.getCode() && this.status >= ResultStatusEnum.DEBUG.getCode();
    }

    public boolean isContinue() {
        return this.status < ResultStatusEnum.ERROR.getCode();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public BatchResult<T> ofStatus(int status) {
        this.setStatus(status);
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public BatchResult<T> ofMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public List<T> getSuccessResult() {
        return this.successResult;
    }

    public void setSuccessResult(List<T> successResult) {
        this.successResult = successResult;
    }

    public BatchResult<T> addSuccessItem(T item) {
        this.successResult.add(item);
        return this;
    }

    public List<T> getFailResult() {
        return FailItem.unwrap(this.failResult);
    }

    public void setFailResult(List<T> failResult) {
        this.failResult = FailItem.wrap(failResult, "");
    }

    public static interface ObjToMap<T> {
        public Map<String, Object> toMap(T var1);
    }

    static class FailItem<T> {
        private final T data;
        private final String message;

        FailItem(T data, String message) {
            this.data = data;
            this.message = message;
        }

        static <T> List<FailItem<T>> wrap(List<T> list, String message) {
            if (list == null) {
                return null;
            }
            ArrayList<FailItem<T>> res = new ArrayList<FailItem<T>>(list.size());
            for (T data : list) {
                res.add(new FailItem<T>(data, message));
            }
            return res;
        }

        static <T> List<T> unwrap(List<FailItem<T>> list) {
            if (list == null) {
                return null;
            }
            ArrayList<T> res = new ArrayList<T>(list.size());
            for (FailItem<T> item : list) {
                res.add(item.data);
            }
            return res;
        }
    }
}

