/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.common.utils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.swc.hsas.common.formula.enums.ConditionEnum;
import kd.swc.hsas.common.formula.enums.FormulaKeyEnum;
import kd.swc.hsas.common.formula.enums.OperatorEnum;
import kd.swc.hsas.common.formula.expression.vo.AssExpression;
import kd.swc.hsas.common.formula.expression.vo.CalExpression;
import kd.swc.hsas.common.formula.expression.vo.DataGradeExpression;
import kd.swc.hsas.common.formula.expression.vo.DateExpression;
import kd.swc.hsas.common.formula.expression.vo.Expression;
import kd.swc.hsas.common.formula.expression.vo.FunExpression;
import kd.swc.hsas.common.formula.expression.vo.ItemExpression;
import kd.swc.hsas.common.formula.expression.vo.NumExpression;
import kd.swc.hsas.common.formula.expression.vo.OperatorExpression;
import kd.swc.hsas.common.formula.expression.vo.StrExpression;
import kd.swc.hsas.common.formula.vo.FormulaInfo;
import kd.swc.hsas.common.formula.vo.OriginalNode;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class FormulaUtils {
    public static final String ERROR_MESSAGE_FUNC = "FC_4070_S";
    public static final String PROMPT_MESSAGE_FUNC = "FC_4050_S";

    public static Map<String, ConditionEnum> getConditionMap() {
        HashMap<String, ConditionEnum> conditionKeyMap = new HashMap<String, ConditionEnum>(16);
        for (ConditionEnum conditionKeyEnum : ConditionEnum.values()) {
            conditionKeyMap.put(conditionKeyEnum.getName(), conditionKeyEnum);
        }
        return conditionKeyMap;
    }

    public static Map<String, OperatorEnum> getOperatorMap() {
        HashMap<String, OperatorEnum> operationMap = new HashMap<String, OperatorEnum>(16);
        for (OperatorEnum operationEnum : OperatorEnum.values()) {
            if (operationEnum == OperatorEnum.FULLSTOP) continue;
            operationMap.put(operationEnum.getAlias(), operationEnum);
        }
        return operationMap;
    }

    public static int getOpertorPriority(OperatorEnum operatorEnum) {
        switch (operatorEnum) {
            case LPARENTHESES: 
            case RPARENTHESES: {
                return 9;
            }
            case MULTIPLY: 
            case DIVIDE: {
                return 6;
            }
            case PLUS: 
            case SUBTRACT: {
                return 5;
            }
            case EQUAL: 
            case UNEQUAL: 
            case GT: 
            case LT: 
            case GTOREQUAL: 
            case LTOREQUAL: 
            case LIKE: {
                return 2;
            }
            case AND: 
            case OR: {
                return 1;
            }
        }
        return 0;
    }

    public static int compareOperatorPriority(OperatorExpression operatorExpression1, OperatorExpression operatorExpression2) {
        Map<String, OperatorEnum> operationMap = FormulaUtils.getOperatorMap();
        OperatorEnum operatorEnum1 = operationMap.get(operatorExpression1.getOperation().getNodeText().toUpperCase());
        OperatorEnum operatorEnum2 = operationMap.get(operatorExpression2.getOperation().getNodeText().toUpperCase());
        return FormulaUtils.getOpertorPriority(operatorEnum1) - FormulaUtils.getOpertorPriority(operatorEnum2);
    }

    public static OperatorEnum getOperatorEnum(OperatorExpression operatorExpression) {
        Map<String, OperatorEnum> operationMap = FormulaUtils.getOperatorMap();
        return operationMap.get(operatorExpression.getOperation().getNodeText().toUpperCase());
    }

    public static String subStringNodetext(String nodeText) {
        if (null == nodeText) {
            return null;
        }
        return nodeText.substring(3, nodeText.length() - 1);
    }

    public static boolean isOperation(String nodeText) {
        return FormulaUtils.getOperatorMap().containsKey(nodeText.toUpperCase());
    }

    public static boolean isFunction(String nodeText) {
        if (null == nodeText) {
            return false;
        }
        return !(!(nodeText = nodeText.toUpperCase(Locale.ENGLISH)).startsWith("FC[") && !nodeText.startsWith("FC\u3010") || !nodeText.endsWith("]") && !nodeText.endsWith("\u3011"));
    }

    public static boolean isDataGrade(String nodeText) {
        if (null == nodeText) {
            return false;
        }
        return !(!(nodeText = nodeText.toUpperCase(Locale.ENGLISH)).startsWith("BR[") && !nodeText.startsWith("BR\u3010") || !nodeText.endsWith("]") && !nodeText.endsWith("\u3011"));
    }

    public static boolean isTempVariableDataType(String nodeText) {
        if (nodeText == null) {
            return false;
        }
        return SWCStringUtils.equals((String)(nodeText = nodeText.toUpperCase(Locale.ENGLISH)), (String)FormulaKeyEnum.DATE.getCode()) || SWCStringUtils.equals((String)nodeText, (String)FormulaKeyEnum.TEXT.getCode()) || SWCStringUtils.equals((String)nodeText, (String)FormulaKeyEnum.NUM.getCode());
    }

    public static boolean isAcc(String nodeText) {
        if (null == nodeText) {
            return false;
        }
        return !(!(nodeText = nodeText.toUpperCase(Locale.ENGLISH)).startsWith("AC[") && !nodeText.startsWith("AC\u3010") || !nodeText.endsWith("]") && !nodeText.endsWith("\u3011"));
    }

    public static boolean isOutputCondition(ConditionEnum conditionEnum) {
        return conditionEnum == null || conditionEnum == ConditionEnum.ELSE || conditionEnum == ConditionEnum.THEN;
    }

    public static boolean isSalaryItem(String nodeText) {
        if (null == nodeText) {
            return false;
        }
        return !(!(nodeText = nodeText.toUpperCase(Locale.ENGLISH)).startsWith("SL[") && !nodeText.startsWith("SL\u3010") || !nodeText.endsWith("]") && !nodeText.endsWith("\u3011"));
    }

    public static boolean isBSItem(String nodeText) {
        if (null == nodeText) {
            return false;
        }
        return !(!(nodeText = nodeText.toUpperCase(Locale.ENGLISH)).startsWith("BS[") && !nodeText.startsWith("BS\u3010") || !nodeText.endsWith("]") && !nodeText.endsWith("\u3011"));
    }

    public static boolean isFTItem(String nodeText) {
        if (null == nodeText) {
            return false;
        }
        return !(!(nodeText = nodeText.toUpperCase(Locale.ENGLISH)).startsWith("FT[") && !nodeText.startsWith("FT\u3010") || !nodeText.endsWith("]") && !nodeText.endsWith("\u3011"));
    }

    public static boolean isSPItem(String nodeText) {
        if (null == nodeText) {
            return false;
        }
        return !(!(nodeText = nodeText.toUpperCase(Locale.ENGLISH)).startsWith("SP[") && !nodeText.startsWith("SP\u3010") || !nodeText.endsWith("]") && !nodeText.endsWith("\u3011"));
    }

    public static boolean isVRItem(String nodeText) {
        if (null == nodeText) {
            return false;
        }
        return !(!(nodeText = nodeText.toUpperCase(Locale.ENGLISH)).startsWith("VR[") && !nodeText.startsWith("VR\u3010") || !nodeText.endsWith("]") && !nodeText.endsWith("\u3011"));
    }

    public static boolean isNumber(String str) {
        boolean flag = false;
        try {
            new BigDecimal(str);
            flag = true;
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public static boolean isString(String str) {
        return str.startsWith(OperatorEnum.QUOT.getAlias()) || str.startsWith("\u201c");
    }

    public static boolean isResultKey(String nodeText) {
        return FormulaKeyEnum.RESULT.getCode().equalsIgnoreCase(nodeText);
    }

    public static boolean isExitKey(String nodeText) {
        return FormulaKeyEnum.EXIT.getCode().equalsIgnoreCase(nodeText);
    }

    public static boolean isNullKey(String nodeText) {
        return FormulaKeyEnum.NULL.getCode().equalsIgnoreCase(nodeText);
    }

    public static boolean isSPAssignmentKey(String nodeText, String nextNodeText) {
        if (nextNodeText == null) {
            return false;
        }
        return FormulaUtils.isSPItem(nodeText) && SWCStringUtils.equals((String)OperatorEnum.EQUAL.getAlias(), (String)nextNodeText);
    }

    public static boolean isVRAssignmentKey(String nodeText, String nextNodeText, String preNodeText) {
        if (nextNodeText == null || FormulaUtils.isTempVariableDataType(preNodeText)) {
            return false;
        }
        return FormulaUtils.isVRItem(nodeText) && SWCStringUtils.equals((String)OperatorEnum.EQUAL.getAlias(), (String)nextNodeText);
    }

    public static String getShowTypeById(long dataTypeId) {
        String showType = null;
        if (dataTypeId == 1010L) {
            showType = "num";
        } else if (dataTypeId == 1020L) {
            showType = "amount";
        } else if (dataTypeId == 1030L) {
            showType = "text";
        } else if (dataTypeId == 1050L) {
            showType = "date";
        }
        return showType;
    }

    public static OriginalNode getExpressionNode(Expression exp) {
        if (exp instanceof StrExpression) {
            StrExpression str = (StrExpression)exp;
            return str.getValue();
        }
        if (exp instanceof NumExpression) {
            NumExpression numExp = (NumExpression)exp;
            return numExp.getValue();
        }
        if (exp instanceof ItemExpression) {
            ItemExpression itemExp = (ItemExpression)exp;
            return itemExp.getItem();
        }
        if (exp instanceof FunExpression) {
            FunExpression funcExp = (FunExpression)exp;
            return funcExp.getFunction();
        }
        if (exp instanceof AssExpression) {
            AssExpression assExpression = (AssExpression)exp;
            return assExpression.getItem();
        }
        if (exp instanceof DataGradeExpression) {
            DataGradeExpression gradeExpression = (DataGradeExpression)exp;
            return gradeExpression.getDataGrade();
        }
        if (exp instanceof DateExpression) {
            DateExpression dateExpression = (DateExpression)exp;
            return dateExpression.getValue();
        }
        if (exp instanceof OperatorExpression) {
            OperatorExpression operatorExpression = (OperatorExpression)exp;
            return operatorExpression.getOperation();
        }
        if (exp instanceof CalExpression) {
            CalExpression calExpression = (CalExpression)exp;
            List<Expression> tempList = calExpression.getParameter();
            if (SWCListUtils.isEmpty(tempList)) {
                return new OriginalNode();
            }
            return FormulaUtils.getExpressionNode(tempList.get(0));
        }
        return new OriginalNode();
    }

    public static boolean isOutPutMessageFunction(String nodeText, FormulaInfo formula) {
        if (SWCStringUtils.isEmpty((String)nodeText)) {
            return false;
        }
        if (!FormulaUtils.isFunction(nodeText)) {
            return false;
        }
        String name = FormulaUtils.subStringNodetext(nodeText);
        Map<String, Map<String, Object>> fcMap = formula.getFcMap();
        Map<String, Object> fcInfoMap = fcMap.get(name);
        if (fcInfoMap == null) {
            return false;
        }
        String uniuqeCode = (String)fcInfoMap.get("uniquecode");
        return ERROR_MESSAGE_FUNC.equals(uniuqeCode) || PROMPT_MESSAGE_FUNC.equals(uniuqeCode);
    }
}

