/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.accumulator;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class AccCalMutexUtils {
    private static final Log LOGGER = LogFactory.getLog(AccCalMutexUtils.class);

    public static void checkPersonHrIsCalingAndAddMutexData(Map<Long, Map<String, Long>> personIndexMap, Map<Long, String> errorDataMap) {
        if (personIndexMap.size() == 0) {
            return;
        }
        DynamicObjectCollection calMutexDataList = AccCalMutexUtils.getSalaryCalMutexData(personIndexMap.keySet());
        for (DynamicObject obj : calMutexDataList) {
            errorDataMap.put(obj.getLong("personindexid"), AccCalMutexUtils.getMsgByType(obj));
            personIndexMap.remove(obj.getLong("personindexid"));
        }
    }

    private static String getMsgByType(DynamicObject obj) {
        String type = obj.getString("type");
        String msg = "";
        switch (type) {
            case "1": {
                msg = ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5df2\u6709\u85aa\u8d44\u6863\u6848\u5728{0}\u4efb\u52a1\u4e2d\u8ba1\u7b97\uff0c\u9700\u8981\u5728\u5176\u8ba1\u7b97\u5b8c\u6210\u540e\uff0c\u518d\u5c1d\u8bd5\u5f53\u524d\u64cd\u4f5c\u3002", (String)"AccCalMutexUtils_0", (String)"swc-hsas-business", (Object[])new Object[]{obj.getString("caltask.number")});
                break;
            }
            case "2": {
                msg = ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5df2\u6709\u85aa\u8d44\u6863\u6848\u5728{0}\u4efb\u52a1\u4e2d\u8ba1\u7b97\u56de\u6eda\uff0c\u9700\u8981\u5728\u5176\u8ba1\u7b97\u56de\u6eda\u5b8c\u6210\u540e\uff0c\u518d\u5c1d\u8bd5\u5f53\u524d\u64cd\u4f5c\u3002", (String)"AccCalMutexUtils_2", (String)"swc-hsas-business", (Object[])new Object[]{obj.getString("caltask.number")});
                break;
            }
            default: {
                msg = ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u7684\u7d2f\u52a0\u7ed3\u679c\u6b63\u5728\u88ab{0}{1}\u7528\u6237\u64cd\u4f5c\uff0c\u8bf7\u7b49\u5f85\u5176\u4ed6\u7528\u6237\u64cd\u4f5c\u5b8c\u6210\u540e\uff0c\u518d\u5c1d\u8bd5\u5f53\u524d\u64cd\u4f5c\u3002", (String)"AccCalMutexUtils_3", (String)"swc-hsas-business", (Object[])new Object[]{obj.getString("modifier.number"), obj.getString("modifier.name")});
            }
        }
        return msg;
    }

    private static DynamicObjectCollection getSalaryCalMutexData(Set<Long> personIndexIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salarycalmutex");
        QFilter filter = new QFilter("personindexid", "in", personIndexIdSet);
        return helper.queryOriginalCollection("caltask.number,personindexid,type,modifier.number,modifier.name", new QFilter[]{filter});
    }

    public static Set<Long> addSalaryCalMutexData(Map<Long, Map<String, Long>> personIndexMap, Map<Long, String> errorDataMap, String type) {
        LOGGER.info("addSalaryCalMutexData start");
        if (personIndexMap.size() == 0) {
            return new HashSet<Long>(0);
        }
        String lockKey = "_swc_hscs_salarycal";
        try (DLock lock = DLock.create((String)"_swc_hscs_salarycal");){
            LOGGER.info("start try lock...");
            if (lock.tryLock(30000L)) {
                LOGGER.info("get locked...");
                AccCalMutexUtils.checkPersonHrIsCalingAndAddMutexData(personIndexMap, errorDataMap);
                if (personIndexMap.size() > 0) {
                    AccCalMutexUtils.addSalaryCalMutexData(personIndexMap, type);
                }
            } else {
                LOGGER.error("try lock fail,time out");
                AccCalMutexUtils.handleExceptionData(personIndexMap, errorDataMap);
            }
        }
        catch (Exception ex) {
            LOGGER.error("addSalaryCalMutex error.", (Throwable)ex);
            AccCalMutexUtils.handleExceptionData(personIndexMap, errorDataMap);
        }
        LOGGER.info("addSalaryCalMutexData end");
        return personIndexMap.keySet();
    }

    private static void handleExceptionData(Map<Long, Map<String, Long>> personIndexMap, Map<Long, String> errorDataMap) {
        String tryLockFailMsg = ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AccCalMutexUtils_1", (String)"swc-hsas-business", (Object[])new Object[0]);
        for (Long personIndexId : personIndexMap.keySet()) {
            errorDataMap.put(personIndexId, tryLockFailMsg);
        }
        personIndexMap.clear();
    }

    private static Set<Long> addSalaryCalMutexData(Map<Long, Map<String, Long>> personIndexMap, String type) {
        LOGGER.info("addSalaryCalMutexData start,personIndexMap size = {}", (Object)personIndexMap.size());
        DynamicObjectCollection calMutexCollection = new DynamicObjectCollection();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"hsas_salarycalmutex");
        DynamicObject calMutex = null;
        for (Map.Entry<Long, Map<String, Long>> entry : personIndexMap.entrySet()) {
            calMutex = (DynamicObject)entityType.createInstance();
            calMutex.set("caltask", (Object)0L);
            calMutex.set("personindexid", (Object)entry.getKey());
            calMutex.set("employee", (Object)entry.getValue().get("employee"));
            calMutex.set("salaryfile", (Object)entry.getValue().get("salaryfile"));
            calMutex.set("createtime", (Object)new Date());
            calMutex.set("modifytime", (Object)new Date());
            calMutex.set("type", (Object)type);
            calMutex.set("creator", (Object)RequestContext.get().getCurrUserId());
            calMutex.set("modifier", (Object)RequestContext.get().getCurrUserId());
            calMutexCollection.add((Object)calMutex);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salarycalmutex");
        helper.save(calMutexCollection);
        LOGGER.info("addSalaryCalMutexData end");
        return personIndexMap.keySet();
    }

    public static void releaseSalaryCalMutexData(Set<Long> personIndexIdSet, String type) {
        LOGGER.info("releaseSalaryCalMutexData start");
        if (personIndexIdSet == null || personIndexIdSet.size() == 0) {
            LOGGER.info("personIndexIdList is empty");
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salarycalmutex");
        QFilter filter = new QFilter("personindexid", "in", personIndexIdSet);
        filter.and("type", "=", (Object)type);
        helper.deleteByFilter(new QFilter[]{filter});
        LOGGER.info("releaseSalaryCalMutexData end");
    }
}

