/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.accumulator.accresultdetail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.item.utils.ItemDataUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class AccResultDetailHelper {
    public DynamicObject getAccResultDetailInfo(Long accResultId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accresult");
        String field = "employee, salaryfile, acc, instancenum, startdate, enddate, dimension1, dimension2, dimension3, dimension4, dimension5, currency.amtprecision, resultvalue, acc.dataprecision.scale,personindexid, acc.periodtype";
        QFilter qFilter = new QFilter("id", "=", (Object)accResultId);
        DynamicObject accResultInfo = helper.queryOne(field, new QFilter[]{qFilter});
        return accResultInfo;
    }

    public DynamicObject[] getAccDetailInfo(Long accResultId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accdetails");
        String field = "id, caltask, calpersonid, currency.amtprecision, initvalue, currentvalue, index";
        QFilter qFilter = new QFilter("accresult", "=", (Object)accResultId);
        DynamicObject[] accDetailsColl = helper.query(field, new QFilter[]{qFilter}, "index asc");
        return accDetailsColl;
    }

    public DynamicObject[] getAccResultInfo(QFilter filter) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accresult");
        String field = "id,employee,salaryfile,salaryfile.number,acc,instancenum,startdate,enddate,dimension1,dimension2,dimension3,dimension4,dimension5,currency,resultvalue,isadjust,adjustentry.adjustamount,adjustentry.adjustdescript,adjustentry.adjusttime,adjustentry.adjustperson,currency.amtprecision";
        DynamicObject[] accResultArray = helper.query(field, new QFilter[]{filter}, null);
        return accResultArray;
    }

    public Map<Long, String> getCalPersonSalaryFileNumber(Map<Long, Long> relationMap) {
        if (relationMap == null || relationMap.size() == 0) {
            return null;
        }
        ArrayList<Long> calPersonIdList = new ArrayList<Long>(relationMap.size());
        for (Map.Entry<Long, Long> entry : relationMap.entrySet()) {
            calPersonIdList.add(entry.getValue());
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        String field = "id, salaryfile.number";
        QFilter qFilter = new QFilter("id", "in", calPersonIdList);
        DynamicObjectCollection calPersonColl = helper.queryColl(field, new QFilter[]{qFilter}, null);
        if (calPersonColl == null || calPersonColl.size() == 0) {
            return null;
        }
        HashMap<Long, String> retMap = new HashMap<Long, String>(16);
        for (Map.Entry<Long, Long> entry : relationMap.entrySet()) {
            Long accDetailId = entry.getKey();
            Long calPersonId = entry.getValue();
            String salaryFileNum = this.getSalaryFileNumberByCalPersonId(calPersonId, calPersonColl);
            if (!SWCStringUtils.isNotEmpty((String)salaryFileNum)) continue;
            retMap.put(accDetailId, salaryFileNum);
        }
        return retMap;
    }

    private String getSalaryFileNumberByCalPersonId(Long calPersonId, DynamicObjectCollection calPersonColl) {
        for (DynamicObject dataObj : calPersonColl) {
            long id = dataObj.getLong("id");
            if (id != calPersonId) continue;
            return dataObj.getString("salaryfile.number");
        }
        return "";
    }

    public Map<Long, Long> getCalTaskPeriodId(Map<Long, Long> calTaskMap) {
        if (calTaskMap == null || calTaskMap.size() == 0) {
            return null;
        }
        ArrayList<Long> calTaskIdList = new ArrayList<Long>(calTaskMap.size());
        for (Map.Entry<Long, Long> entry : calTaskMap.entrySet()) {
            calTaskIdList.add(entry.getValue());
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String field = "id, period.id";
        QFilter qFilter = new QFilter("id", "in", calTaskIdList);
        DynamicObjectCollection calTaskColl = helper.queryColl(field, new QFilter[]{qFilter}, null);
        if (calTaskColl == null || calTaskColl.size() == 0) {
            return null;
        }
        HashMap<Long, Long> retMap = new HashMap<Long, Long>(16);
        for (Map.Entry<Long, Long> entry : calTaskMap.entrySet()) {
            Long accDetailId = entry.getKey();
            Long calTaskId = entry.getValue();
            Long periodId = this.getPeriodIdByCalTaskId(calTaskId, calTaskColl);
            if (periodId == null) continue;
            retMap.put(accDetailId, periodId);
        }
        return retMap;
    }

    private Long getPeriodIdByCalTaskId(Long calTaskId, DynamicObjectCollection calTaskColl) {
        for (DynamicObject dataObj : calTaskColl) {
            long id = dataObj.getLong("id");
            if (id != calTaskId) continue;
            return dataObj.getLong("period.id");
        }
        return null;
    }

    public DynamicObject queryAllEntryDatas(Long accResultId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accresult");
        String field = "id, isadjust, resultvalue,modifytime,modifier,adjustentry.adjustamount, adjustentry.adjustdescript, adjustentry.adjusttime, adjustentry.adjustperson";
        QFilter qFilter = new QFilter("id", "=", (Object)accResultId);
        DynamicObject accResultObj = helper.queryOne(field, new QFilter[]{qFilter}, "adjustentry.adjusttime asc");
        return accResultObj;
    }

    public void writeDateToEntry(DynamicObjectCollection saveDataColl, Long accResultId) {
        if (saveDataColl == null || saveDataColl.size() == 0) {
            return;
        }
        DynamicObject accResultObj = this.queryAllEntryDatas(accResultId);
        if (SWCObjectUtils.isEmpty((Object)accResultObj)) {
            return;
        }
        BigDecimal addAmount = BigDecimal.ZERO;
        long[] entryIds = DB.genLongIds((String)"t_hsas_accresultadjust", (int)saveDataColl.size());
        DynamicObjectCollection entryColl = accResultObj.getDynamicObjectCollection("adjustentry");
        Set<Long> entryIdSet = entryColl.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        for (int i = 0; i < saveDataColl.size(); ++i) {
            DynamicObject dataObj = (DynamicObject)saveDataColl.get(i);
            if (this.entryRowIsExit(entryIdSet, dataObj)) continue;
            DynamicObject newObj = new DynamicObject(entryColl.getDynamicObjectType());
            long entryId = entryIds[i];
            newObj.set("id", (Object)entryId);
            dataObj.set("entryid", (Object)entryId);
            BigDecimal adjustAmount = dataObj.getBigDecimal("adjustamount");
            newObj.set("adjustamount", (Object)adjustAmount);
            if (adjustAmount != null) {
                addAmount = addAmount.add(adjustAmount);
            }
            newObj.set("adjustdescript", dataObj.get("adjustreason"));
            newObj.set("adjusttime", (Object)new Date());
            newObj.set("adjustperson", dataObj.get("adjustuser"));
            entryColl.add((Object)newObj);
        }
        BigDecimal resultVal = accResultObj.getBigDecimal("resultvalue");
        if (resultVal != null) {
            resultVal = resultVal.add(addAmount);
            accResultObj.set("resultvalue", (Object)resultVal);
        } else {
            accResultObj.set("resultvalue", (Object)addAmount);
        }
        accResultObj.set("isadjust", (Object)"1");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accresult");
        helper.updateOne(accResultObj);
    }

    public void batchWriteData(List<DynamicObject> dataList) {
        DynamicObject[] dataArray = new DynamicObject[dataList.size()];
        dataList.toArray(dataArray);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accresult");
        helper.update(dataArray);
    }

    private boolean entryRowIsExit(Set<Long> entryIdSet, DynamicObject dataObj) {
        if (entryIdSet == null || entryIdSet.size() == 0) {
            return false;
        }
        Long adjustEntryId = dataObj.getLong("entryid");
        if (adjustEntryId == null || adjustEntryId == 0L) {
            return false;
        }
        return entryIdSet.contains(adjustEntryId);
    }

    public FormShowParameter getAdjustPageParameter(DynamicObject accResult, long accResultId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hsas_adjustdata");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("accResultId", (Object)accResultId);
        parameter.setCustomParam("resultValue", (Object)accResult.getBigDecimal("resultvalue"));
        long dataTypeId = accResult.getLong("acc.datatype.id");
        int scale = 0;
        scale = DataTypeEnum.NUMBERIC.getDbId() == dataTypeId ? ItemDataUtils.getScal((long)accResult.getLong("acc.dataprecision.id")) : accResult.getInt("currency.amtprecision");
        parameter.setCustomParam("scale", (Object)scale);
        parameter.setCustomParam("employee", (Object)accResult.getLong("employee.id"));
        parameter.setCustomParam("salaryfile", (Object)String.valueOf(accResult.getLong("salaryfile.id")));
        parameter.setCustomParam("personindexid", (Object)accResult.getLong("personindexid"));
        return parameter;
    }

    public Set<Long> getPersonIndexIdSet(Set<Long> employeeIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_employee");
        QFilter filter = new QFilter("id", "in", employeeIdSet);
        String fields = "id,person.personindexid";
        DynamicObjectCollection list = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        return list.stream().map(obj -> obj.getLong("person.personindexid")).collect(Collectors.toSet());
    }
}

